# -*- coding: utf-8 -*-
info = {
    "name": "bg",
    "date_order": "DMY",
    "january": [
        "януари",
        "яну",
        "ян"
    ],
    "february": [
        "февруари",
        "фев",
        "фв"
    ],
    "march": [
        "март"
    ],
    "april": [
        "април",
        "апр",
        "ап"
    ],
    "may": [
        "май"
    ],
    "june": [
        "юни",
        "юн"
    ],
    "july": [
        "юли",
        "юл"
    ],
    "august": [
        "август",
        "авг"
    ],
    "september": [
        "септември",
        "сеп",
        "септ",
        "септм"
    ],
    "october": [
        "октомври",
        "окт"
    ],
    "november": [
        "ноември",
        "ное"
    ],
    "december": [
        "декември",
        "дек"
    ],
    "monday": [
        "понеделник",
        "пн",
        "пон"
    ],
    "tuesday": [
        "вторник",
        "вт",
        "вто"
    ],
    "wednesday": [
        "сряда",
        "ср",
        "сря"
    ],
    "thursday": [
        "четвъртък",
        "чт"
    ],
    "friday": [
        "петък",
        "пт"
    ],
    "saturday": [
        "събота",
        "сб"
    ],
    "sunday": [
        "неделя",
        "нд"
    ],
    "am": [
        "am",
        "проб"
    ],
    "pm": [
        "pm",
        "слоб"
    ],
    "year": [
        "година",
        "г",
        "г",
        "год",
        "години"
    ],
    "month": [
        "месец",
        "м",
        "мес",
        "месеци"
    ],
    "week": [
        "седмица",
        "седм",
        "с",
        "сед",
        "седмици"
    ],
    "day": [
        "ден",
        "д",
        "дни",
        "дена"
    ],
    "hour": [
        "час",
        "ч",
        "часа"
    ],
    "minute": [
        "минута",
        "мин",
        "минути"
    ],
    "second": [
        "секунда",
        "с",
        "сек",
        "секунди"
    ],
    "relative-type": {
        "1 year ago": [
            "миналата година",
            "мин г",
            "преди година"
        ],
        "0 year ago": [
            "тази година",
            "т г"
        ],
        "in 1 year": [
            "следващата година",
            "следв г",
            "сл г"
        ],
        "1 month ago": [
            "предходен месец",
            "мин мес",
            "мин м"
        ],
        "0 month ago": [
            "този месец",
            "този мес",
            "т м"
        ],
        "in 1 month": [
            "следващ месец",
            "следв мес",
            "сл м"
        ],
        "1 week ago": [
            "предходната седмица",
            "миналата седмица",
            "мин седм",
            "преди седмица"
        ],
        "0 week ago": [
            "тази седмица",
            "тази седм"
        ],
        "in 1 week": [
            "следващата седмица",
            "следв седм",
            "сл седм"
        ],
        "1 day ago": [
            "вчера",
            "снощи",
            "преди ден"
        ],
        "0 day ago": [
            "днес"
        ],
        "in 1 day": [
            "утре",
            "след ден"
        ],
        "0 hour ago": [
            "в този час"
        ],
        "0 minute ago": [
            "в тази минута"
        ],
        "0 second ago": [
            "сега"
        ],
        "10 year ago": [
            "преди десетилетие"
        ],
        "in 10 year": [
            "след 1 десетилетие"
        ],
        "2 day ago": [
            "онзи ден"
        ],
        "in 2 day": [
            "вдругиден"
        ],
        "1 hour ago": [
            "преди час"
        ],
        "in 1 hour": [
            "след час"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "след (\\d+) година",
            "след (\\d+) години",
            "след (\\d+) г",
            "сл (\\d+) г"
        ],
        "\\1 year ago": [
            "преди (\\d+) година",
            "преди (\\d+) години",
            "преди (\\d+) г",
            "пр (\\d+) г"
        ],
        "in \\1 month": [
            "след (\\d+) месец",
            "след (\\d+) месеца",
            "след (\\d+) м",
            "сл (\\d+) м"
        ],
        "\\1 month ago": [
            "преди (\\d+) месец",
            "преди (\\d+) месеца",
            "преди (\\d+) м",
            "пр (\\d+) м"
        ],
        "in \\1 week": [
            "след (\\d+) седмица",
            "след (\\d+) седмици",
            "след (\\d+) седм",
            "сл (\\d+) седм"
        ],
        "\\1 week ago": [
            "преди (\\d+) седмица",
            "преди (\\d+) седмици",
            "преди (\\d+) седм",
            "пр (\\d+) седм"
        ],
        "in \\1 day": [
            "след (\\d+) ден",
            "след (\\d+) дни",
            "сл (\\d+) д"
        ],
        "\\1 day ago": [
            "преди (\\d+) ден",
            "преди (\\d+) дни",
            "пр (\\d+) д"
        ],
        "in \\1 hour": [
            "след (\\d+) час",
            "след (\\d+) часа",
            "след (\\d+) ч",
            "сл (\\d+) ч"
        ],
        "\\1 hour ago": [
            "преди (\\d+) час",
            "преди (\\d+) часа",
            "преди (\\d+) ч",
            "пр (\\d+) ч"
        ],
        "in \\1 minute": [
            "след (\\d+) минута",
            "след (\\d+) минути",
            "след (\\d+) мин",
            "сл (\\d+) мин"
        ],
        "\\1 minute ago": [
            "преди (\\d+) минута",
            "преди (\\d+) минути",
            "преди (\\d+) мин",
            "пр (\\d+) мин"
        ],
        "in \\1 second": [
            "след (\\d+) секунда",
            "след (\\d+) секунди",
            "след (\\d+) сек",
            "сл (\\d+) сек"
        ],
        "\\1 second ago": [
            "преди (\\d+) секунда",
            "преди (\\d+) секунди",
            "преди (\\d+) сек",
            "пр (\\d+) сек"
        ]
    },
    "locale_specific": {},
    "skip": [
        "на",
        "върху",
        "под",
        "до",
        "от",
        "около",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "преди"
    ],
    "in": [
        "след",
        "после",
        "подир"
    ],
    "simplifications": [
        {
            "един": "1"
        },
        {
            "два": "2"
        },
        {
            "три": "3"
        }
    ]
}