/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.org.objectweb.asm.Label;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Not;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Not$BooleanNegation;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "BooleanNegation", "backend.jvm"})
public final class Not
extends IntrinsicMethod {
    public static final Not INSTANCE;

    @Override
    @NotNull
    public BooleanNegation invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(codegen2, "codegen");
        Intrinsics.checkParameterIsNotNull(data, "data");
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression == null) {
            Intrinsics.throwNpe();
        }
        return new BooleanNegation(PromisedValueKt.coerceToBoolean((PromisedValue)irExpression.accept(codegen2, data)));
    }

    private Not() {
    }

    static {
        Not not;
        INSTANCE = not = new Not();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Not$BooleanNegation;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "value", "(Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;)V", "getValue", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "jumpIfFalse", "", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "backend.jvm"})
    public static final class BooleanNegation
    extends BooleanValue {
        @NotNull
        private final BooleanValue value;

        @Override
        public void jumpIfFalse(@NotNull Label target) {
            Intrinsics.checkParameterIsNotNull(target, "target");
            this.value.jumpIfTrue(target);
        }

        @Override
        public void jumpIfTrue(@NotNull Label target) {
            Intrinsics.checkParameterIsNotNull(target, "target");
            this.value.jumpIfFalse(target);
        }

        @NotNull
        public final BooleanValue getValue() {
            return this.value;
        }

        public BooleanNegation(@NotNull BooleanValue value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            super(value.getCodegen());
            this.value = value;
        }
    }
}

