/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.ApplePathWatcher;
import com.swoval.files.DirectoryRegistry;
import com.swoval.files.DirectoryRegistryImpl;
import com.swoval.files.FileTreeViews;
import com.swoval.files.Observers;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import com.swoval.files.PlatformWatcher;
import com.swoval.files.SymlinkWatcher;
import com.swoval.files.TypedPath;
import com.swoval.functional.Either;
import com.swoval.functional.Filter;
import com.swoval.functional.Filters;
import com.swoval.logging.Logger;
import com.swoval.runtime.Platform;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;

class SymlinkFollowingPathWatcher
implements PathWatcher<PathWatchers.Event> {
    private final SymlinkWatcher symlinkWatcher;
    private final PathWatcher<PathWatchers.Event> pathWatcher;
    private final Observers<PathWatchers.Event> observers = new Observers();
    private final DirectoryRegistry pathWatcherDirectoryRegistry;

    SymlinkFollowingPathWatcher(PathWatcher<PathWatchers.Event> pathWatcher, final DirectoryRegistry directoryRegistry, Logger logger) throws InterruptedException, IOException {
        this.pathWatcher = pathWatcher;
        this.pathWatcherDirectoryRegistry = directoryRegistry;
        this.symlinkWatcher = new SymlinkWatcher(Platform.isMac() ? new ApplePathWatcher(new DirectoryRegistryImpl(), logger) : PlatformWatcher.make(false, new DirectoryRegistryImpl(), logger), logger);
        pathWatcher.addObserver(new FileTreeViews.Observer<PathWatchers.Event>(){

            @Override
            public void onError(Throwable throwable) {
                SymlinkFollowingPathWatcher.this.observers.onError(throwable);
            }

            @Override
            public void onNext(PathWatchers.Event event) {
                TypedPath typedPath = event.getTypedPath();
                if (typedPath.exists() && typedPath.isSymbolicLink()) {
                    try {
                        int n = directoryRegistry.maxDepthFor(typedPath.getPath());
                        SymlinkFollowingPathWatcher.this.symlinkWatcher.addSymlink(typedPath.getPath(), n);
                        if (typedPath.isDirectory()) {
                            SymlinkFollowingPathWatcher.this.handleNewDirectory(typedPath.getPath(), n, true);
                        }
                    }
                    catch (IOException iOException) {
                        SymlinkFollowingPathWatcher.this.observers.onError(iOException);
                    }
                } else if (!typedPath.exists()) {
                    SymlinkFollowingPathWatcher.this.symlinkWatcher.remove(typedPath.getPath());
                }
                SymlinkFollowingPathWatcher.this.observers.onNext(event);
            }
        });
        this.symlinkWatcher.addObserver((FileTreeViews.Observer<? super PathWatchers.Event>)new FileTreeViews.Observer<PathWatchers.Event>(){

            @Override
            public void onError(Throwable throwable) {
                SymlinkFollowingPathWatcher.this.observers.onError(throwable);
            }

            @Override
            public void onNext(PathWatchers.Event event) {
                SymlinkFollowingPathWatcher.this.observers.onNext(event);
            }
        });
    }

    private void handleNewDirectory(Path path, int n, boolean bl) throws IOException {
        for (TypedPath typedPath : FileTreeViews.list(path, n, Filters.AllPass)) {
            if (typedPath.isSymbolicLink()) {
                Path path2 = typedPath.getPath();
                this.symlinkWatcher.addSymlink(path2, this.pathWatcherDirectoryRegistry.maxDepthFor(path2));
            }
            if (!bl) continue;
            this.observers.onNext(new PathWatchers.Event(typedPath, PathWatchers.Event.Kind.Create));
        }
    }

    @Override
    public Either<IOException, Boolean> register(Path path, int n) {
        Either<IOException, Boolean> either;
        Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        Either<IOException, Boolean> either2 = either = this.pathWatcher.register(path2, n);
        if (either.isRight()) {
            try {
                this.handleNewDirectory(path2, n, false);
                either2 = Either.right(true);
            }
            catch (IOException iOException) {
                either2 = Either.left(iOException);
            }
        }
        return either2;
    }

    @Override
    public void unregister(Path path) {
        Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        try {
            Iterator<TypedPath> iterator = FileTreeViews.list(path2, this.pathWatcherDirectoryRegistry.maxDepthFor(path2), (Filter<? super TypedPath>)new Filter<TypedPath>(){

                @Override
                public boolean accept(TypedPath typedPath) {
                    return typedPath.isSymbolicLink();
                }
            }).iterator();
            while (iterator.hasNext()) {
                this.symlinkWatcher.remove(iterator.next().getPath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pathWatcher.unregister(path2);
    }

    @Override
    public void close() {
        this.pathWatcher.close();
        this.symlinkWatcher.close();
    }

    @Override
    public int addObserver(FileTreeViews.Observer<? super PathWatchers.Event> observer) {
        return this.observers.addObserver(observer);
    }

    @Override
    public void removeObserver(int n) {
        this.observers.removeObserver(n);
    }
}

