/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Screen;
import java.util.ArrayList;
import java.util.ListIterator;

public class ScreenSet {
    public ArrayList<Screen> screens = new ArrayList();
    static LogWriter vlog = new LogWriter("ScreenSet");

    public final ListIterator<Screen> begin() {
        return this.screens.listIterator(0);
    }

    public final ListIterator<Screen> end() {
        return this.screens.listIterator(this.screens.size());
    }

    public final int num_screens() {
        return this.screens.size();
    }

    public final void add_screen(Screen screen) {
        this.screens.add(screen);
    }

    public final void remove_screen(int n) {
        ListIterator<Screen> listIterator = this.begin();
        while (listIterator != this.end()) {
            ListIterator<Screen> listIterator2 = listIterator;
            listIterator2.next();
            if (listIterator.next().id == n) {
                listIterator.remove();
            }
            listIterator = listIterator2;
        }
    }

    public final boolean validate(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Rect rect = new Rect();
        if (this.screens.isEmpty()) {
            return false;
        }
        if (this.num_screens() > 255) {
            return false;
        }
        rect.setXYWH(0, 0, n, n2);
        for (Screen screen : this.screens) {
            if (screen.dimensions.is_empty()) {
                return false;
            }
            if (!screen.dimensions.enclosed_by(rect)) {
                return false;
            }
            arrayList.add(screen.id);
        }
        return true;
    }

    public final void debug_print() {
        vlog.debug(this.num_screens() + " screen(s)", new Object[0]);
        for (Screen screen : this.screens) {
            vlog.debug("    " + screen.id + " (0x" + screen.id + "): " + screen.dimensions.width() + "x" + screen.dimensions.height() + "+" + screen.dimensions.tl.x + "+" + screen.dimensions.tl.y + " (flags 0x" + screen.flags + ")", new Object[0]);
        }
    }
}

