/*
 * Decompiled with CFR 0.152.
 */
package plugins.collaboration.socket;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import freemind.common.NumberProperty;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import freemind.controller.Controller;
import freemind.controller.MapModuleManager;
import freemind.controller.actions.generated.instance.CollaborationUserInformation;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.HookNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.ActionFilter;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.hooks.MindMapNodeHookAdapter;
import freemind.view.MapModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;

public abstract class SocketBasics
extends MindMapNodeHookAdapter
implements MapModuleManager.MapTitleContributor,
ActionFilter.FirstActionFilter {
    private static final String PLUGINS_COLLABORATION_SOCKET = "plugins/collaboration/socket/";
    public static final String MASTER_HOOK_LABEL = "plugins/collaboration/socket/socket_master_plugin";
    public static final String SLAVE_HOOK_LABEL = "plugins/collaboration/socket/socket_slave_plugin";
    public static final String SLAVE_STARTER_LABEL = "plugins/collaboration/socket/socket_slave_starter_plugin";
    protected static final Integer ROLE_MASTER = 0;
    protected static final Integer ROLE_SLAVE = 1;
    private static final String PORT_PROPERTY = "plugins.collaboration.socket.port";
    private static final String SOCKET_BASICS_CLASS = "plugins.collaboration.socket.SocketBasics";
    protected static final String PASSWORD = "plugins.collaboration.socket.SocketBasics.password";
    protected static final String PASSWORD_DESCRIPTION = "plugins.collaboration.socket.SocketBasics.password.description";
    protected static final String PASSWORD_VERIFICATION = "plugins.collaboration.socket.SocketBasics.password_verification";
    protected static final String PASSWORD_VERIFICATION_DESCRIPTION = "plugins.collaboration.socket.SocketBasics.password_verification_description";
    protected static final String HOST = "plugins.collaboration.socket.SocketBasics.host";
    protected static final String HOST_DESCRIPTION = "plugins.collaboration.socket.SocketBasics.host.description";
    protected static final String PORT = "plugins.collaboration.socket.SocketBasics.port";
    protected static final String PORT_DESCRIPTION = "plugins.collaboration.socket.SocketBasics.port.description";
    protected static final String TITLE = "plugins.collaboration.socket.SocketBasics.title";
    protected static final String UNKNWON_HOST_EXCEPTION_MESSAGE = "plugins.collaboration.socket.SocketBasics.unknown_host_exception";
    protected static final String CONNECT_EXCEPTION_MESSAGE = "plugins.collaboration.socket.SocketBasics.connection_exception";
    protected static final String SOCKET_CREATION_EXCEPTION_MESSAGE = "plugins.collaboration.socket.SocketBasics.socket_creation_exception";
    protected static Logger logger = null;
    protected String mPassword;
    protected boolean mFilterEnabled = true;
    private String mUserName = Tools.getUserName();

    public abstract Integer getRole();

    public void startupMapHook() {
        super.startupMapHook();
        if (logger == null) {
            logger = Resources.getInstance().getLogger(((Object)((Object)this)).getClass().getName());
        }
        this.getMindMapController().getController().registerMapTitleContributor((MapModuleManager.MapTitleContributor)this);
    }

    public void shutdownMapHook() {
        Controller controller = this.getMindMapController().getController();
        controller.deregisterMapTitleContributor((MapModuleManager.MapTitleContributor)this);
        controller.setTitle();
        super.shutdownMapHook();
    }

    public static void togglePermanentHook(MindMapController controller, String hookName) {
        MindMapNode rootNode = controller.getRootNode();
        List<MindMapNode> selecteds = Arrays.asList(rootNode);
        controller.addHook(rootNode, selecteds, hookName, null);
    }

    protected void setPortProperty(NumberProperty portProperty) {
        this.getMindMapController().getFrame().setProperty(PORT_PROPERTY, portProperty.getValue());
    }

    protected NumberProperty getPortProperty() {
        NumberProperty portProperty = new NumberProperty(PORT_DESCRIPTION, PORT, 1024, Short.MAX_VALUE, 1);
        portProperty.setValue("" + this.getMindMapController().getFrame().getIntProperty(PORT_PROPERTY, 9001));
        return portProperty;
    }

    public abstract int getPort();

    public String getMapTitle(String pOldTitle, MapModule pMapModule, MindMap pModel) {
        if (pModel.getModeController() != this.getMindMapController()) {
            return pOldTitle;
        }
        CollaborationUserInformation userInfo = this.getMasterInformation();
        if (userInfo == null) {
            return pOldTitle;
        }
        return pOldTitle + Resources.getInstance().format(TITLE, new Object[]{this.getRole(), userInfo.getMasterHostname(), userInfo.getMasterIp(), new Integer(userInfo.getMasterPort()), userInfo.getUserIds()});
    }

    public abstract CollaborationUserInformation getMasterInformation();

    public String getPassword() {
        return this.mPassword;
    }

    private boolean visit(XmlAction pAction, String pSearchString) {
        HookNodeAction hookNodeAction;
        if (pAction instanceof CompoundAction) {
            CompoundAction compound = (CompoundAction)pAction;
            boolean result = false;
            for (XmlAction action : compound.getListChoiceList()) {
                result |= this.visit(action, pSearchString);
            }
            return result;
        }
        return pAction instanceof HookNodeAction && Tools.safeEquals((String)(hookNodeAction = (HookNodeAction)pAction).getHookName(), (String)pSearchString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionPair filterAction(ActionPair pPair) {
        if (pPair == null || !this.mFilterEnabled) {
            return pPair;
        }
        if (this.visit(pPair.getDoAction(), SLAVE_HOOK_LABEL)) {
            return pPair;
        }
        if (this.visit(pPair.getDoAction(), MASTER_HOOK_LABEL)) {
            return pPair;
        }
        String doAction = this.getMindMapController().marshall(pPair.getDoAction());
        String undoAction = this.getMindMapController().marshall(pPair.getUndoAction());
        logger.info("Require lock for command: " + doAction);
        try {
            String lockId = this.lock(this.getUserName());
            this.broadcastCommand(doAction, undoAction, lockId);
        }
        catch (UnableToGetLockException e) {
            Resources.getInstance().logException((Throwable)e);
            ActionPair actionPair = this.getEmptyActionPair();
            return actionPair;
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
            ActionPair actionPair = this.getEmptyActionPair();
            return actionPair;
        }
        finally {
            this.unlock();
        }
        return pPair;
    }

    public ActionPair getEmptyActionPair() {
        return new ActionPair((XmlAction)new CompoundAction(), (XmlAction)new CompoundAction());
    }

    protected abstract String lock(String var1) throws UnableToGetLockException, InterruptedException;

    protected String getUserName() {
        return this.mUserName;
    }

    protected abstract void broadcastCommand(String var1, String var2, String var3) throws Exception;

    protected abstract void unlock();

    protected void registerFilter() {
        logger.info("Registering filter");
        this.getMindMapController().getActionFactory().registerFilter((ActionFilter)this);
    }

    protected void deregisterFilter() {
        logger.info("Deregistering filter");
        this.getMindMapController().getActionFactory().deregisterFilter((ActionFilter)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTransaction(ActionPair pair) {
        this.mFilterEnabled = false;
        try {
            this.getMindMapController().doTransaction("update", pair);
        }
        finally {
            this.mFilterEnabled = true;
        }
    }

    public abstract void shutdown();

    protected static class UnableToGetLockException
    extends Exception {
        protected UnableToGetLockException() {
        }
    }

    public static class FormDialog
    extends JDialog
    implements PropertyChangeListener {
        private final MindMapController mController2;
        private boolean mSuccess = false;
        private JButton mOkButton;
        private FormDialogValidator mFormDialogValidator;

        public boolean isSuccess() {
            return this.mSuccess;
        }

        public FormDialog(MindMapController pController) {
            super(pController.getFrame().getJFrame());
            this.mController2 = pController;
        }

        public void setUp(Vector controls) {
            this.setUp(controls, new FormDialogValidator(){

                @Override
                public boolean isValid() {
                    return true;
                }
            });
        }

        public void setUp(Vector controls, FormDialogValidator pValidator) {
            this.mFormDialogValidator = pValidator;
            this.setModal(true);
            this.getContentPane().setLayout(new BorderLayout());
            FormLayout formLayout = new FormLayout("right:max(40dlu;p), 4dlu, 80dlu, 7dlu", "");
            DefaultFormBuilder builder = new DefaultFormBuilder(formLayout);
            builder.setDefaultDialogBorder();
            for (PropertyControl prop : controls) {
                prop.layout(builder, (TextTranslator)this.mController2);
                PropertyBean bean = (PropertyBean)prop;
                bean.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.getContentPane().add((Component)builder.getPanel(), "Center");
            JButton cancelButton = new JButton(this.getText("Cancel"));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FormDialog.this.closeWindow();
                }
            });
            this.mOkButton = new JButton(this.getText("OK"));
            this.mOkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FormDialog.this.mSuccess = true;
                    FormDialog.this.closeWindow();
                }
            });
            this.getRootPane().setDefaultButton(this.mOkButton);
            this.getContentPane().add((Component)ButtonBarFactory.buildOKCancelBar((JButton)cancelButton, (JButton)this.mOkButton), "South");
            this.setTitle("Enter Password Dialog");
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    FormDialog.this.closeWindow();
                }
            });
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FormDialog.this.closeWindow();
                }
            };
            AbstractAction actionSuccess = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FormDialog.this.mSuccess = true;
                    FormDialog.this.closeWindow();
                }
            };
            Tools.addEscapeActionToDialog((JDialog)this, (Action)action);
            Tools.addKeyActionToDialog((JDialog)this, (Action)actionSuccess, (String)"ENTER", (String)"ok_dialog");
            this.pack();
            this.setVisible(true);
        }

        private void closeWindow() {
            this.setVisible(false);
        }

        String getText(String text) {
            return text;
        }

        @Override
        public void propertyChange(PropertyChangeEvent pEvt) {
            logger.finest("Property change " + pEvt);
            this.mOkButton.setEnabled(this.mFormDialogValidator.isValid());
        }
    }

    public static abstract class FormDialogValidator {
        public abstract boolean isValid();
    }
}

