/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.force.quadtree;

import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.ForceVectorUtils;
import org.gephi.layout.plugin.force.AbstractForce;
import org.gephi.layout.plugin.force.ForceVector;
import org.gephi.layout.plugin.force.quadtree.QuadTree;

public class BarnesHut {
    private float theta = 1.2f;
    private AbstractForce force;

    public BarnesHut(AbstractForce force) {
        this.force = force;
    }

    public ForceVector calculateForce(Node node, QuadTree tree) {
        if (tree.mass() <= 0) {
            return null;
        }
        float distance = ForceVectorUtils.distance(node, tree);
        if (tree.isIsLeaf() || tree.mass() == 1) {
            if ((double)distance < 1.0E-8) {
                return null;
            }
            return this.force.calculateForce(node, tree);
        }
        if (distance * this.theta > tree.size()) {
            ForceVector f = this.force.calculateForce(node, tree, distance);
            f.multiply(tree.mass());
            return f;
        }
        ForceVector f = new ForceVector();
        for (QuadTree child : tree.getChildren()) {
            f.add(this.calculateForce(node, child));
        }
        return f;
    }

    public void setTheta(float theta) {
        this.theta = theta;
    }

    public float getTheta() {
        return this.theta;
    }
}

