/*
 * Decompiled with CFR 0.152.
 */
package org.grails.databinding.converters;

import grails.core.GrailsApplication;
import grails.databinding.converters.ValueConverter;
import io.micronaut.context.exceptions.NoSuchBeanException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.grails.databinding.converters.CurrencyValueConverter;
import org.grails.databinding.converters.DateConversionHelper;
import org.grails.databinding.converters.TimeZoneConverter;
import org.grails.databinding.converters.web.LocaleAwareBigDecimalConverter;
import org.grails.databinding.converters.web.LocaleAwareNumberConverter;
import org.grails.plugins.databinding.DataBindingConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.LocaleResolver;

@Configuration
public class DefaultConvertersConfiguration {
    private final DataBindingConfigurationProperties configurationProperties;
    private final LocaleResolver localResolver;

    public DefaultConvertersConfiguration(GrailsApplication grailsApplication, DataBindingConfigurationProperties configurationProperties) {
        LocaleResolver localResolver;
        this.configurationProperties = configurationProperties;
        try {
            localResolver = (LocaleResolver)grailsApplication.getMainContext().getBean(LocaleResolver.class);
        }
        catch (NoSuchBeanException e) {
            localResolver = null;
        }
        this.localResolver = localResolver;
    }

    @Bean(value={"defaultCurrencyConverter"})
    protected CurrencyValueConverter defaultCurrencyConverter() {
        return new CurrencyValueConverter();
    }

    @Bean(value={"defaultGrailsBigDecimalConverter"})
    protected ValueConverter defaultGrailsBigDecimalConverter() {
        LocaleAwareBigDecimalConverter converter = new LocaleAwareBigDecimalConverter();
        converter.setTargetType(BigDecimal.class);
        converter.setLocaleResolver(this.localResolver);
        return converter;
    }

    @Bean(value={"defaultGrailsBigIntegerConverter"})
    protected ValueConverter defaultGrailsBigIntegerConverter() {
        LocaleAwareBigDecimalConverter converter = new LocaleAwareBigDecimalConverter();
        converter.setTargetType(BigInteger.class);
        converter.setLocaleResolver(this.localResolver);
        return converter;
    }

    @Bean(value={"defaultDateConverter"})
    protected DateConversionHelper defaultDateConverter() {
        DateConversionHelper converter = new DateConversionHelper();
        converter.setDateParsingLenient(this.configurationProperties.isDateParsingLenient());
        converter.setFormatStrings(this.configurationProperties.getDateFormats());
        return converter;
    }

    @Bean(value={"timeZoneConverter"})
    protected TimeZoneConverter defaultTimeZoneConverter() {
        return new TimeZoneConverter();
    }

    @Bean(value={"defaultShortConverter"})
    protected LocaleAwareNumberConverter shortConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Short.class);
        return converter;
    }

    @Bean(value={"defaultshortConverter"})
    protected LocaleAwareNumberConverter primitiveShortConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Short.TYPE);
        return converter;
    }

    @Bean(value={"defaultIntegerConverter"})
    protected LocaleAwareNumberConverter integerConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Integer.class);
        return converter;
    }

    @Bean(value={"defaultintConverter"})
    protected LocaleAwareNumberConverter primitiveIntConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Integer.TYPE);
        return converter;
    }

    @Bean(value={"defaultFloatConverter"})
    protected LocaleAwareNumberConverter floatConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Float.class);
        return converter;
    }

    @Bean(value={"defaultfloatConverter"})
    protected LocaleAwareNumberConverter primitiveFloattConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Float.TYPE);
        return converter;
    }

    @Bean(value={"defaultLongConverter"})
    protected LocaleAwareNumberConverter longConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Long.class);
        return converter;
    }

    @Bean(value={"defaultlongConverter"})
    protected LocaleAwareNumberConverter primitiveLongConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Long.TYPE);
        return converter;
    }

    @Bean(value={"defaultDoubleConverter"})
    protected LocaleAwareNumberConverter doubleConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Double.class);
        return converter;
    }

    @Bean(value={"defaultdoubleConverter"})
    protected LocaleAwareNumberConverter primitiveDoubleConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Double.TYPE);
        return converter;
    }
}

