/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils_7;
import org.bouncycastle.jsse.provider.JsseUtils_8;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ReflectionUtil;

abstract class SSLParametersUtil {
    private static final Method getAlgorithmConstraints;
    private static final Method setAlgorithmConstraints;
    private static final Method getApplicationProtocols;
    private static final Method setApplicationProtocols;
    private static final Method getEndpointIdentificationAlgorithm;
    private static final Method setEndpointIdentificationAlgorithm;
    private static final Method getServerNames;
    private static final Method setServerNames;
    private static final Method getSNIMatchers;
    private static final Method setSNIMatchers;
    private static final Method getUseCipherSuitesOrder;
    private static final Method setUseCipherSuitesOrder;

    SSLParametersUtil() {
    }

    static BCSSLParameters getParameters(ProvSSLParameters provSSLParameters) {
        BCSSLParameters bCSSLParameters = new BCSSLParameters(provSSLParameters.getCipherSuites(), provSSLParameters.getProtocols());
        if (provSSLParameters.getNeedClientAuth()) {
            bCSSLParameters.setNeedClientAuth(true);
        } else if (provSSLParameters.getWantClientAuth()) {
            bCSSLParameters.setWantClientAuth(true);
        } else {
            bCSSLParameters.setWantClientAuth(false);
        }
        bCSSLParameters.setAlgorithmConstraints(provSSLParameters.getAlgorithmConstraints());
        bCSSLParameters.setEndpointIdentificationAlgorithm(provSSLParameters.getEndpointIdentificationAlgorithm());
        bCSSLParameters.setUseCipherSuitesOrder(provSSLParameters.getUseCipherSuitesOrder());
        bCSSLParameters.setServerNames(provSSLParameters.getServerNames());
        bCSSLParameters.setSNIMatchers(provSSLParameters.getSNIMatchers());
        bCSSLParameters.setApplicationProtocols(provSSLParameters.getApplicationProtocols());
        return bCSSLParameters;
    }

    static SSLParameters getSSLParameters(ProvSSLParameters provSSLParameters) {
        Collection<Object> collection;
        SSLParameters sSLParameters = new SSLParameters(provSSLParameters.getCipherSuites(), provSSLParameters.getProtocols());
        if (provSSLParameters.getNeedClientAuth()) {
            sSLParameters.setNeedClientAuth(true);
        } else if (provSSLParameters.getWantClientAuth()) {
            sSLParameters.setWantClientAuth(true);
        } else {
            sSLParameters.setWantClientAuth(false);
        }
        if (null != setAlgorithmConstraints) {
            SSLParametersUtil.set(sSLParameters, setAlgorithmConstraints, JsseUtils_7.exportAlgorithmConstraints(provSSLParameters.getAlgorithmConstraints()));
        }
        if (null != setEndpointIdentificationAlgorithm) {
            SSLParametersUtil.set(sSLParameters, setEndpointIdentificationAlgorithm, provSSLParameters.getEndpointIdentificationAlgorithm());
        }
        if (null != setUseCipherSuitesOrder) {
            SSLParametersUtil.set(sSLParameters, setUseCipherSuitesOrder, provSSLParameters.getUseCipherSuitesOrder());
        }
        if (null != setServerNames && null != (collection = provSSLParameters.getServerNames())) {
            SSLParametersUtil.set(sSLParameters, setServerNames, JsseUtils_8.exportSNIServerNames(collection));
        }
        if (null != setSNIMatchers && null != (collection = provSSLParameters.getSNIMatchers())) {
            SSLParametersUtil.set(sSLParameters, setSNIMatchers, JsseUtils_8.exportSNIMatchers(collection));
        }
        if (null != setApplicationProtocols) {
            SSLParametersUtil.set(sSLParameters, setApplicationProtocols, provSSLParameters.getApplicationProtocols());
        }
        return sSLParameters;
    }

    static BCSSLParameters importSSLParameters(SSLParameters sSLParameters) {
        String[] stringArray;
        BCSSLParameters bCSSLParameters = new BCSSLParameters(sSLParameters.getCipherSuites(), sSLParameters.getProtocols());
        if (sSLParameters.getNeedClientAuth()) {
            bCSSLParameters.setNeedClientAuth(true);
        } else if (sSLParameters.getWantClientAuth()) {
            bCSSLParameters.setWantClientAuth(true);
        } else {
            bCSSLParameters.setWantClientAuth(false);
        }
        if (null != getAlgorithmConstraints && null != (stringArray = SSLParametersUtil.get(sSLParameters, getAlgorithmConstraints))) {
            bCSSLParameters.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraints(stringArray));
        }
        if (null != getEndpointIdentificationAlgorithm && null != (stringArray = (String)SSLParametersUtil.get(sSLParameters, getEndpointIdentificationAlgorithm))) {
            bCSSLParameters.setEndpointIdentificationAlgorithm((String)stringArray);
        }
        if (null != getUseCipherSuitesOrder) {
            bCSSLParameters.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.get(sSLParameters, getUseCipherSuitesOrder));
        }
        if (null != getServerNames && null != (stringArray = SSLParametersUtil.get(sSLParameters, getServerNames))) {
            bCSSLParameters.setServerNames(JsseUtils_8.importSNIServerNames(stringArray));
        }
        if (null != getSNIMatchers && null != (stringArray = SSLParametersUtil.get(sSLParameters, getSNIMatchers))) {
            bCSSLParameters.setSNIMatchers(JsseUtils_8.importSNIMatchers(stringArray));
        }
        if (null != getApplicationProtocols && null != (stringArray = (String[])SSLParametersUtil.get(sSLParameters, getApplicationProtocols))) {
            bCSSLParameters.setApplicationProtocols(stringArray);
        }
        return bCSSLParameters;
    }

    static void setParameters(ProvSSLParameters provSSLParameters, BCSSLParameters bCSSLParameters) {
        String[] stringArray;
        Collection<BCSNIMatcher> collection;
        String string;
        String[] stringArray2;
        String[] stringArray3 = bCSSLParameters.getCipherSuites();
        if (null != stringArray3) {
            provSSLParameters.setCipherSuites(stringArray3);
        }
        if (null != (stringArray2 = bCSSLParameters.getProtocols())) {
            provSSLParameters.setProtocols(stringArray2);
        }
        if (bCSSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else if (bCSSLParameters.getWantClientAuth()) {
            provSSLParameters.setWantClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(false);
        }
        BCAlgorithmConstraints bCAlgorithmConstraints = bCSSLParameters.getAlgorithmConstraints();
        if (null != bCAlgorithmConstraints) {
            provSSLParameters.setAlgorithmConstraints(bCAlgorithmConstraints);
        }
        if (null != (string = bCSSLParameters.getEndpointIdentificationAlgorithm())) {
            provSSLParameters.setEndpointIdentificationAlgorithm(string);
        }
        provSSLParameters.setUseCipherSuitesOrder(bCSSLParameters.getUseCipherSuitesOrder());
        List<BCSNIServerName> list = bCSSLParameters.getServerNames();
        if (null != list) {
            provSSLParameters.setServerNames(list);
        }
        if (null != (collection = bCSSLParameters.getSNIMatchers())) {
            provSSLParameters.setSNIMatchers(collection);
        }
        if (null != (stringArray = bCSSLParameters.getApplicationProtocols())) {
            provSSLParameters.setApplicationProtocols(stringArray);
        }
    }

    static void setSSLParameters(ProvSSLParameters provSSLParameters, SSLParameters sSLParameters) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3 = sSLParameters.getCipherSuites();
        if (null != stringArray3) {
            provSSLParameters.setCipherSuites(stringArray3);
        }
        if (null != (stringArray2 = sSLParameters.getProtocols())) {
            provSSLParameters.setProtocols(stringArray2);
        }
        if (sSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else if (sSLParameters.getWantClientAuth()) {
            provSSLParameters.setWantClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(false);
        }
        if (null != getAlgorithmConstraints && null != (stringArray = SSLParametersUtil.get(sSLParameters, getAlgorithmConstraints))) {
            provSSLParameters.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraints(stringArray));
        }
        if (null != getEndpointIdentificationAlgorithm && null != (stringArray = (String)SSLParametersUtil.get(sSLParameters, getEndpointIdentificationAlgorithm))) {
            provSSLParameters.setEndpointIdentificationAlgorithm((String)stringArray);
        }
        if (null != getUseCipherSuitesOrder) {
            provSSLParameters.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.get(sSLParameters, getUseCipherSuitesOrder));
        }
        if (null != getServerNames && null != (stringArray = SSLParametersUtil.get(sSLParameters, getServerNames))) {
            provSSLParameters.setServerNames(JsseUtils_8.importSNIServerNames(stringArray));
        }
        if (null != getSNIMatchers && null != (stringArray = SSLParametersUtil.get(sSLParameters, getSNIMatchers))) {
            provSSLParameters.setSNIMatchers(JsseUtils_8.importSNIMatchers(stringArray));
        }
        if (null != getApplicationProtocols && null != (stringArray = (String[])SSLParametersUtil.get(sSLParameters, getApplicationProtocols))) {
            provSSLParameters.setApplicationProtocols(stringArray);
        }
    }

    private static Object get(Object object, Method method) {
        return ReflectionUtil.invokeGetter(object, method);
    }

    private static void set(Object object, Method method, Object object2) {
        ReflectionUtil.invokeSetter(object, method, object2);
    }

    static {
        Method[] methodArray = ReflectionUtil.getMethods("javax.net.ssl.SSLParameters");
        getAlgorithmConstraints = ReflectionUtil.findMethod(methodArray, "getAlgorithmConstraints");
        setAlgorithmConstraints = ReflectionUtil.findMethod(methodArray, "setAlgorithmConstraints");
        getApplicationProtocols = ReflectionUtil.findMethod(methodArray, "getApplicationProtocols");
        setApplicationProtocols = ReflectionUtil.findMethod(methodArray, "setApplicationProtocols");
        getEndpointIdentificationAlgorithm = ReflectionUtil.findMethod(methodArray, "getEndpointIdentificationAlgorithm");
        setEndpointIdentificationAlgorithm = ReflectionUtil.findMethod(methodArray, "setEndpointIdentificationAlgorithm");
        getServerNames = ReflectionUtil.findMethod(methodArray, "getServerNames");
        setServerNames = ReflectionUtil.findMethod(methodArray, "setServerNames");
        getSNIMatchers = ReflectionUtil.findMethod(methodArray, "getSNIMatchers");
        setSNIMatchers = ReflectionUtil.findMethod(methodArray, "setSNIMatchers");
        getUseCipherSuitesOrder = ReflectionUtil.findMethod(methodArray, "getUseCipherSuitesOrder");
        setUseCipherSuitesOrder = ReflectionUtil.findMethod(methodArray, "setUseCipherSuitesOrder");
    }
}

