/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class Frame {
    private RubyModule klazz;
    private IRubyObject self;
    private String name;
    private Block block = Block.NULL_BLOCK;
    private Visibility visibility = Visibility.PUBLIC;
    private IRubyObject backRef;
    private IRubyObject lastLine;
    boolean captured;
    @Deprecated
    public static final Frame DUMMY = new Frame();

    public Frame() {
    }

    private Frame(Block nullBlock) {
        this.block = nullBlock;
    }

    private Frame(Frame frame) {
        Block block = frame.block;
        block.getClass();
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.block = block;
        this.visibility = frame.visibility;
    }

    public void updateFrame() {
        this.updateFrame(null, null, null, Block.NULL_BLOCK);
    }

    public void updateFrame(String name2) {
        this.name = name2;
    }

    public void updateFrame(Frame frame) {
        Block block = frame.block;
        block.getClass();
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.block = frame.block;
        this.visibility = frame.visibility;
    }

    public void updateFrame(RubyModule klazz, IRubyObject self2, String name2, Block block) {
        block.getClass();
        this.self = self2;
        this.name = name2;
        this.klazz = klazz;
        this.block = block;
        this.visibility = Visibility.PUBLIC;
    }

    public void updateFrameForEval(IRubyObject self2) {
        this.self = self2;
        this.name = null;
        this.visibility = Visibility.PRIVATE;
    }

    public void updateFrameForBackref() {
    }

    public void clearFrameForBackref() {
        this.backRef = null;
    }

    public Frame clear() {
        this.self = null;
        this.klazz = null;
        this.block = Block.NULL_BLOCK;
        this.backRef = null;
        this.lastLine = null;
        return this;
    }

    public Frame duplicate() {
        return new Frame(this);
    }

    public Frame duplicateForBacktrace() {
        Frame backtraceFrame = new Frame();
        backtraceFrame.name = this.name;
        return backtraceFrame;
    }

    public RubyModule getKlazz() {
        return this.klazz;
    }

    public void setKlazz(RubyModule klazz) {
        this.klazz = klazz;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public String getName() {
        return this.name;
    }

    public IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject self2) {
        this.self = self2;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Block getBlock() {
        return this.block;
    }

    public IRubyObject getBackRef(IRubyObject nil) {
        IRubyObject backRef = this.backRef;
        return backRef == null ? nil : backRef;
    }

    public IRubyObject setBackRef(IRubyObject backRef) {
        this.backRef = backRef;
        return this.backRef;
    }

    public IRubyObject getLastLine(IRubyObject nil) {
        IRubyObject lastLine = this.lastLine;
        return lastLine == null ? nil : lastLine;
    }

    public IRubyObject setLastLine(IRubyObject lastLine) {
        this.lastLine = lastLine;
        return this.lastLine;
    }

    public void setCaptured(boolean captured) {
        this.captured = captured;
    }

    public Frame capture() {
        this.captured = true;
        return this;
    }

    public boolean isCaptured() {
        return this.captured;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("Frame<");
        sb.append(this.klazz);
        if (this.name != null) {
            sb.append(" in ").append(this.name);
        }
        sb.append(">");
        return sb.toString();
    }
}

