'''OpenGL extension INTEL.swap_event

This module customises the behaviour of the 
OpenGL.raw.GLX.INTEL.swap_event to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds a new event type, GLX_BUFFER_SWAP_COMPLETE_INTEL,
	which is sent to the client via the X11 event stream and
	selected/consumed by the normal GLX event mask mechanisms, to indicate
	when a previously queued swap has completed.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/INTEL/swap_event.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLX import _types, _glgets
from OpenGL.raw.GLX.INTEL.swap_event import *
from OpenGL.raw.GLX.INTEL.swap_event import _EXTENSION_NAME

def glInitSwapEventINTEL():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION