/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ENewArray;
import org.elasticsearch.painless.node.EVariable;
import org.elasticsearch.painless.node.ILambda;
import org.elasticsearch.painless.node.SFunction;
import org.elasticsearch.painless.node.SReturn;
import org.objectweb.asm.Type;

public final class ENewArrayFunctionRef
extends AExpression
implements ILambda {
    private final String type;
    private CompilerSettings settings;
    private SFunction function;
    private FunctionRef ref;
    private String defPointer;

    public ENewArrayFunctionRef(Location location, String type) {
        super(location);
        this.type = Objects.requireNonNull(type);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        this.settings = settings;
    }

    @Override
    void extractVariables(Set<String> variables) {
    }

    @Override
    void analyze(Locals locals) {
        SReturn code = new SReturn(this.location, new ENewArray(this.location, this.type, Arrays.asList(new EVariable(this.location, "size")), false));
        this.function = new SFunction(this.location, this.type, locals.getNextSyntheticName(), Arrays.asList("int"), Arrays.asList("size"), Arrays.asList(code), true);
        this.function.storeSettings(this.settings);
        this.function.generateSignature(locals.getPainlessLookup());
        this.function.extractVariables(null);
        this.function.analyze(Locals.newLambdaScope(locals.getProgramScope(), this.function.name, this.function.returnType, this.function.parameters, 0, this.settings.getMaxLoopCounter()));
        if (this.expected == null) {
            this.ref = null;
            this.actual = String.class;
            this.defPointer = "Sthis." + this.function.name + ",0";
        } else {
            this.defPointer = null;
            this.ref = FunctionRef.create(locals.getPainlessLookup(), locals.getMethods(), this.location, this.expected, "this", this.function.name, 0);
            this.actual = this.expected;
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        if (this.ref != null) {
            writer.writeDebugInfo(this.location);
            writer.invokeLambdaCall(this.ref);
        } else {
            writer.push(null);
        }
        globals.addSyntheticMethod(this.function);
    }

    @Override
    public String getPointer() {
        return this.defPointer;
    }

    @Override
    public Type[] getCaptures() {
        return new Type[0];
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.type + "[]", "new");
    }
}

