/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.compression;

import com.jcraft.jzlib.ZStream;
import java.io.IOException;
import org.apache.mina.core.buffer.IoBuffer;

class Zlib {
    public static final int COMPRESSION_MAX = 9;
    public static final int COMPRESSION_MIN = 1;
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_DEFAULT = -1;
    public static final int MODE_DEFLATER = 1;
    public static final int MODE_INFLATER = 2;
    private int compressionLevel;
    private ZStream zStream = null;
    private int mode = -1;

    public Zlib(int compressionLevel, int mode) {
        switch (compressionLevel) {
            case -1: 
            case 0: 
            case 1: 
            case 9: {
                this.compressionLevel = compressionLevel;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid compression level specified");
            }
        }
        this.zStream = new ZStream();
        switch (mode) {
            case 1: {
                this.zStream.deflateInit(this.compressionLevel);
                break;
            }
            case 2: {
                this.zStream.inflateInit();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid mode specified");
            }
        }
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoBuffer inflate(IoBuffer inBuffer) throws IOException {
        if (this.mode == 1) {
            throw new IllegalStateException("not initialized as INFLATER");
        }
        byte[] inBytes = new byte[inBuffer.remaining()];
        inBuffer.get(inBytes).flip();
        byte[] outBytes = new byte[inBytes.length * 2];
        IoBuffer outBuffer = IoBuffer.allocate((int)outBytes.length);
        outBuffer.setAutoExpand(true);
        ZStream zStream = this.zStream;
        synchronized (zStream) {
            this.zStream.next_in = inBytes;
            this.zStream.next_in_index = 0;
            this.zStream.avail_in = inBytes.length;
            this.zStream.next_out = outBytes;
            this.zStream.next_out_index = 0;
            this.zStream.avail_out = outBytes.length;
            int retval = 0;
            do {
                retval = this.zStream.inflate(2);
                switch (retval) {
                    case -5: 
                    case 0: {
                        outBuffer.put(outBytes, 0, this.zStream.next_out_index);
                        this.zStream.next_out_index = 0;
                        this.zStream.avail_out = outBytes.length;
                        break;
                    }
                    default: {
                        outBuffer = null;
                        if (this.zStream.msg == null) {
                            throw new IOException("Unknown error. Error code : " + retval);
                        }
                        throw new IOException("Unknown error. Error code : " + retval + " and message : " + this.zStream.msg);
                    }
                }
            } while (this.zStream.avail_in > 0);
            this.cleanUp();
        }
        return outBuffer.flip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoBuffer deflate(IoBuffer inBuffer) throws IOException {
        if (this.mode == 2) {
            throw new IllegalStateException("not initialized as DEFLATER");
        }
        byte[] inBytes = new byte[inBuffer.remaining()];
        inBuffer.get(inBytes);
        int outLen = (int)Math.round((double)inBytes.length * 1.001) + 1 + 12;
        byte[] outBytes = new byte[outLen];
        ZStream zStream = this.zStream;
        synchronized (zStream) {
            this.zStream.next_in = inBytes;
            this.zStream.next_in_index = 0;
            this.zStream.avail_in = inBytes.length;
            this.zStream.next_out = outBytes;
            this.zStream.next_out_index = 0;
            this.zStream.avail_out = outBytes.length;
            int retval = this.zStream.deflate(2);
            if (retval != 0) {
                outBytes = null;
                inBytes = null;
                throw new IOException("Compression failed with return value : " + retval);
            }
            IoBuffer outBuf = IoBuffer.wrap((byte[])outBytes, (int)0, (int)this.zStream.next_out_index);
            this.cleanUp();
            return outBuf;
        }
    }

    public void cleanUp() {
        if (this.zStream != null) {
            this.zStream.free();
        }
    }
}

