# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Python interface to the FastJet jet clustering package.  

Usage is similar to the C++ case, with a few small changes noted
below.

Notes
-----

- You can pass a python list such as [PseudoJet0, PseudoJet1, ...]
  to any FastJet call that expects a vector of PseudoJets

- Any FastJet call that in C++ returns a vector of PseudoJets will in
  python return a tuple (or list) of PseudoJets

- for many objects that provide definitions of some kind, __str__
  call maps to description(). So, for example, you can just do

       jet_def = fastjet.JetDefinition(fastjet.antikt_algorithm, 0.4)
       print jet_def

- for combinations of selectors, (&&, || and !) in C++ map to 
  (&, | and ~) in python

- Selector::pass is remapped to Selector._pass

- remember that python uses reference, e.g. a = b means that a is a
  reference to b. If you need to copy a PseudoJet (pj), with a view to
  altering it, do 'pjcopy = PseudoJet(pj)'

- the python documentation has been automatically generated from the
  C++ doxygen documentation: python/C++ differences are not indicated,
  and certain methods and classes may be documented that were not
  included in the python conversion and/or configured for this
  particular installation.

Example
-------

  from fastjet import *
  particles = []
  particles.append(PseudoJet(100.0, 0.0, 0.0, 100.0)) # px, py, pz, E
  particles.append(PseudoJet(150.0, 0.0, 0.0, 150.0))

  R = 0.4
  jet_def = JetDefinition(antikt_algorithm, R)

  jets = jet_def(particles)

  print jet_def
  for jet in jets: print jet


"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_fastjet')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_fastjet')
    _fastjet = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_fastjet', [dirname(__file__)])
        except ImportError:
            import _fastjet
            return _fastjet
        try:
            _mod = imp.load_module('_fastjet', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _fastjet = swig_import_helper()
    del swig_import_helper
else:
    import _fastjet
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _fastjet.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _fastjet.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _fastjet.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _fastjet.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _fastjet.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _fastjet.SwigPyIterator_equal(self, x)

    def copy(self):
        return _fastjet.SwigPyIterator_copy(self)

    def next(self):
        return _fastjet.SwigPyIterator_next(self)

    def __next__(self):
        return _fastjet.SwigPyIterator___next__(self)

    def previous(self):
        return _fastjet.SwigPyIterator_previous(self)

    def advance(self, n):
        return _fastjet.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _fastjet.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _fastjet.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _fastjet.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _fastjet.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _fastjet.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _fastjet.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _fastjet.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

class vectorPJ(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, vectorPJ, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, vectorPJ, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _fastjet.vectorPJ_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _fastjet.vectorPJ___nonzero__(self)

    def __bool__(self):
        return _fastjet.vectorPJ___bool__(self)

    def __len__(self):
        return _fastjet.vectorPJ___len__(self)

    def __getslice__(self, i, j):
        return _fastjet.vectorPJ___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _fastjet.vectorPJ___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _fastjet.vectorPJ___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _fastjet.vectorPJ___delitem__(self, *args)

    def __getitem__(self, *args):
        return _fastjet.vectorPJ___getitem__(self, *args)

    def __setitem__(self, *args):
        return _fastjet.vectorPJ___setitem__(self, *args)

    def pop(self):
        return _fastjet.vectorPJ_pop(self)

    def append(self, x):
        return _fastjet.vectorPJ_append(self, x)

    def empty(self):
        return _fastjet.vectorPJ_empty(self)

    def size(self):
        return _fastjet.vectorPJ_size(self)

    def swap(self, v):
        return _fastjet.vectorPJ_swap(self, v)

    def begin(self):
        return _fastjet.vectorPJ_begin(self)

    def end(self):
        return _fastjet.vectorPJ_end(self)

    def rbegin(self):
        return _fastjet.vectorPJ_rbegin(self)

    def rend(self):
        return _fastjet.vectorPJ_rend(self)

    def clear(self):
        return _fastjet.vectorPJ_clear(self)

    def get_allocator(self):
        return _fastjet.vectorPJ_get_allocator(self)

    def pop_back(self):
        return _fastjet.vectorPJ_pop_back(self)

    def erase(self, *args):
        return _fastjet.vectorPJ_erase(self, *args)

    def __init__(self, *args):
        this = _fastjet.new_vectorPJ(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _fastjet.vectorPJ_push_back(self, x)

    def front(self):
        return _fastjet.vectorPJ_front(self)

    def back(self):
        return _fastjet.vectorPJ_back(self)

    def assign(self, n, x):
        return _fastjet.vectorPJ_assign(self, n, x)

    def resize(self, *args):
        return _fastjet.vectorPJ_resize(self, *args)

    def insert(self, *args):
        return _fastjet.vectorPJ_insert(self, *args)

    def reserve(self, n):
        return _fastjet.vectorPJ_reserve(self, n)

    def capacity(self):
        return _fastjet.vectorPJ_capacity(self)
    __swig_destroy__ = _fastjet.delete_vectorPJ
    __del__ = lambda self: None
vectorPJ_swigregister = _fastjet.vectorPJ_swigregister
vectorPJ_swigregister(vectorPJ)

_INCLUDE_FASTJET_CONFIG_AUTO_H = _fastjet._INCLUDE_FASTJET_CONFIG_AUTO_H
FASTJET_HAVE_DLFCN_H = _fastjet.FASTJET_HAVE_DLFCN_H
FASTJET_HAVE_EXECINFO_H = _fastjet.FASTJET_HAVE_EXECINFO_H
FASTJET_HAVE_INTTYPES_H = _fastjet.FASTJET_HAVE_INTTYPES_H
FASTJET_HAVE_LIBM = _fastjet.FASTJET_HAVE_LIBM
FASTJET_HAVE_MEMORY_H = _fastjet.FASTJET_HAVE_MEMORY_H
FASTJET_HAVE_STDINT_H = _fastjet.FASTJET_HAVE_STDINT_H
FASTJET_HAVE_STDLIB_H = _fastjet.FASTJET_HAVE_STDLIB_H
FASTJET_HAVE_STRINGS_H = _fastjet.FASTJET_HAVE_STRINGS_H
FASTJET_HAVE_STRING_H = _fastjet.FASTJET_HAVE_STRING_H
FASTJET_HAVE_SYS_STAT_H = _fastjet.FASTJET_HAVE_SYS_STAT_H
FASTJET_HAVE_SYS_TYPES_H = _fastjet.FASTJET_HAVE_SYS_TYPES_H
FASTJET_HAVE_UNISTD_H = _fastjet.FASTJET_HAVE_UNISTD_H
FASTJET_LT_OBJDIR = _fastjet.FASTJET_LT_OBJDIR
FASTJET_PACKAGE = _fastjet.FASTJET_PACKAGE
FASTJET_PACKAGE_BUGREPORT = _fastjet.FASTJET_PACKAGE_BUGREPORT
FASTJET_PACKAGE_NAME = _fastjet.FASTJET_PACKAGE_NAME
FASTJET_PACKAGE_STRING = _fastjet.FASTJET_PACKAGE_STRING
FASTJET_PACKAGE_TARNAME = _fastjet.FASTJET_PACKAGE_TARNAME
FASTJET_PACKAGE_URL = _fastjet.FASTJET_PACKAGE_URL
FASTJET_PACKAGE_VERSION = _fastjet.FASTJET_PACKAGE_VERSION
FASTJET_STDC_HEADERS = _fastjet.FASTJET_STDC_HEADERS
FASTJET_VERSION = _fastjet.FASTJET_VERSION
FASTJET_VERSION_MAJOR = _fastjet.FASTJET_VERSION_MAJOR
FASTJET_VERSION_MINOR = _fastjet.FASTJET_VERSION_MINOR
FASTJET_VERSION_NUMBER = _fastjet.FASTJET_VERSION_NUMBER
FASTJET_VERSION_PATCHLEVEL = _fastjet.FASTJET_VERSION_PATCHLEVEL
__FASTJET_BASICRANDOM_HH__ = _fastjet.__FASTJET_BASICRANDOM_HH__

def __default_random_generator(__iseed):
    return _fastjet.__default_random_generator(__iseed)
__default_random_generator = _fastjet.__default_random_generator
class LimitedWarning(_object):
    """


    class to provide facilities for giving warnings up to some maximum number of
    times and to provide global summaries of warnings that have been issued.  

    C++ includes: fastjet/LimitedWarning.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LimitedWarning, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LimitedWarning, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `LimitedWarning(int max_warn_in)`  

        constructor that provides a user-set max number of warnings  

        """
        this = _fastjet.new_LimitedWarning(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def warn(self, *args):
        """

        `warn(const std::string &warning, std::ostream *ostr)`  

        outputs a warning to the specified stream  

        """
        return _fastjet.LimitedWarning_warn(self, *args)


    def set_default_stream(ostr):
        """

        `set_default_stream(std::ostream *ostr)`  

        sets the default output stream for all warnings (by default cerr; passing a null
        pointer prevents warnings from being output)  

        """
        return _fastjet.LimitedWarning_set_default_stream(ostr)

    set_default_stream = staticmethod(set_default_stream)

    def set_default_max_warn(max_warn):
        """

        `set_default_max_warn(int max_warn)`  

        sets the default maximum number of warnings of a given kind before warning
        messages are silenced.  

        """
        return _fastjet.LimitedWarning_set_default_max_warn(max_warn)

    set_default_max_warn = staticmethod(set_default_max_warn)

    def max_warn(self):
        """

        `max_warn() const -> int`  

        the maximum number of warning messages that will be printed by this instance of
        the class  

        """
        return _fastjet.LimitedWarning_max_warn(self)


    def n_warn_so_far(self):
        """

        `n_warn_so_far() const -> int`  

        the number of times so far that a warning has been registered with this instance
        of the class.  

        """
        return _fastjet.LimitedWarning_n_warn_so_far(self)


    def summary():
        """

        `summary() -> std::string`  

        returns a summary of all the warnings that came through the LimiteWarning class  

        """
        return _fastjet.LimitedWarning_summary()

    summary = staticmethod(summary)
    __swig_destroy__ = _fastjet.delete_LimitedWarning
    __del__ = lambda self: None
LimitedWarning_swigregister = _fastjet.LimitedWarning_swigregister
LimitedWarning_swigregister(LimitedWarning)
cvar = _fastjet.cvar
pi = cvar.pi
twopi = cvar.twopi
pisq = cvar.pisq
zeta2 = cvar.zeta2
zeta3 = cvar.zeta3
eulergamma = cvar.eulergamma
ln2 = cvar.ln2

def LimitedWarning_set_default_stream(ostr):
    """

    `set_default_stream(std::ostream *ostr)`  

    sets the default output stream for all warnings (by default cerr; passing a null
    pointer prevents warnings from being output)  

    """
    return _fastjet.LimitedWarning_set_default_stream(ostr)

def LimitedWarning_set_default_max_warn(max_warn):
    """

    `set_default_max_warn(int max_warn)`  

    sets the default maximum number of warnings of a given kind before warning
    messages are silenced.  

    """
    return _fastjet.LimitedWarning_set_default_max_warn(max_warn)

def LimitedWarning_summary():
    """

    `summary() -> std::string`  

    returns a summary of all the warnings that came through the LimiteWarning class  

    """
    return _fastjet.LimitedWarning_summary()

class Error(_object):
    """


    base class corresponding to errors that can be thrown by FastJet  

    C++ includes: fastjet/Error.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Error, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Error, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `Error(const std::string &message)`  

        ctor from an error message  

        Parameters
        ----------
        * `message` :  
            to be printed Note: in addition to the error message, one can choose to
            print the backtrace (showing the last few calls before the error) by using
            set_print_backtrace(true). The default is "false".  

        """
        this = _fastjet.new_Error(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_Error
    __del__ = lambda self: None

    def message(self):
        """

        `message() const -> std::string`  

        the error message  

        """
        return _fastjet.Error_message(self)


    def description(self):
        return _fastjet.Error_description(self)

    def set_print_errors(print_errors):
        """

        `set_print_errors(bool print_errors)`  

        controls whether the error message (and the backtrace, if its printing is
        enabled) is printed out or not  

        """
        return _fastjet.Error_set_print_errors(print_errors)

    set_print_errors = staticmethod(set_print_errors)

    def set_print_backtrace(enabled):
        """

        `set_print_backtrace(bool enabled)`  

        controls whether the backtrace is printed out with the error message or not.  

        The default is "false".  

        """
        return _fastjet.Error_set_print_backtrace(enabled)

    set_print_backtrace = staticmethod(set_print_backtrace)

    def set_default_stream(ostr):
        """

        `set_default_stream(std::ostream *ostr)`  

        sets the default output stream for all errors; by default cerr; if it's null
        then error output is suppressed.  

        """
        return _fastjet.Error_set_default_stream(ostr)

    set_default_stream = staticmethod(set_default_stream)

    def __str__(self):
        return _fastjet.Error___str__(self)
Error_swigregister = _fastjet.Error_swigregister
Error_swigregister(Error)

def Error_set_print_errors(print_errors):
    """

    `set_print_errors(bool print_errors)`  

    controls whether the error message (and the backtrace, if its printing is
    enabled) is printed out or not  

    """
    return _fastjet.Error_set_print_errors(print_errors)

def Error_set_print_backtrace(enabled):
    """

    `set_print_backtrace(bool enabled)`  

    controls whether the backtrace is printed out with the error message or not.  

    The default is "false".  

    """
    return _fastjet.Error_set_print_backtrace(enabled)

def Error_set_default_stream(ostr):
    """

    `set_default_stream(std::ostream *ostr)`  

    sets the default output stream for all errors; by default cerr; if it's null
    then error output is suppressed.  

    """
    return _fastjet.Error_set_default_stream(ostr)

class InternalError(Error):
    """


    class corresponding to critical internal errors  

    This is an error class (derived from Error) meant for serious, critical,
    internal errors that we still want to be catchable by an end-user [e.g. a
    serious issue in clustering where the end-user can catch it and retry with a
    different strategy]  

    Please directly contact the FastJet authors if you see such an error.  

    C++ includes: fastjet/Error.hh

    """

    __swig_setmethods__ = {}
    for _s in [Error]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InternalError, name, value)
    __swig_getmethods__ = {}
    for _s in [Error]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InternalError, name)
    __repr__ = _swig_repr

    def __init__(self, message_in):
        """

        `InternalError(const std::string &message_in)`  

        ctor with error message: just add a bit of info to the message and pass it to
        the base class  

        """
        this = _fastjet.new_InternalError(message_in)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_InternalError
    __del__ = lambda self: None
InternalError_swigregister = _fastjet.InternalError_swigregister
InternalError_swigregister(InternalError)

class PseudoJetStructureBase(_object):
    """


    Contains any information related to the clustering that should be directly
    accessible to PseudoJet.  

    By default, this class implements basic access to the ClusterSequence related to
    a PseudoJet (like its constituents or its area). But it can be overloaded in
    order e.g. to give access to the jet substructure.  

    C++ includes: fastjet/PseudoJetStructureBase.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PseudoJetStructureBase, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PseudoJetStructureBase, name)
    __repr__ = _swig_repr

    def __init__(self):
        """

        `PseudoJetStructureBase()`  

        default ctor  

        """
        this = _fastjet.new_PseudoJetStructureBase()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_PseudoJetStructureBase
    __del__ = lambda self: None

    def description(self):
        """

        `description() const -> std::string`  

        description  

        """
        return _fastjet.PseudoJetStructureBase_description(self)


    def has_associated_cluster_sequence(self):
        """

        `has_associated_cluster_sequence() const -> bool`  

        returns true if there is an associated ClusterSequence  

        """
        return _fastjet.PseudoJetStructureBase_has_associated_cluster_sequence(self)


    def associated_cluster_sequence(self):
        """

        `associated_cluster_sequence() const -> const ClusterSequence *`  

        get a (const) pointer to the parent ClusterSequence (NULL if inexistent)  

        """
        return _fastjet.PseudoJetStructureBase_associated_cluster_sequence(self)


    def has_valid_cluster_sequence(self):
        """

        `has_valid_cluster_sequence() const -> bool`  

        returns true if this PseudoJet has an associated and still valid
        ClusterSequence.  

        """
        return _fastjet.PseudoJetStructureBase_has_valid_cluster_sequence(self)


    def validated_cs(self):
        """

        `validated_cs() const -> const ClusterSequence *`  

        if the jet has a valid associated cluster sequence then return a pointer to it;
        otherwise throw an error  

        """
        return _fastjet.PseudoJetStructureBase_validated_cs(self)


    def validated_csab(self):
        """

        `validated_csab() const -> const ClusterSequenceAreaBase *`  

        if the jet has valid area information then return a pointer to the associated
        ClusterSequenceAreaBase object; otherwise throw an error  

        """
        return _fastjet.PseudoJetStructureBase_validated_csab(self)


    def has_partner(self, reference, partner):
        """

        `has_partner(const PseudoJet &reference, PseudoJet &partner) const -> bool`  

        check if it has been recombined with another PseudoJet in which case, return its
        partner through the argument.  

        Otherwise, 'partner' is set to 0.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_has_partner(self, reference, partner)


    def has_child(self, reference, child):
        """

        `has_child(const PseudoJet &reference, PseudoJet &child) const -> bool`  

        check if it has been recombined with another PseudoJet in which case, return its
        child through the argument.  

        Otherwise, 'child' is set to 0.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_has_child(self, reference, child)


    def has_parents(self, reference, parent1, parent2):
        """

        `has_parents(const PseudoJet &reference, PseudoJet &parent1, PseudoJet &parent2)
            const -> bool`  

        check if it is the product of a recombination, in which case return the 2
        parents through the 'parent1' and 'parent2' arguments.  

        Otherwise, set these to 0.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_has_parents(self, reference, parent1, parent2)


    def object_in_jet(self, reference, jet):
        """

        `object_in_jet(const PseudoJet &reference, const PseudoJet &jet) const -> bool`  

        check if the reference PseudoJet is contained the second one passed as argument.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_object_in_jet(self, reference, jet)


    def has_constituents(self):
        """

        `has_constituents() const -> bool`  

        return true if the structure supports constituents.  

        false by default  

        """
        return _fastjet.PseudoJetStructureBase_has_constituents(self)


    def constituents(self, reference):
        """

        `constituents(const PseudoJet &reference) const -> std::vector< PseudoJet >`  

        retrieve the constituents.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_constituents(self, reference)


    def has_exclusive_subjets(self):
        """

        `has_exclusive_subjets() const -> bool`  

        return true if the structure supports exclusive_subjets.  

        """
        return _fastjet.PseudoJetStructureBase_has_exclusive_subjets(self)


    def exclusive_subjets(self, reference, dcut):
        """

        `exclusive_subjets(const PseudoJet &reference, const double &dcut) const ->
            std::vector< PseudoJet >`  

        return a vector of all subjets of the current jet (in the sense of the exclusive
        algorithm) that would be obtained when running the algorithm with the given
        dcut.  

        Time taken is O(m ln m), where m is the number of subjets that are found. If m
        gets to be of order of the total number of constituents in the jet, this could
        be substantially slower than just getting that list of constituents.  

        By default, throws an Error  

        Note: in a future major release of FastJet (4 or higher), "const double &
        dcut" may be replaced with "const double dcut", requiring a modification of
        derived classes that overload this function.  

        """
        return _fastjet.PseudoJetStructureBase_exclusive_subjets(self, reference, dcut)


    def n_exclusive_subjets(self, reference, dcut):
        """

        `n_exclusive_subjets(const PseudoJet &reference, const double &dcut) const ->
            int`  

        return the size of exclusive_subjets(...); still n ln n with same coefficient,
        but marginally more efficient than manually taking exclusive_subjets.size()  

        By default, throws an Error  

        Note: in a future major release of FastJet (4 or higher), "const double &
        dcut" may be replaced with "const double dcut", requiring a modification of
        derived classes that overload this function.  

        """
        return _fastjet.PseudoJetStructureBase_n_exclusive_subjets(self, reference, dcut)


    def exclusive_subjets_up_to(self, reference, nsub):
        """

        `exclusive_subjets_up_to(const PseudoJet &reference, int nsub) const ->
            std::vector< PseudoJet >`  

        return the list of subjets obtained by unclustering the supplied jet down to
        nsub subjets (or all constituents if there are fewer than nsub).  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_exclusive_subjets_up_to(self, reference, nsub)


    def exclusive_subdmerge(self, reference, nsub):
        """

        `exclusive_subdmerge(const PseudoJet &reference, int nsub) const -> double`  

        return the dij that was present in the merging nsub+1 -> nsub subjets inside
        this jet.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_exclusive_subdmerge(self, reference, nsub)


    def exclusive_subdmerge_max(self, reference, nsub):
        """

        `exclusive_subdmerge_max(const PseudoJet &reference, int nsub) const -> double`  

        return the maximum dij that occurred in the whole event at the stage that the
        nsub+1 -> nsub merge of subjets occurred inside this jet.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_exclusive_subdmerge_max(self, reference, nsub)


    def has_pieces(self, arg2):
        """

        `has_pieces(const PseudoJet &) const -> bool`  

        return true if the structure supports pieces.  

        false by default NB: "reference" is commented to avoid unused-variable
        compiler warnings  

        """
        return _fastjet.PseudoJetStructureBase_has_pieces(self, arg2)


    def pieces(self, arg2):
        """

        `pieces(const PseudoJet &) const -> std::vector< PseudoJet >`  

        retrieve the pieces building the jet.  

        By default, throws an Error. NB: "reference" is commented to avoid unused-
        variable compiler warnings  

        """
        return _fastjet.PseudoJetStructureBase_pieces(self, arg2)


    def has_area(self):
        """

        `has_area() const -> bool`  

        check if it has a defined area  

        false by default  

        """
        return _fastjet.PseudoJetStructureBase_has_area(self)


    def area(self, reference):
        """

        `area(const PseudoJet &reference) const -> double`  

        return the jet (scalar) area.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_area(self, reference)


    def area_error(self, reference):
        """

        `area_error(const PseudoJet &reference) const -> double`  

        return the error (uncertainty) associated with the determination of the area of
        this jet.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_area_error(self, reference)


    def area_4vector(self, reference):
        """

        `area_4vector(const PseudoJet &reference) const -> PseudoJet`  

        return the jet 4-vector area.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_area_4vector(self, reference)


    def is_pure_ghost(self, reference):
        """

        `is_pure_ghost(const PseudoJet &reference) const -> bool`  

        true if this jet is made exclusively of ghosts.  

        By default, throws an Error  

        """
        return _fastjet.PseudoJetStructureBase_is_pure_ghost(self, reference)

PseudoJetStructureBase_swigregister = _fastjet.PseudoJetStructureBase_swigregister
PseudoJetStructureBase_swigregister(PseudoJetStructureBase)

class PseudoJet(_object):
    """


    Class to contain pseudojets, including minimal information of use to jet-
    clustering routines.  

    C++ includes: fastjet/PseudoJet.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PseudoJet, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PseudoJet, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `PseudoJet(const siscone_spherical::CSphmomentum &four_vector)`  

        shortcut for converting siscone CSphmomentum into PseudoJet  

        """
        this = _fastjet.new_PseudoJet(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_PseudoJet
    __del__ = lambda self: None

    def E(self):
        """

        `E() const -> double`  

        """
        return _fastjet.PseudoJet_E(self)


    def e(self):
        """

        `e() const -> double`  

        """
        return _fastjet.PseudoJet_e(self)


    def px(self):
        """

        `px() const -> double`  

        """
        return _fastjet.PseudoJet_px(self)


    def py(self):
        """

        `py() const -> double`  

        """
        return _fastjet.PseudoJet_py(self)


    def pz(self):
        """

        `pz() const -> double`  

        """
        return _fastjet.PseudoJet_pz(self)


    def phi(self):
        """

        `phi() const -> double`  

        returns phi (in the range 0..2pi)  

        """
        return _fastjet.PseudoJet_phi(self)


    def phi_std(self):
        """

        `phi_std() const -> double`  

        returns phi in the range -pi..pi  

        """
        return _fastjet.PseudoJet_phi_std(self)


    def phi_02pi(self):
        """

        `phi_02pi() const -> double`  

        returns phi in the range 0..2pi  

        """
        return _fastjet.PseudoJet_phi_02pi(self)


    def rap(self):
        """

        `rap() const -> double`  

        returns the rapidity or some large value when the rapidity is infinite  

        """
        return _fastjet.PseudoJet_rap(self)


    def rapidity(self):
        """

        `rapidity() const -> double`  

        the same as rap()  

        """
        return _fastjet.PseudoJet_rapidity(self)


    def pseudorapidity(self):
        """

        `pseudorapidity() const -> double`  

        returns the pseudo-rapidity or some large value when the rapidity is infinite  

        """
        return _fastjet.PseudoJet_pseudorapidity(self)


    def eta(self):
        """

        `eta() const -> double`  

        """
        return _fastjet.PseudoJet_eta(self)


    def pt2(self):
        """

        `pt2() const -> double`  

        returns the squared transverse momentum  

        """
        return _fastjet.PseudoJet_pt2(self)


    def pt(self):
        """

        `pt() const -> double`  

        returns the scalar transverse momentum  

        """
        return _fastjet.PseudoJet_pt(self)


    def perp2(self):
        """

        `perp2() const -> double`  

        returns the squared transverse momentum  

        """
        return _fastjet.PseudoJet_perp2(self)


    def perp(self):
        """

        `perp() const -> double`  

        returns the scalar transverse momentum  

        """
        return _fastjet.PseudoJet_perp(self)


    def kt2(self):
        """

        `kt2() const -> double`  

        returns the squared transverse momentum  

        """
        return _fastjet.PseudoJet_kt2(self)


    def m2(self):
        """

        `m2() const -> double`  

        returns the squared invariant mass // like CLHEP  

        """
        return _fastjet.PseudoJet_m2(self)


    def m(self):
        """

        `m() const -> double`  

        returns the invariant mass (If m2() is negative then -sqrt(-m2()) is returned,
        as in CLHEP)  

        """
        return _fastjet.PseudoJet_m(self)


    def mperp2(self):
        """

        `mperp2() const -> double`  

        returns the squared transverse mass = kt^2+m^2  

        """
        return _fastjet.PseudoJet_mperp2(self)


    def mperp(self):
        """

        `mperp() const -> double`  

        returns the transverse mass = sqrt(kt^2+m^2)  

        """
        return _fastjet.PseudoJet_mperp(self)


    def mt2(self):
        """

        `mt2() const -> double`  

        returns the squared transverse mass = kt^2+m^2  

        """
        return _fastjet.PseudoJet_mt2(self)


    def mt(self):
        """

        `mt() const -> double`  

        returns the transverse mass = sqrt(kt^2+m^2)  

        """
        return _fastjet.PseudoJet_mt(self)


    def modp2(self):
        """

        `modp2() const -> double`  

        return the squared 3-vector modulus = px^2+py^2+pz^2  

        """
        return _fastjet.PseudoJet_modp2(self)


    def modp(self):
        """

        `modp() const -> double`  

        return the 3-vector modulus = sqrt(px^2+py^2+pz^2)  

        """
        return _fastjet.PseudoJet_modp(self)


    def Et(self):
        """

        `Et() const -> double`  

        return the transverse energy  

        """
        return _fastjet.PseudoJet_Et(self)


    def Et2(self):
        """

        `Et2() const -> double`  

        return the transverse energy squared  

        """
        return _fastjet.PseudoJet_Et2(self)


    def cos_theta(self):
        return _fastjet.PseudoJet_cos_theta(self)

    def theta(self):
        return _fastjet.PseudoJet_theta(self)

    def __call__(self, i):
        return _fastjet.PseudoJet___call__(self, i)

    def kt_distance(self, other):
        """

        `kt_distance(const PseudoJet &other) const -> double`  

        returns kt distance (R=1) between this jet and another  

        """
        return _fastjet.PseudoJet_kt_distance(self, other)


    def plain_distance(self, other):
        """

        `plain_distance(const PseudoJet &other) const -> double`  

        returns squared cylinder (rap-phi) distance between this jet and another  

        """
        return _fastjet.PseudoJet_plain_distance(self, other)


    def squared_distance(self, other):
        """

        `squared_distance(const PseudoJet &other) const -> double`  

        returns squared cylinder (rap-phi) distance between this jet and another  

        """
        return _fastjet.PseudoJet_squared_distance(self, other)


    def delta_R(self, other):
        """

        `delta_R(const PseudoJet &other) const -> double`  

        return the cylinder (rap-phi) distance between this jet and another, $\Delta_R
        = \sqrt{\Delta y^2 + \Delta \phi^2}$.  

        """
        return _fastjet.PseudoJet_delta_R(self, other)


    def delta_phi_to(self, other):
        """

        `delta_phi_to(const PseudoJet &other) const -> double`  

        returns other.phi() - this.phi(), constrained to be in range -pi .  

        returns other.phi() - this.phi(), i.e.  

        . pi  

        the phi distance to other, constrained to be in range -pi .. pi  

        """
        return _fastjet.PseudoJet_delta_phi_to(self, other)


    def beam_distance(self):
        """

        `beam_distance() const -> double`  

        returns distance between this jet and the beam  

        """
        return _fastjet.PseudoJet_beam_distance(self)


    def four_mom(self):
        """

        `four_mom() const -> std::valarray< double >`  

        return a valarray containing the four-momentum (components 0-2 are 3-mom,
        component 3 is energy).  

        """
        return _fastjet.PseudoJet_four_mom(self)

    X = _fastjet.PseudoJet_X
    Y = _fastjet.PseudoJet_Y
    Z = _fastjet.PseudoJet_Z
    T = _fastjet.PseudoJet_T
    NUM_COORDINATES = _fastjet.PseudoJet_NUM_COORDINATES
    SIZE = _fastjet.PseudoJet_SIZE

    def boost(self, prest):
        """

        `boost(const PseudoJet &prest) -> PseudoJet &`  

        transform this jet (given in the rest frame of prest) into a jet in the lab
        frame  

        """
        return _fastjet.PseudoJet_boost(self, prest)


    def unboost(self, prest):
        """

        `unboost(const PseudoJet &prest) -> PseudoJet &`  

        transform this jet (given in lab) into a jet in the rest frame of prest  

        """
        return _fastjet.PseudoJet_unboost(self, prest)


    def __imul__(self, arg2):
        return _fastjet.PseudoJet___imul__(self, arg2)

    def __itruediv__(self, *args):
        return _fastjet.PseudoJet___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def __iadd__(self, arg2):
        return _fastjet.PseudoJet___iadd__(self, arg2)

    def __isub__(self, arg2):
        return _fastjet.PseudoJet___isub__(self, arg2)

    def reset(self, *args):
        """

        `reset(const L &some_four_vector)`  

        reset the 4-momentum according to the supplied generic 4-vector (accessible via
        indexing, [0]==px,...[3]==E) and put the user and history indices back to their
        default values.  

        """
        return _fastjet.PseudoJet_reset(self, *args)


    def reset_PtYPhiM(self, pt_in, y_in, phi_in, m_in=0.0):
        """

        `reset_PtYPhiM(double pt_in, double y_in, double phi_in, double m_in=0.0)`  

        reset the PseudoJet according to the specified pt, rapidity, azimuth and mass
        (also resetting indices, etc.) (phi should satisfy -2pi<phi<4pi)  

        """
        return _fastjet.PseudoJet_reset_PtYPhiM(self, pt_in, y_in, phi_in, m_in)


    def reset_momentum(self, *args):
        """

        `reset_momentum(const L &some_four_vector)`  

        reset the 4-momentum according to the supplied generic 4-vector (accessible via
        indexing, [0]==px,...[3]==E), but leave all other information (indices, user
        info, etc.) untouched  

        """
        return _fastjet.PseudoJet_reset_momentum(self, *args)


    def reset_momentum_PtYPhiM(self, pt, y, phi, m=0.0):
        """

        `reset_momentum_PtYPhiM(double pt, double y, double phi, double m=0.0)`  

        reset the 4-momentum according to the specified pt, rapidity, azimuth and mass
        (phi should satisfy -2pi<phi<4pi)  

        """
        return _fastjet.PseudoJet_reset_momentum_PtYPhiM(self, pt, y, phi, m)


    def set_cached_rap_phi(self, rap, phi):
        """

        `set_cached_rap_phi(double rap, double phi)`  

        in some cases when setting a 4-momentum, the user/program knows what rapidity
        and azimuth are associated with that 4-momentum; by calling this routine the
        user can provide the information directly to the PseudoJet and avoid expensive
        rap-phi recalculations.  

        *  
            Parameters:  
            * `rap` :  
                rapidity  
        *  
            Parameters:  
            * `phi` :  
                (in range -twopi...4*pi)  

            USE WITH CAUTION: there are no checks that the rapidity and azimuth supplied
            are sensible, nor does this reset the 4-momentum components if things don't
            match.  

        """
        return _fastjet.PseudoJet_set_cached_rap_phi(self, rap, phi)


    def user_index(self):
        """

        `user_index() const -> int`  

        return the user_index,  

        """
        return _fastjet.PseudoJet_user_index(self)


    def set_user_index(self, index):
        """

        `set_user_index(const int index)`  

        set the user_index, intended to allow the user to add simple identifying
        information to a particle/jet  

        """
        return _fastjet.PseudoJet_set_user_index(self, index)


    def set_user_info(self, user_info_in):
        """

        `set_user_info(UserInfoBase *user_info_in)`  

        sets the internal shared pointer to the user information.  

        Note that the PseudoJet will now *own* the pointer, and delete the corresponding
        object when it (the jet, and any copies of the jet) goes out of scope.  

        """
        return _fastjet.PseudoJet_set_user_info(self, user_info_in)


    def has_user_info(self):
        """

        `has_user_info() const -> bool`  

        returns true if the PseudoJet has user information than can be cast to the
        template argument type.  

        """
        return _fastjet.PseudoJet_has_user_info(self)


    def user_info_ptr(self):
        """

        `user_info_ptr() const -> const UserInfoBase *`  

        retrieve a pointer to the (const) user information  

        """
        return _fastjet.PseudoJet_user_info_ptr(self)


    def user_info_shared_ptr(self, *args):
        """

        `user_info_shared_ptr() -> SharedPtr< UserInfoBase > &`  

        retrieve a (non-const) shared pointer to the user information; you can use this,
        for example, to set the shared pointer, eg  


        or  



        """
        return _fastjet.PseudoJet_user_info_shared_ptr(self, *args)


    def description(self):
        """

        `description() const -> std::string`  

        return a string describing what kind of PseudoJet we are dealing with  

        """
        return _fastjet.PseudoJet_description(self)


    def has_associated_cluster_sequence(self):
        """

        `has_associated_cluster_sequence() const -> bool`  

        returns true if this PseudoJet has an associated ClusterSequence.  

        """
        return _fastjet.PseudoJet_has_associated_cluster_sequence(self)


    def has_associated_cs(self):
        """

        `has_associated_cs() const -> bool`  

        shorthand for has_associated_cluster_sequence()  

        """
        return _fastjet.PseudoJet_has_associated_cs(self)


    def has_valid_cluster_sequence(self):
        """

        `has_valid_cluster_sequence() const -> bool`  

        returns true if this PseudoJet has an associated and still valid(ated)
        ClusterSequence.  

        """
        return _fastjet.PseudoJet_has_valid_cluster_sequence(self)


    def has_valid_cs(self):
        """

        `has_valid_cs() const -> bool`  

        shorthand for has_valid_cluster_sequence()  

        """
        return _fastjet.PseudoJet_has_valid_cs(self)


    def associated_cluster_sequence(self):
        """

        `associated_cluster_sequence() const -> const ClusterSequence *`  

        get a (const) pointer to the parent ClusterSequence (NULL if inexistent)  

        """
        return _fastjet.PseudoJet_associated_cluster_sequence(self)


    def associated_cs(self):
        """

        `associated_cs() const -> const ClusterSequence *`  

        """
        return _fastjet.PseudoJet_associated_cs(self)


    def validated_cluster_sequence(self):
        """

        `validated_cluster_sequence() const -> const ClusterSequence *`  

        if the jet has a valid associated cluster sequence then return a pointer to it;
        otherwise throw an error  

        """
        return _fastjet.PseudoJet_validated_cluster_sequence(self)


    def validated_cs(self):
        """

        `validated_cs() const -> const ClusterSequence *`  

        shorthand for validated_cluster_sequence()  

        """
        return _fastjet.PseudoJet_validated_cs(self)


    def validated_cluster_sequence_area_base(self):
        """

        `validated_cluster_sequence_area_base() const -> const ClusterSequenceAreaBase
            *`  

        if the jet has valid area information then return a pointer to the associated
        ClusterSequenceAreaBase object; otherwise throw an error  

        """
        return _fastjet.PseudoJet_validated_cluster_sequence_area_base(self)


    def validated_csab(self):
        """

        `validated_csab() const -> const ClusterSequenceAreaBase *`  

        shorthand for validated_cluster_sequence_area_base()  

        """
        return _fastjet.PseudoJet_validated_csab(self)


    def set_structure_shared_ptr(self, structure):
        """

        `set_structure_shared_ptr(const SharedPtr< PseudoJetStructureBase > &structure)`  

        set the associated structure  

        """
        return _fastjet.PseudoJet_set_structure_shared_ptr(self, structure)


    def has_structure(self):
        """

        `has_structure() const -> bool`  

        return true if there is some structure associated with this PseudoJet  

        """
        return _fastjet.PseudoJet_has_structure(self)


    def structure_ptr(self):
        """

        `structure_ptr() const -> const PseudoJetStructureBase *`  

        return a pointer to the structure (of type PseudoJetStructureBase*) associated
        with this PseudoJet.  

        return NULL if there is no associated structure  

        """
        return _fastjet.PseudoJet_structure_ptr(self)


    def structure_non_const_ptr(self):
        """

        `structure_non_const_ptr() -> PseudoJetStructureBase *`  

        return a non-const pointer to the structure (of type PseudoJetStructureBase*)
        associated with this PseudoJet.  

        return NULL if there is no associated structure  

        Only use this if you know what you are doing. In any case, prefer the
        'structure_ptr()' (the const version) to this method, unless you really need a
        write access to the PseudoJet's underlying structure.  

        """
        return _fastjet.PseudoJet_structure_non_const_ptr(self)


    def validated_structure_ptr(self):
        """

        `validated_structure_ptr() const -> const PseudoJetStructureBase *`  

        return a pointer to the structure (of type PseudoJetStructureBase*) associated
        with this PseudoJet.  

        throw an error if there is no associated structure  

        """
        return _fastjet.PseudoJet_validated_structure_ptr(self)


    def structure_shared_ptr(self):
        """

        `structure_shared_ptr() const -> const SharedPtr< PseudoJetStructureBase > &`  

        return a reference to the shared pointer to the PseudoJetStructureBase
        associated with this PseudoJet  

        """
        return _fastjet.PseudoJet_structure_shared_ptr(self)


    def has_partner(self, partner):
        """

        `has_partner(PseudoJet &partner) const -> bool`  

        check if it has been recombined with another PseudoJet in which case, return its
        partner through the argument.  

        Otherwise, 'partner' is set to 0.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.PseudoJet_has_partner(self, partner)


    def has_child(self, child):
        """

        `has_child(PseudoJet &child) const -> bool`  

        check if it has been recombined with another PseudoJet in which case, return its
        child through the argument.  

        Otherwise, 'child' is set to 0.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.PseudoJet_has_child(self, child)


    def has_parents(self, parent1, parent2):
        """

        `has_parents(PseudoJet &parent1, PseudoJet &parent2) const -> bool`  

        check if it is the product of a recombination, in which case return the 2
        parents through the 'parent1' and 'parent2' arguments.  

        Otherwise, set these to 0.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.PseudoJet_has_parents(self, parent1, parent2)


    def contains(self, constituent):
        """

        `contains(const PseudoJet &constituent) const -> bool`  

        check if the current PseudoJet contains the one passed as argument.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.PseudoJet_contains(self, constituent)


    def is_inside(self, jet):
        """

        `is_inside(const PseudoJet &jet) const -> bool`  

        check if the current PseudoJet is contained the one passed as argument.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.PseudoJet_is_inside(self, jet)


    def has_constituents(self):
        """

        `has_constituents() const -> bool`  

        returns true if the PseudoJet has constituents  

        """
        return _fastjet.PseudoJet_has_constituents(self)


    def constituents(self):
        """

        `constituents() const -> std::vector< PseudoJet >`  

        retrieve the constituents.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence or other substructure information  

        """
        return _fastjet.PseudoJet_constituents(self)


    def has_exclusive_subjets(self):
        """

        `has_exclusive_subjets() const -> bool`  

        returns true if the PseudoJet has support for exclusive subjets  

        """
        return _fastjet.PseudoJet_has_exclusive_subjets(self)


    def n_exclusive_subjets(self, dcut):
        """

        `n_exclusive_subjets(const double dcut) const -> int`  

        return the size of exclusive_subjets(...); still n ln n with same coefficient,
        but marginally more efficient than manually taking exclusive_subjets.size()  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.PseudoJet_n_exclusive_subjets(self, dcut)


    def exclusive_subjets(self, *args):
        """

        `exclusive_subjets(int nsub) const -> std::vector< PseudoJet >`  

        return the list of subjets obtained by unclustering the supplied jet down to
        nsub subjets.  

        Throws an error if there are fewer than nsub particles in the jet.  

        For ClusterSequence type jets, requires nsub ln nsub time  

        An Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.PseudoJet_exclusive_subjets(self, *args)


    def exclusive_subjets_up_to(self, nsub):
        """

        `exclusive_subjets_up_to(int nsub) const -> std::vector< PseudoJet >`  

        return the list of subjets obtained by unclustering the supplied jet down to
        nsub subjets (or all constituents if there are fewer than nsub).  

        For ClusterSequence type jets, requires nsub ln nsub time  

        An Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.PseudoJet_exclusive_subjets_up_to(self, nsub)


    def exclusive_subdmerge(self, nsub):
        """

        `exclusive_subdmerge(int nsub) const -> double`  

        Returns the dij that was present in the merging nsub+1 -> nsub subjets inside
        this jet.  

        Returns 0 if there were nsub or fewer constituents in the jet.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.PseudoJet_exclusive_subdmerge(self, nsub)


    def exclusive_subdmerge_max(self, nsub):
        """

        `exclusive_subdmerge_max(int nsub) const -> double`  

        Returns the maximum dij that occurred in the whole event at the stage that the
        nsub+1 -> nsub merge of subjets occurred inside this jet.  

        Returns 0 if there were nsub or fewer constituents in the jet.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.PseudoJet_exclusive_subdmerge_max(self, nsub)


    def has_pieces(self):
        """

        `has_pieces() const -> bool`  

        returns true if a jet has pieces  

        By default a single particle or a jet coming from a ClusterSequence have no
        pieces and this methos will return false.  

        In practice, this is equivalent to have an structure of type
        CompositeJetStructure.  

        """
        return _fastjet.PseudoJet_has_pieces(self)


    def pieces(self):
        """

        `pieces() const -> std::vector< PseudoJet >`  

        retrieve the pieces that make up the jet.  

        If the jet does not support pieces, an error is throw  

        """
        return _fastjet.PseudoJet_pieces(self)


    def has_area(self):
        """

        `has_area() const -> bool`  

        check if it has a defined area  

        """
        return _fastjet.PseudoJet_has_area(self)


    def area(self):
        """

        `area() const -> double`  

        return the jet (scalar) area.  

        throws an Error if there is no support for area in the parent CS  

        """
        return _fastjet.PseudoJet_area(self)


    def area_error(self):
        """

        `area_error() const -> double`  

        return the error (uncertainty) associated with the determination of the area of
        this jet.  

        throws an Error if there is no support for area in the parent CS  

        """
        return _fastjet.PseudoJet_area_error(self)


    def area_4vector(self):
        """

        `area_4vector() const -> PseudoJet`  

        return the jet 4-vector area.  

        throws an Error if there is no support for area in the parent CS  

        """
        return _fastjet.PseudoJet_area_4vector(self)


    def is_pure_ghost(self):
        """

        `is_pure_ghost() const -> bool`  

        true if this jet is made exclusively of ghosts.  

        throws an Error if there is no support for area in the parent CS  

        """
        return _fastjet.PseudoJet_is_pure_ghost(self)


    def cluster_hist_index(self):
        """

        `cluster_hist_index() const -> int`  

        return the cluster_hist_index, intended to be used by clustering routines.  

        """
        return _fastjet.PseudoJet_cluster_hist_index(self)


    def set_cluster_hist_index(self, index):
        """

        `set_cluster_hist_index(const int index)`  

        set the cluster_hist_index, intended to be used by clustering routines.  

        """
        return _fastjet.PseudoJet_set_cluster_hist_index(self, index)


    def cluster_sequence_history_index(self):
        """

        `cluster_sequence_history_index() const -> int`  

        alternative name for cluster_hist_index() [perhaps more meaningful]  

        """
        return _fastjet.PseudoJet_cluster_sequence_history_index(self)


    def set_cluster_sequence_history_index(self, index):
        """

        `set_cluster_sequence_history_index(const int index)`  

        alternative name for set_cluster_hist_index(...) [perhaps more meaningful]  

        """
        return _fastjet.PseudoJet_set_cluster_sequence_history_index(self, index)


    def __str__(self):
        return _fastjet.PseudoJet___str__(self)

    def set_python_info(self, pyobj):
        return _fastjet.PseudoJet_set_python_info(self, pyobj)

    def python_info(self):
        return _fastjet.PseudoJet_python_info(self)

    def __add__(self, p):
        return _fastjet.PseudoJet___add__(self, p)

    def __sub__(self, p):
        return _fastjet.PseudoJet___sub__(self, p)

    def __mul__(self, x):
        return _fastjet.PseudoJet___mul__(self, x)

    def __rmul__(self, x):
        return _fastjet.PseudoJet___rmul__(self, x)

    def __div__(self, x):
        return _fastjet.PseudoJet___div__(self, x)

    def __eq__(self, *args):
        return _fastjet.PseudoJet___eq__(self, *args)

    def __ne__(self, *args):
        return _fastjet.PseudoJet___ne__(self, *args)
PseudoJet_swigregister = _fastjet.PseudoJet_swigregister
PseudoJet_swigregister(PseudoJet)
MaxRap = cvar.MaxRap
pseudojet_invalid_phi = cvar.pseudojet_invalid_phi
pseudojet_invalid_rap = cvar.pseudojet_invalid_rap


def __add__(arg1, arg2):
    return _fastjet.__add__(arg1, arg2)
__add__ = _fastjet.__add__

def __sub__(arg1, arg2):
    return _fastjet.__sub__(arg1, arg2)
__sub__ = _fastjet.__sub__

def __truediv__(arg1, arg2):
    return _fastjet.__truediv__(arg1, arg2)
__truediv__ = _fastjet.__truediv__

def __eq__(*args):
    return _fastjet.__eq__(*args)
__eq__ = _fastjet.__eq__

def __ne__(*args):
    return _fastjet.__ne__(*args)
__ne__ = _fastjet.__ne__

def dot_product(a, b):
    return _fastjet.dot_product(a, b)
dot_product = _fastjet.dot_product

def cos_theta(a, b):
    return _fastjet.cos_theta(a, b)
cos_theta = _fastjet.cos_theta

def theta(a, b):
    return _fastjet.theta(a, b)
theta = _fastjet.theta

def have_same_momentum(arg1, arg2):
    return _fastjet.have_same_momentum(arg1, arg2)
have_same_momentum = _fastjet.have_same_momentum

def PtYPhiM(pt, y, phi, m=0.0):
    return _fastjet.PtYPhiM(pt, y, phi, m)
PtYPhiM = _fastjet.PtYPhiM

def sorted_by_pt(jets):
    return _fastjet.sorted_by_pt(jets)
sorted_by_pt = _fastjet.sorted_by_pt

def sorted_by_rapidity(jets):
    return _fastjet.sorted_by_rapidity(jets)
sorted_by_rapidity = _fastjet.sorted_by_rapidity

def sorted_by_E(jets):
    return _fastjet.sorted_by_E(jets)
sorted_by_E = _fastjet.sorted_by_E

def sorted_by_pz(jets):
    return _fastjet.sorted_by_pz(jets)
sorted_by_pz = _fastjet.sorted_by_pz

def sort_indices(indices, values):
    return _fastjet.sort_indices(indices, values)
sort_indices = _fastjet.sort_indices
class IndexedSortHelper(_object):
    """


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, IndexedSortHelper, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, IndexedSortHelper, name)
    __repr__ = _swig_repr

    def __init__(self, reference_values):
        """

        `IndexedSortHelper(const std::vector< double > *reference_values)`  

        """
        this = _fastjet.new_IndexedSortHelper(reference_values)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, i1, i2):
        return _fastjet.IndexedSortHelper___call__(self, i1, i2)
    __swig_destroy__ = _fastjet.delete_IndexedSortHelper
    __del__ = lambda self: None
IndexedSortHelper_swigregister = _fastjet.IndexedSortHelper_swigregister
IndexedSortHelper_swigregister(IndexedSortHelper)

class RangeDefinition(_object):
    """


    class for holding a range definition specification, given by limits on rapidity
    and azimuth.  

    C++ includes: fastjet/RangeDefinition.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RangeDefinition, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RangeDefinition, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _fastjet.delete_RangeDefinition
    __del__ = lambda self: None

    def __init__(self, *args):
        """

        `RangeDefinition(double rapmin, double rapmax, double phimin=0.0, double
            phimax=twopi)`  

        constructor for a range definition given by rapmin <= y <= rapmax, phimin <= phi
        <= phimax  

        """
        this = _fastjet.new_RangeDefinition(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def is_localizable(self):
        """

        `is_localizable() const -> bool`  

        returns true if the range is localizable (i.e.  

        set_position is meant to do something meaningful).  

        This version of the class is not localizable and so it returns false.  

        For localizable classes override this function with a function that returns true  

        """
        return _fastjet.RangeDefinition_is_localizable(self)


    def set_position(self, *args):
        """

        `set_position(const PseudoJet &jet)`  

        place the range on the jet position  

        """
        return _fastjet.RangeDefinition_set_position(self, *args)


    def is_in_range(self, *args):
        """

        `is_in_range(double rap, double phi) const -> bool`  

        return bool according to whether a (rap,phi) point is in range  

        """
        return _fastjet.RangeDefinition_is_in_range(self, *args)


    def get_rap_limits(self, rapmin, rapmax):
        """

        `get_rap_limits(double &rapmin, double &rapmax) const`  

        return the minimal and maximal rapidity of this range; remember to replace this
        if you write a derived class with more complex ranges;  

        """
        return _fastjet.RangeDefinition_get_rap_limits(self, rapmin, rapmax)


    def area(self):
        """

        `area() const -> double`  

        area of the range region  

        """
        return _fastjet.RangeDefinition_area(self)


    def description(self):
        """

        `description() const -> std::string`  

        textual description of range  

        """
        return _fastjet.RangeDefinition_description(self)

RangeDefinition_swigregister = _fastjet.RangeDefinition_swigregister
RangeDefinition_swigregister(RangeDefinition)

class SelectorWorker(_object):
    """


    default selector worker is an abstract virtual base class  

    The Selector class is only an interface, it is the SelectorWorker that really
    does the work. To implement various selectors, one thus has to overload this
    class.  

    C++ includes: fastjet/Selector.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SelectorWorker, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SelectorWorker, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _fastjet.delete_SelectorWorker
    __del__ = lambda self: None

    def _pass(self, jet):
        """

        `pass(const PseudoJet &jet) const =0 -> bool`  

        returns true if a given object passes the selection criterion, and is the main
        function that needs to be overloaded by derived workers.  

        NB: this function is used only if applies_jet_by_jet() returns true. If it does
        not, then derived classes are expected to (re)implement the terminator
        function()  

        """
        return _fastjet.SelectorWorker__pass(self, jet)


    def terminator(self, jets):
        """

        `terminator(std::vector< const PseudoJet *> &jets) const`  

        For each jet that does not pass the cuts, this routine sets the pointer to 0.  

        It does not assume that the PseudoJet* passed as argument are not NULL  

        """
        return _fastjet.SelectorWorker_terminator(self, jets)


    def applies_jet_by_jet(self):
        """

        `applies_jet_by_jet() const -> bool`  

        returns true if this can be applied jet by jet  

        """
        return _fastjet.SelectorWorker_applies_jet_by_jet(self)


    def description(self):
        """

        `description() const -> std::string`  

        returns a description of the worker  

        """
        return _fastjet.SelectorWorker_description(self)


    def takes_reference(self):
        """

        `takes_reference() const -> bool`  

        returns true if the worker is defined with respect to a reference jet  

        """
        return _fastjet.SelectorWorker_takes_reference(self)


    def set_reference(self, arg2):
        """

        `set_reference(const PseudoJet &)`  

        sets the reference jet for the selector NB: "reference" is commented to avoid
        unused-variable compiler warnings  

        """
        return _fastjet.SelectorWorker_set_reference(self, arg2)


    def copy(self):
        """

        `copy() -> SelectorWorker *`  

        return a copy of the current object.  

        This function is only called for objects that take a reference and need not be
        reimplemented otherwise.  

        """
        return _fastjet.SelectorWorker_copy(self)


    def get_rapidity_extent(self, rapmin, rapmax):
        """

        `get_rapidity_extent(double &rapmin, double &rapmax) const`  

        returns the rapidity range for which it may return "true"  

        """
        return _fastjet.SelectorWorker_get_rapidity_extent(self, rapmin, rapmax)


    def is_geometric(self):
        """

        `is_geometric() const -> bool`  

        check if it is a geometric selector (i.e.  

        only puts constraints on rapidity and azimuthal angle)  

        """
        return _fastjet.SelectorWorker_is_geometric(self)


    def has_finite_area(self):
        """

        `has_finite_area() const -> bool`  

        check if it has a finite area  

        """
        return _fastjet.SelectorWorker_has_finite_area(self)


    def has_known_area(self):
        """

        `has_known_area() const -> bool`  

        check if it has an analytically computable area  

        """
        return _fastjet.SelectorWorker_has_known_area(self)


    def known_area(self):
        """

        `known_area() const -> double`  

        if it has a computable area, return it  

        """
        return _fastjet.SelectorWorker_known_area(self)

SelectorWorker_swigregister = _fastjet.SelectorWorker_swigregister
SelectorWorker_swigregister(SelectorWorker)

class Selector(_object):
    """


    Class that encodes information about cuts and other selection criteria that can
    be applied to PseudoJet(s).  

    C++ includes: fastjet/Selector.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Selector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Selector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `Selector(const RangeDefinition &range)`  

        ctor from a RangeDefinition  

        This is provided for backward compatibility and will be removed in a future
        major release of FastJet  

        Watch out that the Selector will only hold a pointer to the range so the
        selector will crash if one tries to use it after the range has gone out of
        scope. We thus strongly advise against the direct use of this constructor.  

        """
        this = _fastjet.new_Selector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_Selector
    __del__ = lambda self: None

    def _pass(self, jet):
        """

        `pass(const PseudoJet &jet) const -> bool`  

        return true if the jet passes the selection  

        """
        return _fastjet.Selector__pass(self, jet)


    def count(self, jets):
        """

        `count(const std::vector< PseudoJet > &jets) const -> unsigned int`  

        Return a count of the objects that pass the selection.  

        This will often be more efficient that getting the vector of objects that passes
        and then evaluating the size of the vector  

        """
        return _fastjet.Selector_count(self, jets)


    def sum(self, jets):
        """

        `sum(const std::vector< PseudoJet > &jets) const -> PseudoJet`  

        Return the 4-vector sum of the objects that pass the selection.  

        This will often be more efficient that getting the vector of objects that passes
        and then evaluating the size of the vector  

        """
        return _fastjet.Selector_sum(self, jets)


    def scalar_pt_sum(self, jets):
        """

        `scalar_pt_sum(const std::vector< PseudoJet > &jets) const -> double`  

        Return the scalar pt sum of the objects that pass the selection.  

        This will often be more efficient that getting the vector of objects that passes
        and then evaluating the size of the vector  

        """
        return _fastjet.Selector_scalar_pt_sum(self, jets)


    def sift(self, jets, jets_that_pass, jets_that_fail):
        """

        `sift(const std::vector< PseudoJet > &jets, std::vector< PseudoJet >
            &jets_that_pass, std::vector< PseudoJet > &jets_that_fail) const`  

        sift the input jets into two vectors -- those that pass the selector and those
        that do not  

        """
        return _fastjet.Selector_sift(self, jets, jets_that_pass, jets_that_fail)


    def applies_jet_by_jet(self):
        """

        `applies_jet_by_jet() const -> bool`  

        returns true if this can be applied jet by jet  

        """
        return _fastjet.Selector_applies_jet_by_jet(self)


    def __call__(self, *args):
        return _fastjet.Selector___call__(self, *args)

    def nullify_non_selected(self, jets):
        """

        `nullify_non_selected(std::vector< const PseudoJet *> &jets) const`  

        For each jet that does not pass the cuts, this routine sets the pointer to 0.  

        It is legitimate for some (or all) of the pointers that are passed to already be
        NULL.  

        """
        return _fastjet.Selector_nullify_non_selected(self, jets)


    def get_rapidity_extent(self, rapmin, rapmax):
        """

        `get_rapidity_extent(double &rapmin, double &rapmax) const`  

        returns the rapidity range for which it may return "true"  

        """
        return _fastjet.Selector_get_rapidity_extent(self, rapmin, rapmax)


    def description(self):
        """

        `description() const -> std::string`  

        returns a textual description of the selector  

        """
        return _fastjet.Selector_description(self)


    def is_geometric(self):
        """

        `is_geometric() const -> bool`  

        returns true if it is a geometric selector (i.e.  

        one that only puts constraints on rapidities and azimuthal angles)  

        """
        return _fastjet.Selector_is_geometric(self)


    def has_finite_area(self):
        """

        `has_finite_area() const -> bool`  

        returns true if it has a meaningful and finite area (i.e.  

        the Selector has the property that is_geometric() returns true and the rapidity
        extent is finite).  

        """
        return _fastjet.Selector_has_finite_area(self)


    def area(self, *args):
        """

        `area(double ghost_area) const -> double`  

        returns the rapidity-phi area associated with the Selector (throws InvalidArea
        if the area does not make sense).  

        The behaviour is the as with the area() call, but with the ability to
        additionally specify the ghost area to be used in the case of a Monte Carlo area
        evaluation.  

        """
        return _fastjet.Selector_area(self, *args)


    def worker(self):
        """

        `worker() const -> const SharedPtr< SelectorWorker > &`  

        returns a (reference to) the underlying worker's shared pointer  

        """
        return _fastjet.Selector_worker(self)


    def validated_worker(self):
        """

        `validated_worker() const -> const SelectorWorker *`  

        returns a worker if there is a valid one, otherwise throws an InvalidWorker
        error  

        """
        return _fastjet.Selector_validated_worker(self)


    def takes_reference(self):
        """

        `takes_reference() const -> bool`  

        returns true if this can be applied jet by jet  

        """
        return _fastjet.Selector_takes_reference(self)


    def set_reference(self, reference):
        """

        `set_reference(const PseudoJet &reference) -> const Selector &`  

        set the reference jet for this Selector  

        """
        return _fastjet.Selector_set_reference(self, reference)


    def __iand__(self, b):
        return _fastjet.Selector___iand__(self, b)

    def __ior__(self, b):
        return _fastjet.Selector___ior__(self, b)

    def __str__(self, *args):
        return _fastjet.Selector___str__(self, *args)

    def __mul__(self, other):
        return _fastjet.Selector___mul__(self, other)

    def __and__(self, other):
        return _fastjet.Selector___and__(self, other)

    def __or__(self, other):
        return _fastjet.Selector___or__(self, other)

    def __invert__(self):
        return _fastjet.Selector___invert__(self)
Selector_swigregister = _fastjet.Selector_swigregister
Selector_swigregister(Selector)


def SelectorIdentity():
    return _fastjet.SelectorIdentity()
SelectorIdentity = _fastjet.SelectorIdentity

def __mul__(*args):
    return _fastjet.__mul__(*args)
__mul__ = _fastjet.__mul__

def SelectorPtMin(ptmin):
    return _fastjet.SelectorPtMin(ptmin)
SelectorPtMin = _fastjet.SelectorPtMin

def SelectorPtMax(ptmax):
    return _fastjet.SelectorPtMax(ptmax)
SelectorPtMax = _fastjet.SelectorPtMax

def SelectorPtRange(ptmin, ptmax):
    return _fastjet.SelectorPtRange(ptmin, ptmax)
SelectorPtRange = _fastjet.SelectorPtRange

def SelectorEtMin(Etmin):
    return _fastjet.SelectorEtMin(Etmin)
SelectorEtMin = _fastjet.SelectorEtMin

def SelectorEtMax(Etmax):
    return _fastjet.SelectorEtMax(Etmax)
SelectorEtMax = _fastjet.SelectorEtMax

def SelectorEtRange(Etmin, Etmax):
    return _fastjet.SelectorEtRange(Etmin, Etmax)
SelectorEtRange = _fastjet.SelectorEtRange

def SelectorEMin(Emin):
    return _fastjet.SelectorEMin(Emin)
SelectorEMin = _fastjet.SelectorEMin

def SelectorEMax(Emax):
    return _fastjet.SelectorEMax(Emax)
SelectorEMax = _fastjet.SelectorEMax

def SelectorERange(Emin, Emax):
    return _fastjet.SelectorERange(Emin, Emax)
SelectorERange = _fastjet.SelectorERange

def SelectorMassMin(Mmin):
    return _fastjet.SelectorMassMin(Mmin)
SelectorMassMin = _fastjet.SelectorMassMin

def SelectorMassMax(Mmax):
    return _fastjet.SelectorMassMax(Mmax)
SelectorMassMax = _fastjet.SelectorMassMax

def SelectorMassRange(Mmin, Mmax):
    return _fastjet.SelectorMassRange(Mmin, Mmax)
SelectorMassRange = _fastjet.SelectorMassRange

def SelectorRapMin(rapmin):
    return _fastjet.SelectorRapMin(rapmin)
SelectorRapMin = _fastjet.SelectorRapMin

def SelectorRapMax(rapmax):
    return _fastjet.SelectorRapMax(rapmax)
SelectorRapMax = _fastjet.SelectorRapMax

def SelectorRapRange(rapmin, rapmax):
    return _fastjet.SelectorRapRange(rapmin, rapmax)
SelectorRapRange = _fastjet.SelectorRapRange

def SelectorAbsRapMin(absrapmin):
    return _fastjet.SelectorAbsRapMin(absrapmin)
SelectorAbsRapMin = _fastjet.SelectorAbsRapMin

def SelectorAbsRapMax(absrapmax):
    return _fastjet.SelectorAbsRapMax(absrapmax)
SelectorAbsRapMax = _fastjet.SelectorAbsRapMax

def SelectorAbsRapRange(absrapmin, absrapmax):
    return _fastjet.SelectorAbsRapRange(absrapmin, absrapmax)
SelectorAbsRapRange = _fastjet.SelectorAbsRapRange

def SelectorEtaMin(etamin):
    return _fastjet.SelectorEtaMin(etamin)
SelectorEtaMin = _fastjet.SelectorEtaMin

def SelectorEtaMax(etamax):
    return _fastjet.SelectorEtaMax(etamax)
SelectorEtaMax = _fastjet.SelectorEtaMax

def SelectorEtaRange(etamin, etamax):
    return _fastjet.SelectorEtaRange(etamin, etamax)
SelectorEtaRange = _fastjet.SelectorEtaRange

def SelectorAbsEtaMin(absetamin):
    return _fastjet.SelectorAbsEtaMin(absetamin)
SelectorAbsEtaMin = _fastjet.SelectorAbsEtaMin

def SelectorAbsEtaMax(absetamax):
    return _fastjet.SelectorAbsEtaMax(absetamax)
SelectorAbsEtaMax = _fastjet.SelectorAbsEtaMax

def SelectorAbsEtaRange(absetamin, absetamax):
    return _fastjet.SelectorAbsEtaRange(absetamin, absetamax)
SelectorAbsEtaRange = _fastjet.SelectorAbsEtaRange

def SelectorPhiRange(phimin, phimax):
    return _fastjet.SelectorPhiRange(phimin, phimax)
SelectorPhiRange = _fastjet.SelectorPhiRange

def SelectorRapPhiRange(rapmin, rapmax, phimin, phimax):
    return _fastjet.SelectorRapPhiRange(rapmin, rapmax, phimin, phimax)
SelectorRapPhiRange = _fastjet.SelectorRapPhiRange

def SelectorNHardest(n):
    return _fastjet.SelectorNHardest(n)
SelectorNHardest = _fastjet.SelectorNHardest

def SelectorCircle(radius):
    return _fastjet.SelectorCircle(radius)
SelectorCircle = _fastjet.SelectorCircle

def SelectorDoughnut(radius_in, radius_out):
    return _fastjet.SelectorDoughnut(radius_in, radius_out)
SelectorDoughnut = _fastjet.SelectorDoughnut

def SelectorStrip(half_width):
    return _fastjet.SelectorStrip(half_width)
SelectorStrip = _fastjet.SelectorStrip

def SelectorRectangle(half_rap_width, half_phi_width):
    return _fastjet.SelectorRectangle(half_rap_width, half_phi_width)
SelectorRectangle = _fastjet.SelectorRectangle

def SelectorPtFractionMin(fraction):
    return _fastjet.SelectorPtFractionMin(fraction)
SelectorPtFractionMin = _fastjet.SelectorPtFractionMin

def SelectorIsZero():
    return _fastjet.SelectorIsZero()
SelectorIsZero = _fastjet.SelectorIsZero

def SelectorIsPureGhost():
    return _fastjet.SelectorIsPureGhost()
SelectorIsPureGhost = _fastjet.SelectorIsPureGhost

def fastjet_version_string():
    return _fastjet.fastjet_version_string()
fastjet_version_string = _fastjet.fastjet_version_string
N2MHTLazy9AntiKtSeparateGhosts = _fastjet.N2MHTLazy9AntiKtSeparateGhosts
N2MHTLazy9 = _fastjet.N2MHTLazy9
N2MHTLazy25 = _fastjet.N2MHTLazy25
N2MHTLazy9Alt = _fastjet.N2MHTLazy9Alt
N2MinHeapTiled = _fastjet.N2MinHeapTiled
N2Tiled = _fastjet.N2Tiled
N2PoorTiled = _fastjet.N2PoorTiled
N2Plain = _fastjet.N2Plain
N3Dumb = _fastjet.N3Dumb
Best = _fastjet.Best
NlnN = _fastjet.NlnN
NlnN3pi = _fastjet.NlnN3pi
NlnN4pi = _fastjet.NlnN4pi
NlnNCam4pi = _fastjet.NlnNCam4pi
NlnNCam2pi2R = _fastjet.NlnNCam2pi2R
NlnNCam = _fastjet.NlnNCam
BestFJ30 = _fastjet.BestFJ30
plugin_strategy = _fastjet.plugin_strategy
kt_algorithm = _fastjet.kt_algorithm
cambridge_algorithm = _fastjet.cambridge_algorithm
antikt_algorithm = _fastjet.antikt_algorithm
genkt_algorithm = _fastjet.genkt_algorithm
cambridge_for_passive_algorithm = _fastjet.cambridge_for_passive_algorithm
genkt_for_passive_algorithm = _fastjet.genkt_for_passive_algorithm
ee_kt_algorithm = _fastjet.ee_kt_algorithm
ee_genkt_algorithm = _fastjet.ee_genkt_algorithm
plugin_algorithm = _fastjet.plugin_algorithm
undefined_jet_algorithm = _fastjet.undefined_jet_algorithm
E_scheme = _fastjet.E_scheme
pt_scheme = _fastjet.pt_scheme
pt2_scheme = _fastjet.pt2_scheme
Et_scheme = _fastjet.Et_scheme
Et2_scheme = _fastjet.Et2_scheme
BIpt_scheme = _fastjet.BIpt_scheme
BIpt2_scheme = _fastjet.BIpt2_scheme
WTA_pt_scheme = _fastjet.WTA_pt_scheme
WTA_modp_scheme = _fastjet.WTA_modp_scheme
external_scheme = _fastjet.external_scheme
class JetDefinition(_object):
    """


    class that is intended to hold a full definition of the jet clusterer  

    C++ includes: fastjet/JetDefinition.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, JetDefinition, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, JetDefinition, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `JetDefinition(JetAlgorithm jet_algorithm_in, double R_in, RecombinationScheme
            recomb_scheme_in, Strategy strategy_in, int nparameters_in)`  

        constructor to fully specify a jet-definition (together with information about
        how algorithically to run it).  

        """
        this = _fastjet.new_JetDefinition(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def set_recombination_scheme(self, arg2):
        """

        `set_recombination_scheme(RecombinationScheme)`  

        set the recombination scheme to the one provided  

        """
        return _fastjet.JetDefinition_set_recombination_scheme(self, arg2)


    def set_recombiner(self, *args):
        """

        `set_recombiner(const JetDefinition &other_jet_def)`  

        set the recombiner to be the same as the one of 'other_jet_def'  

        Note that this is the recommended method to associate to a jet definition the
        recombiner from another jet definition. Compared to the set_recombiner(const
        Recombiner *) above, it correctly handles the case where the jet definition owns
        the recombiner (i.e. where delete_recombiner_when_unused has been called)  

        """
        return _fastjet.JetDefinition_set_recombiner(self, *args)


    def delete_recombiner_when_unused(self):
        """

        `delete_recombiner_when_unused()`  

        calling this tells the JetDefinition to handle the deletion of the recombiner
        when it is no longer used.  

        causes the JetDefinition to handle the deletion of the recombiner when it is no
        longer used  

        (Should not be called if the recombiner was initialised from a JetDef whose
        recombiner was already scheduled to delete itself - memory handling will already
        be automatic across both JetDef's in that case).  

        """
        return _fastjet.JetDefinition_delete_recombiner_when_unused(self)


    def plugin(self):
        """

        `plugin() const -> const Plugin *`  

        return a pointer to the plugin  

        """
        return _fastjet.JetDefinition_plugin(self)


    def delete_plugin_when_unused(self):
        """

        `delete_plugin_when_unused()`  

        calling this causes the JetDefinition to handle the deletion of the plugin when
        it is no longer used  

        allows to let the JetDefinition handle the deletion of the plugin when it is no
        longer used  

        """
        return _fastjet.JetDefinition_delete_plugin_when_unused(self)


    def jet_algorithm(self):
        """

        `jet_algorithm() const -> JetAlgorithm`  

        return information about the definition...  

        """
        return _fastjet.JetDefinition_jet_algorithm(self)


    def jet_finder(self):
        """

        `jet_finder() const -> JetAlgorithm`  

        same as above for backward compatibility  

        """
        return _fastjet.JetDefinition_jet_finder(self)


    def R(self):
        """

        `R() const -> double`  

        """
        return _fastjet.JetDefinition_R(self)


    def extra_param(self):
        """

        `extra_param() const -> double`  

        """
        return _fastjet.JetDefinition_extra_param(self)


    def strategy(self):
        """

        `strategy() const -> Strategy`  

        """
        return _fastjet.JetDefinition_strategy(self)


    def recombination_scheme(self):
        """

        `recombination_scheme() const -> RecombinationScheme`  

        """
        return _fastjet.JetDefinition_recombination_scheme(self)


    def set_jet_algorithm(self, njf):
        """

        `set_jet_algorithm(JetAlgorithm njf)`  

        (re)set the jet finder  

        """
        return _fastjet.JetDefinition_set_jet_algorithm(self, njf)


    def set_jet_finder(self, njf):
        """

        `set_jet_finder(JetAlgorithm njf)`  

        same as above for backward compatibility  

        """
        return _fastjet.JetDefinition_set_jet_finder(self, njf)


    def set_extra_param(self, xtra_param):
        """

        `set_extra_param(double xtra_param)`  

        (re)set the general purpose extra parameter  

        """
        return _fastjet.JetDefinition_set_extra_param(self, xtra_param)


    def recombiner(self):
        """

        `recombiner() const -> const Recombiner *`  

        returns a pointer to the currently defined recombiner.  

        Warning: the pointer may be to an internal recombiner (for default recombination
        schemes), in which case if the JetDefinition becomes invalid (e.g. is deleted),
        the pointer will then point to an object that no longer exists.  

        Note also that if you copy a JetDefinition with a default recombination scheme,
        then the two copies will have distinct recombiners, and return different
        recombiner() pointers.  

        """
        return _fastjet.JetDefinition_recombiner(self)


    def has_same_recombiner(self, other_jd):
        """

        `has_same_recombiner(const JetDefinition &other_jd) const -> bool`  

        returns true if the current jet definitions shares the same recombiner as the
        one passed as an argument  

        """
        return _fastjet.JetDefinition_has_same_recombiner(self, other_jd)


    def is_spherical(self):
        """

        `is_spherical() const -> bool`  

        returns true if the jet definition involves an algorithm intended for use on a
        spherical geometry (e.g.  

        e+e- algorithms, as opposed to most pp algorithms, which use a cylindrical,
        rapidity-phi geometry).  

        """
        return _fastjet.JetDefinition_is_spherical(self)


    def description(self):
        """

        `description() const -> std::string`  

        return a textual description of the current jet definition  

        """
        return _fastjet.JetDefinition_description(self)


    def description_no_recombiner(self):
        """

        `description_no_recombiner() const -> std::string`  

        returns a description not including the recombiner information  

        """
        return _fastjet.JetDefinition_description_no_recombiner(self)


    def algorithm_description(jet_alg):
        """

        `algorithm_description(const JetAlgorithm jet_alg) -> std::string`  

        a short textual description of the algorithm jet_alg  

        """
        return _fastjet.JetDefinition_algorithm_description(jet_alg)

    algorithm_description = staticmethod(algorithm_description)

    def n_parameters_for_algorithm(jet_alg):
        """

        `n_parameters_for_algorithm(const JetAlgorithm jet_alg) -> unsigned int`  

        the number of parameters associated to a given jet algorithm  

        """
        return _fastjet.JetDefinition_n_parameters_for_algorithm(jet_alg)

    n_parameters_for_algorithm = staticmethod(n_parameters_for_algorithm)

    def __str__(self):
        return _fastjet.JetDefinition___str__(self)

    def __call__(self, particles):
        return _fastjet.JetDefinition___call__(self, particles)

    def set_python_recombiner(self, pyobj):
        return _fastjet.JetDefinition_set_python_recombiner(self, pyobj)
    __swig_destroy__ = _fastjet.delete_JetDefinition
    __del__ = lambda self: None
JetDefinition_swigregister = _fastjet.JetDefinition_swigregister
JetDefinition_swigregister(JetDefinition)
aachen_algorithm = cvar.aachen_algorithm
cambridge_aachen_algorithm = cvar.cambridge_aachen_algorithm
JetDefinition.max_allowable_R = _fastjet.cvar.JetDefinition_max_allowable_R

def JetDefinition_algorithm_description(jet_alg):
    """

    `algorithm_description(const JetAlgorithm jet_alg) -> std::string`  

    a short textual description of the algorithm jet_alg  

    """
    return _fastjet.JetDefinition_algorithm_description(jet_alg)

def JetDefinition_n_parameters_for_algorithm(jet_alg):
    """

    `n_parameters_for_algorithm(const JetAlgorithm jet_alg) -> unsigned int`  

    the number of parameters associated to a given jet algorithm  

    """
    return _fastjet.JetDefinition_n_parameters_for_algorithm(jet_alg)


def join(*args):
    return _fastjet.join(*args)
join = _fastjet.join
class CompositeJetStructure(PseudoJetStructureBase):
    """


    The structure for a jet made of pieces.  

    This stores the vector of the pieces that make the jet and provide the methods
    to access them  

    C++ includes: fastjet/CompositeJetStructure.hh

    """

    __swig_setmethods__ = {}
    for _s in [PseudoJetStructureBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CompositeJetStructure, name, value)
    __swig_getmethods__ = {}
    for _s in [PseudoJetStructureBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CompositeJetStructure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `CompositeJetStructure(const std::vector< PseudoJet > &initial_pieces, const
            JetDefinition::Recombiner *recombiner=0)`  

        ctor with initialisation  

        """
        this = _fastjet.new_CompositeJetStructure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_CompositeJetStructure
    __del__ = lambda self: None

    def description(self):
        """

        `description() const -> std::string`  

        description  

        """
        return _fastjet.CompositeJetStructure_description(self)


    def has_constituents(self):
        """

        `has_constituents() const -> bool`  

        true unless the jet has no pieces (see also the description of constituents()
        below)  

        """
        return _fastjet.CompositeJetStructure_has_constituents(self)


    def constituents(self, jet):
        """

        `constituents(const PseudoJet &jet) const -> std::vector< PseudoJet >`  

        return the constituents (i.e.  

        the union of the constituents of each piece)  

        If any of the pieces has no constituent, the piece itself is considered as a
        constituent Note that as a consequence, a composite jet with no pieces will have
        an empty vector as constituents  

        """
        return _fastjet.CompositeJetStructure_constituents(self, jet)


    def has_pieces(self, arg2):
        """

        `has_pieces(const PseudoJet &) const -> bool`  

        true if it has pieces (always the case)  

        """
        return _fastjet.CompositeJetStructure_has_pieces(self, arg2)


    def pieces(self, jet):
        """

        `pieces(const PseudoJet &jet) const -> std::vector< PseudoJet >`  

        returns the pieces  

        """
        return _fastjet.CompositeJetStructure_pieces(self, jet)


    def has_area(self):
        """

        `has_area() const -> bool`  

        check if it has a well-defined area  

        """
        return _fastjet.CompositeJetStructure_has_area(self)


    def area(self, reference):
        """

        `area(const PseudoJet &reference) const -> double`  

        return the jet (scalar) area.  

        """
        return _fastjet.CompositeJetStructure_area(self, reference)


    def area_error(self, reference):
        """

        `area_error(const PseudoJet &reference) const -> double`  

        return the error (uncertainty) associated with the determination of the area of
        this jet.  

        Be conservative: return the sum of the errors  

        """
        return _fastjet.CompositeJetStructure_area_error(self, reference)


    def area_4vector(self, reference):
        """

        `area_4vector(const PseudoJet &reference) const -> PseudoJet`  

        return the jet 4-vector area.  

        """
        return _fastjet.CompositeJetStructure_area_4vector(self, reference)


    def is_pure_ghost(self, reference):
        """

        `is_pure_ghost(const PseudoJet &reference) const -> bool`  

        true if this jet is made exclusively of ghosts.  

        In this case, it will be true if all pieces are pure ghost  

        """
        return _fastjet.CompositeJetStructure_is_pure_ghost(self, reference)


    def discard_area(self):
        """

        `discard_area()`  

        disable the area of the composite jet  

        this can be used e.g. to discard the area of a composite jet made of pieces with
        non-explicit-ghost area since the area may by erroneous in that case  

        """
        return _fastjet.CompositeJetStructure_discard_area(self)

CompositeJetStructure_swigregister = _fastjet.CompositeJetStructure_swigregister
CompositeJetStructure_swigregister(CompositeJetStructure)

class ClusterSequenceStructure(PseudoJetStructureBase):
    """


    Contains any information related to the clustering that should be directly
    accessible to PseudoJet.  

    By default, this class implements basic access to the ClusterSequence related to
    a PseudoJet (like its constituents or its area). But it can be overloaded in
    order e.g. to give access to the jet substructure.  

    C++ includes: fastjet/ClusterSequenceStructure.hh

    """

    __swig_setmethods__ = {}
    for _s in [PseudoJetStructureBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClusterSequenceStructure, name, value)
    __swig_getmethods__ = {}
    for _s in [PseudoJetStructureBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ClusterSequenceStructure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `ClusterSequenceStructure(const ClusterSequence *cs)`  

        ctor with initialisation to a given ClusterSequence  

        In principle, this is reserved for initialisation by the parent ClusterSequence  

        """
        this = _fastjet.new_ClusterSequenceStructure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_ClusterSequenceStructure
    __del__ = lambda self: None

    def description(self):
        """

        `description() const -> std::string`  

        description  

        """
        return _fastjet.ClusterSequenceStructure_description(self)


    def has_associated_cluster_sequence(self):
        """

        `has_associated_cluster_sequence() const -> bool`  

        returns true if there is an associated ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_has_associated_cluster_sequence(self)


    def associated_cluster_sequence(self):
        """

        `associated_cluster_sequence() const -> const ClusterSequence *`  

        get a (const) pointer to the parent ClusterSequence (NULL if inexistent)  

        """
        return _fastjet.ClusterSequenceStructure_associated_cluster_sequence(self)


    def has_valid_cluster_sequence(self):
        """

        `has_valid_cluster_sequence() const -> bool`  

        returns true if there is a valid associated ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_has_valid_cluster_sequence(self)


    def validated_cs(self):
        """

        `validated_cs() const -> const ClusterSequence *`  

        if the jet has a valid associated cluster sequence then return a pointer to it;
        otherwise throw an error  

        """
        return _fastjet.ClusterSequenceStructure_validated_cs(self)


    def validated_csab(self):
        """

        `validated_csab() const -> const ClusterSequenceAreaBase *`  

        if the jet has valid area information then return a pointer to the associated
        ClusterSequenceAreaBase object; otherwise throw an error  

        """
        return _fastjet.ClusterSequenceStructure_validated_csab(self)


    def set_associated_cs(self, new_cs):
        """

        `set_associated_cs(const ClusterSequence *new_cs)`  

        set the associated csw  

        """
        return _fastjet.ClusterSequenceStructure_set_associated_cs(self, new_cs)


    def has_partner(self, reference, partner):
        """

        `has_partner(const PseudoJet &reference, PseudoJet &partner) const -> bool`  

        check if it has been recombined with another PseudoJet in which case, return its
        partner through the argument.  

        Otherwise, 'partner' is set to 0.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_has_partner(self, reference, partner)


    def has_child(self, reference, child):
        """

        `has_child(const PseudoJet &reference, PseudoJet &child) const -> bool`  

        check if it has been recombined with another PseudoJet in which case, return its
        child through the argument.  

        Otherwise, 'child' is set to 0.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_has_child(self, reference, child)


    def has_parents(self, reference, parent1, parent2):
        """

        `has_parents(const PseudoJet &reference, PseudoJet &parent1, PseudoJet &parent2)
            const -> bool`  

        check if it is the product of a recombination, in which case return the 2
        parents through the 'parent1' and 'parent2' arguments.  

        Otherwise, set these to 0.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_has_parents(self, reference, parent1, parent2)


    def object_in_jet(self, reference, jet):
        """

        `object_in_jet(const PseudoJet &reference, const PseudoJet &jet) const -> bool`  

        check if the reference PseudoJet is contained in the second one passed as
        argument.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        false is returned if the 2 PseudoJet do not belong the same ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_object_in_jet(self, reference, jet)


    def has_constituents(self):
        """

        `has_constituents() const -> bool`  

        return true if the structure supports constituents.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_has_constituents(self)


    def constituents(self, reference):
        """

        `constituents(const PseudoJet &reference) const -> std::vector< PseudoJet >`  

        retrieve the constituents.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_constituents(self, reference)


    def has_exclusive_subjets(self):
        """

        `has_exclusive_subjets() const -> bool`  

        return true if the structure supports exclusive_subjets.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_has_exclusive_subjets(self)


    def exclusive_subjets(self, reference, dcut):
        """

        `exclusive_subjets(const PseudoJet &reference, const double &dcut) const ->
            std::vector< PseudoJet >`  

        return a vector of all subjets of the current jet (in the sense of the exclusive
        algorithm) that would be obtained when running the algorithm with the given
        dcut.  

        Time taken is O(m ln m), where m is the number of subjets that are found. If m
        gets to be of order of the total number of constituents in the jet, this could
        be substantially slower than just getting that list of constituents.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_exclusive_subjets(self, reference, dcut)


    def n_exclusive_subjets(self, reference, dcut):
        """

        `n_exclusive_subjets(const PseudoJet &reference, const double &dcut) const ->
            int`  

        return the size of exclusive_subjets(...); still n ln n with same coefficient,
        but marginally more efficient than manually taking exclusive_subjets.size()  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_n_exclusive_subjets(self, reference, dcut)


    def exclusive_subjets_up_to(self, reference, nsub):
        """

        `exclusive_subjets_up_to(const PseudoJet &reference, int nsub) const ->
            std::vector< PseudoJet >`  

        return the list of subjets obtained by unclustering the supplied jet down to
        nsub subjets (or all constituents if there are fewer than nsub).  

        requires nsub ln nsub time  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_exclusive_subjets_up_to(self, reference, nsub)


    def exclusive_subdmerge(self, reference, nsub):
        """

        `exclusive_subdmerge(const PseudoJet &reference, int nsub) const -> double`  

        return the dij that was present in the merging nsub+1 -> nsub subjets inside
        this jet.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_exclusive_subdmerge(self, reference, nsub)


    def exclusive_subdmerge_max(self, reference, nsub):
        """

        `exclusive_subdmerge_max(const PseudoJet &reference, int nsub) const -> double`  

        return the maximum dij that occurred in the whole event at the stage that the
        nsub+1 -> nsub merge of subjets occurred inside this jet.  

        an Error is thrown if this PseudoJet has no currently valid associated
        ClusterSequence  

        """
        return _fastjet.ClusterSequenceStructure_exclusive_subdmerge_max(self, reference, nsub)


    def has_pieces(self, reference):
        """

        `has_pieces(const PseudoJet &reference) const -> bool`  

        by convention, a jet associated with a ClusterSequence will have its parents as
        pieces  

        """
        return _fastjet.ClusterSequenceStructure_has_pieces(self, reference)


    def pieces(self, reference):
        """

        `pieces(const PseudoJet &reference) const -> std::vector< PseudoJet >`  

        by convention, a jet associated with a ClusterSequence will have its parents as
        pieces  

        if it has no parents, then there will only be a single piece: itself  

        Note that to answer that question, we need to access the cluster sequence. If
        the cluster sequence has gone out of scope, an error will be thrown  

        """
        return _fastjet.ClusterSequenceStructure_pieces(self, reference)


    def has_area(self):
        """

        `has_area() const -> bool`  

        check if it has a defined area  

        """
        return _fastjet.ClusterSequenceStructure_has_area(self)


    def area(self, reference):
        """

        `area(const PseudoJet &reference) const -> double`  

        return the jet (scalar) area.  

        throws an Error if there is no support for area in the parent CS  

        """
        return _fastjet.ClusterSequenceStructure_area(self, reference)


    def area_error(self, reference):
        """

        `area_error(const PseudoJet &reference) const -> double`  

        return the error (uncertainty) associated with the determination of the area of
        this jet.  

        throws an Error if there is no support for area in the parent CS  

        """
        return _fastjet.ClusterSequenceStructure_area_error(self, reference)


    def area_4vector(self, reference):
        """

        `area_4vector(const PseudoJet &reference) const -> PseudoJet`  

        return the jet 4-vector area.  

        throws an Error if there is no support for area in the parent CS  

        """
        return _fastjet.ClusterSequenceStructure_area_4vector(self, reference)


    def is_pure_ghost(self, reference):
        """

        `is_pure_ghost(const PseudoJet &reference) const -> bool`  

        true if this jet is made exclusively of ghosts.  

        throws an Error if there is no support for area in the parent CS  

        """
        return _fastjet.ClusterSequenceStructure_is_pure_ghost(self, reference)

ClusterSequenceStructure_swigregister = _fastjet.ClusterSequenceStructure_swigregister
ClusterSequenceStructure_swigregister(ClusterSequenceStructure)

class ClusterSequence(_object):
    """


    deals with clustering  

    C++ includes: fastjet/ClusterSequence.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClusterSequence, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ClusterSequence, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _fastjet.delete_ClusterSequence
    __del__ = lambda self: None

    def inclusive_jets(self, ptmin=0.0):
        """

        `inclusive_jets(const double ptmin=0.0) const -> std::vector< PseudoJet >`  

        return a vector of all jets (in the sense of the inclusive algorithm) with pt >=
        ptmin.  

        Time taken should be of the order of the number of jets returned.  

        """
        return _fastjet.ClusterSequence_inclusive_jets(self, ptmin)


    def n_exclusive_jets(self, dcut):
        """

        `n_exclusive_jets(const double dcut) const -> int`  

        return the number of jets (in the sense of the exclusive algorithm) that would
        be obtained when running the algorithm with the given dcut.  

        """
        return _fastjet.ClusterSequence_n_exclusive_jets(self, dcut)


    def exclusive_jets(self, *args):
        """

        `exclusive_jets(const int njets) const -> std::vector< PseudoJet >`  

        return a vector of all jets when the event is clustered (in the exclusive sense)
        to exactly njets.  

        If there are fewer than njets particles in the ClusterSequence an error is
        thrown  

        """
        return _fastjet.ClusterSequence_exclusive_jets(self, *args)


    def exclusive_jets_up_to(self, njets):
        """

        `exclusive_jets_up_to(const int njets) const -> std::vector< PseudoJet >`  

        return a vector of all jets when the event is clustered (in the exclusive sense)
        to exactly njets.  

        If there are fewer than njets particles in the ClusterSequence the function just
        returns however many particles there were.  

        """
        return _fastjet.ClusterSequence_exclusive_jets_up_to(self, njets)


    def exclusive_dmerge(self, njets):
        """

        `exclusive_dmerge(const int njets) const -> double`  

        return the dmin corresponding to the recombination that went from n+1 to n jets
        (sometimes known as d_{n n+1}).  

        return the dmin corresponding to the recombination that went from n+1 to n jets  

        If the number of particles in the event is <= njets, the function returns 0.  

        """
        return _fastjet.ClusterSequence_exclusive_dmerge(self, njets)


    def exclusive_dmerge_max(self, njets):
        """

        `exclusive_dmerge_max(const int njets) const -> double`  

        return the maximum of the dmin encountered during all recombinations up to the
        one that led to an n-jet final state; identical to exclusive_dmerge, except in
        cases where the dmin do not increase monotonically.  

        """
        return _fastjet.ClusterSequence_exclusive_dmerge_max(self, njets)


    def exclusive_ymerge(self, njets):
        """

        `exclusive_ymerge(int njets) const -> double`  

        return the ymin corresponding to the recombination that went from n+1 to n jets
        (sometimes known as y_{n n+1}).  

        """
        return _fastjet.ClusterSequence_exclusive_ymerge(self, njets)


    def exclusive_ymerge_max(self, njets):
        """

        `exclusive_ymerge_max(int njets) const -> double`  

        same as exclusive_dmerge_max, but normalised to squared total energy  

        """
        return _fastjet.ClusterSequence_exclusive_ymerge_max(self, njets)


    def n_exclusive_jets_ycut(self, ycut):
        """

        `n_exclusive_jets_ycut(double ycut) const -> int`  

        the number of exclusive jets at the given ycut  

        """
        return _fastjet.ClusterSequence_n_exclusive_jets_ycut(self, ycut)


    def exclusive_jets_ycut(self, ycut):
        """

        `exclusive_jets_ycut(double ycut) const -> std::vector< PseudoJet >`  

        the exclusive jets obtained at the given ycut  

        """
        return _fastjet.ClusterSequence_exclusive_jets_ycut(self, ycut)


    def n_exclusive_subjets(self, jet, dcut):
        """

        `n_exclusive_subjets(const PseudoJet &jet, const double dcut) const -> int`  

        return the size of exclusive_subjets(...); still n ln n with same coefficient,
        but marginally more efficient than manually taking exclusive_subjets.size()  

        """
        return _fastjet.ClusterSequence_n_exclusive_subjets(self, jet, dcut)


    def exclusive_subjets(self, *args):
        """

        `exclusive_subjets(const PseudoJet &jet, int nsub) const -> std::vector<
            PseudoJet >`  

        return the list of subjets obtained by unclustering the supplied jet down to
        nsub subjets.  

        Throws an error if there are fewer than nsub particles in the jet.  

        This requires nsub ln nsub time  

        Throws an error if there are fewer than nsub particles in the jet.  

        """
        return _fastjet.ClusterSequence_exclusive_subjets(self, *args)


    def exclusive_subjets_up_to(self, jet, nsub):
        """

        `exclusive_subjets_up_to(const PseudoJet &jet, int nsub) const -> std::vector<
            PseudoJet >`  

        return the list of subjets obtained by unclustering the supplied jet down to
        nsub subjets (or all constituents if there are fewer than nsub).  

        This requires nsub ln nsub time  

        """
        return _fastjet.ClusterSequence_exclusive_subjets_up_to(self, jet, nsub)


    def exclusive_subdmerge(self, jet, nsub):
        """

        `exclusive_subdmerge(const PseudoJet &jet, int nsub) const -> double`  

        returns the dij that was present in the merging nsub+1 -> nsub subjets inside
        this jet.  

        return the dij that was present in the merging nsub+1 -> nsub subjets inside
        this jet.  

        Returns 0 if there were nsub or fewer constituents in the jet.  

        If the jet has nsub or fewer constituents, it will return 0.  

        will be zero if nconst <= nsub, since highest will be an original particle have
        zero dij  

        """
        return _fastjet.ClusterSequence_exclusive_subdmerge(self, jet, nsub)


    def exclusive_subdmerge_max(self, jet, nsub):
        """

        `exclusive_subdmerge_max(const PseudoJet &jet, int nsub) const -> double`  

        returns the maximum dij that occurred in the whole event at the stage that the
        nsub+1 -> nsub merge of subjets occurred inside this jet.  

        return the maximum dij that occurred in the whole event at the stage that the
        nsub+1 -> nsub merge of subjets occurred inside this jet.  

        Returns 0 if there were nsub or fewer constituents in the jet.  

        If the jet has nsub or fewer constituents, it will return 0.  

        will be zero if nconst <= nsub, since highest will be an original particle have
        zero dij  

        """
        return _fastjet.ClusterSequence_exclusive_subdmerge_max(self, jet, nsub)


    def Q(self):
        """

        `Q() const -> double`  

        returns the sum of all energies in the event (relevant mainly for e+e-)  

        """
        return _fastjet.ClusterSequence_Q(self)


    def Q2(self):
        """

        `Q2() const -> double`  

        return Q()^2  

        """
        return _fastjet.ClusterSequence_Q2(self)


    def object_in_jet(self, object, jet):
        """

        `object_in_jet(const PseudoJet &object, const PseudoJet &jet) const -> bool`  

        returns true iff the object is included in the jet.  

        NB: this is only sensible if the object is already registered within the cluster
        sequence, so you cannot use it with an input particle to the CS (since the
        particle won't have the history index set properly).  

        For nice clustering structures it should run in O(ln(N)) time but in worst cases
        (certain cone plugins) it can take O(n) time, where n is the number of particles
        in the jet.  

        """
        return _fastjet.ClusterSequence_object_in_jet(self, object, jet)


    def has_parents(self, jet, parent1, parent2):
        """

        `has_parents(const PseudoJet &jet, PseudoJet &parent1, PseudoJet &parent2) const
            -> bool`  

        if the jet has parents in the clustering, it returns true and sets parent1 and
        parent2 equal to them.  

        if it has no parents it returns false and sets parent1 and parent2 to zero  

        """
        return _fastjet.ClusterSequence_has_parents(self, jet, parent1, parent2)


    def has_child(self, *args):
        """

        `has_child(const PseudoJet &jet, const PseudoJet *&childp) const -> bool`  

        Version of has_child that sets a pointer to the child if the child exists;.  

        """
        return _fastjet.ClusterSequence_has_child(self, *args)


    def has_partner(self, jet, partner):
        """

        `has_partner(const PseudoJet &jet, PseudoJet &partner) const -> bool`  

        if this jet has a child (and so a partner) return true and give the partner,
        otherwise return false and set the partner to zero  

        """
        return _fastjet.ClusterSequence_has_partner(self, jet, partner)


    def constituents(self, jet):
        """

        `constituents(const PseudoJet &jet) const -> std::vector< PseudoJet >`  

        return a vector of the particles that make up jet  

        """
        return _fastjet.ClusterSequence_constituents(self, jet)


    def print_jets_for_root(self, *args):
        """

        `print_jets_for_root(const std::vector< PseudoJet > &jets, const std::string
            &filename, const std::string &comment="") const`  

        print jets for root to the file labelled filename, with an optional comment at
        the beginning  

        """
        return _fastjet.ClusterSequence_print_jets_for_root(self, *args)


    def add_constituents(self, jet, subjet_vector):
        """

        `add_constituents(const PseudoJet &jet, std::vector< PseudoJet > &subjet_vector)
            const`  

        add on to subjet_vector the constituents of jet (for internal use mainly)  

        """
        return _fastjet.ClusterSequence_add_constituents(self, jet, subjet_vector)


    def strategy_used(self):
        """

        `strategy_used() const -> Strategy`  

        return the enum value of the strategy used to cluster the event  

        """
        return _fastjet.ClusterSequence_strategy_used(self)


    def strategy_string(self, *args):
        """

        `strategy_string(Strategy strategy_in) const -> std::string`  

        return the name of the strategy associated with the enum strategy_in  

        """
        return _fastjet.ClusterSequence_strategy_string(self, *args)


    def jet_def(self):
        """

        `jet_def() const -> const JetDefinition &`  

        return a reference to the jet definition  

        """
        return _fastjet.ClusterSequence_jet_def(self)


    def delete_self_when_unused(self):
        """

        `delete_self_when_unused()`  

        by calling this routine you tell the ClusterSequence to delete itself when all
        the Pseudojets associated with it have gone out of scope.  

        At the time you call this, there must be at least one jet or other object
        outside the CS that is associated with the CS (e.g. the result of
        inclusive_jets()).  

        NB: after having made this call, the user is still allowed to delete the CS.
        Jets associated with it will then simply not be able to access their
        substructure after that point.  

        """
        return _fastjet.ClusterSequence_delete_self_when_unused(self)


    def will_delete_self_when_unused(self):
        """

        `will_delete_self_when_unused() const -> bool`  

        return true if the object has been told to delete itself when unused  

        """
        return _fastjet.ClusterSequence_will_delete_self_when_unused(self)


    def signal_imminent_self_deletion(self):
        """

        `signal_imminent_self_deletion() const`  

        tell the ClusterSequence it's about to be self deleted (internal use only)  

        """
        return _fastjet.ClusterSequence_signal_imminent_self_deletion(self)


    def jet_scale_for_algorithm(self, jet):
        """

        `jet_scale_for_algorithm(const PseudoJet &jet) const -> double`  

        returns the scale associated with a jet as required for this clustering
        algorithm (kt^2 for the kt-algorithm, 1 for the Cambridge algorithm).  

        Intended mainly for internal use and not valid for plugin algorithms.  

        """
        return _fastjet.ClusterSequence_jet_scale_for_algorithm(self, jet)


    def plugin_record_ij_recombination(self, *args):
        """

        `plugin_record_ij_recombination(int jet_i, int jet_j, double dij, const
            PseudoJet &newjet, int &newjet_k)`  

        as for the simpler variant of plugin_record_ij_recombination, except that the
        new jet is attributed the momentum and user_index of newjet  

        """
        return _fastjet.ClusterSequence_plugin_record_ij_recombination(self, *args)


    def plugin_record_iB_recombination(self, jet_i, diB):
        """

        `plugin_record_iB_recombination(int jet_i, double diB)`  

        record the fact that there has been a recombination between jets()[jet_i] and
        the beam, with the specified diB; when looking for inclusive jets, any iB
        recombination will returned to the user as a jet.  

        """
        return _fastjet.ClusterSequence_plugin_record_iB_recombination(self, jet_i, diB)


    def plugin_associate_extras(self, extras_in):
        """

        `plugin_associate_extras(Extras *extras_in)`  

        the plugin can associate some extra information with the ClusterSequence object
        by calling this function.  

        The ClusterSequence takes ownership of the pointer (and responsibility for
        deleting it when the CS gets deleted).  

        """
        return _fastjet.ClusterSequence_plugin_associate_extras(self, extras_in)


    def plugin_activated(self):
        """

        `plugin_activated() const -> bool`  

        returns true when the plugin is allowed to run the show.  

        """
        return _fastjet.ClusterSequence_plugin_activated(self)


    def extras(self):
        """

        `extras() const -> const Extras *`  

        returns a pointer to the extras object (may be null)  

        """
        return _fastjet.ClusterSequence_extras(self)

    Invalid = _fastjet.ClusterSequence_Invalid
    InexistentParent = _fastjet.ClusterSequence_InexistentParent
    BeamJet = _fastjet.ClusterSequence_BeamJet

    def jets(self):
        """

        `jets() const -> const std::vector< PseudoJet > &`  

        allow the user to access the internally stored _jets() array, which contains
        both the initial particles and the various intermediate and final stages of
        recombination.  

        The first n_particles() entries are the original particles, in the order in
        which they were supplied to the ClusterSequence constructor. It can be useful to
        access them for example when examining whether a given input object is part of a
        specific jet, via the objects_in_jet(...) member function (which only takes
        PseudoJets that are registered in the ClusterSequence).  

        One of the other (internal uses) is related to the fact because we don't seem to
        be able to access protected elements of the class for an object that is not
        "this" (at least in case where "this" is of a slightly different kind from
        the object, both derived from ClusterSequence).  

        """
        return _fastjet.ClusterSequence_jets(self)


    def history(self):
        """

        `history() const -> const std::vector< history_element > &`  

        allow the user to access the raw internal history.  

        This is present (as for jets()) in part so that protected derived classes can
        access this information about other ClusterSequences.  

        A user who wishes to follow the details of the ClusterSequence can also make use
        of this information (and should consult the history_element documentation for
        more information), but should be aware that these internal structures may evolve
        in future FastJet versions.  

        """
        return _fastjet.ClusterSequence_history(self)


    def n_particles(self):
        """

        `n_particles() const -> unsigned int`  

        returns the number of particles that were provided to the clustering algorithm
        (helps the user find their way around the history and jets objects if they
        weren't paying attention beforehand).  

        """
        return _fastjet.ClusterSequence_n_particles(self)


    def particle_jet_indices(self, arg2):
        """

        `particle_jet_indices(const std::vector< PseudoJet > &) const -> std::vector<
            int >`  

        returns a vector of size n_particles() which indicates, for each of the initial
        particles (in the order in which they were supplied), which of the supplied jets
        it belongs to; if it does not belong to any of the supplied jets, the index is
        set to -1;  

        """
        return _fastjet.ClusterSequence_particle_jet_indices(self, arg2)


    def unique_history_order(self):
        """

        `unique_history_order() const -> std::vector< int >`  

        routine that returns an order in which to read the history such that clusterings
        that lead to identical jet compositions but different histories (because of
        degeneracies in the clustering order) will have matching constituents for each
        matching entry in the unique_history_order.  

        The order has the property that an entry's parents will always appear prior to
        that entry itself.  

        Roughly speaking the order is such that we first provide all steps that lead to
        the final jet containing particle 1; then we have the steps that lead to
        reconstruction of the jet containing the next-lowest-numbered unclustered
        particle, etc... [see GPS CCN28-12 for more info -- of course a full explanation
        here would be better...]  

        """
        return _fastjet.ClusterSequence_unique_history_order(self)


    def unclustered_particles(self):
        """

        `unclustered_particles() const -> std::vector< PseudoJet >`  

        return the set of particles that have not been clustered.  

        For kt and cam/aachen algorithms this should always be null, but for cone type
        algorithms it can be non-null;  

        """
        return _fastjet.ClusterSequence_unclustered_particles(self)


    def childless_pseudojets(self):
        """

        `childless_pseudojets() const -> std::vector< PseudoJet >`  

        Return the list of pseudojets in the ClusterSequence that do not have children
        (and are not among the inclusive jets).  

        They may result from a clustering step or may be one of the pseudojets returned
        by unclustered_particles().  

        """
        return _fastjet.ClusterSequence_childless_pseudojets(self)


    def contains(self, object):
        """

        `contains(const PseudoJet &object) const -> bool`  

        returns true if the object (jet or particle) is contained by (ie belongs to)
        this cluster sequence.  

        Tests performed: if thejet's interface is this cluster sequence and its cluster
        history index is in a consistent range.  

        """
        return _fastjet.ClusterSequence_contains(self, object)


    def transfer_from_sequence(self, from_seq, action_on_jets=None):
        """

        `transfer_from_sequence(const ClusterSequence &from_seq, const
            FunctionOfPseudoJet< PseudoJet > *action_on_jets=0)`  

        transfer the sequence contained in other_seq into our own; any plugin "extras"
        contained in the from_seq will be lost from there.  

        It also sets the ClusterSequence pointers of the PseudoJets in the history to
        point to this ClusterSequence  

        When specified, the second argument is an action that will be applied on every
        jets in the resulting ClusterSequence  

        """
        return _fastjet.ClusterSequence_transfer_from_sequence(self, from_seq, action_on_jets)


    def structure_shared_ptr(self):
        """

        `structure_shared_ptr() const -> const SharedPtr< PseudoJetStructureBase > &`  

        retrieve a shared pointer to the wrapper to this ClusterSequence  

        this may turn useful if you want to track when this ClusterSequence goes out of
        scope  

        """
        return _fastjet.ClusterSequence_structure_shared_ptr(self)


    def print_banner():
        """

        `print_banner()`  

        This is the function that is automatically called during clustering to print the
        FastJet banner.  

        Only the first call to this function will result in the printout of the banner.
        Users may wish to call this function themselves, during the initialization phase
        of their program, in order to ensure that the banner appears before other
        output. This call will not affect 3rd-party banners, e.g. those from plugins.  

        """
        return _fastjet.ClusterSequence_print_banner()

    print_banner = staticmethod(print_banner)
    if _newclass:
        set_fastjet_banner_stream = staticmethod(_fastjet.ClusterSequence_set_fastjet_banner_stream)
    else:
        set_fastjet_banner_stream = _fastjet.ClusterSequence_set_fastjet_banner_stream

    def fastjet_banner_stream():
        """

        `fastjet_banner_stream() -> std::ostream *`  

        returns a pointer to the stream to be used to print banners (cout by default).  

        This function is used by plugins to determine where to direct their banners.
        Plugins should properly handle the case where the pointer is null.  

        """
        return _fastjet.ClusterSequence_fastjet_banner_stream()

    fastjet_banner_stream = staticmethod(fastjet_banner_stream)

    def __init__(self, *args):
        """

        `ClusterSequence(const ClusterSequence &cs)`  

        copy constructor for a ClusterSequence  

        """
        this = _fastjet.new_ClusterSequence(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
ClusterSequence_swigregister = _fastjet.ClusterSequence_swigregister
ClusterSequence_swigregister(ClusterSequence)

def ClusterSequence_print_banner():
    """

    `print_banner()`  

    This is the function that is automatically called during clustering to print the
    FastJet banner.  

    Only the first call to this function will result in the printout of the banner.
    Users may wish to call this function themselves, during the initialization phase
    of their program, in order to ensure that the banner appears before other
    output. This call will not affect 3rd-party banners, e.g. those from plugins.  

    """
    return _fastjet.ClusterSequence_print_banner()

def ClusterSequence_set_fastjet_banner_stream(ostr):
    return _fastjet.ClusterSequence_set_fastjet_banner_stream(ostr)
ClusterSequence_set_fastjet_banner_stream = _fastjet.ClusterSequence_set_fastjet_banner_stream

def ClusterSequence_fastjet_banner_stream():
    """

    `fastjet_banner_stream() -> std::ostream *`  

    returns a pointer to the stream to be used to print banners (cout by default).  

    This function is used by plugins to determine where to direct their banners.
    Plugins should properly handle the case where the pointer is null.  

    """
    return _fastjet.ClusterSequence_fastjet_banner_stream()

class TilingBase(_object):
    """


    Class to indicate generic structure of tilings.  

    C++ includes: fastjet/RectangularGrid.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TilingBase, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TilingBase, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def tile_index(self, p):
        """

        `tile_index(const PseudoJet &p) const =0 -> int`  

        returns the index of the tile in which p is located, or -1 if p is outside the
        tiling region  

        """
        return _fastjet.TilingBase_tile_index(self, p)


    def n_tiles(self):
        """

        `n_tiles() const =0 -> int`  

        returns the total number of tiles in the tiling; valid tile indices run from 0
        ...  

        n_tiles()-1;  

        """
        return _fastjet.TilingBase_n_tiles(self)


    def n_good_tiles(self):
        """

        `n_good_tiles() const -> int`  

        returns the number of tiles that are "good"; i.e.  

        there is scope for having tiles that, for whatever reason, should be ignored;
        there are situations in which having "non-good" tiles may be the simplest
        mechanism to obtain a tiling with holes in it  

        """
        return _fastjet.TilingBase_n_good_tiles(self)


    def tile_is_good(self, arg2):
        """

        `tile_is_good(int) const -> bool`  

        returns whether a given tile is good  

        """
        return _fastjet.TilingBase_tile_is_good(self, arg2)


    def all_tiles_good(self):
        """

        `all_tiles_good() const -> bool`  

        returns whether all tiles are good  

        """
        return _fastjet.TilingBase_all_tiles_good(self)


    def all_tiles_equal_area(self):
        """

        `all_tiles_equal_area() const -> bool`  

        returns true if all tiles have the same area  

        """
        return _fastjet.TilingBase_all_tiles_equal_area(self)


    def tile_area(self, arg2):
        """

        `tile_area(int) const -> double`  

        returns the area of tile itile.  

        Here with a default implementation to return mean_tile_area(), consistent with
        the fact that all_tiles_equal_area() returns true.  

        """
        return _fastjet.TilingBase_tile_area(self, arg2)


    def mean_tile_area(self):
        """

        `mean_tile_area() const =0 -> double`  

        returns the mean area of the tiles.  

        """
        return _fastjet.TilingBase_mean_tile_area(self)


    def description(self):
        """

        `description() const =0 -> std::string`  

        returns a string to describe the tiling  

        """
        return _fastjet.TilingBase_description(self)


    def is_initialised(self):
        """

        `is_initialised() const =0 -> bool`  

        returns true if the Tiling structure is in a suitably initialised state  

        """
        return _fastjet.TilingBase_is_initialised(self)


    def is_initialized(self):
        """

        `is_initialized() const -> bool`  

        """
        return _fastjet.TilingBase_is_initialized(self)

    __swig_destroy__ = _fastjet.delete_TilingBase
    __del__ = lambda self: None
TilingBase_swigregister = _fastjet.TilingBase_swigregister
TilingBase_swigregister(TilingBase)

class RectangularGrid(TilingBase):
    """


    Class that holds a generic rectangular tiling.  

    C++ includes: fastjet/RectangularGrid.hh

    """

    __swig_setmethods__ = {}
    for _s in [TilingBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RectangularGrid, name, value)
    __swig_getmethods__ = {}
    for _s in [TilingBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RectangularGrid, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `RectangularGrid()`  

        dummy ctor (will give an unusable grid)  

        """
        this = _fastjet.new_RectangularGrid(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def n_tiles(self):
        """

        `n_tiles() const -> int`  

        returns the total number of tiles in the tiling; valid tile indices run from 0
        ...  

        n_tiles()-1;  

        """
        return _fastjet.RectangularGrid_n_tiles(self)


    def n_good_tiles(self):
        """

        `n_good_tiles() const -> int`  

        returns the number of tiles that are "good"; i.e.  

        there is scope for having tiles that, for whatever reason, should be ignored;
        there are situations in which having "non-good" tiles may be the simplest
        mechanism to obtain a tiling with holes in it  

        """
        return _fastjet.RectangularGrid_n_good_tiles(self)


    def tile_index(self, p):
        """

        `tile_index(const PseudoJet &p) const -> int`  

        returns the index of the tile in which p is located, or -1 if p is outside the
        tiling region  

        """
        return _fastjet.RectangularGrid_tile_index(self, p)


    def tile_is_good(self, itile):
        """

        `tile_is_good(int itile) const -> bool`  

        returns whether a given tile is good  

        """
        return _fastjet.RectangularGrid_tile_is_good(self, itile)


    def tile_area(self, arg2):
        """

        `tile_area(int) const -> double`  

        returns the area of tile itile.  

        """
        return _fastjet.RectangularGrid_tile_area(self, arg2)


    def mean_tile_area(self):
        """

        `mean_tile_area() const -> double`  

        returns the mean area of tiles.  

        """
        return _fastjet.RectangularGrid_mean_tile_area(self)


    def description(self):
        """

        `description() const -> std::string`  

        returns a textual description of the grid  

        """
        return _fastjet.RectangularGrid_description(self)


    def rapmin(self):
        """

        `rapmin() const -> double`  

        returns the minimum rapidity extent of the grid  

        """
        return _fastjet.RectangularGrid_rapmin(self)


    def rapmax(self):
        """

        `rapmax() const -> double`  

        returns the maxmium rapidity extent of the grid  

        """
        return _fastjet.RectangularGrid_rapmax(self)


    def drap(self):
        """

        `drap() const -> double`  

        returns the spacing of the grid in rapidity  

        """
        return _fastjet.RectangularGrid_drap(self)


    def dphi(self):
        """

        `dphi() const -> double`  

        returns the spacing of the grid in azimuth  

        """
        return _fastjet.RectangularGrid_dphi(self)


    def is_initialised(self):
        """

        `is_initialised() const -> bool`  

        returns true if the grid is in a suitably initialised state  

        """
        return _fastjet.RectangularGrid_is_initialised(self)


    def __str__(self):
        return _fastjet.RectangularGrid___str__(self)
    __swig_destroy__ = _fastjet.delete_RectangularGrid
    __del__ = lambda self: None
RectangularGrid_swigregister = _fastjet.RectangularGrid_swigregister
RectangularGrid_swigregister(RectangularGrid)

class _NoInfo(_object):
    """


    internal dummy class, used as a default template argument  

    C++ includes: fastjet/NNBase.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _NoInfo, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _NoInfo, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _fastjet.new__NoInfo()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete__NoInfo
    __del__ = lambda self: None
_NoInfo_swigregister = _fastjet._NoInfo_swigregister
_NoInfo_swigregister(_NoInfo)

STATIC_GENERATOR = _fastjet.STATIC_GENERATOR
class GhostedAreaSpec(_object):
    """


    Parameters to configure the computation of jet areas using ghosts.  

    Class that defines the parameters that go into the measurement of active jet
    areas.  

    C++ includes: fastjet/GhostedAreaSpec.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GhostedAreaSpec, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GhostedAreaSpec, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `GhostedAreaSpec(const Selector &selector, int repeat_in=gas::def_repeat, double
            ghost_area_in=gas::def_ghost_area, double
            grid_scatter_in=gas::def_grid_scatter, double
            pt_scatter_in=gas::def_pt_scatter, double
            mean_ghost_pt_in=gas::def_mean_ghost_pt)`  

        constructor based on a Selector  

        explicit constructor  

        """
        this = _fastjet.new_GhostedAreaSpec(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def _initialize(self):
        """

        `_initialize()`  

        does the initialization of actual ghost parameters  

        sets the detailed parameters for the ghosts (which may not be quite the same as
        those requested -- this is in order for things to fit in nicely into 2pi etc...  

        """
        return _fastjet.GhostedAreaSpec__initialize(self)


    def ghost_rapmax(self):
        """

        `ghost_rapmax() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_ghost_rapmax(self)


    def ghost_maxrap(self):
        """

        `ghost_maxrap() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_ghost_maxrap(self)


    def ghost_etamax(self):
        """

        `ghost_etamax() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_ghost_etamax(self)


    def ghost_maxeta(self):
        """

        `ghost_maxeta() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_ghost_maxeta(self)


    def ghost_area(self):
        """

        `ghost_area() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_ghost_area(self)


    def grid_scatter(self):
        """

        `grid_scatter() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_grid_scatter(self)


    def pt_scatter(self):
        """

        `pt_scatter() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_pt_scatter(self)


    def mean_ghost_pt(self):
        """

        `mean_ghost_pt() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_mean_ghost_pt(self)


    def repeat(self):
        """

        `repeat() const -> int`  

        """
        return _fastjet.GhostedAreaSpec_repeat(self)


    def fj2_placement(self):
        """

        `fj2_placement() const -> bool`  

        """
        return _fastjet.GhostedAreaSpec_fj2_placement(self)


    def kt_scatter(self):
        """

        `kt_scatter() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_kt_scatter(self)


    def mean_ghost_kt(self):
        """

        `mean_ghost_kt() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_mean_ghost_kt(self)


    def actual_ghost_area(self):
        """

        `actual_ghost_area() const -> double`  

        """
        return _fastjet.GhostedAreaSpec_actual_ghost_area(self)


    def n_ghosts(self):
        """

        `n_ghosts() const -> int`  

        """
        return _fastjet.GhostedAreaSpec_n_ghosts(self)


    def set_ghost_area(self, val):
        """

        `set_ghost_area(double val)`  

        """
        return _fastjet.GhostedAreaSpec_set_ghost_area(self, val)


    def set_ghost_rapmax(self, val):
        """

        `set_ghost_rapmax(double val)`  

        """
        return _fastjet.GhostedAreaSpec_set_ghost_rapmax(self, val)


    def set_ghost_maxrap(self, val):
        """

        `set_ghost_maxrap(double val)`  

        """
        return _fastjet.GhostedAreaSpec_set_ghost_maxrap(self, val)


    def set_ghost_etamax(self, val):
        """

        `set_ghost_etamax(double val)`  

        """
        return _fastjet.GhostedAreaSpec_set_ghost_etamax(self, val)


    def set_ghost_maxeta(self, val):
        """

        `set_ghost_maxeta(double val)`  

        """
        return _fastjet.GhostedAreaSpec_set_ghost_maxeta(self, val)


    def set_grid_scatter(self, val):
        """

        `set_grid_scatter(double val)`  

        """
        return _fastjet.GhostedAreaSpec_set_grid_scatter(self, val)


    def set_pt_scatter(self, val):
        """

        `set_pt_scatter(double val)`  

        """
        return _fastjet.GhostedAreaSpec_set_pt_scatter(self, val)


    def set_mean_ghost_pt(self, val):
        """

        `set_mean_ghost_pt(double val)`  

        """
        return _fastjet.GhostedAreaSpec_set_mean_ghost_pt(self, val)


    def set_repeat(self, val):
        """

        `set_repeat(int val)`  

        """
        return _fastjet.GhostedAreaSpec_set_repeat(self, val)


    def set_kt_scatter(self, val):
        """

        `set_kt_scatter(double val)`  

        """
        return _fastjet.GhostedAreaSpec_set_kt_scatter(self, val)


    def set_mean_ghost_kt(self, val):
        """

        `set_mean_ghost_kt(double val)`  

        """
        return _fastjet.GhostedAreaSpec_set_mean_ghost_kt(self, val)


    def set_fj2_placement(self, val):
        return _fastjet.GhostedAreaSpec_set_fj2_placement(self, val)

    def nphi(self):
        """

        `nphi() const -> int`  

        return nphi (ghosts layed out (-nrap, 0..nphi-1), (-nrap+1,0..nphi-1), ...  

        (nrap,0..nphi-1)  

        """
        return _fastjet.GhostedAreaSpec_nphi(self)


    def nrap(self):
        """

        `nrap() const -> int`  

        """
        return _fastjet.GhostedAreaSpec_nrap(self)


    def get_random_status(self, __iseed):
        """

        `get_random_status(std::vector< int > &__iseed) const`  

        get all relevant information about the status of the random number generator, so
        that it can be reset subsequently with set_random_status.  

        """
        return _fastjet.GhostedAreaSpec_get_random_status(self, __iseed)


    def set_random_status(self, __iseed):
        """

        `set_random_status(const std::vector< int > &__iseed)`  

        set the status of the random number generator, as obtained previously with
        get_random_status.  

        Note that the random generator is a static member of the class, i.e. common to
        all instances of the class --- so if you modify the random for this instance,
        you modify it for all instances.  

        """
        return _fastjet.GhostedAreaSpec_set_random_status(self, __iseed)


    def checkpoint_random(self):
        """

        `checkpoint_random()`  

        """
        return _fastjet.GhostedAreaSpec_checkpoint_random(self)


    def restore_checkpoint_random(self):
        """

        `restore_checkpoint_random()`  

        """
        return _fastjet.GhostedAreaSpec_restore_checkpoint_random(self)


    def description(self):
        """

        `description() const -> std::string`  

        for a summary  

        """
        return _fastjet.GhostedAreaSpec_description(self)


    def add_ghosts(self, arg2):
        """

        `add_ghosts(std::vector< PseudoJet > &) const`  

        push a set of ghost 4-momenta onto the back of the vector of PseudoJets  

        adds the ghost 4-momenta to the vector of PseudoJet's  

        """
        return _fastjet.GhostedAreaSpec_add_ghosts(self, arg2)


    def random_at_own_risk(self):
        """

        `random_at_own_risk() const -> double`  

        very deprecated public access to a random number from the internal generator  

        """
        return _fastjet.GhostedAreaSpec_random_at_own_risk(self)


    def generator_at_own_risk(self):
        """

        `generator_at_own_risk() const -> BasicRandom< double > &`  

        very deprecated public access to the generator itself  

        """
        return _fastjet.GhostedAreaSpec_generator_at_own_risk(self)


    def __str__(self):
        return _fastjet.GhostedAreaSpec___str__(self)
    __swig_destroy__ = _fastjet.delete_GhostedAreaSpec
    __del__ = lambda self: None
GhostedAreaSpec_swigregister = _fastjet.GhostedAreaSpec_swigregister
GhostedAreaSpec_swigregister(GhostedAreaSpec)
def_ghost_maxrap = cvar.def_ghost_maxrap
def_repeat = cvar.def_repeat
def_ghost_area = cvar.def_ghost_area
def_grid_scatter = cvar.def_grid_scatter
def_pt_scatter = cvar.def_pt_scatter
def_mean_ghost_pt = cvar.def_mean_ghost_pt

class VoronoiAreaSpec(_object):
    """


    Specification for the computation of the Voronoi jet area.  

    class for holding a "Voronoi area" specification; an area will be assigned to
    each particle, which is the area of the intersection of the particle's Voronoi
    cell with a circle of radius R*effective_Rfact.  

    C++ includes: fastjet/AreaDefinition.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VoronoiAreaSpec, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VoronoiAreaSpec, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `VoronoiAreaSpec(double effective_Rfact_in)`  

        constructor that allows you to set effective_Rfact.  

        """
        this = _fastjet.new_VoronoiAreaSpec(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def effective_Rfact(self):
        """

        `effective_Rfact() const -> double`  

        return the value of effective_Rfact  

        """
        return _fastjet.VoronoiAreaSpec_effective_Rfact(self)


    def description(self):
        """

        `description() const -> std::string`  

        return a textual description of the area definition.  

        """
        return _fastjet.VoronoiAreaSpec_description(self)

    __swig_destroy__ = _fastjet.delete_VoronoiAreaSpec
    __del__ = lambda self: None
VoronoiAreaSpec_swigregister = _fastjet.VoronoiAreaSpec_swigregister
VoronoiAreaSpec_swigregister(VoronoiAreaSpec)

invalid_area = _fastjet.invalid_area
active_area = _fastjet.active_area
active_area_explicit_ghosts = _fastjet.active_area_explicit_ghosts
one_ghost_passive_area = _fastjet.one_ghost_passive_area
passive_area = _fastjet.passive_area
voronoi_area = _fastjet.voronoi_area
class AreaDefinition(_object):
    """


    class that holds a generic area definition  

    C++ includes: fastjet/AreaDefinition.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AreaDefinition, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AreaDefinition, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `AreaDefinition(const VoronoiAreaSpec &spec)`  

        constructor for an area definition based on a voronoi area specification  

        """
        this = _fastjet.new_AreaDefinition(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def description(self):
        """

        `description() const -> std::string`  

        return a description of the current area definition  

        return info about the type of area being used by this defn  

        """
        return _fastjet.AreaDefinition_description(self)


    def area_type(self):
        """

        `area_type() const -> AreaType`  

        return info about the type of area being used by this defn  

        """
        return _fastjet.AreaDefinition_area_type(self)


    def ghost_spec(self, *args):
        """

        `ghost_spec() -> GhostedAreaSpec &`  

        """
        return _fastjet.AreaDefinition_ghost_spec(self, *args)


    def voronoi_spec(self):
        """

        `voronoi_spec() const -> const VoronoiAreaSpec &`  

        return a reference to the voronoi area spec  

        """
        return _fastjet.AreaDefinition_voronoi_spec(self)


    def __str__(self):
        return _fastjet.AreaDefinition___str__(self)
    __swig_destroy__ = _fastjet.delete_AreaDefinition
    __del__ = lambda self: None
AreaDefinition_swigregister = _fastjet.AreaDefinition_swigregister
AreaDefinition_swigregister(AreaDefinition)

class ClusterSequenceAreaBase(ClusterSequence):
    """


    base class that sets interface for extensions of ClusterSequence that provide
    information about the area of each jet  

    the virtual functions here all return 0, since no area determination is
    implemented.  

    C++ includes: fastjet/ClusterSequenceAreaBase.hh

    """

    __swig_setmethods__ = {}
    for _s in [ClusterSequence]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClusterSequenceAreaBase, name, value)
    __swig_getmethods__ = {}
    for _s in [ClusterSequence]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ClusterSequenceAreaBase, name)
    __repr__ = _swig_repr

    def __init__(self):
        """

        `ClusterSequenceAreaBase()`  

        default constructor  

        """
        this = _fastjet.new_ClusterSequenceAreaBase()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_ClusterSequenceAreaBase
    __del__ = lambda self: None

    def area(self, arg2):
        """

        `area(const PseudoJet &) const -> double`  

        return the area associated with the given jet; this base class returns 0.  

        """
        return _fastjet.ClusterSequenceAreaBase_area(self, arg2)


    def area_error(self, arg2):
        """

        `area_error(const PseudoJet &) const -> double`  

        return the error (uncertainty) associated with the determination of the area of
        this jet; this base class returns 0.  

        """
        return _fastjet.ClusterSequenceAreaBase_area_error(self, arg2)


    def area_4vector(self, arg2):
        """

        `area_4vector(const PseudoJet &) const -> PseudoJet`  

        return a PseudoJet whose 4-vector is defined by the following integral  

        drap d PseudoJet("rap,phi,pt=one") *  

        *   Theta("rap,phi inside jet boundary")  

        where PseudoJet("rap,phi,pt=one") is a 4-vector with the given rapidity (rap),
        azimuth (phi) and pt=1, while Theta("rap,phi
        inside jet boundary") is a function that is 1 when rap,phi define a direction
        inside the jet boundary and 0 otherwise.  

        This base class returns a null 4-vector.  

        """
        return _fastjet.ClusterSequenceAreaBase_area_4vector(self, arg2)


    def is_pure_ghost(self, arg2):
        """

        `is_pure_ghost(const PseudoJet &) const -> bool`  

        true if a jet is made exclusively of ghosts  

        NB: most area classes do not give any explicit ghost jets, but some do, and they
        should replace this function with their own version.  

        """
        return _fastjet.ClusterSequenceAreaBase_is_pure_ghost(self, arg2)


    def has_explicit_ghosts(self):
        """

        `has_explicit_ghosts() const -> bool`  

        returns true if ghosts are explicitly included within jets for this
        ClusterSequence;  

        Derived classes that do include explicit ghosts should provide an alternative
        version of this routine and set it properly.  

        """
        return _fastjet.ClusterSequenceAreaBase_has_explicit_ghosts(self)


    def empty_area(self, selector):
        """

        `empty_area(const Selector &selector) const -> double`  

        return the total area, corresponding to the given Selector, that is free of
        jets, in general based on the inclusive jets.  

        return the total area, within the selector's range, that is free of jets.  

        The selector passed as an argument has to have a finite area and apply jet-by-
        jet (see the BackgroundEstimator and Subtractor tools for more generic usages)  

        Calculate this as (range area) - {i in range} A_i  

        for ClusterSequences with explicit ghosts, assume that there will never be any
        empty area, i.e. it is always filled in by pure ghosts jets. This holds for
        seq.rec. algorithms  

        """
        return _fastjet.ClusterSequenceAreaBase_empty_area(self, selector)


    def empty_area_from_jets(self, all_jets, selector):
        """

        `empty_area_from_jets(const std::vector< PseudoJet > &all_jets, const Selector
            &selector) const -> double`  

        return the total area, corresponding to the given Selector, that is free of
        jets, based on the supplied all_jets  

        return the total area, within range, that is free of jets.  

        The selector passed as an argument has to have a finite area and apply jet-by-
        jet (see the BackgroundEstimator and Subtractor tools for more generic usages)  

        Calculate this as (range area) - {i in range} A_i  

        """
        return _fastjet.ClusterSequenceAreaBase_empty_area_from_jets(self, all_jets, selector)


    def n_empty_jets(self, selector):
        """

        `n_empty_jets(const Selector &selector) const -> double`  

        return something similar to the number of pure ghost jets in the given
        selector's range in an active area case.  

        For the local implementation we return empty_area/(0.55 pi R^2), based on
        measured properties of ghost jets with kt and cam (cf arXiv:0802.1188).  

        Note that the number returned is a double.  

        The selector passed as an argument has to have a finite area and apply jet-by-
        jet (see the BackgroundEstimator and Subtractor tools for more generic usages)  

        """
        return _fastjet.ClusterSequenceAreaBase_n_empty_jets(self, selector)


    def median_pt_per_unit_area(self, selector):
        return _fastjet.ClusterSequenceAreaBase_median_pt_per_unit_area(self, selector)

    def median_pt_per_unit_area_4vector(self, selector):
        return _fastjet.ClusterSequenceAreaBase_median_pt_per_unit_area_4vector(self, selector)

    def median_pt_per_unit_something(self, selector, use_area_4vector):
        return _fastjet.ClusterSequenceAreaBase_median_pt_per_unit_something(self, selector, use_area_4vector)

    def get_median_rho_and_sigma(self, *args):
        """

        `get_median_rho_and_sigma(const Selector &selector, bool use_area_4vector,
            double &median, double &sigma) const`  

        same as the full version of get_median_rho_and_error, but without access to the
        mean_area  

        The selector passed as an argument has to have a finite area and apply jet-by-
        jet (see the BackgroundEstimator and Subtractor tools for more generic usages)  

        """
        return _fastjet.ClusterSequenceAreaBase_get_median_rho_and_sigma(self, *args)


    def parabolic_pt_per_unit_area(self, a, b, selector, exclude_above=-1.0, use_area_4vector=False):
        """

        `parabolic_pt_per_unit_area(double &a, double &b, const Selector &selector,
            double exclude_above=-1.0, bool use_area_4vector=false) const`  

        fits a form pt_per_unit_area(y) = a + b*y^2 in the selector range.  

        fits a form pt_per_unit_area(y) = a + b*y^2 for jets in range.  

        exclude_above allows one to exclude large values of pt/area from fit. (if
        negative, the cut is discarded) use_area_4vector = true uses the 4vector areas.  

        The selector passed as an argument has to have a finite area and apply jet-by-
        jet (see the BackgroundEstimator and Subtractor tools for more generic usages)  

        exclude_above allows one to exclude large values of pt/area from fit.
        use_area_4vector = true uses the 4vector areas.  

        """
        return _fastjet.ClusterSequenceAreaBase_parabolic_pt_per_unit_area(self, a, b, selector, exclude_above, use_area_4vector)


    def subtracted_jets(self, *args):
        return _fastjet.ClusterSequenceAreaBase_subtracted_jets(self, *args)

    def subtracted_jet(self, *args):
        return _fastjet.ClusterSequenceAreaBase_subtracted_jet(self, *args)

    def subtracted_pt(self, *args):
        return _fastjet.ClusterSequenceAreaBase_subtracted_pt(self, *args)
ClusterSequenceAreaBase_swigregister = _fastjet.ClusterSequenceAreaBase_swigregister
ClusterSequenceAreaBase_swigregister(ClusterSequenceAreaBase)

class ClusterSequenceActiveAreaExplicitGhosts(ClusterSequenceAreaBase):
    """


    Like ClusterSequence with computation of the active jet area with the addition
    of explicit ghosts.  

    Class that behaves essentially like ClusterSequence except that it also provides
    access to the area of a jet (which will be a random quantity... Figure out what
    to do about seeds later...)  

    This class should not be used directly. Rather use ClusterSequenceArea with the
    appropriate AreaDefinition  

    C++ includes: fastjet/ClusterSequenceActiveAreaExplicitGhosts.hh

    """

    __swig_setmethods__ = {}
    for _s in [ClusterSequenceAreaBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClusterSequenceActiveAreaExplicitGhosts, name, value)
    __swig_getmethods__ = {}
    for _s in [ClusterSequenceAreaBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ClusterSequenceActiveAreaExplicitGhosts, name)
    __repr__ = _swig_repr

    def n_hard_particles(self):
        """

        `n_hard_particles() const -> unsigned int`  

        returns the number of hard particles (i.e. those supplied by the user).  

        """
        return _fastjet.ClusterSequenceActiveAreaExplicitGhosts_n_hard_particles(self)


    def area(self, jet):
        """

        `area(const PseudoJet &jet) const -> double`  

        returns the area of a jet  

        """
        return _fastjet.ClusterSequenceActiveAreaExplicitGhosts_area(self, jet)


    def area_4vector(self, jet):
        """

        `area_4vector(const PseudoJet &jet) const -> PseudoJet`  

        returns a four vector corresponding to the sum (E-scheme) of the ghost four-
        vectors composing the jet area, normalised such that for a small contiguous area
        the p_t of the extended_area jet is equal to area of the jet.  

        """
        return _fastjet.ClusterSequenceActiveAreaExplicitGhosts_area_4vector(self, jet)


    def is_pure_ghost(self, *args):
        """

        `is_pure_ghost(int history_index) const -> bool`  

        true if the entry in the history index corresponds to a ghost; if hist_ix does
        not correspond to an actual particle (i.e.  

        hist_ix < 0), then the result is false.  

        """
        return _fastjet.ClusterSequenceActiveAreaExplicitGhosts_is_pure_ghost(self, *args)


    def has_explicit_ghosts(self):
        """

        `has_explicit_ghosts() const -> bool`  

        this class does have explicit ghosts  

        """
        return _fastjet.ClusterSequenceActiveAreaExplicitGhosts_has_explicit_ghosts(self)


    def empty_area(self, selector):
        """

        `empty_area(const Selector &selector) const -> double`  

        return the total area, corresponding to a given Selector, that consists of
        unclustered ghosts  

        The selector needs to apply jet by jet  

        """
        return _fastjet.ClusterSequenceActiveAreaExplicitGhosts_empty_area(self, selector)


    def total_area(self):
        """

        `total_area() const -> double`  

        returns the total area under study  

        """
        return _fastjet.ClusterSequenceActiveAreaExplicitGhosts_total_area(self)


    def max_ghost_perp2(self):
        """

        `max_ghost_perp2() const -> double`  

        returns the largest squared transverse momentum among all ghosts  

        """
        return _fastjet.ClusterSequenceActiveAreaExplicitGhosts_max_ghost_perp2(self)


    def has_dangerous_particles(self):
        """

        `has_dangerous_particles() const -> bool`  

        returns true if there are any particles whose transverse momentum if so low that
        there's a risk of the ghosts having modified the clustering sequence  

        """
        return _fastjet.ClusterSequenceActiveAreaExplicitGhosts_has_dangerous_particles(self)


    def __init__(self, *args):
        """

        `ClusterSequenceActiveAreaExplicitGhosts(const std::vector< L > &pseudojets,
            const JetDefinition &jet_def_in, const std::vector< L > &ghosts, double
            ghost_area, const bool &writeout_combinations=false)`  

        """
        this = _fastjet.new_ClusterSequenceActiveAreaExplicitGhosts(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_ClusterSequenceActiveAreaExplicitGhosts
    __del__ = lambda self: None
ClusterSequenceActiveAreaExplicitGhosts_swigregister = _fastjet.ClusterSequenceActiveAreaExplicitGhosts_swigregister
ClusterSequenceActiveAreaExplicitGhosts_swigregister(ClusterSequenceActiveAreaExplicitGhosts)

class ClusterSequenceActiveArea(ClusterSequenceAreaBase):
    """


    Like ClusterSequence with computation of the active jet area.  

    Class that behaves essentially like ClusterSequence except that it also provides
    access to the area of a jet (which will be a random quantity... Figure out what
    to do about seeds later...)  

    This class should not be used directly. Rather use ClusterSequenceArea with the
    appropriate AreaDefinition  

    C++ includes: fastjet/ClusterSequenceActiveArea.hh

    """

    __swig_setmethods__ = {}
    for _s in [ClusterSequenceAreaBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClusterSequenceActiveArea, name, value)
    __swig_getmethods__ = {}
    for _s in [ClusterSequenceAreaBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ClusterSequenceActiveArea, name)
    __repr__ = _swig_repr

    def area(self, jet):
        """

        `area(const PseudoJet &jet) const -> double`  

        return the area associated with the given jet; this base class returns 0.  

        """
        return _fastjet.ClusterSequenceActiveArea_area(self, jet)


    def area_error(self, jet):
        """

        `area_error(const PseudoJet &jet) const -> double`  

        return the error (uncertainty) associated with the determination of the area of
        this jet; this base class returns 0.  

        """
        return _fastjet.ClusterSequenceActiveArea_area_error(self, jet)


    def area_4vector(self, jet):
        """

        `area_4vector(const PseudoJet &jet) const -> PseudoJet`  

        return a PseudoJet whose 4-vector is defined by the following integral  

        drap d PseudoJet("rap,phi,pt=one") *  

        *   Theta("rap,phi inside jet boundary")  

        where PseudoJet("rap,phi,pt=one") is a 4-vector with the given rapidity (rap),
        azimuth (phi) and pt=1, while Theta("rap,phi
        inside jet boundary") is a function that is 1 when rap,phi define a direction
        inside the jet boundary and 0 otherwise.  

        This base class returns a null 4-vector.  

        """
        return _fastjet.ClusterSequenceActiveArea_area_4vector(self, jet)

    median = _fastjet.ClusterSequenceActiveArea_median
    non_ghost_median = _fastjet.ClusterSequenceActiveArea_non_ghost_median
    pttot_over_areatot = _fastjet.ClusterSequenceActiveArea_pttot_over_areatot
    pttot_over_areatot_cut = _fastjet.ClusterSequenceActiveArea_pttot_over_areatot_cut
    mean_ratio_cut = _fastjet.ClusterSequenceActiveArea_mean_ratio_cut
    play = _fastjet.ClusterSequenceActiveArea_play
    median_4vector = _fastjet.ClusterSequenceActiveArea_median_4vector

    def pt_per_unit_area(self, *args):
        """

        `pt_per_unit_area(mean_pt_strategies strat=median, double range=2.0) const ->
            double`  

        return the transverse momentum per unit area according to one of the above
        strategies; for some strategies (those with "cut" in their name) the parameter
        "range" allows one to exclude a subset of the jets for the background
        estimation, those that have pt/area > median(pt/area)*range.  

        NB: This call is OBSOLETE and deprecated; use a JetMedianBackgroundEstimator or
        GridMedianBackgroundEstimator instead.  

        """
        return _fastjet.ClusterSequenceActiveArea_pt_per_unit_area(self, *args)


    def empty_area(self, selector):
        """

        `empty_area(const Selector &selector) const -> double`  

        rewrite the empty area from the parent class, so as to use all info at our
        disposal return the total area, corresponding to a given Selector, that consists
        of ghost jets or unclustered ghosts  

        The selector passed as an argument needs to apply jet by jet.  

        """
        return _fastjet.ClusterSequenceActiveArea_empty_area(self, selector)


    def n_empty_jets(self, selector):
        """

        `n_empty_jets(const Selector &selector) const -> double`  

        return the true number of empty jets (replaces
        ClusterSequenceAreaBase::n_empty_jets(...))  

        """
        return _fastjet.ClusterSequenceActiveArea_n_empty_jets(self, selector)


    def __init__(self, *args):
        """

        `ClusterSequenceActiveArea(const std::vector< L > &pseudojets, const
            JetDefinition &jet_def_in, const GhostedAreaSpec &ghost_spec, const bool
            &writeout_combinations=false)`  

        constructor based on JetDefinition and GhostedAreaSpec  

        """
        this = _fastjet.new_ClusterSequenceActiveArea(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_ClusterSequenceActiveArea
    __del__ = lambda self: None
ClusterSequenceActiveArea_swigregister = _fastjet.ClusterSequenceActiveArea_swigregister
ClusterSequenceActiveArea_swigregister(ClusterSequenceActiveArea)

class ClusterSequence1GhostPassiveArea(ClusterSequenceActiveArea):
    """


    Like ClusterSequence with computation of the passive jet area by adding a single
    ghost.  

    Class that behaves essentially like ClusterSequence except that it also provides
    access to the area of a jet (which will be a random quantity... Figure out what
    to do about seeds later...)  

    This class should not be used directly. Rather use ClusterSequenceArea  

    C++ includes: fastjet/ClusterSequence1GhostPassiveArea.hh

    """

    __swig_setmethods__ = {}
    for _s in [ClusterSequenceActiveArea]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClusterSequence1GhostPassiveArea, name, value)
    __swig_getmethods__ = {}
    for _s in [ClusterSequenceActiveArea]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ClusterSequence1GhostPassiveArea, name)
    __repr__ = _swig_repr

    def n_empty_jets(self, selector):
        """

        `n_empty_jets(const Selector &selector) const -> double`  

        return an estimate for the number of empty jets -- one uses the AreaBase one
        rather than the ActiveArea one (which for which we do not have the information).  

        """
        return _fastjet.ClusterSequence1GhostPassiveArea_n_empty_jets(self, selector)


    def __init__(self, *args):
        """

        `ClusterSequence1GhostPassiveArea(const std::vector< L > &pseudojets, const
            JetDefinition &jet_def_in, const GhostedAreaSpec &area_spec, const bool
            &writeout_combinations=false)`  

        constructor based on JetDefinition and 1GhostPassiveAreaSpec  

        """
        this = _fastjet.new_ClusterSequence1GhostPassiveArea(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_ClusterSequence1GhostPassiveArea
    __del__ = lambda self: None
ClusterSequence1GhostPassiveArea_swigregister = _fastjet.ClusterSequence1GhostPassiveArea_swigregister
ClusterSequence1GhostPassiveArea_swigregister(ClusterSequence1GhostPassiveArea)

class ClusterSequencePassiveArea(ClusterSequence1GhostPassiveArea):
    """


    Like ClusterSequence with computation of the passive jet area.  

    Class that behaves essentially like ClusterSequence except that it also provides
    access to the area of a jet (which will be a random quantity... Figure out what
    to do about seeds later...)  

    This class should not be used directly. Rather use ClusterSequenceArea with the
    appropriate AreaDefinition  

    C++ includes: fastjet/ClusterSequencePassiveArea.hh

    """

    __swig_setmethods__ = {}
    for _s in [ClusterSequence1GhostPassiveArea]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClusterSequencePassiveArea, name, value)
    __swig_getmethods__ = {}
    for _s in [ClusterSequence1GhostPassiveArea]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ClusterSequencePassiveArea, name)
    __repr__ = _swig_repr

    def empty_area(self, selector):
        """

        `empty_area(const Selector &selector) const -> double`  

        return an empty area that's appropriate to the passive area determination
        carried out  

        """
        return _fastjet.ClusterSequencePassiveArea_empty_area(self, selector)


    def __init__(self, pseudojets, jet_def_in, area_spec, writeout_combinations=False):
        """

        `ClusterSequencePassiveArea(const std::vector< L > &pseudojets, const
            JetDefinition &jet_def_in, const GhostedAreaSpec &area_spec, const bool
            &writeout_combinations=false)`  

        constructor based on JetDefinition and PassiveAreaSpec  

        """
        this = _fastjet.new_ClusterSequencePassiveArea(pseudojets, jet_def_in, area_spec, writeout_combinations)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_ClusterSequencePassiveArea
    __del__ = lambda self: None
ClusterSequencePassiveArea_swigregister = _fastjet.ClusterSequencePassiveArea_swigregister
ClusterSequencePassiveArea_swigregister(ClusterSequencePassiveArea)

class ClusterSequenceVoronoiArea(ClusterSequenceAreaBase):
    """


    Like ClusterSequence with computation of the Voronoi jet area.  

    Handle the computation of Voronoi jet area.  

    This class should not be used directly. Rather use ClusterSequenceArea with the
    appropriate AreaDefinition  

    C++ includes: fastjet/ClusterSequenceVoronoiArea.hh

    """

    __swig_setmethods__ = {}
    for _s in [ClusterSequenceAreaBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClusterSequenceVoronoiArea, name, value)
    __swig_getmethods__ = {}
    for _s in [ClusterSequenceAreaBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ClusterSequenceVoronoiArea, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _fastjet.delete_ClusterSequenceVoronoiArea
    __del__ = lambda self: None

    def area(self, jet):
        """

        `area(const PseudoJet &jet) const -> double`  

        return the area associated with the given jet  

        """
        return _fastjet.ClusterSequenceVoronoiArea_area(self, jet)


    def area_4vector(self, jet):
        """

        `area_4vector(const PseudoJet &jet) const -> PseudoJet`  

        return a 4-vector area associated with the given jet -- strictly this is not the
        exact 4-vector area, but rather an approximation made of sums of centres of all
        Voronoi cells in jet, each contributing with a normalisation equal to the area
        of the cell  

        """
        return _fastjet.ClusterSequenceVoronoiArea_area_4vector(self, jet)


    def area_error(self, arg2):
        """

        `area_error(const PseudoJet &) const -> double`  

        return the error of the area associated with the given jet (0 by definition for
        a voronoi area)  

        """
        return _fastjet.ClusterSequenceVoronoiArea_area_error(self, arg2)


    def __init__(self, *args):
        """

        `ClusterSequenceVoronoiArea(const std::vector< L > &pseudojets, const
            JetDefinition &jet_def, const VoronoiAreaSpec &spec=VoronoiAreaSpec(), const
            bool &writeout_combinations=false)`  

        template ctor  

        template constructor need to be specified in the header!  

        Parameters
        ----------
        * `pseudojet` :  
            list of jets (template type)  
        * `jet_def` :  
            jet definition  
        * `effective_Rfact` :  
            effective radius  
        * `writeout_combinations` :  
            ??????  

        """
        this = _fastjet.new_ClusterSequenceVoronoiArea(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
ClusterSequenceVoronoiArea_swigregister = _fastjet.ClusterSequenceVoronoiArea_swigregister
ClusterSequenceVoronoiArea_swigregister(ClusterSequenceVoronoiArea)

class ClusterSequenceArea(ClusterSequenceAreaBase):
    """


    General class for user to obtain ClusterSequence with additional area
    information.  

    Based on the area_def, it automatically dispatches the work to the appropriate
    actual ClusterSequenceAreaBase-derived-class to do the real work.  

    C++ includes: fastjet/ClusterSequenceArea.hh

    """

    __swig_setmethods__ = {}
    for _s in [ClusterSequenceAreaBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClusterSequenceArea, name, value)
    __swig_getmethods__ = {}
    for _s in [ClusterSequenceAreaBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ClusterSequenceArea, name)
    __repr__ = _swig_repr

    def area_def(self):
        """

        `area_def() const -> const AreaDefinition &`  

        return a reference to the area definition  

        """
        return _fastjet.ClusterSequenceArea_area_def(self)


    def area(self, jet):
        """

        `area(const PseudoJet &jet) const -> double`  

        return the area associated with the given jet  

        """
        return _fastjet.ClusterSequenceArea_area(self, jet)


    def area_error(self, jet):
        """

        `area_error(const PseudoJet &jet) const -> double`  

        return the error (uncertainty) associated with the determination of the area of
        this jet  

        """
        return _fastjet.ClusterSequenceArea_area_error(self, jet)


    def area_4vector(self, jet):
        """

        `area_4vector(const PseudoJet &jet) const -> PseudoJet`  

        return the 4-vector area  

        """
        return _fastjet.ClusterSequenceArea_area_4vector(self, jet)


    def empty_area(self, selector):
        """

        `empty_area(const Selector &selector) const -> double`  

        return the total area, corresponding to the given selector, that is free of jets  

        The selector needs to have a finite area and be applicable jet by jet (see the
        BackgroundEstimator and Subtractor tools for more advanced usage)  

        """
        return _fastjet.ClusterSequenceArea_empty_area(self, selector)


    def n_empty_jets(self, selector):
        """

        `n_empty_jets(const Selector &selector) const -> double`  

        return something similar to the number of pure ghost jets in the given rap-phi
        range in an active area case.  

        For the local implementation we return empty_area/(0.55 pi R^2), based on
        measured properties of ghost jets with kt and cam. Note that the number returned
        is a double.  

        The selector needs to have a finite area and be applicable jet by jet (see the
        BackgroundEstimator and Subtractor tools for more advanced usage)  

        """
        return _fastjet.ClusterSequenceArea_n_empty_jets(self, selector)


    def is_pure_ghost(self, jet):
        """

        `is_pure_ghost(const PseudoJet &jet) const -> bool`  

        true if a jet is made exclusively of ghosts  

        """
        return _fastjet.ClusterSequenceArea_is_pure_ghost(self, jet)


    def has_explicit_ghosts(self):
        """

        `has_explicit_ghosts() const -> bool`  

        true if this ClusterSequence has explicit ghosts  

        """
        return _fastjet.ClusterSequenceArea_has_explicit_ghosts(self)


    def get_median_rho_and_sigma(self, *args):
        """

        `get_median_rho_and_sigma(const Selector &selector, bool use_area_4vector,
            double &median, double &sigma, double &mean_area) const`  

        overload version of what's in the ClusterSequenceAreaBase class, which actually
        just does the same thing as the base version (but since we've overridden the
        multi-argument version above, we have to override the 5-argument version too.  

        """
        return _fastjet.ClusterSequenceArea_get_median_rho_and_sigma(self, *args)


    def parabolic_pt_per_unit_area(self, a, b, selector, exclude_above=-1.0, use_area_4vector=False):
        """

        `parabolic_pt_per_unit_area(double &a, double &b, const Selector &selector,
            double exclude_above=-1.0, bool use_area_4vector=false) const`  

        overload version of what's in the ClusterSequenceAreaBase class, which
        additionally checks compatibility between "range" and region in which ghosts
        are thrown.  

        """
        return _fastjet.ClusterSequenceArea_parabolic_pt_per_unit_area(self, a, b, selector, exclude_above, use_area_4vector)


    def __init__(self, *args):
        """

        `ClusterSequenceArea(const std::vector< L > &pseudojets, const JetDefinition
            &jet_def_in, const VoronoiAreaSpec &voronoi_spec)`  

        constructor with a VoronoiAreaSpec  

        """
        this = _fastjet.new_ClusterSequenceArea(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_ClusterSequenceArea
    __del__ = lambda self: None
ClusterSequenceArea_swigregister = _fastjet.ClusterSequenceArea_swigregister
ClusterSequenceArea_swigregister(ClusterSequenceArea)

class UserInfoPython(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, UserInfoPython, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, UserInfoPython, name)
    __repr__ = _swig_repr

    def __init__(self, pyobj):
        this = _fastjet.new_UserInfoPython(pyobj)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def get_pyobj(self):
        return _fastjet.UserInfoPython_get_pyobj(self)
    __swig_destroy__ = _fastjet.delete_UserInfoPython
    __del__ = lambda self: None
UserInfoPython_swigregister = _fastjet.UserInfoPython_swigregister
UserInfoPython_swigregister(UserInfoPython)


def cpp_string_from_py_str(py_str):
    return _fastjet.cpp_string_from_py_str(py_str)
cpp_string_from_py_str = _fastjet.cpp_string_from_py_str

def cpp_string_from_str_py_obj(py_obj):
    return _fastjet.cpp_string_from_str_py_obj(py_obj)
cpp_string_from_str_py_obj = _fastjet.cpp_string_from_str_py_obj

def cpp_string_from_name_py_obj(py_obj):
    return _fastjet.cpp_string_from_name_py_obj(py_obj)
cpp_string_from_name_py_obj = _fastjet.cpp_string_from_name_py_obj
class SelectorWorkerPython(SelectorWorker):
    __swig_setmethods__ = {}
    for _s in [SelectorWorker]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SelectorWorkerPython, name, value)
    __swig_getmethods__ = {}
    for _s in [SelectorWorker]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SelectorWorkerPython, name)
    __repr__ = _swig_repr

    def __init__(self, py_class_or_function):
        this = _fastjet.new_SelectorWorkerPython(py_class_or_function)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_SelectorWorkerPython
    __del__ = lambda self: None

    def description(self):
        """

        `description() const -> std::string`  

        returns a description of the worker  

        """
        return _fastjet.SelectorWorkerPython_description(self)


    def _pass(self, jet):
        """

        `pass(const PseudoJet &jet) const =0 -> bool`  

        returns true if a given object passes the selection criterion, and is the main
        function that needs to be overloaded by derived workers.  

        NB: this function is used only if applies_jet_by_jet() returns true. If it does
        not, then derived classes are expected to (re)implement the terminator
        function()  

        """
        return _fastjet.SelectorWorkerPython__pass(self, jet)

SelectorWorkerPython_swigregister = _fastjet.SelectorWorkerPython_swigregister
SelectorWorkerPython_swigregister(SelectorWorkerPython)


def SelectorPython(py_function_or_class):
    return _fastjet.SelectorPython(py_function_or_class)
SelectorPython = _fastjet.SelectorPython
class RecombinerPython(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RecombinerPython, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RecombinerPython, name)
    __repr__ = _swig_repr

    def __init__(self, py_class):
        this = _fastjet.new_RecombinerPython(py_class)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_RecombinerPython
    __del__ = lambda self: None

    def description(self):
        return _fastjet.RecombinerPython_description(self)

    def recombine(self, pa, pb, pab):
        return _fastjet.RecombinerPython_recombine(self, pa, pb, pab)

    def preprocess(self, pa):
        return _fastjet.RecombinerPython_preprocess(self, pa)
RecombinerPython_swigregister = _fastjet.RecombinerPython_swigregister
RecombinerPython_swigregister(RecombinerPython)


def JetDefinition0Param(*args):
    return _fastjet.JetDefinition0Param(*args)
JetDefinition0Param = _fastjet.JetDefinition0Param

def JetDefinition1Param(*args):
    return _fastjet.JetDefinition1Param(*args)
JetDefinition1Param = _fastjet.JetDefinition1Param

def JetDefinition2Param(*args):
    return _fastjet.JetDefinition2Param(*args)
JetDefinition2Param = _fastjet.JetDefinition2Param
class FunctionOfPseudoJetDouble(_object):
    """


    base class providing interface for a generic function of a PseudoJet  

    This class serves as a base class to provide a standard interface for a function
    that returns an object of a given (templated) type that depends on a PseudoJet
    argument. The rationale for using a class (rather than a pointer to a function)
    is that a class can be constructed with (and store) additional arguments.  

    C++ includes: fastjet/FunctionOfPseudoJet.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionOfPseudoJetDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionOfPseudoJetDouble, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _fastjet.delete_FunctionOfPseudoJetDouble
    __del__ = lambda self: None

    def description(self):
        """

        `description() const -> std::string`  

        returns a description of the function (an empty string by default)  

        """
        return _fastjet.FunctionOfPseudoJetDouble_description(self)


    def result(self, pj):
        """

        `result(const PseudoJet &pj) const =0 -> TOut`  

        the action of the function this *has* to be overloaded in derived classes  

        Parameters
        ----------
        * `pj` :  
            the PseudoJet input to the function  

        """
        return _fastjet.FunctionOfPseudoJetDouble_result(self, pj)


    def __call__(self, *args):
        return _fastjet.FunctionOfPseudoJetDouble___call__(self, *args)

    def __str__(self):
        return _fastjet.FunctionOfPseudoJetDouble___str__(self)
FunctionOfPseudoJetDouble_swigregister = _fastjet.FunctionOfPseudoJetDouble_swigregister
FunctionOfPseudoJetDouble_swigregister(FunctionOfPseudoJetDouble)

class FunctionOfPseudoJetPseudoJet(_object):
    """


    base class providing interface for a generic function of a PseudoJet  

    This class serves as a base class to provide a standard interface for a function
    that returns an object of a given (templated) type that depends on a PseudoJet
    argument. The rationale for using a class (rather than a pointer to a function)
    is that a class can be constructed with (and store) additional arguments.  

    C++ includes: fastjet/FunctionOfPseudoJet.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionOfPseudoJetPseudoJet, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionOfPseudoJetPseudoJet, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _fastjet.delete_FunctionOfPseudoJetPseudoJet
    __del__ = lambda self: None

    def description(self):
        """

        `description() const -> std::string`  

        returns a description of the function (an empty string by default)  

        """
        return _fastjet.FunctionOfPseudoJetPseudoJet_description(self)


    def result(self, pj):
        """

        `result(const PseudoJet &pj) const =0 -> TOut`  

        the action of the function this *has* to be overloaded in derived classes  

        Parameters
        ----------
        * `pj` :  
            the PseudoJet input to the function  

        """
        return _fastjet.FunctionOfPseudoJetPseudoJet_result(self, pj)


    def __call__(self, *args):
        return _fastjet.FunctionOfPseudoJetPseudoJet___call__(self, *args)

    def __str__(self):
        return _fastjet.FunctionOfPseudoJetPseudoJet___str__(self)
FunctionOfPseudoJetPseudoJet_swigregister = _fastjet.FunctionOfPseudoJetPseudoJet_swigregister
FunctionOfPseudoJetPseudoJet_swigregister(FunctionOfPseudoJetPseudoJet)

class Transformer(FunctionOfPseudoJetPseudoJet):
    """


    Base (abstract) class for a jet transformer.  

    A transformer, when it acts on a jet, returns a modified version of that jet,
    one that may have a different momentum and/or different internal structure.  

    The typical usage of a class derived from Transformer is  

    For many transformers, the transformed jets have transformer-specific
    information that can be accessed through the  


    See the description of the Filter class for a more detailed usage example. See
    the FastJet manual to find out how to implement new transformers.  

    C++ includes: fastjet/tools/Transformer.hh

    """

    __swig_setmethods__ = {}
    for _s in [FunctionOfPseudoJetPseudoJet]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Transformer, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionOfPseudoJetPseudoJet]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Transformer, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _fastjet.delete_Transformer
    __del__ = lambda self: None

    def result(self, original):
        """

        `result(const PseudoJet &original) const =0 -> PseudoJet`  

        the result of the Transformer acting on the PseudoJet.  

        this *has* to be overloaded in derived classes  

        Parameters
        ----------
        * `original` :  
            the PseudoJet input to the Transformer  

        """
        return _fastjet.Transformer_result(self, original)


    def description(self):
        """

        `description() const =0 -> std::string`  

        This should be overloaded to return a description of the Transformer.  

        """
        return _fastjet.Transformer_description(self)

Transformer_swigregister = _fastjet.Transformer_swigregister
Transformer_swigregister(Transformer)

class Boost(FunctionOfPseudoJetPseudoJet):
    """


    Class to boost a PseudoJet.  

    This is a FunctionOfPseudoJet with return type PseudoJet. Its action if to boost
    the PseudoJet by a boost vector passed to its constructor  

    C++ includes: fastjet/tools/Boost.hh

    """

    __swig_setmethods__ = {}
    for _s in [FunctionOfPseudoJetPseudoJet]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Boost, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionOfPseudoJetPseudoJet]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Boost, name)
    __repr__ = _swig_repr

    def __init__(self, jet_rest):
        """

        `Boost(const PseudoJet &jet_rest)`  

        default ctor  

        """
        this = _fastjet.new_Boost(jet_rest)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def result(self, original):
        """

        `result(const PseudoJet &original) const -> PseudoJet`  

        the action of the function: boost the PseudoJet by a boost vector _jet_rest  

        """
        return _fastjet.Boost_result(self, original)


    def __str__(self):
        return _fastjet.Boost___str__(self)
    __swig_destroy__ = _fastjet.delete_Boost
    __del__ = lambda self: None
Boost_swigregister = _fastjet.Boost_swigregister
Boost_swigregister(Boost)

class Unboost(FunctionOfPseudoJetPseudoJet):
    """


    Class to un-boost a PseudoJet.  

    This is a FunctionOfPseudoJet with return type PseudoJet. Its action if to un-
    boost the PseudoJet back in the restframe of the PseudoJet passed to its
    constructor  

    C++ includes: fastjet/tools/Boost.hh

    """

    __swig_setmethods__ = {}
    for _s in [FunctionOfPseudoJetPseudoJet]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Unboost, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionOfPseudoJetPseudoJet]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Unboost, name)
    __repr__ = _swig_repr

    def __init__(self, jet_rest):
        """

        `Unboost(const PseudoJet &jet_rest)`  

        default ctor  

        """
        this = _fastjet.new_Unboost(jet_rest)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def result(self, original):
        """

        `result(const PseudoJet &original) const -> PseudoJet`  

        the action of the function: boost the PseudoJet to the rest frame of _jet_rest  

        """
        return _fastjet.Unboost_result(self, original)


    def __str__(self):
        return _fastjet.Unboost___str__(self)
    __swig_destroy__ = _fastjet.delete_Unboost
    __del__ = lambda self: None
Unboost_swigregister = _fastjet.Unboost_swigregister
Unboost_swigregister(Unboost)

class Recluster(FunctionOfPseudoJetPseudoJet):
    """


    Recluster a jet's constituents with a new jet definition.  

    When Recluster is constructed from a JetDefinition, it is that definition that
    will be used to obtain the new jets. The user may then decide if the recombiner
    should be the one from that jet definition or if it should be acquired from the
    jet being processed (the default).  

    Alternatively, Recluster can be constructed from a jet algorithm and an optional
    radius. In that case the recombiner is systematically obtained from the jet
    being processed (unless you call set_acquire_recombiner(false)). If only the jet
    algorithm is specified, a default radius of max_allowable_R will be assumed if
    needed.  

    Recluster has two possible behaviours:  

    *   if it is constructed with keep=keep_only_hardest the hardest inclusive jet
        is returned as a "standard" jet with an associated cluster sequence
        (unless there were no inclusive jets, in which case a zero jet is returned,
        with no associated cluster sequence)  
    *   if it is constructed with keep=keep_all all the inclusive jets are joined
        into a composite jet  

    [Note that since the structure of the resulting PseudoJet depends on its usage,
    this class inherits from FunctionOfPseudoJet<PseudoJet> (including a
    description) rather than being a full-fledged Transformer]  

    C++ includes: fastjet/tools/Recluster.hh

    """

    __swig_setmethods__ = {}
    for _s in [FunctionOfPseudoJetPseudoJet]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Recluster, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionOfPseudoJetPseudoJet]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Recluster, name)
    __repr__ = _swig_repr
    keep_only_hardest = _fastjet.Recluster_keep_only_hardest
    keep_all = _fastjet.Recluster_keep_all

    def __init__(self, *args):
        """

        `Recluster(JetAlgorithm new_jet_alg, Keep keep_in=keep_only_hardest)`  

        constructor with just a jet algorithm, but no jet radius.  

        If the algorithm requires a jet radius, JetDefinition::max_allowable_R will be
        used.  

        """
        this = _fastjet.new_Recluster(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_Recluster
    __del__ = lambda self: None

    def set_acquire_recombiner(self, acquire):
        """

        `set_acquire_recombiner(bool acquire)`  

        set whether the reclustering should attempt to acquire a recombiner from the
        input jet  

        """
        return _fastjet.Recluster_set_acquire_recombiner(self, acquire)


    def acquire_recombiner(self):
        """

        `acquire_recombiner() const -> bool`  

        returns true if this reclusterer is set to acquire the recombiner from the input
        jet  

        """
        return _fastjet.Recluster_acquire_recombiner(self)


    def set_cambridge_optimisation(self, enabled):
        """

        `set_cambridge_optimisation(bool enabled)`  

        sets whether to try to optimise reclustering with Cambridge/Aachen algorithms
        (by not reclustering if the requested C/A reclustering can be obtained by using
        subjets of an input C/A jet or one composed of multiple C/A pieces from the same
        clustering sequence).  

        By default this is enabled, and *should* always be correct; disable it to test
        this statement!  

        """
        return _fastjet.Recluster_set_cambridge_optimisation(self, enabled)


    def set_cambridge_optimization(self, enabled):
        """

        `set_cambridge_optimization(bool enabled)`  

        sets whether to try to optimise reclustering with Cambridge/Aachen algorithms
        (US spelling!)  

        """
        return _fastjet.Recluster_set_cambridge_optimization(self, enabled)


    def cambridge_optimization(self):
        """

        `cambridge_optimization() -> bool`  

        returns true if the reclusterer tries to optimise reclustering with
        Cambridge/Aachen algorithms  

        """
        return _fastjet.Recluster_cambridge_optimization(self)


    def cambridge_optimisation(self):
        """

        `cambridge_optimisation() -> bool`  

        """
        return _fastjet.Recluster_cambridge_optimisation(self)


    def set_keep(self, keep_in):
        """

        `set_keep(Keep keep_in)`  

        set the behaviour with regards to keeping all resulting jets or just the
        hardest.  

        """
        return _fastjet.Recluster_set_keep(self, keep_in)


    def keep(self):
        """

        `keep() const -> Keep`  

        returns the current "keep" mode i.e.  

        whether only the hardest inclusive jet is returned or all of them (see the Keep
        enum above)  

        """
        return _fastjet.Recluster_keep(self)


    def description(self):
        """

        `description() const -> std::string`  

        class description  

        """
        return _fastjet.Recluster_description(self)


    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> PseudoJet`  

        runs the reclustering and sets kept and rejected to be the jets of interest
        (with non-zero rho, they will have been subtracted).  

        Normally this will be accessed through the base class's operator().  

        Parameters
        ----------
        * `jet` :  
            the jet that gets reclustered  

        Returns
        -------
        the reclustered jet  

        """
        return _fastjet.Recluster_result(self, jet)


    def get_new_jets_and_def(self, input_jet, output_jets):
        """

        `get_new_jets_and_def(const PseudoJet &input_jet, std::vector< PseudoJet >
            &output_jets) const -> bool`  

        A lower-level method that does the actual work of reclustering the input jet.  

        The resulting jets are stored in output_jets. The jet definition that has been
        used can be accessed from the output_jets' ClusterSequence.  

        Parameters
        ----------
        * `input_jet` :  
            the (input) jet that one wants to recluster  
        * `output_jets` :  
            inclusive jets resulting from the new clustering  

        Returns true if the C/A optimisation has been used (this means that
        generate_output_jet then has to watch out for non-explicit-ghost areas that
        might be leftover)  

        """
        return _fastjet.Recluster_get_new_jets_and_def(self, input_jet, output_jets)


    def generate_output_jet(self, incljets, ca_optimisation_used):
        """

        `generate_output_jet(std::vector< PseudoJet > &incljets, bool
            ca_optimisation_used) const -> PseudoJet`  

        given a set of inclusive jets and a jet definition used, create the resulting
        PseudoJet;  

        If ca_optimisation_used then special care will be taken in deciding whether the
        final jet can legitimately have an area.  

        """
        return _fastjet.Recluster_generate_output_jet(self, incljets, ca_optimisation_used)


    def __str__(self):
        return _fastjet.Recluster___str__(self)
Recluster_swigregister = _fastjet.Recluster_swigregister
Recluster_swigregister(Recluster)

class Filter(Transformer):
    """


    Class that helps perform filtering (Butterworth, Davison, Rubin and Salam,
    arXiv:0802.2470) and trimming (Krohn, Thaler and Wang, arXiv:0912.1342) on jets,
    optionally in conjunction with subtraction (Cacciari and Salam,
    arXiv:0707.1378).  

    For example, to apply filtering that reclusters a jet's constituents with the
    Cambridge/Aachen jet algorithm with R=0.3 and then selects the 3 hardest
    subjets, one can use the following code:  

    To obtain trimming, involving for example the selection of all subjets carrying
    at least 3% of the original jet's pt, the selector would be replaced by
    SelectorPtFractionMin(0.03).  

    To additionally perform subtraction on the subjets prior to selection, either
    include a 3rd argument specifying the background density rho, or call the
    set_subtractor(...) member function. If subtraction is requested, the original
    jet must be the result of a clustering with active area with explicit ghosts
    support or a merging of such pieces.  

    The information on the subjets that were kept and rejected can be obtained
    using:  
    Implementation Note
    If the original jet was defined with the Cambridge/Aachen algorithm (or is made
    of pieces each of which comes from the C/A alg) and the filtering definition is
    C/A, then the filter does not rerun the C/A algorithm on the constituents, but
    instead makes use of the existent C/A cluster sequence in the original jet. This
    increases the speed of the filter.  

    See also 11 - use of filtering for a further usage example.  

    Support for areas, reuse of C/A cluster sequences, etc., considerably
    complicates the implementation of Filter. For an explanation of how a simpler
    filter might be coded, see the "User-defined transformers" appendix of the
    manual.  

    C++ includes: fastjet/tools/Filter.hh

    """

    __swig_setmethods__ = {}
    for _s in [Transformer]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Filter, name, value)
    __swig_getmethods__ = {}
    for _s in [Transformer]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Filter, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `Filter(FunctionOfPseudoJet< double > *Rfilt_func, Selector selector, double
            rho=0.0)`  

        Same as the full constructor (see above) but just specifying a filtering radius
        that will depend on the jet being filtered As for the previous case, Cambridge-
        Aachen is used If the jet (or all its pieces) is obtained with a non-default
        recombiner, that one will be used.  

        Parameters
        ----------
        * `Rfilt_func` :  
            the filtering radius function of a PseudoJet  

        """
        this = _fastjet.new_Filter(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_Filter
    __del__ = lambda self: None

    def set_subtractor(self, subtractor_in):
        """

        `set_subtractor(const FunctionOfPseudoJet< PseudoJet > *subtractor_in)`  

        Set a subtractor that is applied to all individual subjets before deciding which
        ones to keep.  

        It takes precedence over a non-zero rho.  

        """
        return _fastjet.Filter_set_subtractor(self, subtractor_in)


    def subtractor(self):
        """

        `subtractor() const -> const FunctionOfPseudoJet< PseudoJet > *`  

        Set a subtractor that is applied to all individual subjets before deciding which
        ones to keep.  

        It takes precedence over a non-zero rho.  

        """
        return _fastjet.Filter_subtractor(self)


    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> PseudoJet`  

        runs the filtering and sets kept and rejected to be the jets of interest (with
        non-zero rho, they will have been subtracted).  

        Parameters
        ----------
        * `jet` :  
            the jet that gets filtered  

        Returns
        -------
        the filtered jet  

        """
        return _fastjet.Filter_result(self, jet)


    def description(self):
        """

        `description() const -> std::string`  

        class description  

        """
        return _fastjet.Filter_description(self)


    def __str__(self):
        return _fastjet.Filter___str__(self)
Filter_swigregister = _fastjet.Filter_swigregister
Filter_swigregister(Filter)

class FilterStructure(CompositeJetStructure):
    """


    Class to contain structure information for a filtered jet.  

    C++ includes: fastjet/tools/Filter.hh

    """

    __swig_setmethods__ = {}
    for _s in [CompositeJetStructure]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FilterStructure, name, value)
    __swig_getmethods__ = {}
    for _s in [CompositeJetStructure]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FilterStructure, name)
    __repr__ = _swig_repr

    def __init__(self, pieces_in, rec=None):
        """

        `FilterStructure(const std::vector< PseudoJet > &pieces_in, const
            JetDefinition::Recombiner *rec=0)`  

        constructor from an original ClusterSequenceInfo We just share the original
        ClusterSequenceWrapper and initialise the rest  

        """
        this = _fastjet.new_FilterStructure(pieces_in, rec)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_FilterStructure
    __del__ = lambda self: None

    def description(self):
        """

        `description() const -> std::string`  

        description  

        """
        return _fastjet.FilterStructure_description(self)


    def rejected(self):
        """

        `rejected() const -> const std::vector< PseudoJet > &`  

        returns the subjets that were not kept during the filtering procedure
        (subtracted if the filter requests it, and valid in the original cs)  

        """
        return _fastjet.FilterStructure_rejected(self)

FilterStructure_swigregister = _fastjet.FilterStructure_swigregister
FilterStructure_swigregister(FilterStructure)

class Pruner(Transformer):
    """


    Transformer that prunes a jet.  

    This transformer prunes a jet according to the ideas presented in
    arXiv:0903.5081 (S.D. Ellis, C.K. Vermilion and J.R. Walsh).  

    The jet's constituents are reclustered with a user-specified jet definition,
    with the modification that objects i and j are only recombined if at least one
    of the following two criteria is satisfied:  

    *   the geometric distance between i and j is smaller than 'Rcut' with Rcut =
        Rcut_factor*2m/pt (Rcut_factor is a parameter of the Pruner and m and pt
        obtained from the jet being pruned)  
    *   the transverse momenta of i and j are at least 'zcut' p_t(i+j)  

    If both these criteria fail, i and j are not recombined, the harder of i and j
    is kept, and the softer is rejected.  

    Usage:  

    The pruned_jet has a valid associated cluster sequence. In addition the subjets
    of the original jet that have been vetoed by pruning (i.e. have been 'pruned
    away') can be accessed using  


    If the re-clustering happens to find more than a single inclusive jet (this
    should normally not happen if the radius of the jet definition used for the
    reclustering was set large enough), the hardest of these jets is retured as the
    result of the Pruner. The other jets can be accessed through  


    Instead of using Rcut_factor and zcut, one can alternatively construct a Pruner
    by passing two (pointers to) functions of PseudoJet that dynamically compute the
    Rcut and zcut to be used for the jet being pruned.  

    When the jet being pruned has area support and explicit ghosts, the resulting
    pruned jet will likewise have area.  

    C++ includes: fastjet/tools/Pruner.hh

    """

    __swig_setmethods__ = {}
    for _s in [Transformer]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Pruner, name, value)
    __swig_getmethods__ = {}
    for _s in [Transformer]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Pruner, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `Pruner(const JetDefinition &jet_def, const FunctionOfPseudoJet< double >
            *zcut_dyn, const FunctionOfPseudoJet< double > *Rcut_dyn)`  

        alternative ctor in which the pt-fraction cut and angular distance cut are
        functions of the jet being pruned.  

        Parameters
        ----------
        * `jet_def` :  
            the jet definition for the internal clustering  
        * `zcut_dyn` :  
            dynamic pt-fraction cut in the pruning  
        * `Rcut_dyn` :  
            dynamic angular distance cut in the pruning  

        """
        this = _fastjet.new_Pruner(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> PseudoJet`  

        action on a single jet  

        """
        return _fastjet.Pruner_result(self, jet)


    def description(self):
        """

        `description() const -> std::string`  

        description  

        """
        return _fastjet.Pruner_description(self)


    def __str__(self):
        return _fastjet.Pruner___str__(self)
    __swig_destroy__ = _fastjet.delete_Pruner
    __del__ = lambda self: None
Pruner_swigregister = _fastjet.Pruner_swigregister
Pruner_swigregister(Pruner)

class PrunerStructure(_object):
    """


    The structure associated with a PseudoJet thas has gone through a Pruner
    transformer.  

    C++ includes: fastjet/tools/Pruner.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PrunerStructure, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PrunerStructure, name)
    __repr__ = _swig_repr

    def __init__(self, result_jet):
        """

        `PrunerStructure(const PseudoJet &result_jet)`  

        default ctor  

        Parameters
        ----------
        * `result_jet` :  
            the jet for which we have to keep the structure  

        """
        this = _fastjet.new_PrunerStructure(result_jet)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def description(self):
        """

        `description() const -> std::string`  

        description  

        """
        return _fastjet.PrunerStructure_description(self)


    def rejected(self):
        """

        `rejected() const -> std::vector< PseudoJet >`  

        return the constituents that have been rejected  

        """
        return _fastjet.PrunerStructure_rejected(self)


    def extra_jets(self):
        """

        `extra_jets() const -> std::vector< PseudoJet >`  

        return the other jets that may have been found along with the result of the
        pruning The resulting vector is sorted in pt  

        """
        return _fastjet.PrunerStructure_extra_jets(self)


    def Rcut(self):
        """

        `Rcut() const -> double`  

        return the value of Rcut that was used for this specific pruning.  

        """
        return _fastjet.PrunerStructure_Rcut(self)


    def zcut(self):
        """

        `zcut() const -> double`  

        return the value of Rcut that was used for this specific pruning.  

        """
        return _fastjet.PrunerStructure_zcut(self)

    __swig_destroy__ = _fastjet.delete_PrunerStructure
    __del__ = lambda self: None
PrunerStructure_swigregister = _fastjet.PrunerStructure_swigregister
PrunerStructure_swigregister(PrunerStructure)

class PruningRecombiner(_object):
    """


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PruningRecombiner, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PruningRecombiner, name)
    __repr__ = _swig_repr

    def __init__(self, zcut, Rcut, recombiner):
        """

        `PruningRecombiner(double zcut, double Rcut, const JetDefinition::Recombiner
            *recombiner)`  

        ctor  

        Parameters
        ----------
        * `zcut` :  
            transverse momentum fraction cut  
        * `Rcut` :  
            angular separation cut  
        * `recomb` :  
            pointer to a recombiner to use to cluster pairs  

        """
        this = _fastjet.new_PruningRecombiner(zcut, Rcut, recombiner)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def recombine(self, pa, pb, pab):
        """

        `recombine(const PseudoJet &pa, const PseudoJet &pb, PseudoJet &pab) const`  

        perform a recombination taking into account the pruning conditions  

        """
        return _fastjet.PruningRecombiner_recombine(self, pa, pb, pab)


    def description(self):
        """

        `description() const -> std::string`  

        returns the description of the recombiner  

        """
        return _fastjet.PruningRecombiner_description(self)


    def rejected(self):
        """

        `rejected() const -> const std::vector< unsigned int > &`  

        return the history indices that have been pruned away  

        """
        return _fastjet.PruningRecombiner_rejected(self)


    def clear_rejected(self):
        """

        `clear_rejected()`  

        clears the list of rejected indices  

        If one decides to use this recombiner standalone, one has to call this after
        each clustering in order for the rejected() vector to remain sensible and not
        grow to infinite size.  

        """
        return _fastjet.PruningRecombiner_clear_rejected(self)

    __swig_destroy__ = _fastjet.delete_PruningRecombiner
    __del__ = lambda self: None
PruningRecombiner_swigregister = _fastjet.PruningRecombiner_swigregister
PruningRecombiner_swigregister(PruningRecombiner)

class PruningPlugin(_object):
    """


    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PruningPlugin, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PruningPlugin, name)
    __repr__ = _swig_repr

    def __init__(self, jet_def, zcut, Rcut):
        """

        `PruningPlugin(const JetDefinition &jet_def, double zcut, double Rcut)`  

        ctor  

        Parameters
        ----------
        * `jet_def` :  
            the jet definition to be used for the internal clustering  
        * `zcut` :  
            transverse momentum fraction cut  
        * `Rcut` :  
            angular separation cut  

        """
        this = _fastjet.new_PruningPlugin(jet_def, zcut, Rcut)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def run_clustering(self, input_cs):
        """

        `run_clustering(ClusterSequence &input_cs) const`  

        the actual clustering work for the plugin  

        """
        return _fastjet.PruningPlugin_run_clustering(self, input_cs)


    def description(self):
        """

        `description() const -> std::string`  

        description of the plugin  

        """
        return _fastjet.PruningPlugin_description(self)


    def R(self):
        """

        `R() const -> double`  

        returns the radius  

        """
        return _fastjet.PruningPlugin_R(self)

    __swig_destroy__ = _fastjet.delete_PruningPlugin
    __del__ = lambda self: None
PruningPlugin_swigregister = _fastjet.PruningPlugin_swigregister
PruningPlugin_swigregister(PruningPlugin)

class CASubJetTagger(Transformer):
    """


    clean (almost parameter-free) tagger searching for the element in the clustering
    history that maximises a chosen distance  

    class to help us get a clean (almost parameter-free) handle on substructure
    inside a C/A jet. It follows the logic described in arXiv:0906.0728 (and is
    inspired by the original Cambridge algorithm paper in its use of separate
    angular and dimensionful distances), but provides some extra flexibility.  

    It searches for all splittings that pass a symmetry cut (zcut) and then selects
    the one with the largest auxiliary scale choice (e.g. jade distance of the
    splitting, kt distance of the splitting, etc.)  

    By default, the zcut is calculated from the fraction of the child pt carried by
    the parent jet. If one calls set_absolute_z_cut the fraction of transverse
    momentum will be computed wrt the original jet.  

    original code copyright (C) 2009 by Gavin Salam, released under the GPL.  
    Options
    *   the distance choice: options are kt2_distance : usual
        min(kti^2,ktj^2)DeltaR_{ij}^2 jade_distance : kti . ktj DeltaR_{ij}^2 (LI
        version of jade) jade2_distance : kti . ktj DeltaR_{ij}^4 (LI version of
        jade * DR^2) plain_distance : DeltaR_{ij}^2 mass_drop_distance : m_jet -
        max(m_parent1,m_parent2) dot_product_distance: parent1.parent2 (kt2_distance
        by default)  
    *   the z cut (0 by default)  
    *   by calling set_absolute_z_cut(), one can ask that the pt fraction if
        calculated wrt the original jet  
    *   by calling set_dr_min(drmin), one can ask that only the recombinations where
        the 2 objects are (geometrically) distant by at least drmin are kept in the
        maximisation.  
    Input conditions
    *   the jet must have been obtained from a Cambridge/Aachen cluster sequence  
    Output/structure
    *   the element of the cluster sequence maximising the requested distance (and
        satisfying the zcut) is returned.  
    *   if the original jet has no parents, it will be returned  
    *   the value of the "z" and distance corresponding to that history element
        are stored and accessible through result.structure_of<CASubJetTagger>().z();
        result.structure_of<CASubJetTagger>().distance();  

    C++ includes: fastjet/tools/CASubJetTagger.hh

    """

    __swig_setmethods__ = {}
    for _s in [Transformer]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CASubJetTagger, name, value)
    __swig_getmethods__ = {}
    for _s in [Transformer]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CASubJetTagger, name)
    __repr__ = _swig_repr
    kt2_distance = _fastjet.CASubJetTagger_kt2_distance
    jade_distance = _fastjet.CASubJetTagger_jade_distance
    jade2_distance = _fastjet.CASubJetTagger_jade2_distance
    plain_distance = _fastjet.CASubJetTagger_plain_distance
    mass_drop_distance = _fastjet.CASubJetTagger_mass_drop_distance
    dot_product_distance = _fastjet.CASubJetTagger_dot_product_distance

    def __init__(self, *args):
        """

        `CASubJetTagger(ScaleChoice scale_choice=jade_distance, double z_threshold=0.1)`  

        just constructs  

        """
        this = _fastjet.new_CASubJetTagger(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def set_dr_min(self, drmin):
        """

        `set_dr_min(double drmin)`  

        sets a minimum delta R below which spliting will be ignored (only relevant if
        set prior to calling run())  

        """
        return _fastjet.CASubJetTagger_set_dr_min(self, drmin)


    def description(self):
        """

        `description() const -> std::string`  

        returns a textual description of the tagger  

        """
        return _fastjet.CASubJetTagger_description(self)


    def set_absolute_z_cut(self, abs_z_cut=True):
        """

        `set_absolute_z_cut(bool abs_z_cut=true)`  

        If (abs_z_cut) is set to false (the default) then for a splitting to be
        considered, each subjet must satisfy.  

        p_{t,sub} > z_threshold * p_{t,parent}  

        whereas if it is set to true, then each subject must satisfy  

               p_{t,sub} > z_threshold * p_{t,original-jet}  

        where parent is the immediate parent of the splitting, and original jet is the
        one supplied to the run() function.  

        Only relevant is called prior to run().  

        """
        return _fastjet.CASubJetTagger_set_absolute_z_cut(self, abs_z_cut)


    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> PseudoJet`  

        runs the tagger on the given jet and returns the tagged PseudoJet if successful,
        or a PseudoJet==0 otherwise (standard access is through operator()).  

        """
        return _fastjet.CASubJetTagger_result(self, jet)


    def __str__(self):
        return _fastjet.CASubJetTagger___str__(self)
    __swig_destroy__ = _fastjet.delete_CASubJetTagger
    __del__ = lambda self: None
CASubJetTagger_swigregister = _fastjet.CASubJetTagger_swigregister
CASubJetTagger_swigregister(CASubJetTagger)

class CASubJetTaggerStructure(_object):
    """


    the structure returned by a CASubJetTagger  

    Since this is directly an element of the ClusterSequence, we keep basically the
    original ClusterSequenceStructure (wrapped for memory-management reasons) and
    add information about the pt fraction and distance of the subjet structure  

    C++ includes: fastjet/tools/CASubJetTagger.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CASubJetTaggerStructure, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CASubJetTaggerStructure, name)
    __repr__ = _swig_repr

    def __init__(self, result_jet):
        """

        `CASubJetTaggerStructure(const PseudoJet &result_jet)`  

        default ctor  

        Parameters
        ----------
        * `result_jet` :  
            the jet for which we have to keep the structure  

        """
        this = _fastjet.new_CASubJetTaggerStructure(result_jet)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def scale_choice(self):
        """

        `scale_choice() const -> CASubJetTagger::ScaleChoice`  

        returns the scale choice asked for the maximisation  

        """
        return _fastjet.CASubJetTaggerStructure_scale_choice(self)


    def distance(self):
        """

        `distance() const -> double`  

        returns the value of the distance measure (corresponding to ScaleChoice) for
        this jet's splitting  

        """
        return _fastjet.CASubJetTaggerStructure_distance(self)


    def z(self):
        """

        `z() const -> double`  

        returns the pt fraction contained by the softer of the two component pieces of
        this jet (normalised relative to this jet)  

        """
        return _fastjet.CASubJetTaggerStructure_z(self)


    def absolute_z(self):
        """

        `absolute_z() const -> bool`  

        returns the pt fraction contained by the softer of the two component pieces of
        this jet (normalised relative to the original jet)  

        """
        return _fastjet.CASubJetTaggerStructure_absolute_z(self)

    __swig_destroy__ = _fastjet.delete_CASubJetTaggerStructure
    __del__ = lambda self: None
CASubJetTaggerStructure_swigregister = _fastjet.CASubJetTaggerStructure_swigregister
CASubJetTaggerStructure_swigregister(CASubJetTaggerStructure)

class MassDropTagger(Transformer):
    """


    Class that helps perform 2-pronged boosted tagging using the "mass-drop"
    technique (with asymmetry cut) introduced by Jonathan Butterworth, Adam Davison,
    Mathieu Rubin and Gavin Salam in arXiv:0802.2470 in the context of a boosted
    Higgs search.  

    The tagger proceeds as follows:  

    0. start from a jet obtained from with the Cambridge/Aachen algorithm  

    1.  undo the last step of the clustering step j -> j1 + j2 (label them such as
        j1 is the most massive).  
    2.  if there is a mass drop, i.e. m_j1/m_j < mu_cut, and the splitting is
        sufficiently symmetric, ${\rm min}(p_{tj1}^2,p_{tj2}^2)\Delta R_{j1,j2}^2
        > y_{\rm cut} m_j^2$, keep j as the result of the tagger (with j1 and j2
        its 2 subjets)  
    3.  otherwise, redefine j to be equal to j1 and return to step 1.  

    Note that in the original proposal, j1 and j2 are both required to be b-tagged
    and a filter (with Rfilt=min(0.3,Rbb/2) and n_filt=3) is also applied to j to
    obtain the final "Higgs candidate". See the example 12 - boosted Higgs tagging
    for details.  
    Options
    The constructor has the following arguments:  

    *   The first argument is the minimal mass drop that is required (mu_cut) [0.67
        by default]  
    *   The second argument is the asymmetry cut (y_cut) [0.09 by default]  
    Input conditions
    *   one must be able to successively "uncluster" the original jet using
        "has_parents"  
    Output/structure
    *   the 2 subjets are kept as pieces if some substructure is found, otherwise a
        single 0-momentum piece is returned  
    *   the 'mu' and 'y' values corresponding to the unclustering step that passed
        the tagger's cuts  

    See also 12 - boosted Higgs tagging for a usage example.  

    C++ includes: fastjet/tools/MassDropTagger.hh

    """

    __swig_setmethods__ = {}
    for _s in [Transformer]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MassDropTagger, name, value)
    __swig_getmethods__ = {}
    for _s in [Transformer]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MassDropTagger, name)
    __repr__ = _swig_repr

    def __init__(self, mu=0.67, ycut=0.09):
        """

        `MassDropTagger(const double mu=0.67, const double ycut=0.09)`  

        default ctor  

        """
        this = _fastjet.new_MassDropTagger(mu, ycut)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def description(self):
        """

        `description() const -> std::string`  

        returns a textual description of the tagger  

        """
        return _fastjet.MassDropTagger_description(self)


    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> PseudoJet`  

        runs the tagger on the given jet and returns the tagged PseudoJet if successful,
        a PseudoJet==0 otherwise (standard access is through operator()).  

        Parameters
        ----------
        * `jet` :  
            the PseudoJet to tag  

        """
        return _fastjet.MassDropTagger_result(self, jet)


    def __str__(self):
        return _fastjet.MassDropTagger___str__(self)
    __swig_destroy__ = _fastjet.delete_MassDropTagger
    __del__ = lambda self: None
MassDropTagger_swigregister = _fastjet.MassDropTagger_swigregister
MassDropTagger_swigregister(MassDropTagger)

class MassDropTaggerStructure(_object):
    """


    the structure returned by the MassDropTagger transformer.  

    See the MassDropTagger class description for the details of what is inside this
    structure  

    C++ includes: fastjet/tools/MassDropTagger.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MassDropTaggerStructure, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MassDropTaggerStructure, name)
    __repr__ = _swig_repr

    def __init__(self, result_jet):
        """

        `MassDropTaggerStructure(const PseudoJet &result_jet)`  

        ctor with initialisation  

        Parameters
        ----------
        * `pieces` :  
            the pieces of the created jet  
        * `rec` :  
            the recombiner from the underlying cluster sequence  

        """
        this = _fastjet.new_MassDropTaggerStructure(result_jet)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def mu(self):
        """

        `mu() const -> double`  

        returns the mass-drop ratio, pieces[0].m()/jet.m(), for the splitting that
        triggered the mass-drop condition  

        """
        return _fastjet.MassDropTaggerStructure_mu(self)


    def y(self):
        """

        `y() const -> double`  

        returns the value of y = (squared kt distance) / (squared mass) for the
        splitting that triggered the mass-drop condition  

        """
        return _fastjet.MassDropTaggerStructure_y(self)

    __swig_destroy__ = _fastjet.delete_MassDropTaggerStructure
    __del__ = lambda self: None
MassDropTaggerStructure_swigregister = _fastjet.MassDropTaggerStructure_swigregister
MassDropTaggerStructure_swigregister(MassDropTaggerStructure)

class RestFrameNSubjettinessTagger(Transformer):
    """


    Class that helps perform 2-pronged boosted tagging using a reclustering in the
    jet's rest frame, supplemented with a cut on N-subjettiness (and a decay angle),
    as discussed by Ji-Hun Kim in arXiv:1011.1493.  

    To tag a fat jet, the tagger proceeds as follows:  

    *   boost its constituents into the rest frame of the jet  
    *   recluster them using another jet definition (the original choice was SISCone
        in spherical coordinates with R=0.6 and f=0.75.  
    *   keep the 2 most energetic subjets ( $q_{1,2}$) and compute the
        2-subjettiness \[ \tau_2^j = \frac{2}{m_{\rm jet}^2}\, \sum_{k\in
        {\rm jet}} {\rm min}(q_1.p_k,q_2.p_k) \] where the sum runs over the
        constituents of the jet.  
    *   require $\tau_2^j < \tau_2^{\rm cut}$ [0.08 by default]  
    *   impose that (in the rest frame of the fat jet), the angles between the 2
        most energetic subjets and the boost axis are both large enough:
        $\cos(\theta_s)<c_\theta^{\rm cut}$ [0.8 by default]  

    Note that in the original version, the jets to be tagged were reconstructed
    using SISCone with R=0.8 and f=0.75. Also, b-tagging was imposed on the 2
    subjets found in the rest-frame tagging procedure.  
    Options
    The constructor has the following arguments:  

    *   The first argument is the jet definition to be used to recluster the
        constituents of the jet to be filtered (in the rest frame of the tagged
        jet).  
    *   The second argument is the cut on tau_2 [0.08 by default]  
    *   The 3rd argument is the cut on cos(theta_s) [0.8 by default]  
    *   If the 4th argument is true, 2 exclusive rest-frame jets will be considered
        in place of the 2 most energetic inclusive jets  
    Input conditions
    *   the original jet must have constituents  
    Output/structure
    *   the 2 subjets are kept as pieces if some substructure is found, otherwise a
        single 0-momentum piece  
    *   the tau2 and maximal cos(theta_s) values computed during the tagging can be
        obtained via the resulting jet's structure_of<...>() function  

    C++ includes: fastjet/tools/RestFrameNSubjettinessTagger.hh

    """

    __swig_setmethods__ = {}
    for _s in [Transformer]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RestFrameNSubjettinessTagger, name, value)
    __swig_getmethods__ = {}
    for _s in [Transformer]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RestFrameNSubjettinessTagger, name)
    __repr__ = _swig_repr

    def __init__(self, subjet_def, tau2cut=0.08, costhetascut=0.8, use_exclusive=False):
        """

        `RestFrameNSubjettinessTagger(const JetDefinition subjet_def, const double
            tau2cut=0.08, const double costhetascut=0.8, const bool
            use_exclusive=false)`  

        ctor with arguments (see the class description above)  

        """
        this = _fastjet.new_RestFrameNSubjettinessTagger(subjet_def, tau2cut, costhetascut, use_exclusive)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def description(self):
        """

        `description() const -> std::string`  

        returns a textual description of the tagger  

        """
        return _fastjet.RestFrameNSubjettinessTagger_description(self)


    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> PseudoJet`  

        runs the tagger on the given jet and returns the tagged PseudoJet if successful,
        a PseudoJet==0 otherwise (standard access is through operator()).  

        impose the cut on cos(theta_s)  

        """
        return _fastjet.RestFrameNSubjettinessTagger_result(self, jet)


    def __str__(self):
        return _fastjet.RestFrameNSubjettinessTagger___str__(self)
    __swig_destroy__ = _fastjet.delete_RestFrameNSubjettinessTagger
    __del__ = lambda self: None
RestFrameNSubjettinessTagger_swigregister = _fastjet.RestFrameNSubjettinessTagger_swigregister
RestFrameNSubjettinessTagger_swigregister(RestFrameNSubjettinessTagger)

class RestFrameNSubjettinessTaggerStructure(CompositeJetStructure):
    """


    the structure returned by the RestFrameNSubjettinessTagger transformer.  

    See the RestFrameNSubjettinessTagger class description for the details of what
    is inside this structure  

    C++ includes: fastjet/tools/RestFrameNSubjettinessTagger.hh

    """

    __swig_setmethods__ = {}
    for _s in [CompositeJetStructure]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RestFrameNSubjettinessTaggerStructure, name, value)
    __swig_getmethods__ = {}
    for _s in [CompositeJetStructure]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RestFrameNSubjettinessTaggerStructure, name)
    __repr__ = _swig_repr

    def __init__(self, pieces_in):
        """

        `RestFrameNSubjettinessTaggerStructure(const std::vector< PseudoJet >
            &pieces_in)`  

        ctor with pieces initialisation  

        """
        this = _fastjet.new_RestFrameNSubjettinessTaggerStructure(pieces_in)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def tau2(self):
        """

        `tau2() const -> double`  

        returns the associated N-subjettiness  

        """
        return _fastjet.RestFrameNSubjettinessTaggerStructure_tau2(self)


    def costhetas(self):
        """

        `costhetas() const -> double`  

        returns the associated angle with the boosted axis  

        """
        return _fastjet.RestFrameNSubjettinessTaggerStructure_costhetas(self)

    __swig_destroy__ = _fastjet.delete_RestFrameNSubjettinessTaggerStructure
    __del__ = lambda self: None
RestFrameNSubjettinessTaggerStructure_swigregister = _fastjet.RestFrameNSubjettinessTaggerStructure_swigregister
RestFrameNSubjettinessTaggerStructure_swigregister(RestFrameNSubjettinessTaggerStructure)

class TopTaggerBase(Transformer):
    """


    A base class that provides a common interface for top taggers that are able to
    return a W (in addition to the top itself).  

    Top taggers that derive from this should satisfy the following criteria:  

    *   their underlying structure should derive from TopTaggerBaseStructure  
    *   tagged tops should have two pieces, the first of which is the W candidate  
    *   they should apply the top and W selectors to decide if the top has been
        tagged  

    C++ includes: fastjet/tools/TopTaggerBase.hh

    """

    __swig_setmethods__ = {}
    for _s in [Transformer]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TopTaggerBase, name, value)
    __swig_getmethods__ = {}
    for _s in [Transformer]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TopTaggerBase, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def set_top_selector(self, sel):
        """

        `set_top_selector(const Selector &sel)`  

        sets the selector that is applied to the top candidate  

        """
        return _fastjet.TopTaggerBase_set_top_selector(self, sel)


    def set_W_selector(self, sel):
        """

        `set_W_selector(const Selector &sel)`  

        sets the selector that is applied to the W candidate  

        """
        return _fastjet.TopTaggerBase_set_W_selector(self, sel)


    def description_of_selectors(self):
        """

        `description_of_selectors() const -> std::string`  

        returns a description of the top and W selectors  

        """
        return _fastjet.TopTaggerBase_description_of_selectors(self)

    __swig_destroy__ = _fastjet.delete_TopTaggerBase
    __del__ = lambda self: None
TopTaggerBase_swigregister = _fastjet.TopTaggerBase_swigregister
TopTaggerBase_swigregister(TopTaggerBase)

class TopTaggerBaseStructure(_object):
    """


    class that specifies the structure common to all top taggers  

    Note that this specifies only the W, non_W part of the interface. An actual top
    tagger structure class will also need to derive from a PseudoJetStructureBase
    type class (e.g. CompositeJetStructure)  

    C++ includes: fastjet/tools/TopTaggerBase.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TopTaggerBaseStructure, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TopTaggerBaseStructure, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def W(self):
        """

        `W() const =0 -> const PseudoJet &`  

        """
        return _fastjet.TopTaggerBaseStructure_W(self)


    def non_W(self):
        """

        `non_W() const =0 -> const PseudoJet &`  

        """
        return _fastjet.TopTaggerBaseStructure_non_W(self)

    __swig_destroy__ = _fastjet.delete_TopTaggerBaseStructure
    __del__ = lambda self: None
TopTaggerBaseStructure_swigregister = _fastjet.TopTaggerBaseStructure_swigregister
TopTaggerBaseStructure_swigregister(TopTaggerBaseStructure)

class JHTopTagger(TopTaggerBase):
    """


    Class that helps perform boosted top tagging using the "Johns Hopkins" method
    from arXiv:0806.0848 (Kaplan, Rehermann, Schwartz and Tweedie)  

    The tagger proceeds as follows:  

    *   start from a jet J obtained with the Cambridge/Aachen algorithm  
    *   undo the last iteration j -> j_1,j_2 (with pt_1>pt_2) until the two subjets
        satisfy pt_1 > delta_p pt_J (with pt_J the pt of the original jet) and |y_1
        - y_2| + |phi_1 - phi_2| > delta_r.  
    *   if one of these criteria is not satisfied, carry on the procedure with j_1
        (discarding j_2)  
    *   for each of the subjets found, repeat the procedure. If some new
        substructure is found, keep these 2 new subjets, otherwise keep the original
        subjet (found during the first iteration)  
    *   at this stage, one has at most 4 subjets. If one has less than 3, the tagger
        has failed.  
    *   reconstruct the W from the 2 subjets with a mass closest to the W mass  
    *   impose that the W helicity angle be less than a threshold cos_theta_W_max.  
    Input conditions
    *   the original jet must have an associated (and valid) ClusterSequence  
    *   the tagger is designed to work with jets formed by the Cambridge/Aachen
        (C/A) algorithm; if a non-C/A jet is passed to the tagger, a warning will be
        issued  
    Example
    A JHTopTagger can be used as follows:  


    The full set of information available from the structure_of<JHTopTagger>() call
    is  

    *   PseudoJet W() : the W subjet of the top candidate  
    *   PseudoJet non_W(): non-W subjet(s) of the top candidate (i.e. the b)  
    *   double cos_theta_W(): the W helicity angle  
    *   PseudoJet W1(): the harder of the two prongs of the W  
    *   PseudoJet W2(): the softer of the two prongs of the W  

    The structure of the top_candidate can also be accessed through its pieces()
    function:  

    *   top_candidate.pieces()[0]: W  
    *   top_candidate.pieces()[1]: non_W  

    The W itself has two pieces (corresponding to W1, W2).  

    The existence of the first two of the structural calls (W(), non_W()) and the
    fact that the top is made of two pieces (W, non_W) are features that should be
    common to all taggers derived from TopTaggerBase.  

    See also 13 - boosted top tagging for a full usage example.  

    C++ includes: fastjet/tools/JHTopTagger.hh

    """

    __swig_setmethods__ = {}
    for _s in [TopTaggerBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, JHTopTagger, name, value)
    __swig_getmethods__ = {}
    for _s in [TopTaggerBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, JHTopTagger, name)
    __repr__ = _swig_repr

    def __init__(self, delta_p=0.10, delta_r=0.19, cos_theta_W_max=0.7, mW=80.4):
        """

        `JHTopTagger(const double delta_p=0.10, const double delta_r=0.19, double
            cos_theta_W_max=0.7, double mW=80.4)`  

        default ctor The parameters are the following:  

        Parameters
        ----------
        * `delta_p` :  
            fractional pt cut imposed on the subjets (computed as a fraction of the
            original jet)  
        * `delta_r` :  
            minimal distance between 2 subjets (computed as |y1-y2|+|phi1-phi2|)  
        * `cos_theta_W_max` :  
            the maximal value for the polarisation angle of the W  
        * `mW` :  
            the W mass  

        The default values of all these parameters are taken from arXiv:0806:0848  

        """
        this = _fastjet.new_JHTopTagger(delta_p, delta_r, cos_theta_W_max, mW)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def description(self):
        """

        `description() const -> std::string`  

        returns a textual description of the tagger  

        """
        return _fastjet.JHTopTagger_description(self)


    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> PseudoJet`  

        runs the tagger on the given jet and returns the tagged PseudoJet if successful,
        or a PseudoJet==0 otherwise (standard access is through operator()).  

        Parameters
        ----------
        * `jet` :  
            the PseudoJet to tag  

        """
        return _fastjet.JHTopTagger_result(self, jet)


    def __str__(self):
        return _fastjet.JHTopTagger___str__(self)
    __swig_destroy__ = _fastjet.delete_JHTopTagger
    __del__ = lambda self: None
JHTopTagger_swigregister = _fastjet.JHTopTagger_swigregister
JHTopTagger_swigregister(JHTopTagger)

class JHTopTaggerStructure(CompositeJetStructure, TopTaggerBaseStructure):
    """


    the structure returned by the JHTopTagger transformer.  

    See the JHTopTagger class description for the details of what is inside this
    structure  

    C++ includes: fastjet/tools/JHTopTagger.hh

    """

    __swig_setmethods__ = {}
    for _s in [CompositeJetStructure, TopTaggerBaseStructure]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, JHTopTaggerStructure, name, value)
    __swig_getmethods__ = {}
    for _s in [CompositeJetStructure, TopTaggerBaseStructure]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, JHTopTaggerStructure, name)
    __repr__ = _swig_repr

    def __init__(self, pieces_in, recombiner=None):
        """

        `JHTopTaggerStructure(std::vector< PseudoJet > pieces_in, const
            JetDefinition::Recombiner *recombiner=0)`  

        ctor with pieces initialisation  

        """
        this = _fastjet.new_JHTopTaggerStructure(pieces_in, recombiner)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def W(self):
        """

        `W() const -> const PseudoJet &`  

        returns the W subjet  

        """
        return _fastjet.JHTopTaggerStructure_W(self)


    def W1(self):
        """

        `W1() const -> PseudoJet`  

        returns the first W subjet (the harder)  

        """
        return _fastjet.JHTopTaggerStructure_W1(self)


    def W2(self):
        """

        `W2() const -> PseudoJet`  

        returns the second W subjet  

        """
        return _fastjet.JHTopTaggerStructure_W2(self)


    def non_W(self):
        """

        `non_W() const -> const PseudoJet &`  

        returns the non-W subjet It will have 1 or 2 pieces depending on whether the
        tagger has found 3 or 4 pieces  

        """
        return _fastjet.JHTopTaggerStructure_non_W(self)


    def cos_theta_W(self):
        """

        `cos_theta_W() const -> double`  

        returns the W helicity angle  

        """
        return _fastjet.JHTopTaggerStructure_cos_theta_W(self)

    __swig_destroy__ = _fastjet.delete_JHTopTaggerStructure
    __del__ = lambda self: None
JHTopTaggerStructure_swigregister = _fastjet.JHTopTaggerStructure_swigregister
JHTopTaggerStructure_swigregister(JHTopTaggerStructure)

class BackgroundEstimatorBase(_object):
    """


    Abstract base class that provides the basic interface for classes that estimate
    levels of background radiation in hadron and heavy-ion collider events.  

    C++ includes: fastjet/tools/BackgroundEstimatorBase.hh

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BackgroundEstimatorBase, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BackgroundEstimatorBase, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _fastjet.delete_BackgroundEstimatorBase
    __del__ = lambda self: None

    def set_particles(self, particles):
        """

        `set_particles(const std::vector< PseudoJet > &particles)=0`  

        tell the background estimator that it has a new event, composed of the specified
        particles.  

        """
        return _fastjet.BackgroundEstimatorBase_set_particles(self, particles)


    def rho(self, *args):
        """

        `rho(const PseudoJet &jet)=0 -> double`  

        get rho, the background density per unit area, locally at the position of a
        given jet.  

        Note that this is not const, because a user may then wish to query other aspects
        of the background that could depend on the position of the jet last used for a
        rho(jet) determination.  

        """
        return _fastjet.BackgroundEstimatorBase_rho(self, *args)


    def sigma(self, *args):
        """

        `sigma(const PseudoJet &) -> double`  

        get sigma, the background fluctuations per unit area, locally at the position of
        a given jet.  

        As for rho(jet), it is non-const.  

        """
        return _fastjet.BackgroundEstimatorBase_sigma(self, *args)


    def has_sigma(self):
        """

        `has_sigma() -> bool`  

        returns true if this background estimator has support for determination of sigma  

        """
        return _fastjet.BackgroundEstimatorBase_has_sigma(self)


    def rho_m(self, *args):
        """

        `rho_m(const PseudoJet &) -> double`  

        Returns rho_m locally at the jet position. As for rho(jet), it is non-const.  

        """
        return _fastjet.BackgroundEstimatorBase_rho_m(self, *args)


    def sigma_m(self, *args):
        """

        `sigma_m(const PseudoJet &) -> double`  

        Returns sigma_m locally at the jet position. As for rho(jet), it is non-const.  

        """
        return _fastjet.BackgroundEstimatorBase_sigma_m(self, *args)


    def has_rho_m(self):
        """

        `has_rho_m() const -> bool`  

        Returns true if this background estimator has support for determination of
        rho_m.  

        Note that support for sigma_m is automatic is one has sigma and rho_m support.  

        """
        return _fastjet.BackgroundEstimatorBase_has_rho_m(self)


    def set_rescaling_class(self, rescaling_class_in):
        """

        `set_rescaling_class(const FunctionOfPseudoJet< double > *rescaling_class_in)`  

        Set a pointer to a class that calculates the rescaling factor as a function of
        the jet (position).  

        Note that the rescaling factor is used both in the determination of the
        "global" rho (the pt/A of each jet is divided by this factor) and when asking
        for a local rho (the result is multiplied by this factor).  

        The BackgroundRescalingYPolynomial class can be used to get a rescaling that
        depends just on rapidity.  

        There is currently no support for different rescaling classes for rho and rho_m
        determinations.  

        """
        return _fastjet.BackgroundEstimatorBase_set_rescaling_class(self, rescaling_class_in)


    def rescaling_class(self):
        """

        `rescaling_class() const -> const FunctionOfPseudoJet< double > *`  

        return the pointer to the jet density class  

        """
        return _fastjet.BackgroundEstimatorBase_rescaling_class(self)


    def description(self):
        """

        `description() const =0 -> std::string`  

        returns a textual description of the background estimator  

        """
        return _fastjet.BackgroundEstimatorBase_description(self)

BackgroundEstimatorBase_swigregister = _fastjet.BackgroundEstimatorBase_swigregister
BackgroundEstimatorBase_swigregister(BackgroundEstimatorBase)

class BackgroundRescalingYPolynomial(FunctionOfPseudoJetDouble):
    """


    A background rescaling that is a simple polynomial in y.  

    C++ includes: fastjet/tools/BackgroundEstimatorBase.hh

    """

    __swig_setmethods__ = {}
    for _s in [FunctionOfPseudoJetDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BackgroundRescalingYPolynomial, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionOfPseudoJetDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BackgroundRescalingYPolynomial, name)
    __repr__ = _swig_repr

    def __init__(self, a0=1, a1=0, a2=0, a3=0, a4=0):
        """

        `BackgroundRescalingYPolynomial(double a0=1, double a1=0, double a2=0, double
            a3=0, double a4=0)`  

        construct a background rescaling polynomial of the form a0 + a1*y + a2*y^2 +
        a3*y^3 + a4*y^4  

        The following values give a reasonable reproduction of the Pythia8 tune 4C
        background shape for pp collisions at sqrt(s)=7TeV:  

        *   a0 = 1.157  
        *   a1 = 0  
        *   a2 = -0.0266  
        *   a3 = 0  
        *   a4 = 0.000048  

        """
        this = _fastjet.new_BackgroundRescalingYPolynomial(a0, a1, a2, a3, a4)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> double`  

        return the rescaling factor associated with this jet  

        """
        return _fastjet.BackgroundRescalingYPolynomial_result(self, jet)

    __swig_destroy__ = _fastjet.delete_BackgroundRescalingYPolynomial
    __del__ = lambda self: None
BackgroundRescalingYPolynomial_swigregister = _fastjet.BackgroundRescalingYPolynomial_swigregister
BackgroundRescalingYPolynomial_swigregister(BackgroundRescalingYPolynomial)

class JetMedianBackgroundEstimator(BackgroundEstimatorBase):
    """


    Class to estimate the pt density of the background per unit area, using the
    median of the distribution of pt/area from jets that pass some selection
    criterion.  

    Events are passed either in the form of the event particles (in which they're
    clustered by the class), a ClusterSequenceArea (in which case the jets used are
    those returned by "inclusive_jets()") or directly as a set of jets.  

    The selection criterion is typically a geometrical one (e.g. all jets with
    |y|<2) sometimes supplemented with some kinematical restriction (e.g. exclusion
    of the two hardest jets). It is passed to the class through a Selector.  

    Beware: by default, to correctly handle partially empty events, the class
    attempts to calculate an "empty area", based (schematically) on  

           range.total_area() - sum_{jets_in_range} jets.area()  

    For ranges with small areas, this can be inaccurate (particularly relevant in
    dense events where empty_area should be zero and ends up not being zero).  

    This calculation of empty area can be avoided if a ClusterSequenceArea class
    with explicit ghosts (ActiveAreaExplicitGhosts) is used. This is *recommended*
    unless speed requirements cause you to use Voronoi areas. For speedy background
    estimation you could also consider using GridMedianBackgroundEstimator.  

    C++ includes: fastjet/tools/JetMedianBackgroundEstimator.hh

    """

    __swig_setmethods__ = {}
    for _s in [BackgroundEstimatorBase]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, JetMedianBackgroundEstimator, name, value)
    __swig_getmethods__ = {}
    for _s in [BackgroundEstimatorBase]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, JetMedianBackgroundEstimator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `JetMedianBackgroundEstimator(const Selector &rho_range=SelectorIdentity())`  

        Default constructor that optionally sets the rho range.  

        The configuration must be done later calling set_cluster_sequence(...) or
        set_jets(...).  

        Parameters
        ----------
        * `rho_range` :  
            the Selector specifying which jets will be considered  

        """
        this = _fastjet.new_JetMedianBackgroundEstimator(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_JetMedianBackgroundEstimator
    __del__ = lambda self: None

    def set_particles(self, particles):
        """

        `set_particles(const std::vector< PseudoJet > &particles)`  

        tell the background estimator that it has a new event, composed of the specified
        particles.  

        """
        return _fastjet.JetMedianBackgroundEstimator_set_particles(self, particles)


    def set_cluster_sequence(self, csa):
        """

        `set_cluster_sequence(const ClusterSequenceAreaBase &csa)`  

        (re)set the cluster sequence (with area support) to be used by future calls to
        rho() etc.  

        Parameters
        ----------
        * `csa` :  
            the cluster sequence area  

        Pre-conditions:  

        *   one should be able to estimate the "empty area" (i.e. the area not
            occupied by jets). This is feasible if at least one of the following
            conditions is satisfied: ( i) the ClusterSequence has explicit ghosts (ii)
            the range selected has a computable area.  
        *   the jet algorithm must be suited for median computation (otherwise a warning
            will be issues)  

        Note that selectors with e.g. hardest-jets exclusion do not have a well-defined
        area. For this reasons, it is STRONGLY advised to use an area with explicit
        ghosts.  

        """
        return _fastjet.JetMedianBackgroundEstimator_set_cluster_sequence(self, csa)


    def set_jets(self, jets):
        """

        `set_jets(const std::vector< PseudoJet > &jets)`  

        (re)set the jets (which must have area support) to be used by future calls to
        rho() etc.  

        ; for the conditions that must be satisfied by the jets, see the Constructor
        that takes jets.  

        """
        return _fastjet.JetMedianBackgroundEstimator_set_jets(self, jets)


    def set_selector(self, rho_range_selector):
        """

        `set_selector(const Selector &rho_range_selector)`  

        (re)set the selector to be used for future calls to rho() etc.  

        """
        return _fastjet.JetMedianBackgroundEstimator_set_selector(self, rho_range_selector)


    def set_compute_rho_m(self, enable):
        """

        `set_compute_rho_m(bool enable)`  

        determine whether the automatic calculation of rho_m and sigma_m is enabled (by
        default true)  

        """
        return _fastjet.JetMedianBackgroundEstimator_set_compute_rho_m(self, enable)


    def rho(self, *args):
        """

        `rho(const PseudoJet &jet) -> double`  

        get rho, the median background density per unit area, locally at the position of
        a given jet.  

        If the Selector associated with the range takes a reference jet (i.e. is
        relocatable), then for subsequent operations the Selector has that jet set as
        its reference.  

        """
        return _fastjet.JetMedianBackgroundEstimator_rho(self, *args)


    def sigma(self, *args):
        """

        `sigma(const PseudoJet &jet) -> double`  

        get sigma, the background fluctuations per unit area, locally at the position of
        a given jet.  

        If the Selector associated with the range takes a reference jet (i.e. is
        relocatable), then for subsequent operations the Selector has that jet set as
        its reference.  

        """
        return _fastjet.JetMedianBackgroundEstimator_sigma(self, *args)


    def has_sigma(self):
        """

        `has_sigma() -> bool`  

        returns true if this background estimator has support for determination of sigma  

        """
        return _fastjet.JetMedianBackgroundEstimator_has_sigma(self)


    def rho_m(self, *args):
        """

        `rho_m(const PseudoJet &) -> double`  

        Returns rho_m locally at the jet position. As for rho(jet), it is non-const.  

        """
        return _fastjet.JetMedianBackgroundEstimator_rho_m(self, *args)


    def sigma_m(self, *args):
        """

        `sigma_m(const PseudoJet &) -> double`  

        Returns sigma_m locally at the jet position. As for rho(jet), it is non-const.  

        """
        return _fastjet.JetMedianBackgroundEstimator_sigma_m(self, *args)


    def has_rho_m(self):
        """

        `has_rho_m() const -> bool`  

        Returns true if this background estimator has support for determination of
        rho_m.  

        In te presence of a density class, support for rho_m is automatically disabled  

        Note that support for sigma_m is automatic is one has sigma and rho_m support.  

        """
        return _fastjet.JetMedianBackgroundEstimator_has_rho_m(self)


    def mean_area(self):
        """

        `mean_area() const -> double`  

        Returns the mean area of the jets used to actually compute the background
        properties in the last call of rho() or sigma() If the configuration has changed
        in the meantime, throw an error.  

        """
        return _fastjet.JetMedianBackgroundEstimator_mean_area(self)


    def n_jets_used(self):
        """

        `n_jets_used() const -> unsigned int`  

        returns the number of jets used to actually compute the background properties in
        the last call of rho() or sigma() If the configuration has changed in the
        meantime, throw an error.  

        """
        return _fastjet.JetMedianBackgroundEstimator_n_jets_used(self)


    def jets_used(self):
        """

        `jets_used() const -> std::vector< PseudoJet >`  

        returns the jets used to actually compute the background properties  

        """
        return _fastjet.JetMedianBackgroundEstimator_jets_used(self)


    def empty_area(self):
        """

        `empty_area() const -> double`  

        Returns the estimate of the area (within the range defined by the selector) that
        is not occupied by jets.  

        The value is that for the last call of rho() or sigma() If the configuration has
        changed in the meantime, throw an error.  

        The answer is defined to be zero if the area calculation involved explicit
        ghosts; if the area calculation was an active area, then use is made of the
        active area's internal list of pure ghost jets (taking those that pass the
        selector); otherwise it is based on the difference between the selector's total
        area and the area of the jets that pass the selector.  

        The result here is just the cached result of the corresponding call to the
        ClusterSequenceAreaBase function.  

        """
        return _fastjet.JetMedianBackgroundEstimator_empty_area(self)


    def n_empty_jets(self):
        """

        `n_empty_jets() const -> double`  

        Returns the number of empty jets used when computing the background properties.  

        The value is that for the last call of rho() or sigma(). If the configuration
        has changed in the meantime, throw an error.  

        If the area has explicit ghosts the result is zero; for active areas it is the
        number of internal pure ghost jets that pass the selector; otherwise it is
        deduced from the empty area, divided by $ 0.55 \pi R^2 $ (the average pure-
        ghost-jet area).  

        The result here is just the cached result of the corresponding call to the
        ClusterSequenceAreaBase function.  

        """
        return _fastjet.JetMedianBackgroundEstimator_n_empty_jets(self)


    def reset(self):
        """

        `reset()`  

        Resets the class to its default state, including the choice to use 4-vector
        areas.  

        """
        return _fastjet.JetMedianBackgroundEstimator_reset(self)


    def set_use_area_4vector(self, use_it=True):
        """

        `set_use_area_4vector(bool use_it=true)`  

        By default when calculating pt/Area for a jet, it is the transverse component of
        the 4-vector area that is used in the ratiof $p_t/A$.  

        Calling this function with a "false" argument causes the scalar area to be
        used instead.  

        While the difference between the two choices is usually small, for high-
        precision work it is usually the 4-vector area that is to be preferred.  

        Parameters
        ----------
        * `use_it` :  
            whether one uses the 4-vector area or not (true by default)  

        """
        return _fastjet.JetMedianBackgroundEstimator_set_use_area_4vector(self, use_it)


    def use_area_4vector(self):
        """

        `use_area_4vector() const -> bool`  

        check if the estimator uses the 4-vector area or the scalar area  

        """
        return _fastjet.JetMedianBackgroundEstimator_use_area_4vector(self)


    def set_provide_fj2_sigma(self, provide_fj2_sigma=True):
        """

        `set_provide_fj2_sigma(bool provide_fj2_sigma=true)`  

        The FastJet v2.X sigma calculation had a small spurious offset in the limit of a
        small number of jets.  

        This is fixed by default in versions 3 upwards. The old behaviour can be
        obtained with a call to this function.  

        """
        return _fastjet.JetMedianBackgroundEstimator_set_provide_fj2_sigma(self, provide_fj2_sigma)


    def set_jet_density_class(self, jet_density_class):
        """

        `set_jet_density_class(const FunctionOfPseudoJet< double > *jet_density_class)`  

        Set a pointer to a class that calculates the quantity whose median will be
        calculated; if the pointer is null then pt/area is used (as occurs also if this
        function is not called).  

        Note that this is still *preliminary* in FastJet 3.0 and that backward
        compatibility is not guaranteed in future releases of FastJet  

        """
        return _fastjet.JetMedianBackgroundEstimator_set_jet_density_class(self, jet_density_class)


    def jet_density_class(self):
        """

        `jet_density_class() const -> const FunctionOfPseudoJet< double > *`  

        return the pointer to the jet density class  

        """
        return _fastjet.JetMedianBackgroundEstimator_jet_density_class(self)


    def set_rescaling_class(self, rescaling_class_in):
        """

        `set_rescaling_class(const FunctionOfPseudoJet< double > *rescaling_class_in)`  

        Set a pointer to a class that calculates the rescaling factor as a function of
        the jet (position).  

        Note that the rescaling factor is used both in the determination of the
        "global" rho (the pt/A of each jet is divided by this factor) and when asking
        for a local rho (the result is multiplied by this factor).  

        The BackgroundRescalingYPolynomial class can be used to get a rescaling that
        depends just on rapidity.  

        """
        return _fastjet.JetMedianBackgroundEstimator_set_rescaling_class(self, rescaling_class_in)


    def description(self):
        """

        `description() const -> std::string`  

        returns a textual description of the background estimator  

        """
        return _fastjet.JetMedianBackgroundEstimator_description(self)

JetMedianBackgroundEstimator_swigregister = _fastjet.JetMedianBackgroundEstimator_swigregister
JetMedianBackgroundEstimator_swigregister(JetMedianBackgroundEstimator)

class BackgroundJetPtDensity(FunctionOfPseudoJetDouble):
    """


    Class that implements pt/area_4vector.perp() for background estimation *(this is
    a preliminary class)*.  

    C++ includes: fastjet/tools/JetMedianBackgroundEstimator.hh

    """

    __swig_setmethods__ = {}
    for _s in [FunctionOfPseudoJetDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BackgroundJetPtDensity, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionOfPseudoJetDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BackgroundJetPtDensity, name)
    __repr__ = _swig_repr

    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> double`  

        the action of the function this *has* to be overloaded in derived classes  

        Parameters
        ----------
        * `pj` :  
            the PseudoJet input to the function  

        """
        return _fastjet.BackgroundJetPtDensity_result(self, jet)


    def description(self):
        """

        `description() const -> std::string`  

        returns a description of the function (an empty string by default)  

        """
        return _fastjet.BackgroundJetPtDensity_description(self)


    def __init__(self):
        this = _fastjet.new_BackgroundJetPtDensity()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_BackgroundJetPtDensity
    __del__ = lambda self: None
BackgroundJetPtDensity_swigregister = _fastjet.BackgroundJetPtDensity_swigregister
BackgroundJetPtDensity_swigregister(BackgroundJetPtDensity)

class BackgroundJetScalarPtDensity(FunctionOfPseudoJetDouble):
    """


    Class that implements (scalar pt sum of jet)/(scalar area of jet) for background
    estimation *(this is a preliminary class)*.  

    Optionally it can return a quantity based on the sum of pt^n, e.g. for use in
    subtracting fragementation function moments.  

    C++ includes: fastjet/tools/JetMedianBackgroundEstimator.hh

    """

    __swig_setmethods__ = {}
    for _s in [FunctionOfPseudoJetDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BackgroundJetScalarPtDensity, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionOfPseudoJetDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BackgroundJetScalarPtDensity, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `BackgroundJetScalarPtDensity(double n)`  

        Constructor to provide background estimation based on $ sum_{i\in jet}
        p_{ti}^{n} $.  

        """
        this = _fastjet.new_BackgroundJetScalarPtDensity(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> double`  

        the action of the function this *has* to be overloaded in derived classes  

        Parameters
        ----------
        * `pj` :  
            the PseudoJet input to the function  

        """
        return _fastjet.BackgroundJetScalarPtDensity_result(self, jet)


    def description(self):
        """

        `description() const -> std::string`  

        returns a description of the function (an empty string by default)  

        """
        return _fastjet.BackgroundJetScalarPtDensity_description(self)

    __swig_destroy__ = _fastjet.delete_BackgroundJetScalarPtDensity
    __del__ = lambda self: None
BackgroundJetScalarPtDensity_swigregister = _fastjet.BackgroundJetScalarPtDensity_swigregister
BackgroundJetScalarPtDensity_swigregister(BackgroundJetScalarPtDensity)

class BackgroundJetPtMDensity(FunctionOfPseudoJetDouble):
    """


    Class that implements $ \frac{1}{A} \sum_{i \in jet} (\sqrt{p_{ti}^2+m^2} -
    p_{ti}) $ for background estimation *(this is a preliminary class)*.  

    This is useful for correcting jet masses in cases where the event involves
    massive particles.  

    C++ includes: fastjet/tools/JetMedianBackgroundEstimator.hh

    """

    __swig_setmethods__ = {}
    for _s in [FunctionOfPseudoJetDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BackgroundJetPtMDensity, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionOfPseudoJetDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BackgroundJetPtMDensity, name)
    __repr__ = _swig_repr

    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> double`  

        the action of the function this *has* to be overloaded in derived classes  

        Parameters
        ----------
        * `pj` :  
            the PseudoJet input to the function  

        """
        return _fastjet.BackgroundJetPtMDensity_result(self, jet)


    def description(self):
        """

        `description() const -> std::string`  

        returns a description of the function (an empty string by default)  

        """
        return _fastjet.BackgroundJetPtMDensity_description(self)


    def __init__(self):
        this = _fastjet.new_BackgroundJetPtMDensity()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_BackgroundJetPtMDensity
    __del__ = lambda self: None
BackgroundJetPtMDensity_swigregister = _fastjet.BackgroundJetPtMDensity_swigregister
BackgroundJetPtMDensity_swigregister(BackgroundJetPtMDensity)

class GridMedianBackgroundEstimator(BackgroundEstimatorBase, RectangularGrid):
    """


    Background Estimator based on the median pt/area of a set of grid cells.  

    Description of the method: This background estimator works by projecting the
    event onto a grid in rapidity and azimuth. In each grid cell, the scalar pt sum
    of the particles in the cell is computed. The background density is then
    estimated by the median of (scalar pt sum/cell area) for all cells.  

    Parameters: The class takes 2 arguments: the absolute rapidity extent of the
    cells and the size of the grid cells. Note that the size of the cell will be
    adjusted in azimuth to satisfy the 2pi periodicity and in rapidity to match the
    requested rapidity extent.  

    Rescaling: It is possible to use a rescaling profile. In this case, the profile
    needs to be set before setting the particles and it will be applied to each
    particle (i.e. not to each cell). Note also that in this case one needs to call
    rho(jet) instead of rho() [Without rescaling, they are identical]  

    C++ includes: fastjet/tools/GridMedianBackgroundEstimator.hh

    """

    __swig_setmethods__ = {}
    for _s in [BackgroundEstimatorBase, RectangularGrid]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GridMedianBackgroundEstimator, name, value)
    __swig_getmethods__ = {}
    for _s in [BackgroundEstimatorBase, RectangularGrid]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GridMedianBackgroundEstimator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `GridMedianBackgroundEstimator(double rapmin_in, double rapmax_in, double
            drap_in, double dphi_in, Selector tile_selector=Selector())`  

        Constructor with the explicit parameters for the underlying RectangularGrid.  

        Parameters
        ----------
        * `rapmin` :  
            the minimum rapidity extent of the grid  
        * `rapmax` :  
            the maximum rapidity extent of the grid  
        * `drap` :  
            the grid spacing in rapidity  
        * `dphi` :  
            the grid spacing in azimuth  
        * `tile_selector` :  
            optional (geometric) selector to specify which tiles are good; a tile is
            good if a massless 4-vector at the center of the tile passes the selection  

        """
        this = _fastjet.new_GridMedianBackgroundEstimator(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def set_particles(self, particles):
        """

        `set_particles(const std::vector< PseudoJet > &particles)`  

        tell the background estimator that it has a new event, composed of the specified
        particles.  

        """
        return _fastjet.GridMedianBackgroundEstimator_set_particles(self, particles)


    def set_compute_rho_m(self, enable):
        """

        `set_compute_rho_m(bool enable)`  

        determine whether the automatic calculation of rho_m and sigma_m is enabled (by
        default true)  

        """
        return _fastjet.GridMedianBackgroundEstimator_set_compute_rho_m(self, enable)


    def rho(self, *args):
        """

        `rho(const PseudoJet &jet) -> double`  

        returns rho, the background density per unit area, locally at the position of a
        given jet.  

        Note that this is not const, because a user may then wish to query other aspects
        of the background that could depend on the position of the jet last used for a
        rho(jet) determination.  

        """
        return _fastjet.GridMedianBackgroundEstimator_rho(self, *args)


    def sigma(self, *args):
        """

        `sigma(const PseudoJet &jet) -> double`  

        returns sigma, the background fluctuations per unit area, locally at the
        position of a given jet.  

        As for rho(jet), it is non-const.  

        """
        return _fastjet.GridMedianBackgroundEstimator_sigma(self, *args)


    def has_sigma(self):
        """

        `has_sigma() -> bool`  

        returns true if this background estimator has support for determination of sigma  

        """
        return _fastjet.GridMedianBackgroundEstimator_has_sigma(self)


    def rho_m(self, *args):
        """

        `rho_m(const PseudoJet &jet) -> double`  

        Returns rho_m locally at the jet position. As for rho(jet), it is non-const.  

        """
        return _fastjet.GridMedianBackgroundEstimator_rho_m(self, *args)


    def sigma_m(self, *args):
        """

        `sigma_m(const PseudoJet &jet) -> double`  

        Returns sigma_m locally at the jet position. As for rho(jet), it is non-const.  

        """
        return _fastjet.GridMedianBackgroundEstimator_sigma_m(self, *args)


    def has_rho_m(self):
        """

        `has_rho_m() const -> bool`  

        Returns true if this background estimator has support for determination of
        rho_m.  

        Note that support for sigma_m is automatic if one has sigma and rho_m support.  

        """
        return _fastjet.GridMedianBackgroundEstimator_has_rho_m(self)


    def mean_area(self):
        """

        `mean_area() const -> double`  

        returns the area of the grid cells (all identical, but referred to as "mean"
        area for uniformity with JetMedianBGE).  

        """
        return _fastjet.GridMedianBackgroundEstimator_mean_area(self)


    def set_rescaling_class(self, rescaling_class):
        """

        `set_rescaling_class(const FunctionOfPseudoJet< double > *rescaling_class)`  

        Set a pointer to a class that calculates the rescaling factor as a function of
        the jet (position).  

        Note that the rescaling factor is used both in the determination of the
        "global" rho (the pt/A of each jet is divided by this factor) and when asking
        for a local rho (the result is multiplied by this factor).  

        The BackgroundRescalingYPolynomial class can be used to get a rescaling that
        depends just on rapidity.  

        Note that this has to be called BEFORE any attempt to do an actual computation  

        The same profile will be used for both pt and mt (this is probabaly a good
        approximation since the particle density changes is what dominates the rapidity
        profile)  

        """
        return _fastjet.GridMedianBackgroundEstimator_set_rescaling_class(self, rescaling_class)


    def description(self):
        """

        `description() const -> std::string`  

        returns a textual description of the background estimator  

        """
        return _fastjet.GridMedianBackgroundEstimator_description(self)

    __swig_destroy__ = _fastjet.delete_GridMedianBackgroundEstimator
    __del__ = lambda self: None
GridMedianBackgroundEstimator_swigregister = _fastjet.GridMedianBackgroundEstimator_swigregister
GridMedianBackgroundEstimator_swigregister(GridMedianBackgroundEstimator)

class Subtractor(Transformer):
    """


    Class that helps perform jet background subtraction.  

    This class derives from Transformer and makes use of a pointer to a
    BackgroundEstimatorBase object in order to determine the background in the
    vicinity of a given jet and then subtract area*background from the jet. It can
    also be initialised with a specific fixed value for the background pt density.  
    Input conditions
    The original jet must have area support (4-vector)  
    Output/structure
    The underlying structure of the returned, subtracted jet (i.e. constituents,
    pieces, etc.) is identical to that of the original jet.  

    C++ includes: fastjet/tools/Subtractor.hh

    """

    __swig_setmethods__ = {}
    for _s in [Transformer]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Subtractor, name, value)
    __swig_getmethods__ = {}
    for _s in [Transformer]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Subtractor, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        `Subtractor()`  

        default constructor  

        """
        this = _fastjet.new_Subtractor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fastjet.delete_Subtractor
    __del__ = lambda self: None

    def set_defaults(self):
        """

        `set_defaults()`  

        reset all parameters to default values  

        Note: by default, the rho_m term is not included and the safety test for the
        mass is not done. This is mostly for backwards compatibility with FastJet 3.0
        and is highly likely to change in a future release of FastJet  

        """
        return _fastjet.Subtractor_set_defaults(self)


    def set_use_rho_m(self, use_rho_m_in=True):
        """

        `set_use_rho_m(bool use_rho_m_in=true)`  

        when 'use_rho_m' is true, include in the subtraction the correction from rho_m,
        the purely longitudinal, particle-mass-induced component of the background
        density per unit area  

        Note: this will be switched off by default (for backwards compatibility with
        FastJet 3.0) but is highly likely to change in a future release of FastJet  

        """
        return _fastjet.Subtractor_set_use_rho_m(self, use_rho_m_in)


    def use_rho_m(self):
        """

        `use_rho_m() const -> bool`  

        returns whether or not the rho_m component is used  

        """
        return _fastjet.Subtractor_use_rho_m(self)


    def set_safe_mass(self, safe_mass_in=True):
        """

        `set_safe_mass(bool safe_mass_in=true)`  

        when 'safe_mass' is true, ensure that the mass of the subtracted 4-vector remain
        positive  

        when true, if the subtracted mass is negative, we return a 4-vector with 0 mass,
        pt and phi from the subtracted 4-vector and the rapidity of the original,
        unsubtracted jet.  

        Note: this will be switched off by default (for backwards compatibility with
        FastJet 3.0) but is highly likely to change in a future release of FastJet  

        """
        return _fastjet.Subtractor_set_safe_mass(self, safe_mass_in)


    def safe_mass(self):
        """

        `safe_mass() const -> bool`  

        returns whether or not safety tests on the mass are included  

        """
        return _fastjet.Subtractor_safe_mass(self)


    def set_known_selectors(self, sel_known_vertex, sel_leading_vertex):
        """

        `set_known_selectors(const Selector &sel_known_vertex, const Selector
            &sel_leading_vertex)`  

        This is mostly intended for cherge-hadron-subtracted type of events where we
        wich to use vertex information to improve the subtraction.  

        Given the following parameters:  

        Parameters
        ----------
        * `sel_known_vertex` :  
            selects the particles with a known vertex origin  
        * `sel_leading_vertex` :  
            amongst the particles with a known vertex origin, select those coming from
            the leading vertex Momentum identified as coming from the leading vertex
            will be kept, momentum identified as coming from a non-leading vertex will
            be eliminated and a regular area-median subtraction will be applied on the
            4-vector sum of the particles with unknown vertex origin.  

        When this is set, we shall ensure that the pt of the subtracted 4-vector is at
        least the pt of the particles that are known to come from the leading vertex (if
        it fails, subtraction returns the component that is known to come from the
        leading vertex --- or, the original unsubtracted jet if it contains no particles
        from the leading vertex). Furthermore, when safe_mass() is on, we also impose a
        similar constraint on the mass of the subtracted 4-vector (if the test fails,
        the longitudinal part of the subtracted 4-vector is taken from the component
        that is known to come from the leading vertex).  

        """
        return _fastjet.Subtractor_set_known_selectors(self, sel_known_vertex, sel_leading_vertex)


    def result(self, jet):
        """

        `result(const PseudoJet &jet) const -> PseudoJet`  

        returns a jet that's subtracted  

        Parameters
        ----------
        * `jet` :  
            the jet that is to be subtracted  

        Returns
        -------
        the subtracted jet  

        """
        return _fastjet.Subtractor_result(self, jet)


    def description(self):
        """

        `description() const -> std::string`  

        class description  

        """
        return _fastjet.Subtractor_description(self)


    def __str__(self):
        return _fastjet.Subtractor___str__(self)
Subtractor_swigregister = _fastjet.Subtractor_swigregister
Subtractor_swigregister(Subtractor)

# This file is compatible with both classic and new-style classes.


