/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IOUtil {
    public static final boolean BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER = SystemProperties.getBooleanProperty("idea.bytebuffers.use.native.byte.order", true);
    private static final ThreadLocalCachedValue<byte[]> ourReadWriteBuffersCache = new ThreadLocalCachedValue<byte[]>(){

        @Override
        @NotNull
        protected byte[] create() {
            byte[] byArray = IOUtil.allocReadWriteUTFBuffer();
            if (byArray == null) {
                1.$$$reportNull$$$0(0);
            }
            return byArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/IOUtil$1", "create"));
        }
    };
    private static final ThreadLocalCachedValue<char[]> spareBufferLocal = new ThreadLocalCachedValue<char[]>(){

        @Override
        @NotNull
        protected char[] create() {
            char[] cArray = new char[255];
            if (cArray == null) {
                2.$$$reportNull$$$0(0);
            }
            return cArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/IOUtil$2", "create"));
        }
    };

    private IOUtil() {
    }

    public static String readString(@NotNull DataInput stream) throws IOException {
        int length;
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(0);
        }
        if ((length = stream.readInt()) == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length * 2];
        stream.readFully(bytes);
        return new String(bytes, 0, length * 2, CharsetToolkit.UTF_16BE_CHARSET);
    }

    public static void writeString(@Nullable String s, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(1);
        }
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(s.length());
        if (s.isEmpty()) {
            return;
        }
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        int i = 0;
        int i2 = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    public static void writeUTFTruncated(@NotNull DataOutput stream, @NotNull String text2) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            IOUtil.$$$reportNull$$$0(3);
        }
        if (text2.length() > 16383) {
            stream.writeUTF(text2.substring(0, 16383));
        } else {
            stream.writeUTF(text2);
        }
    }

    public static void writeUTF(@NotNull DataOutput storage2, @NotNull String value) throws IOException {
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(4);
        }
        if (value == null) {
            IOUtil.$$$reportNull$$$0(5);
        }
        IOUtil.writeUTFFast(ourReadWriteBuffersCache.getValue(), storage2, value);
    }

    public static String readUTF(@NotNull DataInput storage2) throws IOException {
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(6);
        }
        return IOUtil.readUTFFast(ourReadWriteBuffersCache.getValue(), storage2);
    }

    @NotNull
    public static byte[] allocReadWriteUTFBuffer() {
        byte[] byArray = new byte[256];
        if (byArray == null) {
            IOUtil.$$$reportNull$$$0(7);
        }
        return byArray;
    }

    public static void writeUTFFast(@NotNull byte[] buffer, @NotNull DataOutput storage2, @NotNull String value) throws IOException {
        int len;
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(8);
        }
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(9);
        }
        if (value == null) {
            IOUtil.$$$reportNull$$$0(10);
        }
        if ((len = value.length()) < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i + 1] = (byte)c;
            }
            if (isAscii) {
                storage2.write(buffer, 0, len + 1);
                return;
            }
        }
        storage2.writeByte(-1);
        try {
            storage2.writeUTF(value);
        }
        catch (UTFDataFormatException e) {
            storage2.writeUTF("LONGER_THAN_64K");
            IOUtil.writeString(value, storage2);
        }
    }

    public static String readUTFFast(@NotNull byte[] buffer, @NotNull DataInput storage2) throws IOException {
        int len;
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(11);
        }
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(12);
        }
        if ((len = 0xFF & storage2.readByte()) == 255) {
            String result2 = storage2.readUTF();
            if ("LONGER_THAN_64K".equals(result2)) {
                return IOUtil.readString(storage2);
            }
            return result2;
        }
        if (len == 0) {
            return "";
        }
        storage2.readFully(buffer, 0, len);
        char[] chars = spareBufferLocal.getValue();
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(buffer[i] & 0xFF);
        }
        return new String(chars, 0, len);
    }

    public static boolean isAscii(@NotNull String str) {
        if (str == null) {
            IOUtil.$$$reportNull$$$0(13);
        }
        return IOUtil.isAscii((CharSequence)str);
    }

    public static boolean isAscii(@NotNull CharSequence str) {
        if (str == null) {
            IOUtil.$$$reportNull$$$0(14);
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char c) {
        return c < '\u0080';
    }

    public static boolean deleteAllFilesStartingWith(@NotNull File file2) {
        if (file2 == null) {
            IOUtil.$$$reportNull$$$0(15);
        }
        String baseName = file2.getName();
        File parentFile = file2.getParentFile();
        File[] files2 = parentFile != null ? parentFile.listFiles(pathname -> pathname.getName().startsWith(baseName)) : null;
        boolean ok = true;
        if (files2 != null) {
            for (File f : files2) {
                ok &= FileUtil.delete(f);
            }
        }
        return ok;
    }

    public static void syncStream(@NotNull OutputStream stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(16);
        }
        stream.flush();
        try {
            Object o;
            Field outField = FilterOutputStream.class.getDeclaredField("out");
            outField.setAccessible(true);
            while (stream instanceof FilterOutputStream && (o = outField.get(stream)) instanceof OutputStream) {
                stream = (OutputStream)o;
            }
            if (stream instanceof FileOutputStream) {
                ((FileOutputStream)stream).getFD().sync();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull File file2) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            IOUtil.$$$reportNull$$$0(18);
        }
        return IOUtil.openCleanOrResetBroken(factoryComputable, () -> IOUtil.deleteAllFilesStartingWith(file2));
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Runnable cleanupCallback) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(19);
        }
        if (cleanupCallback == null) {
            IOUtil.$$$reportNull$$$0(20);
        }
        try {
            return factoryComputable.compute();
        }
        catch (IOException ex) {
            cleanupCallback.run();
            return factoryComputable.compute();
        }
    }

    public static void writeStringList(@NotNull DataOutput out, @NotNull Collection<String> list2) throws IOException {
        if (out == null) {
            IOUtil.$$$reportNull$$$0(21);
        }
        if (list2 == null) {
            IOUtil.$$$reportNull$$$0(22);
        }
        DataInputOutputUtil.writeINT(out, list2.size());
        for (String s : list2) {
            IOUtil.writeUTF(out, s);
        }
    }

    @NotNull
    public static List<String> readStringList(@NotNull DataInput in) throws IOException {
        if (in == null) {
            IOUtil.$$$reportNull$$$0(23);
        }
        int size = DataInputOutputUtil.readINT(in);
        ArrayList<String> strings2 = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            strings2.add(IOUtil.readUTF(in));
        }
        ArrayList<String> arrayList = strings2;
        if (arrayList == null) {
            IOUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/IOUtil";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryComputable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupCallback";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/IOUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "allocReadWriteUTFBuffer";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeUTFTruncated";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeUTF";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readUTF";
                break;
            }
            case 7: 
            case 24: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeUTFFast";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readUTFFast";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAscii";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deleteAllFilesStartingWith";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "syncStream";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "openCleanOrResetBroken";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeStringList";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readStringList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

