/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import org.jruby.RubySymbol;
import org.jruby.ast.DefNode;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.util.ByteList;

public class IRMethod
extends IRScope {
    public final boolean isInstanceMethod;
    protected ArgumentDescriptor[] argDesc = ArgumentDescriptor.EMPTY_ARRAY;
    private DefNode defn;

    public IRMethod(IRManager manager, IRScope lexicalParent, DefNode defn, ByteList name2, boolean isInstanceMethod, int lineNumber, StaticScope staticScope, boolean needsCodeCoverage) {
        super(manager, lexicalParent, name2, lineNumber, staticScope);
        this.defn = defn;
        this.isInstanceMethod = isInstanceMethod;
        if (needsCodeCoverage) {
            this.getFlags().add(IRFlags.CODE_COVERAGE);
        }
        if (!this.getManager().isDryRun() && staticScope != null) {
            staticScope.setIRScope(this);
        }
    }

    @Override
    public boolean hasBeenBuilt() {
        return this.defn == null;
    }

    public synchronized InterpreterContext lazilyAcquireInterpreterContext() {
        if (!this.hasBeenBuilt()) {
            IRBuilder.topIRBuilder(this.getManager(), this).defineMethodInner(this.defn, this.getLexicalParent(), this.getFlags().contains((Object)IRFlags.CODE_COVERAGE));
            this.defn = null;
        }
        return this.interpreterContext;
    }

    @Override
    public synchronized BasicBlock[] prepareForCompilation() {
        if (!this.hasBeenBuilt()) {
            this.lazilyAcquireInterpreterContext();
        }
        BasicBlock[] bbs = super.prepareForCompilation();
        return bbs;
    }

    @Override
    public IRScopeType getScopeType() {
        return this.isInstanceMethod ? IRScopeType.INSTANCE_METHOD : IRScopeType.CLASS_METHOD;
    }

    @Override
    protected LocalVariable findExistingLocalVariable(RubySymbol name2, int scopeDepth) {
        assert (scopeDepth == 0) : "Local variable depth in IRMethod should always be zero (" + name2 + " had depth of " + scopeDepth + ")";
        return (LocalVariable)this.localVars.get(name2);
    }

    @Override
    public LocalVariable getLocalVariable(RubySymbol name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        }
        return lvar;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argDesc;
    }

    public void setArgumentDescriptors(ArgumentDescriptor[] argDesc) {
        this.argDesc = argDesc;
    }
}

