/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractRareTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.LongRareTerms;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class LongRareTermsAggregator
extends AbstractRareTermsAggregator<ValuesSource.Numeric, IncludeExclude.LongFilter, Long> {
    protected LongHash bucketOrds;

    LongRareTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, SearchContext aggregationContext, Aggregator parent, IncludeExclude.LongFilter longFilter, int maxDocCount, double precision, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData, maxDocCount, precision, format, valuesSource, longFilter);
        this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
    }

    protected SortedNumericDocValues getValues(ValuesSource.Numeric valuesSource, LeafReaderContext ctx) throws IOException {
        return valuesSource.longValues(ctx);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final SortedNumericDocValues values = this.getValues((ValuesSource.Numeric)this.valuesSource, ctx);
        if (this.subCollectors == null) {
            this.subCollectors = sub;
        }
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int docId, long owningBucketOrdinal) throws IOException {
                if (values.advanceExact(docId)) {
                    int valuesCount = values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        if (LongRareTermsAggregator.this.includeExclude == null || ((IncludeExclude.LongFilter)LongRareTermsAggregator.this.includeExclude).accept(val)) {
                            LongRareTermsAggregator.this.doCollect(val, docId);
                        }
                        previous = val;
                    }
                }
            }
        };
    }

    @Override
    long addValueToOrds(Long value) {
        return this.bucketOrds.add(value);
    }

    private List<LongRareTerms.Bucket> buildSketch() {
        long deletionCount = 0L;
        LongHash newBucketOrds = new LongHash(1L, this.context.bigArrays());
        ArrayList<LongRareTerms.Bucket> buckets = new ArrayList<LongRareTerms.Bucket>();
        try (LongHash oldBucketOrds = this.bucketOrds;){
            long[] mergeMap = new long[(int)oldBucketOrds.size()];
            int i = 0;
            while ((long)i < oldBucketOrds.size()) {
                long oldKey = oldBucketOrds.get(i);
                long newBucketOrd = -1L;
                long docCount = this.bucketDocCount(i);
                if (docCount <= this.maxDocCount) {
                    newBucketOrd = newBucketOrds.add(oldKey);
                    LongRareTerms.Bucket bucket = new LongRareTerms.Bucket(oldKey, docCount, null, this.format);
                    bucket.bucketOrd = newBucketOrd;
                    buckets.add(bucket);
                    this.consumeBucketsAndMaybeBreak(1);
                } else {
                    ++deletionCount;
                    this.filter.add(oldKey);
                }
                mergeMap[i] = newBucketOrd;
                ++i;
            }
            if (deletionCount > 0L) {
                this.mergeBuckets(mergeMap, newBucketOrds.size());
                if (this.deferringCollector != null) {
                    this.deferringCollector.mergeBuckets(mergeMap);
                }
            }
        }
        this.bucketOrds = newBucketOrds;
        return buckets;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        List<LongRareTerms.Bucket> buckets = this.buildSketch();
        this.runDeferredCollections(buckets.stream().mapToLong(b -> b.bucketOrd).toArray());
        for (LongRareTerms.Bucket bucket : buckets) {
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
        }
        CollectionUtil.introSort(buckets, ORDER.comparator(this));
        return new LongRareTerms(this.name, ORDER, this.pipelineAggregators(), this.metaData(), this.format, buckets, this.maxDocCount, this.filter);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new LongRareTerms(this.name, ORDER, this.pipelineAggregators(), this.metaData(), this.format, Collections.emptyList(), 0L, this.filter);
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

