/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class StringLiteral
extends Literal {
    char[] source;
    int lineNumber;

    public StringLiteral(char[] cArray, int n, int n2, int n3) {
        this(n, n2);
        this.source = cArray;
        this.lineNumber = n3 - 1;
    }

    public StringLiteral(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void computeConstant() {
        this.constant = StringConstant.fromValue(String.valueOf(this.source));
    }

    public ExtendedStringLiteral extendWith(CharLiteral charLiteral) {
        return new ExtendedStringLiteral(this, charLiteral);
    }

    public ExtendedStringLiteral extendWith(StringLiteral stringLiteral) {
        return new ExtendedStringLiteral(this, stringLiteral);
    }

    public StringLiteralConcatenation extendsWith(StringLiteral stringLiteral) {
        return new StringLiteralConcatenation(this, stringLiteral);
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.ldc(this.constant.stringValue());
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public TypeBinding literalType(BlockScope blockScope) {
        return blockScope.getJavaLangString();
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        for (int i = 0; i < this.source.length; ++i) {
            Util.appendEscapedChar(stringBuffer, this.source[i], true);
        }
        stringBuffer.append('\"');
        return stringBuffer;
    }

    @Override
    public char[] source() {
        return this.source;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

