/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.CacheUtils;
import org.apache.maven.plugin.ProjectArtifactsCache;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;

@Component(role=ProjectArtifactsCache.class)
public class DefaultProjectArtifactsCache
implements ProjectArtifactsCache {
    protected final Map<ProjectArtifactsCache.Key, ProjectArtifactsCache.CacheRecord> cache = new ConcurrentHashMap<ProjectArtifactsCache.Key, ProjectArtifactsCache.CacheRecord>();

    @Override
    public ProjectArtifactsCache.Key createKey(MavenProject project2, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session) {
        return new CacheKey(project2, project2.getRemoteProjectRepositories(), scopesToCollect, scopesToResolve, aggregating, session);
    }

    @Override
    public ProjectArtifactsCache.CacheRecord get(ProjectArtifactsCache.Key key2) throws LifecycleExecutionException {
        ProjectArtifactsCache.CacheRecord cacheRecord = this.cache.get(key2);
        if (cacheRecord != null && cacheRecord.exception != null) {
            throw cacheRecord.exception;
        }
        return cacheRecord;
    }

    @Override
    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key2, Set<Artifact> projectArtifacts) {
        Validate.notNull(projectArtifacts, "projectArtifacts cannot be null", new Object[0]);
        this.assertUniqueKey(key2);
        ProjectArtifactsCache.CacheRecord record = new ProjectArtifactsCache.CacheRecord(Collections.unmodifiableSet(new HashSet<Artifact>(projectArtifacts)));
        this.cache.put(key2, record);
        return record;
    }

    protected void assertUniqueKey(ProjectArtifactsCache.Key key2) {
        if (this.cache.containsKey(key2)) {
            throw new IllegalStateException("Duplicate artifact resolution result for project " + key2);
        }
    }

    @Override
    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key2, LifecycleExecutionException exception) {
        Validate.notNull(exception, "exception cannot be null", new Object[0]);
        this.assertUniqueKey(key2);
        ProjectArtifactsCache.CacheRecord record = new ProjectArtifactsCache.CacheRecord(exception);
        this.cache.put(key2, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    protected static int pluginHashCode(Plugin plugin) {
        return CacheUtils.pluginHashCode(plugin);
    }

    protected static boolean pluginEquals(Plugin a, Plugin b) {
        return CacheUtils.pluginEquals(a, b);
    }

    @Override
    public void register(MavenProject project2, ProjectArtifactsCache.Key cacheKey, ProjectArtifactsCache.CacheRecord record) {
    }

    protected static class CacheKey
    implements ProjectArtifactsCache.Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Set<String> dependencyArtifacts;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final Set<String> collect;
        private final Set<String> resolve;
        private boolean aggregating;
        private final int hashCode;

        public CacheKey(MavenProject project2, List<RemoteRepository> repositories, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session) {
            this.groupId = project2.getGroupId();
            this.artifactId = project2.getArtifactId();
            this.version = project2.getVersion();
            HashSet<String> deps = new HashSet<String>();
            if (project2.getDependencyArtifacts() != null) {
                for (Artifact dep : project2.getDependencyArtifacts()) {
                    deps.add(dep.toString());
                }
            }
            this.dependencyArtifacts = Collections.unmodifiableSet(deps);
            this.workspace = CacheUtils.getWorkspace(session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.collect = scopesToCollect == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToCollect));
            this.resolve = scopesToResolve == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToResolve));
            this.aggregating = aggregating;
            int hash2 = 17;
            hash2 = hash2 * 31 + CacheKey.hash(this.groupId);
            hash2 = hash2 * 31 + CacheKey.hash(this.artifactId);
            hash2 = hash2 * 31 + CacheKey.hash(this.version);
            hash2 = hash2 * 31 + CacheKey.hash(this.dependencyArtifacts);
            hash2 = hash2 * 31 + CacheKey.hash(this.workspace);
            hash2 = hash2 * 31 + CacheKey.hash(this.localRepo);
            hash2 = hash2 * 31 + CacheUtils.repositoriesHashCode(repositories);
            hash2 = hash2 * 31 + CacheKey.hash(this.collect);
            hash2 = hash2 * 31 + CacheKey.hash(this.resolve);
            this.hashCode = hash2 = hash2 * 31 + CacheKey.hash(aggregating);
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static int hash(Object obj) {
            return obj != null ? obj.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return CacheKey.eq(this.groupId, that.groupId) && CacheKey.eq(this.artifactId, that.artifactId) && CacheKey.eq(this.version, that.version) && CacheKey.eq(this.dependencyArtifacts, that.dependencyArtifacts) && CacheKey.eq(this.workspace, that.workspace) && CacheKey.eq(this.localRepo, that.localRepo) && CacheUtils.repositoriesEquals(this.repositories, that.repositories) && CacheKey.eq(this.collect, that.collect) && CacheKey.eq(this.resolve, that.resolve) && this.aggregating == that.aggregating;
        }

        private static <T> boolean eq(T s1, T s2) {
            return s1 != null ? s1.equals(s2) : s2 == null;
        }
    }
}

