/*
 * Decompiled with CFR 0.152.
 */
package a_vcard.android.syncml.pim.vcard;

import a_vcard.android.syncml.pim.vcard.VCardException;
import a_vcard.android.syncml.pim.vcard.VCardParser_V21;
import a_vcard.android.util.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class VCardParser_V30
extends VCardParser_V21 {
    private static final String LOG_TAG = "VCardParser_V30";
    private static final HashSet<String> acceptablePropsWithParam = new HashSet<String>(Arrays.asList("BEGIN", "LOGO", "PHOTO", "LABEL", "FN", "TITLE", "SOUND", "VERSION", "TEL", "EMAIL", "TZ", "GEO", "NOTE", "URL", "BDAY", "ROLE", "REV", "UID", "KEY", "MAILER", "NAME", "PROFILE", "SOURCE", "NICKNAME", "CLASS", "SORT-STRING", "CATEGORIES", "PRODID"));
    private static final HashSet<String> sAcceptableEncodingV30 = new HashSet<String>(Arrays.asList("7BIT", "8BIT", "BASE64", "B"));
    private static final HashSet<String> acceptablePropsWithoutParam = new HashSet();
    private String mPreviousLine;

    protected String getVersion() {
        return "3.0";
    }

    protected boolean isValidPropertyName(String propertyName) {
        if (!(acceptablePropsWithParam.contains(propertyName) || acceptablePropsWithoutParam.contains(propertyName) || propertyName.startsWith("X-") || this.mWarningValueMap.contains(propertyName))) {
            this.mWarningValueMap.add(propertyName);
            Log.w(LOG_TAG, "Property name unsupported by vCard 3.0: " + propertyName);
        }
        return true;
    }

    protected boolean isValidEncoding(String encoding) {
        return sAcceptableEncodingV30.contains(encoding.toUpperCase());
    }

    protected String getLine() throws IOException {
        if (this.mPreviousLine != null) {
            String ret = this.mPreviousLine;
            this.mPreviousLine = null;
            return ret;
        }
        return this.mReader.readLine();
    }

    protected String getNonEmptyLine() throws IOException, VCardException {
        String line;
        block9: {
            StringBuilder builder = null;
            while (true) {
                if ((line = this.mReader.readLine()) == null) {
                    if (builder != null) {
                        return builder.toString();
                    }
                    if (this.mPreviousLine != null) {
                        String ret = this.mPreviousLine;
                        this.mPreviousLine = null;
                        return ret;
                    }
                    throw new VCardException("Reached end of buffer.");
                }
                if (line.length() == 0) {
                    if (builder != null) {
                        return builder.toString();
                    }
                    if (this.mPreviousLine == null) continue;
                    String ret = this.mPreviousLine;
                    this.mPreviousLine = null;
                    return ret;
                }
                if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                    if (builder != null) {
                        builder.append(line.substring(1));
                        continue;
                    }
                    if (this.mPreviousLine != null) {
                        builder = new StringBuilder();
                        builder.append(this.mPreviousLine);
                        this.mPreviousLine = null;
                        builder.append(line.substring(1));
                        continue;
                    }
                    throw new VCardException("Space exists at the beginning of the line");
                }
                if (this.mPreviousLine != null) break block9;
                this.mPreviousLine = line;
                if (builder != null) break;
            }
            return builder.toString();
        }
        String ret = this.mPreviousLine;
        this.mPreviousLine = line;
        return ret;
    }

    protected boolean readBeginVCard(boolean allowGarbage) throws IOException, VCardException {
        return super.readBeginVCard(allowGarbage);
    }

    protected void readEndVCard(boolean useCache, boolean allowGarbage) throws IOException, VCardException {
        super.readEndVCard(useCache, allowGarbage);
    }

    protected void handleParams(String params) throws VCardException {
        try {
            super.handleParams(params);
        }
        catch (VCardException e) {
            String[] strArray = params.split("=", 2);
            if (strArray.length == 2) {
                this.handleAnyParam(strArray[0], strArray[1]);
            }
            throw new VCardException("Unknown params value: " + params);
        }
    }

    protected void handleAnyParam(String paramName, String paramValue) {
        super.handleAnyParam(paramName, paramValue);
    }

    protected void handleType(String ptypevalues) {
        String[] ptypeArray = ptypevalues.split(",");
        this.mBuilder.propertyParamType("TYPE");
        for (String value : ptypeArray) {
            int length = value.length();
            if (length >= 2 && value.startsWith("\"") && value.endsWith("\"")) {
                this.mBuilder.propertyParamValue(value.substring(1, value.length() - 1));
                continue;
            }
            this.mBuilder.propertyParamValue(value);
        }
    }

    protected void handleAgent(String propertyValue) throws VCardException {
        throw new VCardException("AGENT in vCard 3.0 is not supported yet.");
    }

    protected String getBase64(String firstString) throws IOException, VCardException {
        StringBuilder builder = new StringBuilder();
        builder.append(firstString);
        while (true) {
            String line;
            if ((line = this.getLine()) == null) {
                throw new VCardException("File ended during parsing BASE64 binary");
            }
            if (line.length() == 0) break;
            if (!line.startsWith(" ") && !line.startsWith("\t")) {
                this.mPreviousLine = line;
                break;
            }
            builder.append(line);
        }
        return builder.toString();
    }

    protected String maybeUnescapeText(String text) {
        StringBuilder builder = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch == '\\' && i < length - 1) {
                char next_ch;
                if ((next_ch = text.charAt(++i)) == 'n' || next_ch == 'N') {
                    builder.append("\r\n");
                    continue;
                }
                builder.append(next_ch);
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    protected String maybeUnescape(char ch) {
        if (ch == 'n' || ch == 'N') {
            return "\r\n";
        }
        return String.valueOf(ch);
    }
}

