/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class LockedWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        LockedWidget lockedWidget = new LockedWidget(view);
        return lockedWidget;
    }

    private static class LockedWidget
    implements Widget {
        private final JLabel cmp = new ToolTipLabel();
        private final View view;

        LockedWidget(final View view) {
            this.cmp.setHorizontalAlignment(0);
            this.view = view;
            this.cmp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    view.getBuffer().toggleLocked(view);
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.cmp;
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            Boolean bl = buffer.isLocked();
            this.cmp.setText(bl != false ? "L" : "l");
            this.cmp.setEnabled(bl);
            this.cmp.setToolTipText(jEdit.getProperty("view.status.locked-tooltip", new Integer[]{bl != false ? 1 : 0}));
        }

        @Override
        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fontMetrics = this.cmp.getFontMetrics(font);
            Dimension dimension = new Dimension(Math.max(fontMetrics.charWidth('r'), fontMetrics.charWidth('R')) + 1, fontMetrics.getHeight());
            this.cmp.setPreferredSize(dimension);
            this.cmp.setMaximumSize(dimension);
        }
    }
}

