# browsing.py
# Copyright (C) 2008-2010 Stefan J. Betz <info@stefan-betz.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Stdlib Imports
from threading import Thread
import gettext
# pyNeighborhood Imports
from pyneighborhood import config, db, dblock
from pyneighborhood.misc import push_notification
from pyneighborhood.nmblookup import query_masters, query_workgroup, query_workgroup_hosts, query_host
from pyneighborhood.smbclient import scan_shares
from pyneighborhood.events import browsingevent,syncevent

_ = gettext.gettext

class BrowsingThread(Thread):
    """
    Browsing Class
    """

    def __init__(self):
        """
        Constructor
        """
        Thread.__init__(self)
        self.daemon = True

    def run(self):
        """
        Browse me...
        """
        while True:
            browsingevent.wait()
            push_notification(_("Starting browsing...\n"))
            dblock.acquire()
            cursor = db.cursor()
            cursor.execute("""UPDATE workgroups SET validated = 0 WHERE manual = 0""")
            cursor.execute("""UPDATE hosts SET validated = 0 WHERE manual = 0""")
            cursor.execute("""UPDATE shares SET validated = 0 WHERE manual = 0""")
            dblock.release()
            for master in query_masters():
                push_notification(_("Found Master Browser: %s\n") % master)
                workgroup, workgroupid = query_workgroup(master)
                push_notification(_("Master Browser %(master)s is member of workgroup %(workgroup)s\n") % { "master": master, "workgroup": workgroup })
                for host in query_workgroup_hosts(workgroup):
                    query_host(host)
            cur = db.cursor()
            workgroups_result = cur.execute("""SELECT name FROM workgroups WHERE manual = 0""").fetchall()
            for result in workgroups_result:
                push_notification(_("Found workgroup: %s\n") % result[0])
            hosts_result = cur.execute("""SELECT id,name,ip FROM hosts WHERE manual = 0""").fetchall()
            for result in hosts_result:
                push_notification(_("Scanning host %s for shares...\n") % result[1] )
                scan_shares(result[2])
                shares_result = cur.execute("""SELECT * FROM shares WHERE host = ? AND manual = 0""", (result[0],)).fetchall()
                for share in shares_result:
                    push_notification(_("Found share: %s\n") % str(share[1]))
            syncevent.set()
            browsingevent.clear()
