/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public abstract class TTFInput {
    private Stack filePosStack = new Stack();
    private int tempFlags;

    public abstract void seek(long var1) throws IOException;

    abstract long getPointer() throws IOException;

    public void pushPos() throws IOException {
        this.filePosStack.push(new Long(this.getPointer()));
    }

    public void popPos() throws IOException {
        this.seek((Long)this.filePosStack.pop());
    }

    public abstract int readRawByte() throws IOException;

    public abstract int readByte() throws IOException;

    public abstract short readShort() throws IOException;

    public abstract int readUShort() throws IOException;

    public abstract long readULong() throws IOException;

    public abstract int readLong() throws IOException;

    public abstract byte readChar() throws IOException;

    public final short readFWord() throws IOException {
        return this.readShort();
    }

    public final int readUFWord() throws IOException {
        return this.readUShort();
    }

    public final double readFixed() throws IOException {
        short major = this.readShort();
        short minor = this.readShort();
        return (double)major + (double)minor / 16384.0;
    }

    public final double readF2Dot14() throws IOException {
        int major = this.readByte();
        int minor = this.readByte();
        int fraction = minor + ((major & 0x3F) << 8);
        int mantissa = major >> 6;
        if (mantissa >= 2) {
            mantissa -= 4;
        }
        return (double)mantissa + (double)fraction / 16384.0;
    }

    public final void checkShortZero() throws IOException {
        if (this.readShort() != 0) {
            System.err.println("Reserved bit should be 0.");
        }
    }

    public static final boolean checkZeroBit(int b, int bit, String name) throws IOException {
        if (TTFInput.flagBit(b, bit)) {
            System.err.println("Reserved bit " + bit + " in " + name + " not 0.");
            return false;
        }
        return true;
    }

    public void readUShortFlags() throws IOException {
        this.tempFlags = this.readUShort();
    }

    public void readByteFlags() throws IOException {
        this.tempFlags = this.readByte();
    }

    public boolean flagBit(int bit) {
        return TTFInput.flagBit(this.tempFlags, bit);
    }

    public static boolean flagBit(int b, int bit) {
        return (b & 1 << bit) > 0;
    }

    public abstract void readFully(byte[] var1) throws IOException;

    public int[] readFFFFTerminatedUShortArray() throws IOException {
        LinkedList<Integer> values = new LinkedList<Integer>();
        int ushort = -1;
        do {
            ushort = this.readUShort();
            values.add(new Integer(ushort));
        } while (ushort != 65535);
        int[] shorts = new int[values.size()];
        Iterator i = values.iterator();
        int j = 0;
        while (i.hasNext()) {
            shorts[j++] = (Integer)i.next();
        }
        return shorts;
    }

    public int[] readUShortArray(int n) throws IOException {
        int[] temp = new int[n];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.readUShort();
        }
        return temp;
    }

    public short[] readShortArray(int n) throws IOException {
        short[] temp = new short[n];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.readShort();
        }
        return temp;
    }
}

