/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.LinkedList;
import java.util.List;
import net.htmlparser.jericho.Source;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.parser.SpiderParserListener;

public abstract class SpiderParser {
    private List<SpiderParserListener> listeners = new LinkedList<SpiderParserListener>();
    protected static final Logger log = Logger.getLogger(SpiderParser.class);

    public void addSpiderParserListener(SpiderParserListener listener) {
        this.listeners.add(listener);
    }

    public void removeSpiderParserListener(SpiderParserListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListenersResourceFound(HttpMessage message, int depth, String uri) {
        for (SpiderParserListener l : this.listeners) {
            l.resourceURIFound(message, depth, uri);
        }
    }

    protected void notifyListenersPostResourceFound(HttpMessage message, int depth, String uri, String requestBody) {
        for (SpiderParserListener l : this.listeners) {
            l.resourcePostURIFound(message, depth, uri, requestBody);
        }
    }

    protected void processURL(HttpMessage message, int depth, String localURL, String baseURL) {
        String fullURL = URLCanonicalizer.getCanonicalURL(localURL, baseURL);
        if (fullURL == null) {
            return;
        }
        log.debug((Object)("Canonical URL constructed using '" + localURL + "': " + fullURL));
        this.notifyListenersResourceFound(message, depth + 1, fullURL);
    }

    public abstract boolean parseResource(HttpMessage var1, Source var2, int var3);

    public abstract boolean canParseResource(HttpMessage var1, String var2, boolean var3);
}

