/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.ColorChooserDialog;
import org.gjt.sp.util.GenericGUIUtilities;

public class ColorWellButton
extends JButton {
    public ColorWellButton(Color color) {
        this.setIcon(new ColorWell(color));
        this.setMargin(new Insets(2, 2, 2, 2));
        this.addActionListener(new ActionHandler());
        if (OperatingSystem.isMacOSLF()) {
            this.putClientProperty("JButton.buttonType", "toolbar");
        }
    }

    public Color getSelectedColor() {
        return ((ColorWell)this.getIcon()).color;
    }

    public void setSelectedColor(Color color) {
        ((ColorWell)this.getIcon()).color = color;
        this.repaint();
        this.fireStateChanged();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDialog jDialog = GenericGUIUtilities.getParentDialog(ColorWellButton.this);
            Color color = null;
            if (jDialog != null) {
                ColorChooserDialog colorChooserDialog = new ColorChooserDialog((Window)jDialog, ColorWellButton.this.getSelectedColor());
                color = colorChooserDialog.getColor();
            } else {
                ColorChooserDialog colorChooserDialog = new ColorChooserDialog((Window)SwingUtilities.getRoot(ColorWellButton.this), ColorWellButton.this.getSelectedColor());
                color = colorChooserDialog.getColor();
            }
            if (color != null) {
                ColorWellButton.this.setSelectedColor(color);
            }
        }
    }

    static class ColorWell
    implements Icon {
        Color color;
        private Rectangle2D bounds = new JLabel("").getFont().createGlyphVector(new FontRenderContext(null, true, false), "AAAA").getVisualBounds();

        ColorWell(Color color) {
            this.color = color;
        }

        @Override
        public int getIconWidth() {
            return (int)Math.ceil(this.bounds.getWidth());
        }

        @Override
        public int getIconHeight() {
            return (int)Math.ceil(this.bounds.getHeight());
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.color == null) {
                return;
            }
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
            graphics.setColor(this.color.darker());
            graphics.drawRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
    }
}

