/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagCheckerIndex;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.Functions;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.LiteralExpression;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.TokenMgrError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.DefaultGeoProperty;
import org.openstreetmap.josm.tools.GeoProperty;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSTagChecker
extends Test.TagTest {
    MapCSSTagCheckerIndex indexData;
    final Set<OsmPrimitive> tested = new HashSet<OsmPrimitive>();
    public static final String ENTRIES_PREF_KEY = "validator." + MapCSSTagChecker.class.getName() + ".entries";
    final MultiMap<String, TagCheck> checks = new MultiMap();

    public MapCSSTagChecker() {
        super(I18n.tr("Tag checker (MapCSS based)", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    public synchronized Collection<TestError> getErrorsForPrimitive(OsmPrimitive p, boolean includeOtherSeverity) {
        ArrayList<TestError> res = new ArrayList<TestError>();
        if (this.indexData == null) {
            this.indexData = new MapCSSTagCheckerIndex(this.checks, includeOtherSeverity, true);
        }
        MapCSSStyleSource.MapCSSRuleIndex matchingRuleIndex = this.indexData.get(p);
        Environment env = new Environment(p, new MultiCascade(), "default", null);
        MapCSSRule.Declaration lastDeclUsed = null;
        Iterator<MapCSSRule> candidates = matchingRuleIndex.getRuleCandidates(p);
        while (candidates.hasNext()) {
            TagCheck check;
            MapCSSRule r = candidates.next();
            env.clearSelectorMatchingInformation();
            if (!r.selector.matches(env) || (check = this.indexData.getCheck(r)) == null || r.declaration == lastDeclUsed) continue;
            lastDeclUsed = r.declaration;
            r.declaration.execute(env);
            if (check.errors.isEmpty()) continue;
            for (TestError e : check.getErrorsForPrimitive(p, r.selector, env, new MapCSSTagCheckerAndRule(check.rule))) {
                MapCSSTagChecker.addIfNotSimilar(e, res);
            }
        }
        return res;
    }

    private static void addIfNotSimilar(TestError toAdd, List<TestError> errors) {
        boolean isDup = false;
        if (toAdd.getPrimitives().size() >= 2) {
            for (TestError e : errors) {
                if (e.getCode() != toAdd.getCode() || !e.getMessage().equals(toAdd.getMessage()) || e.getPrimitives().size() != toAdd.getPrimitives().size() || !e.getPrimitives().containsAll(toAdd.getPrimitives()) || e.getHighlighted().size() != toAdd.getHighlighted().size() || !e.getHighlighted().containsAll(toAdd.getHighlighted())) continue;
                isDup = true;
                break;
            }
        }
        if (!isDup) {
            errors.add(toAdd);
        }
    }

    private static Collection<TestError> getErrorsForPrimitive(OsmPrimitive p, boolean includeOtherSeverity, Collection<Set<TagCheck>> checksCol) {
        ArrayList<TestError> r = new ArrayList<TestError>();
        Environment env = new Environment(p, new MultiCascade(), "default", null);
        for (Set<TagCheck> schecks : checksCol) {
            for (TagCheck check : schecks) {
                Selector selector;
                boolean ignoreError;
                boolean bl = ignoreError = Severity.OTHER == check.getSeverity() && !includeOtherSeverity;
                if (ignoreError && check.setClassExpressions.isEmpty() || (selector = check.whichSelectorMatchesEnvironment(env)) == null) continue;
                check.rule.declaration.execute(env);
                if (ignoreError || check.errors.isEmpty()) continue;
                r.addAll(check.getErrorsForPrimitive(p, selector, env, new MapCSSTagCheckerAndRule(check.rule)));
            }
        }
        return r;
    }

    @Override
    public void check(OsmPrimitive p) {
        for (TestError e : this.getErrorsForPrimitive(p, ValidatorPrefHelper.PREF_OTHER.get())) {
            MapCSSTagChecker.addIfNotSimilar(e, this.errors);
        }
        if (this.partialSelection && p.isTagged()) {
            this.tested.add(p);
        }
    }

    public synchronized ParseResult addMapCSS(String url) throws ParseException, IOException {
        ParseResult result;
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        try (CachedFile cache = new CachedFile(url);
             InputStream zip = cache.findZipEntryInputStream("validator.mapcss", "");
             InputStream s = zip != null ? zip : cache.getInputStream();
             BufferedReader reader = new BufferedReader(UTFInputStreamReader.create(s));){
            if (zip != null) {
                I18n.addTexts(cache.getFile());
            }
            result = TagCheck.readMapCSS(reader);
            this.checks.remove(url);
            this.checks.putAll(url, result.parseChecks);
            this.indexData = null;
            if (Config.getPref().getBoolean("validator.check_assert_local_rules", false) && Utils.isLocalUrl(url)) {
                for (String msg : this.checkAsserts(result.parseChecks)) {
                    Logging.warn(msg);
                }
            }
        }
        return result;
    }

    @Override
    public synchronized void initialize() throws Exception {
        this.checks.clear();
        this.indexData = null;
        for (SourceEntry source : new ValidatorPrefHelper().get()) {
            if (!source.active) continue;
            String i = source.url;
            try {
                if (!i.startsWith("resource:")) {
                    Logging.info(I18n.tr("Adding {0} to tag checker", i));
                } else if (Logging.isDebugEnabled()) {
                    Logging.debug(I18n.tr("Adding {0} to tag checker", i));
                }
                this.addMapCSS(i);
                if (!Config.getPref().getBoolean("validator.auto_reload_local_rules", true) || !source.isLocal()) continue;
                FileWatcher.getDefaultInstance().registerSource(source);
            }
            catch (IOException | IllegalArgumentException | IllegalStateException ex) {
                Logging.warn(I18n.tr("Failed to add {0} to tag checker", i));
                Logging.log(Logging.LEVEL_WARN, ex);
            }
            catch (ParseException | TokenMgrError ex) {
                Logging.warn(I18n.tr("Failed to add {0} to tag checker", i));
                Logging.warn(ex);
            }
        }
    }

    private static Method getFunctionMethod(String method) {
        try {
            return Functions.class.getDeclaredMethod(method, Environment.class, String.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Logging.error(e);
            return null;
        }
    }

    private static Optional<String> getFirstInsideCountry(TagCheck check, Method insideMethod) {
        return check.rule.selectors.stream().filter(s -> s instanceof Selector.GeneralSelector).flatMap(s -> ((Selector.GeneralSelector)s).getConditions().stream()).filter(c -> c instanceof ConditionFactory.ExpressionCondition).map(c -> ((ConditionFactory.ExpressionCondition)c).getExpression()).filter(c -> c instanceof ExpressionFactory.ParameterFunction).map(c -> (ExpressionFactory.ParameterFunction)c).filter(c -> c.getMethod().equals(insideMethod)).flatMap(c -> c.getArgs().stream()).filter(e -> e instanceof LiteralExpression).map(e -> ((LiteralExpression)e).getLiteral()).filter(l -> l instanceof String).map(l -> ((String)l).split(",")[0]).findFirst();
    }

    private static LatLon getLocation(TagCheck check, Method insideMethod) {
        GeoProperty<Boolean> prop;
        GeoPropertyIndex<Boolean> index;
        Optional<String> inside = MapCSSTagChecker.getFirstInsideCountry(check, insideMethod);
        if (inside.isPresent() && (index = Territories.getGeoPropertyIndex(inside.get())) != null && (prop = index.getGeoProperty()) instanceof DefaultGeoProperty) {
            Rectangle bounds = ((DefaultGeoProperty)prop).getArea().getBounds();
            return new LatLon(bounds.getCenterY(), bounds.getCenterX());
        }
        return LatLon.ZERO;
    }

    public Set<String> checkAsserts(Collection<TagCheck> schecks) {
        LinkedHashSet<String> assertionErrors = new LinkedHashSet<String>();
        Method insideMethod = MapCSSTagChecker.getFunctionMethod("inside");
        DataSet ds = new DataSet();
        for (TagCheck check : schecks) {
            Logging.debug("Check: {0}", check);
            for (Map.Entry<String, Boolean> i : check.assertions.entrySet()) {
                Logging.debug("- Assertion: {0}", i);
                OsmPrimitive p = OsmUtils.createPrimitive(i.getKey(), MapCSSTagChecker.getLocation(check, insideMethod), true);
                ArrayList<Set<TagCheck>> checksToRun = new ArrayList<Set<TagCheck>>();
                Set<TagCheck> checkDependencies = check.getTagCheckDependencies(schecks);
                if (!checkDependencies.isEmpty()) {
                    checksToRun.add(checkDependencies);
                }
                checksToRun.add(Collections.singleton(check));
                MapCSSTagChecker.addPrimitive(ds, p);
                Collection<TestError> pErrors = MapCSSTagChecker.getErrorsForPrimitive(p, true, checksToRun);
                Logging.debug("- Errors: {0}", pErrors);
                boolean isError = pErrors.stream().anyMatch(e -> e.getTester().equals(check.rule));
                if (isError != i.getValue()) {
                    String error = MessageFormat.format("Expecting test ''{0}'' (i.e., {1}) to {2} {3} (i.e., {4})", check.getMessage(p), check.rule.selectors, i.getValue() != false ? "match" : "not match", i.getKey(), p.getKeys());
                    assertionErrors.add(error);
                }
                ds.removePrimitive((PrimitiveId)p);
            }
        }
        return assertionErrors;
    }

    private static void addPrimitive(DataSet ds, OsmPrimitive p) {
        if (p instanceof Way) {
            ((Way)p).getNodes().forEach(n -> MapCSSTagChecker.addPrimitive(ds, n));
        } else if (p instanceof Relation) {
            ((Relation)p).getMembers().forEach(m -> MapCSSTagChecker.addPrimitive(ds, m.getMember()));
        }
        ds.addPrimitive(p);
    }

    @Override
    public synchronized int hashCode() {
        return Objects.hash(super.hashCode(), this.checks);
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MapCSSTagChecker that = (MapCSSTagChecker)obj;
        return Objects.equals(this.checks, that.checks);
    }

    public static void reloadRule(SourceEntry rule) {
        MapCSSTagChecker tagChecker = OsmValidator.getTest(MapCSSTagChecker.class);
        if (tagChecker != null) {
            try {
                tagChecker.addMapCSS(rule.url);
            }
            catch (IOException | ParseException | TokenMgrError e) {
                Logging.warn(e);
            }
        }
    }

    @Override
    public synchronized void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        super.setShowElements(true);
        if (this.indexData == null) {
            this.indexData = new MapCSSTagCheckerIndex(this.checks, this.includeOtherSeverityChecks(), true);
        }
        this.tested.clear();
    }

    @Override
    public synchronized void endTest() {
        if (this.partialSelection && !this.tested.isEmpty()) {
            this.indexData = new MapCSSTagCheckerIndex(this.checks, this.includeOtherSeverityChecks(), false);
            HashSet<OsmPrimitive> surrounding = new HashSet<OsmPrimitive>();
            for (OsmPrimitive p : this.tested) {
                if (p.getDataSet() == null) continue;
                surrounding.addAll(p.getDataSet().searchWays(p.getBBox()));
                surrounding.addAll(p.getDataSet().searchRelations(p.getBBox()));
            }
            boolean includeOtherSeverity = this.includeOtherSeverityChecks();
            for (OsmPrimitive p : surrounding) {
                if (this.tested.contains(p)) continue;
                Collection<TestError> additionalErrors = this.getErrorsForPrimitive(p, includeOtherSeverity);
                for (TestError e : additionalErrors) {
                    if (!e.getPrimitives().stream().anyMatch(this.tested::contains)) continue;
                    MapCSSTagChecker.addIfNotSimilar(e, this.errors);
                }
            }
            this.tested.clear();
        }
        super.endTest();
        this.indexData = null;
    }

    private boolean includeOtherSeverityChecks() {
        return this.isBeforeUpload ? ValidatorPrefHelper.PREF_OTHER_UPLOAD.get() : ValidatorPrefHelper.PREF_OTHER.get();
    }

    static class MapCSSTagCheckerAndRule
    extends MapCSSTagChecker {
        public final GroupedMapCSSRule rule;

        MapCSSTagCheckerAndRule(GroupedMapCSSRule rule) {
            this.rule = rule;
        }

        @Override
        public synchronized boolean equals(Object obj) {
            return super.equals(obj) || obj instanceof TagCheck && this.rule.equals(((TagCheck)obj).rule) || obj instanceof GroupedMapCSSRule && this.rule.equals(obj);
        }

        @Override
        public synchronized int hashCode() {
            return Objects.hash(super.hashCode(), this.rule);
        }

        public String toString() {
            return "MapCSSTagCheckerAndRule [rule=" + this.rule + ']';
        }
    }

    public static class TagCheck
    implements Predicate<OsmPrimitive> {
        protected final GroupedMapCSSRule rule;
        protected final List<FixCommand> fixCommands = new ArrayList<FixCommand>();
        protected final List<String> alternatives = new ArrayList<String>();
        protected final Map<Instruction.AssignmentInstruction, Severity> errors = new HashMap<Instruction.AssignmentInstruction, Severity>();
        protected final Map<String, Boolean> assertions = new HashMap<String, Boolean>();
        protected final Set<String> setClassExpressions = new HashSet<String>();
        protected boolean deletion;
        protected String group;
        private static final String POSSIBLE_THROWS = TagCheck.possibleThrows();

        TagCheck(GroupedMapCSSRule rule) {
            this.rule = rule;
        }

        static final String possibleThrows() {
            StringBuilder sb = new StringBuilder();
            for (Severity s : Severity.values()) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append("throw").append(s.name().charAt(0)).append(s.name().substring(1).toLowerCase(Locale.ENGLISH));
            }
            return sb.toString();
        }

        static TagCheck ofMapCSSRule(GroupedMapCSSRule rule) throws IllegalDataException {
            TagCheck check = new TagCheck(rule);
            for (Instruction i : rule.declaration.instructions) {
                if (!(i instanceof Instruction.AssignmentInstruction)) continue;
                Instruction.AssignmentInstruction ai = (Instruction.AssignmentInstruction)i;
                if (ai.isSetInstruction) {
                    check.setClassExpressions.add(ai.key);
                    continue;
                }
                try {
                    String val;
                    String string = ai.val instanceof Expression ? (String)Optional.ofNullable(((Expression)ai.val).evaluate(new Environment())).map(Object::toString).orElse(null) : (ai.val instanceof String ? (String)ai.val : (val = ai.val instanceof Keyword ? ((Keyword)ai.val).val : null));
                    if (ai.key.startsWith("throw")) {
                        try {
                            check.errors.put(ai, Severity.valueOf(ai.key.substring("throw".length()).toUpperCase(Locale.ENGLISH)));
                        }
                        catch (IllegalArgumentException e) {
                            Logging.log(Logging.LEVEL_WARN, "Unsupported " + ai.key + " instruction. Allowed instructions are " + POSSIBLE_THROWS + '.', e);
                        }
                        continue;
                    }
                    if ("fixAdd".equals(ai.key)) {
                        check.fixCommands.add(FixCommand.fixAdd(ai.val));
                        continue;
                    }
                    if ("fixRemove".equals(ai.key)) {
                        CheckParameterUtil.ensureThat(!(ai.val instanceof String) || val == null || !val.contains("="), "Unexpected '='. Please only specify the key to remove in: " + ai);
                        check.fixCommands.add(FixCommand.fixRemove(ai.val));
                        continue;
                    }
                    if (val != null && "fixChangeKey".equals(ai.key)) {
                        CheckParameterUtil.ensureThat(val.contains("=>"), "Separate old from new key by '=>'!");
                        String[] x = val.split("=>", 2);
                        check.fixCommands.add(FixCommand.fixChangeKey(Utils.removeWhiteSpaces(x[0]), Utils.removeWhiteSpaces(x[1])));
                        continue;
                    }
                    if (val != null && "fixDeleteObject".equals(ai.key)) {
                        CheckParameterUtil.ensureThat("this".equals(val), "fixDeleteObject must be followed by 'this'");
                        check.deletion = true;
                        continue;
                    }
                    if (val != null && "suggestAlternative".equals(ai.key)) {
                        check.alternatives.add(val);
                        continue;
                    }
                    if (val != null && "assertMatch".equals(ai.key)) {
                        check.assertions.put(val, Boolean.TRUE);
                        continue;
                    }
                    if (val != null && "assertNoMatch".equals(ai.key)) {
                        check.assertions.put(val, Boolean.FALSE);
                        continue;
                    }
                    if (val != null && "group".equals(ai.key)) {
                        check.group = val;
                        continue;
                    }
                    if (ai.key.startsWith("-")) {
                        Logging.debug("Ignoring extension instruction: " + ai.key + ": " + ai.val);
                        continue;
                    }
                    throw new IllegalDataException("Cannot add instruction " + ai.key + ": " + ai.val + '!');
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalDataException(e);
                }
            }
            if (check.errors.isEmpty() && check.setClassExpressions.isEmpty()) {
                throw new IllegalDataException("No " + POSSIBLE_THROWS + " given! You should specify a validation error message for " + rule.selectors);
            }
            if (check.errors.size() > 1) {
                throw new IllegalDataException("More than one " + POSSIBLE_THROWS + " given! You should specify a single validation error message for " + rule.selectors);
            }
            return check;
        }

        static ParseResult readMapCSS(Reader css) throws ParseException {
            CheckParameterUtil.ensureParameterNotNull(css, "css");
            MapCSSStyleSource source = new MapCSSStyleSource("");
            MapCSSParser preprocessor = new MapCSSParser(css, MapCSSParser.LexicalState.PREPROCESSOR);
            StringReader mapcss = new StringReader(preprocessor.pp_root(source));
            MapCSSParser parser = new MapCSSParser(mapcss, MapCSSParser.LexicalState.DEFAULT);
            parser.sheet(source);
            source.removeMetaRules();
            LinkedHashMap g = new LinkedHashMap();
            for (MapCSSRule rule : source.rules) {
                if (!g.containsKey(rule.declaration)) {
                    ArrayList<Selector> sels = new ArrayList<Selector>();
                    sels.add(rule.selector);
                    g.put(rule.declaration, sels);
                    continue;
                }
                ((List)g.get(rule.declaration)).add(rule.selector);
            }
            ArrayList<TagCheck> parseChecks = new ArrayList<TagCheck>();
            for (Map.Entry map : g.entrySet()) {
                try {
                    parseChecks.add(TagCheck.ofMapCSSRule(new GroupedMapCSSRule((List)map.getValue(), (MapCSSRule.Declaration)map.getKey())));
                }
                catch (IllegalDataException e) {
                    Logging.error("Cannot add MapCss rule: " + e.getMessage());
                    source.logError(e);
                }
            }
            return new ParseResult(parseChecks, source.getErrors());
        }

        @Override
        public boolean test(OsmPrimitive primitive) {
            return this.whichSelectorMatchesPrimitive(primitive) != null;
        }

        Selector whichSelectorMatchesPrimitive(OsmPrimitive primitive) {
            return this.whichSelectorMatchesEnvironment(new Environment(primitive));
        }

        Selector whichSelectorMatchesEnvironment(Environment env) {
            for (Selector i : this.rule.selectors) {
                env.clearSelectorMatchingInformation();
                if (!i.matches(env)) continue;
                return i;
            }
            return null;
        }

        static String determineArgument(Selector.OptimizedGeneralSelector matchingSelector, int index, String type, OsmPrimitive p) {
            try {
                Tag tag;
                Condition c = matchingSelector.getConditions().get(index);
                Tag tag2 = tag = c instanceof Condition.ToTagConvertable ? ((Condition.ToTagConvertable)((Object)c)).asTag(p) : null;
                if (tag == null) {
                    return null;
                }
                if ("key".equals(type)) {
                    return tag.getKey();
                }
                if ("value".equals(type)) {
                    return tag.getValue();
                }
                if ("tag".equals(type)) {
                    return tag.toString();
                }
            }
            catch (IndexOutOfBoundsException ignore) {
                Logging.debug(ignore);
            }
            return null;
        }

        static String insertArguments(Selector matchingSelector, String s, OsmPrimitive p) {
            if (s != null && matchingSelector instanceof Selector.ChildOrParentSelector) {
                return TagCheck.insertArguments(((Selector.ChildOrParentSelector)matchingSelector).right, s, p);
            }
            if (s == null || !(matchingSelector instanceof Selector.OptimizedGeneralSelector)) {
                return s;
            }
            Matcher m = Pattern.compile("\\{(\\d+)\\.(key|value|tag)\\}").matcher(s);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String argument = TagCheck.determineArgument((Selector.OptimizedGeneralSelector)matchingSelector, Integer.parseInt(m.group(1)), m.group(2), p);
                try {
                    m.appendReplacement(sb, String.valueOf(argument).replace("^(", "").replace(")$", ""));
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                    Logging.log(Logging.LEVEL_ERROR, I18n.tr("Unable to replace argument {0} in {1}: {2}", argument, sb, e.getMessage()), e);
                }
            }
            m.appendTail(sb);
            return sb.toString();
        }

        Command fixPrimitive(OsmPrimitive p) {
            if (this.fixCommands.isEmpty() && !this.deletion) {
                return null;
            }
            try {
                Selector matchingSelector = this.whichSelectorMatchesPrimitive(p);
                LinkedList<Command> cmds = new LinkedList<Command>();
                for (FixCommand fixCommand : this.fixCommands) {
                    cmds.add(fixCommand.createCommand(p, matchingSelector));
                }
                if (this.deletion && !p.isDeleted()) {
                    cmds.add(new DeleteCommand(p));
                }
                return new SequenceCommand(I18n.tr("Fix of {0}", this.getDescriptionForMatchingSelector(p, matchingSelector)), cmds);
            }
            catch (IllegalArgumentException e) {
                Logging.error(e);
                return null;
            }
        }

        String getMessage(OsmPrimitive p) {
            if (this.errors.isEmpty()) {
                return this.rule.declaration.toString();
            }
            Object val = this.errors.keySet().iterator().next().val;
            return String.valueOf(val instanceof Expression ? ((Expression)val).evaluate(new Environment(p)) : val);
        }

        String getDescription(OsmPrimitive p) {
            if (this.alternatives.isEmpty()) {
                return this.getMessage(p);
            }
            return I18n.tr("{0}, use {1} instead", this.getMessage(p), Utils.join(I18n.tr(" or ", new Object[0]), this.alternatives));
        }

        String getDescriptionForMatchingSelector(OsmPrimitive p, Selector matchingSelector) {
            return TagCheck.insertArguments(matchingSelector, this.getDescription(p), p);
        }

        Severity getSeverity() {
            return this.errors.isEmpty() ? null : this.errors.values().iterator().next();
        }

        public String toString() {
            return this.getDescription(null);
        }

        List<TestError> getErrorsForPrimitive(OsmPrimitive p) {
            Environment env = new Environment(p);
            return this.getErrorsForPrimitive(p, this.whichSelectorMatchesEnvironment(env), env, null);
        }

        private List<TestError> getErrorsForPrimitive(OsmPrimitive p, Selector matchingSelector, Environment env, Test tester) {
            ArrayList<TestError> res = new ArrayList<TestError>();
            if (matchingSelector != null && !this.errors.isEmpty()) {
                Command fix = this.fixPrimitive(p);
                String description = this.getDescriptionForMatchingSelector(p, matchingSelector);
                String description1 = this.group == null ? description : this.group;
                String description2 = this.group == null ? null : description;
                TestError.Builder errorBuilder = TestError.builder(tester, this.getSeverity(), 3000).messageWithManuallyTranslatedDescription(description1, description2, matchingSelector.toString());
                if (fix != null) {
                    errorBuilder = errorBuilder.fix(() -> fix);
                }
                if (env.child instanceof OsmPrimitive) {
                    res.add(errorBuilder.primitives(p, (OsmPrimitive)env.child).build());
                } else if (env.children != null) {
                    for (IPrimitive c : env.children) {
                        if (!(c instanceof OsmPrimitive)) continue;
                        errorBuilder = TestError.builder(tester, this.getSeverity(), 3000).messageWithManuallyTranslatedDescription(description1, description2, matchingSelector.toString());
                        if (fix != null) {
                            errorBuilder = errorBuilder.fix(() -> fix);
                        }
                        res.add(errorBuilder.primitives(p, (OsmPrimitive)c).build());
                    }
                } else {
                    res.add(errorBuilder.primitives(p).build());
                }
            }
            return res;
        }

        public Set<TagCheck> getTagCheckDependencies(Collection<TagCheck> schecks) {
            HashSet<TagCheck> result = new HashSet<TagCheck>();
            Set<String> classes = this.getClassesIds();
            if (schecks != null && !classes.isEmpty()) {
                block0: for (TagCheck tc : schecks) {
                    if (this.equals(tc)) continue;
                    for (String id : tc.setClassExpressions) {
                        if (!classes.contains(id)) continue;
                        result.add(tc);
                        continue block0;
                    }
                }
            }
            return result;
        }

        public Set<String> getClassesIds() {
            HashSet<String> result = new HashSet<String>();
            for (Selector s : this.rule.selectors) {
                if (!(s instanceof Selector.AbstractSelector)) continue;
                for (Condition c : ((Selector.AbstractSelector)s).getConditions()) {
                    if (!(c instanceof ConditionFactory.ClassCondition)) continue;
                    result.add(((ConditionFactory.ClassCondition)c).id);
                }
            }
            return result;
        }
    }

    public static class ParseResult {
        public final List<TagCheck> parseChecks;
        public final Collection<Throwable> parseErrors;

        public ParseResult(List<TagCheck> parseChecks, Collection<Throwable> parseErrors) {
            this.parseChecks = parseChecks;
            this.parseErrors = parseErrors;
        }
    }

    @FunctionalInterface
    static interface FixCommand {
        public Command createCommand(OsmPrimitive var1, Selector var2);

        public static void checkObject(Object obj) {
            CheckParameterUtil.ensureThat(obj instanceof Expression || obj instanceof String, () -> "instance of Exception or String expected, but got " + obj);
        }

        public static String evaluateObject(Object obj, OsmPrimitive p, Selector matchingSelector) {
            String s;
            if (obj instanceof Expression) {
                s = (String)((Expression)obj).evaluate(new Environment(p));
            } else if (obj instanceof String) {
                s = (String)obj;
            } else {
                return null;
            }
            return TagCheck.insertArguments(matchingSelector, s, p);
        }

        public static FixCommand fixAdd(final Object obj) {
            FixCommand.checkObject(obj);
            return new FixCommand(){

                @Override
                public Command createCommand(OsmPrimitive p, Selector matchingSelector) {
                    Tag tag = Tag.ofString(FixCommand.evaluateObject(obj, p, matchingSelector));
                    return new ChangePropertyCommand(p, tag.getKey(), tag.getValue());
                }

                public String toString() {
                    return "fixAdd: " + obj;
                }
            };
        }

        public static FixCommand fixRemove(final Object obj) {
            FixCommand.checkObject(obj);
            return new FixCommand(){

                @Override
                public Command createCommand(OsmPrimitive p, Selector matchingSelector) {
                    String key = FixCommand.evaluateObject(obj, p, matchingSelector);
                    return new ChangePropertyCommand(p, key, "");
                }

                public String toString() {
                    return "fixRemove: " + obj;
                }
            };
        }

        public static FixCommand fixChangeKey(final String oldKey, final String newKey) {
            return new FixCommand(){

                @Override
                public Command createCommand(OsmPrimitive p, Selector matchingSelector) {
                    return new ChangePropertyKeyCommand(p, TagCheck.insertArguments(matchingSelector, oldKey, p), TagCheck.insertArguments(matchingSelector, newKey, p));
                }

                public String toString() {
                    return "fixChangeKey: " + oldKey + " => " + newKey;
                }
            };
        }
    }

    public static class GroupedMapCSSRule {
        public final List<Selector> selectors;
        public final MapCSSRule.Declaration declaration;

        public GroupedMapCSSRule(List<Selector> selectors, MapCSSRule.Declaration declaration) {
            this.selectors = selectors;
            this.declaration = declaration;
        }

        public int hashCode() {
            return Objects.hash(this.selectors, this.declaration);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GroupedMapCSSRule that = (GroupedMapCSSRule)obj;
            return Objects.equals(this.selectors, that.selectors) && Objects.equals(this.declaration, that.declaration);
        }

        public String toString() {
            return "GroupedMapCSSRule [selectors=" + this.selectors + ", declaration=" + this.declaration + ']';
        }
    }
}

