# database.py
# 
# Copyright (C) 2009 Stefan J. Betz <stefan_betz@gmx.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""
This Modul contains all database related stuff, expect the database itself.
"""

def init_database(database):
    """
    Creates the required database tables pyNeighborhood deeds.
    """
    cursor = database.cursor()
    cursor.execute("""CREATE TABLE workgroups (
                      id INTEGER PRIMARY KEY,
                      name TEXT,
                      treeview TEXT,
                      validated INTEGER DEFAULT 0,
                      manual INTEGER DEFAULT 0);""")
    cursor.execute("""CREATE TABLE hosts (
                      id INTEGER PRIMARY KEY,
                      name TEXT,
                      ip TEXT,
                      hostname TEXT,
                      workgroup INTEGER REFERENCES workgroups(id),
                      comment TEXT,
                      treeview TEXT,
                      validated INTEGER DEFAULT 0,
                      manual INTEGER DEFAULT 0);""")
    cursor.execute("""CREATE TABLE shares (
                      id INTEGER PRIMARY KEY,
                      name TEXT, 
                      host INTEGER REFERENCES hosts(id),
                      mountpoint TEXT,
                      username TEXT,
                      password TEXT,
                      guest BOOLEAN,
                      comment TEXT,
                      treeview TEXT,
                      validated INTEGER DEFAULT 0,
                      manual INTEGER DEFAULT 0);""")
