#ifndef _EFL_UI_DND_EO_H_
#define _EFL_UI_DND_EO_H_

#ifndef _EFL_UI_DND_EO_CLASS_TYPE
#define _EFL_UI_DND_EO_CLASS_TYPE

typedef Eo Efl_Ui_Dnd;

#endif

#ifndef _EFL_UI_DND_EO_TYPES
#define _EFL_UI_DND_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
#define EFL_UI_DND_MIXIN efl_ui_dnd_mixin_get()

EWAPI const Efl_Class *efl_ui_dnd_mixin_get(void);

/**
 * @brief Start a drag and drop process at the drag side. During dragging,
 * there are three events emitted as belows: - EFL_UI_DND_EVENT_DRAG_POS -
 * EFL_UI_DND_EVENT_DRAG_ACCEPT - EFL_UI_DND_EVENT_DRAG_DONE
 *
 * @param[in] obj The object.
 * @param[in] format The data format
 * @param[in] data The drag data
 * @param[in] action Action when data is transferred
 * @param[in] icon_func Function pointer to create icon
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @ingroup Efl_Ui_Dnd
 */
EOAPI void efl_ui_dnd_drag_start(Eo *obj, Efl_Ui_Selection_Format format, Eina_Slice data, Efl_Ui_Selection_Action action, void *icon_func_data, Efl_Dnd_Drag_Icon_Create icon_func, Eina_Free_Cb icon_func_free_cb, unsigned int seat);

/**
 * @brief Set the action for the drag
 *
 * @param[in] obj The object.
 * @param[in] action Drag action
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @ingroup Efl_Ui_Dnd
 */
EOAPI void efl_ui_dnd_drag_action_set(Eo *obj, Efl_Ui_Selection_Action action, unsigned int seat);

/**
 * @brief Cancel the on-going drag
 *
 * @param[in] obj The object.
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @ingroup Efl_Ui_Dnd
 */
EOAPI void efl_ui_dnd_drag_cancel(Eo *obj, unsigned int seat);

/**
 * @brief Make the current object as drop target. There are four events
 * emitted: - EFL_UI_DND_EVENT_DRAG_ENTER - EFL_UI_DND_EVENT_DRAG_LEAVE -
 * EFL_UI_DND_EVENT_DRAG_POS - EFL_UI_DND_EVENT_DRAG_DROP.
 *
 * @param[in] obj The object.
 * @param[in] format Accepted data format
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @ingroup Efl_Ui_Dnd
 */
EOAPI void efl_ui_dnd_drop_target_add(Eo *obj, Efl_Ui_Selection_Format format, unsigned int seat);

/**
 * @brief Delete the dropable status from object
 *
 * @param[in] obj The object.
 * @param[in] format Accepted data format
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @ingroup Efl_Ui_Dnd
 */
EOAPI void efl_ui_dnd_drop_target_del(Eo *obj, Efl_Ui_Selection_Format format, unsigned int seat);

EWAPI extern const Efl_Event_Description _EFL_UI_DND_EVENT_DRAG_ACCEPT;

/** accept drag data
 * @return Eina_Bool *
 *
 * @ingroup Efl_Ui_Dnd
 */
#define EFL_UI_DND_EVENT_DRAG_ACCEPT (&(_EFL_UI_DND_EVENT_DRAG_ACCEPT))

EWAPI extern const Efl_Event_Description _EFL_UI_DND_EVENT_DRAG_DONE;

/** drag is done (mouse up)
 *
 * @ingroup Efl_Ui_Dnd
 */
#define EFL_UI_DND_EVENT_DRAG_DONE (&(_EFL_UI_DND_EVENT_DRAG_DONE))

EWAPI extern const Efl_Event_Description _EFL_UI_DND_EVENT_DRAG_ENTER;

/** called when the drag object enters this object
 *
 * @ingroup Efl_Ui_Dnd
 */
#define EFL_UI_DND_EVENT_DRAG_ENTER (&(_EFL_UI_DND_EVENT_DRAG_ENTER))

EWAPI extern const Efl_Event_Description _EFL_UI_DND_EVENT_DRAG_LEAVE;

/** called when the drag object leaves this object
 *
 * @ingroup Efl_Ui_Dnd
 */
#define EFL_UI_DND_EVENT_DRAG_LEAVE (&(_EFL_UI_DND_EVENT_DRAG_LEAVE))

EWAPI extern const Efl_Event_Description _EFL_UI_DND_EVENT_DRAG_POS;

/** called when the drag object changes drag position
 * @return Efl_Dnd_Drag_Pos
 *
 * @ingroup Efl_Ui_Dnd
 */
#define EFL_UI_DND_EVENT_DRAG_POS (&(_EFL_UI_DND_EVENT_DRAG_POS))

EWAPI extern const Efl_Event_Description _EFL_UI_DND_EVENT_DRAG_DROP;

/** called when the drag object dropped on this object
 * @return Efl_Ui_Selection_Data
 *
 * @ingroup Efl_Ui_Dnd
 */
#define EFL_UI_DND_EVENT_DRAG_DROP (&(_EFL_UI_DND_EVENT_DRAG_DROP))
#endif /* EFL_BETA_API_SUPPORT */

#endif
