#ifndef _EFL_UI_SLIDER_EO_H_
#define _EFL_UI_SLIDER_EO_H_

#ifndef _EFL_UI_SLIDER_EO_CLASS_TYPE
#define _EFL_UI_SLIDER_EO_CLASS_TYPE

typedef Eo Efl_Ui_Slider;

#endif

#ifndef _EFL_UI_SLIDER_EO_TYPES
#define _EFL_UI_SLIDER_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Elementary slider class
 *
 * @ingroup Efl_Ui_Slider
 */
#define EFL_UI_SLIDER_CLASS efl_ui_slider_class_get()

EWAPI const Efl_Class *efl_ui_slider_class_get(void);

EWAPI extern const Efl_Event_Description _EFL_UI_SLIDER_EVENT_CHANGED;

/** Called when slider changed
 *
 * @ingroup Efl_Ui_Slider
 */
#define EFL_UI_SLIDER_EVENT_CHANGED (&(_EFL_UI_SLIDER_EVENT_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_SLIDER_EVENT_DELAY_CHANGED;

/** Called when delay changed
 *
 * @ingroup Efl_Ui_Slider
 */
#define EFL_UI_SLIDER_EVENT_DELAY_CHANGED (&(_EFL_UI_SLIDER_EVENT_DELAY_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_SLIDER_EVENT_SLIDER_DRAG_START;

/** Called when slider drag started
 *
 * @ingroup Efl_Ui_Slider
 */
#define EFL_UI_SLIDER_EVENT_SLIDER_DRAG_START (&(_EFL_UI_SLIDER_EVENT_SLIDER_DRAG_START))

EWAPI extern const Efl_Event_Description _EFL_UI_SLIDER_EVENT_SLIDER_DRAG_STOP;

/** Called when slider drag stopped
 *
 * @ingroup Efl_Ui_Slider
 */
#define EFL_UI_SLIDER_EVENT_SLIDER_DRAG_STOP (&(_EFL_UI_SLIDER_EVENT_SLIDER_DRAG_STOP))
#endif /* EFL_BETA_API_SUPPORT */

#endif
