#ifndef _EFL_UI_TABLE_EO_H_
#define _EFL_UI_TABLE_EO_H_

#ifndef _EFL_UI_TABLE_EO_CLASS_TYPE
#define _EFL_UI_TABLE_EO_CLASS_TYPE

typedef Eo Efl_Ui_Table;

#endif

#ifndef _EFL_UI_TABLE_EO_TYPES
#define _EFL_UI_TABLE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl UI table class
 *
 * @ingroup Efl_Ui_Table
 */
#define EFL_UI_TABLE_CLASS efl_ui_table_class_get()

EWAPI const Efl_Class *efl_ui_table_class_get(void);

/**
 * @brief Control homogeneous mode.
 *
 * This will enable the homogeneous mode where cells are of the same weight and
 * of the same min size which is determined by maximum min size of cells.
 *
 * @param[in] obj The object.
 * @param[in] homogeneoush @c true if the box is homogeneous horizontally,
 * @c false otherwise
 * @param[in] homogeneousv @c true if the box is homogeneous vertically,
 * @c false otherwise
 *
 * @ingroup Efl_Ui_Table
 */
EOAPI void efl_ui_table_homogeneous_set(Eo *obj, Eina_Bool homogeneoush, Eina_Bool homogeneousv);

/**
 * @brief Control homogeneous mode.
 *
 * This will enable the homogeneous mode where cells are of the same weight and
 * of the same min size which is determined by maximum min size of cells.
 *
 * @param[in] obj The object.
 * @param[out] homogeneoush @c true if the box is homogeneous horizontally,
 * @c false otherwise
 * @param[out] homogeneousv @c true if the box is homogeneous vertically,
 * @c false otherwise
 *
 * @ingroup Efl_Ui_Table
 */
EOAPI void efl_ui_table_homogeneous_get(const Eo *obj, Eina_Bool *homogeneoush, Eina_Bool *homogeneousv);
#endif /* EFL_BETA_API_SUPPORT */

#endif
