/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartDecorator;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.axis.BytesAxisUtils;
import org.netbeans.lib.profiler.charts.axis.BytesMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimeMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.CrossBorderLayout;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.BytesXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYItemPainter;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYSelectionOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.ColorFactory;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;

public final class MemoryGraphPanel
extends GraphPanel {
    private final Color SIZE_COLOR = ColorFactory.getPredefinedColor(0);
    private final Color[] SIZE_GRADIENT = ColorFactory.getPredefinedGradient(0);
    private final Color USED_COLOR = ColorFactory.getPredefinedColor(1);
    private final Color[] USED_GRADIENT = ColorFactory.getPredefinedGradient(1);
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final VMTelemetryModels models;
    private final DataManagerListener listener;
    private final boolean smallPanel;

    public static MemoryGraphPanel createBigPanel(VMTelemetryModels vMTelemetryModels) {
        return new MemoryGraphPanel(vMTelemetryModels, false, null);
    }

    public static MemoryGraphPanel createSmallPanel(VMTelemetryModels vMTelemetryModels, Action action) {
        return new MemoryGraphPanel(vMTelemetryModels, true, action);
    }

    private MemoryGraphPanel(VMTelemetryModels vMTelemetryModels, boolean bl, Action action) {
        this.models = vMTelemetryModels;
        this.smallPanel = bl;
        this.initComponents(action);
        this.listener = new DataManagerListener(){

            public void dataChanged() {
                MemoryGraphPanel.this.updateData();
            }

            public void dataReset() {
                MemoryGraphPanel.this.resetData();
            }
        };
        vMTelemetryModels.getDataManager().addDataListener(this.listener);
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    @Override
    public void cleanup() {
        this.models.getDataManager().removeDataListener(this.listener);
    }

    private void updateData() {
        VMTelemetryDataManager vMTelemetryDataManager;
        long[] lArray;
        if (this.smallPanel && this.chart.fitsWidth() && (lArray = vMTelemetryDataManager.timeStamps)[(vMTelemetryDataManager = this.models.getDataManager()).getItemCount() - 1] - lArray[0] >= 180000L) {
            this.chart.setFitsWidth(false);
        }
    }

    private void resetData() {
        if (this.smallPanel) {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(true);
        } else {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(false);
        }
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 0x4000000L));
    }

    private void initComponents(Action action) {
        PaintersModel paintersModel = this.createMemoryPaintersModel();
        this.chart = this.createChart(this.models.memoryItemsModel(), paintersModel, this.smallPanel);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        this.chart.addPreDecorator(this.createMaxHeapDecorator());
        AxisComponent axisComponent = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.memoryItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 1, 2);
        axisComponent.setForeground(Color.GRAY);
        SynchronousXYItem synchronousXYItem = this.models.memoryItemsModel().getItem(0);
        XYItemPainter xYItemPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)synchronousXYItem);
        AxisComponent axisComponent2 = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new BytesXYItemMarksComputer((XYItem)synchronousXYItem, xYItemPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)new BytesMarksPainter(), 7, 2);
        axisComponent2.setForeground(Color.GRAY);
        JPanel jPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        jPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createMatteBorder(10, 10, 5, 5, GraphsUI.CHART_BACKGROUND_COLOR));
        jPanel.add((Component)((Object)this.chart), new Integer[]{0});
        jPanel.add((Component)axisComponent, new Integer[]{1, 2, 8});
        jPanel.add((Component)axisComponent2, new Integer[]{7, 6});
        JScrollBar jScrollBar = new JScrollBar(0);
        this.chart.attachHorizontalScrollBar(jScrollBar);
        jPanel.add((Component)jScrollBar, new Integer[]{5});
        if (!this.smallPanel) {
            ProfilerXYTooltipPainter profilerXYTooltipPainter = new ProfilerXYTooltipPainter(this.createTooltipModel());
            this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, profilerXYTooltipPainter));
            this.chart.getSelectionModel().setHoverMode(102);
            ProfilerXYSelectionOverlay profilerXYSelectionOverlay = new ProfilerXYSelectionOverlay();
            this.chart.addOverlayComponent(profilerXYSelectionOverlay);
            profilerXYSelectionOverlay.registerChart((ChartComponent)this.chart);
            this.chart.getSelectionModel().setMoveMode(1);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.add((Component)jPanel, "Center");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setOpaque(false);
            int n = new JLabel((String)"XXX").getPreferredSize().height;
            jPanel3.setBorder(BorderFactory.createEmptyBorder(n + 17, 0, 0, 10));
            InvisibleToolbar invisibleToolbar = new InvisibleToolbar(1);
            invisibleToolbar.setOpaque(true);
            invisibleToolbar.setBackground(UIUtils.getProfilerResultsBackground());
            invisibleToolbar.add(this.chart.toggleViewAction()).setBackground(UIUtils.getProfilerResultsBackground());
            invisibleToolbar.add(this.chart.zoomInAction()).setBackground(UIUtils.getProfilerResultsBackground());
            invisibleToolbar.add(this.chart.zoomOutAction()).setBackground(UIUtils.getProfilerResultsBackground());
            jPanel3.add((Component)invisibleToolbar, "Center");
            JLabel jLabel = new JLabel(GraphsUI.HEAP_SIZE_NAME, new ColorIcon(this.SIZE_COLOR, Color.BLACK, 18, 9), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel jLabel2 = new JLabel(GraphsUI.USED_HEAP_NAME, new ColorIcon(this.USED_COLOR, Color.BLACK, 18, 9), 10);
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel jPanel4 = new JPanel(new FlowLayout(4, 7, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 30));
            jPanel4.setOpaque(true);
            jPanel4.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel4.add(jLabel);
            jPanel4.add(jLabel2);
            this.setLayout(new BorderLayout());
            this.setBackground(UIUtils.getProfilerResultsBackground());
            JLabel jLabel3 = new JLabel(GraphsUI.MEMORY_CAPTION, 0);
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            jLabel3.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
            jLabel3.setOpaque(true);
            jLabel3.setBackground(UIUtils.getProfilerResultsBackground());
            this.add((Component)jLabel3, "North");
            this.add((Component)jPanel2, "Center");
            this.add((Component)jPanel4, "South");
            this.add((Component)jPanel3, "East");
            this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
        }
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long l) {
                return GraphPanel.DATE_FORMATTER.format(new Date(l));
            }

            @Override
            public int getRowsCount() {
                return 2;
            }

            @Override
            public String getRowName(int n) {
                switch (n) {
                    case 0: {
                        return GraphsUI.HEAP_SIZE_NAME;
                    }
                    case 1: {
                        return GraphsUI.USED_HEAP_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int n) {
                switch (n) {
                    case 0: {
                        return GraphsUI.HEAP_SIZE_PAINTER_FILL_COLOR;
                    }
                    case 1: {
                        return GraphsUI.USED_HEAP_PAINTER_FILL_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int n, long l) {
                return GraphPanel.INT_FORMATTER.format(l);
            }

            @Override
            public String getRowUnits(int n) {
                return BytesAxisUtils.UNITS_B;
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int n) {
                return MemoryGraphPanel.this.getMaxValueString(this.getRowName(n));
            }

            @Override
            public Color getExtraRowColor(int n) {
                return this.getRowColor(n);
            }

            @Override
            public String getExtraRowValue(int n) {
                SynchronousXYItem synchronousXYItem = MemoryGraphPanel.this.models.memoryItemsModel().getItem(n);
                return GraphPanel.INT_FORMATTER.format(synchronousXYItem.getMaxYValue());
            }

            @Override
            public String getExtraRowUnits(int n) {
                return this.getRowUnits(n);
            }
        };
    }

    private PaintersModel createMemoryPaintersModel() {
        ProfilerXYItemPainter profilerXYItemPainter;
        ProfilerXYItemPainter profilerXYItemPainter2;
        ProfilerXYItemPainter profilerXYItemPainter3 = profilerXYItemPainter2 = ProfilerXYItemPainter.absolutePainter(2.0f, this.SIZE_COLOR, this.SIZE_GRADIENT[0]);
        ProfilerXYItemPainter profilerXYItemPainter4 = profilerXYItemPainter = ProfilerXYItemPainter.absolutePainter(2.0f, this.USED_COLOR, this.USED_GRADIENT[0]);
        SynchronousXYItemsModel synchronousXYItemsModel = this.models.memoryItemsModel();
        PaintersModel.Default default_ = new PaintersModel.Default(new ChartItem[]{synchronousXYItemsModel.getItem(0), synchronousXYItemsModel.getItem(1)}, (ItemPainter[])new XYItemPainter[]{profilerXYItemPainter3, profilerXYItemPainter4});
        return default_;
    }

    private ChartDecorator createMaxHeapDecorator() {
        return new ChartDecorator(){

            public void paint(Graphics2D graphics2D, Rectangle rectangle, ChartContext chartContext) {
                int n = Utils.checkedInt((double)chartContext.getViewY((double)((MemoryGraphPanel)MemoryGraphPanel.this).models.getDataManager().maxHeapSize));
                if (n <= chartContext.getViewportHeight()) {
                    graphics2D.setColor(GraphsUI.HEAP_LIMIT_FILL_COLOR);
                    if (chartContext.isBottomBased()) {
                        graphics2D.fillRect(0, 0, chartContext.getViewportWidth(), n);
                    } else {
                        graphics2D.fillRect(0, n, chartContext.getViewportWidth(), chartContext.getViewportHeight() - n);
                    }
                }
            }
        };
    }
}

