# -*- coding: utf-8 -*-
info = {
    "name": "ur",
    "date_order": "DMY",
    "january": [
        "جنوری"
    ],
    "february": [
        "فروری"
    ],
    "march": [
        "مارچ"
    ],
    "april": [
        "اپریل"
    ],
    "may": [
        "مئی"
    ],
    "june": [
        "جون"
    ],
    "july": [
        "جولائی"
    ],
    "august": [
        "اگست"
    ],
    "september": [
        "ستمبر"
    ],
    "october": [
        "اکتوبر"
    ],
    "november": [
        "نومبر"
    ],
    "december": [
        "دسمبر"
    ],
    "monday": [
        "سوموار"
    ],
    "tuesday": [
        "منگل"
    ],
    "wednesday": [
        "بدھ"
    ],
    "thursday": [
        "جمعرات"
    ],
    "friday": [
        "جمعہ"
    ],
    "saturday": [
        "ہفتہ"
    ],
    "sunday": [
        "اتوار"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "سال"
    ],
    "month": [
        "مہینہ",
        "ماہ"
    ],
    "week": [
        "ہفتہ"
    ],
    "day": [
        "دن"
    ],
    "hour": [
        "گھنٹہ"
    ],
    "minute": [
        "منٹ"
    ],
    "second": [
        "سیکنڈ"
    ],
    "relative-type": {
        "1 year ago": [
            "گزشتہ سال"
        ],
        "0 year ago": [
            "اس سال"
        ],
        "in 1 year": [
            "اگلے سال"
        ],
        "1 month ago": [
            "پچھلے مہینہ"
        ],
        "0 month ago": [
            "اس مہینہ"
        ],
        "in 1 month": [
            "اگلے مہینہ"
        ],
        "1 week ago": [
            "پچھلے ہفتہ"
        ],
        "0 week ago": [
            "اس ہفتہ"
        ],
        "in 1 week": [
            "اگلے ہفتہ"
        ],
        "1 day ago": [
            "گزشتہ کل"
        ],
        "0 day ago": [
            "آج"
        ],
        "in 1 day": [
            "آئندہ کل"
        ],
        "0 hour ago": [
            "اس گھنٹے"
        ],
        "0 minute ago": [
            "اس منٹ"
        ],
        "0 second ago": [
            "اب"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) سال میں"
        ],
        "\\1 year ago": [
            "(\\d+) سال پہلے"
        ],
        "in \\1 month": [
            "(\\d+) مہینہ میں",
            "(\\d+) مہینے میں",
            "(\\d+) ماہ میں"
        ],
        "\\1 month ago": [
            "(\\d+) مہینہ پہلے",
            "(\\d+) مہینے پہلے",
            "(\\d+) ماہ قبل",
            "(\\d+) ماہ پہلے"
        ],
        "in \\1 week": [
            "(\\d+) ہفتہ میں",
            "(\\d+) ہفتے میں"
        ],
        "\\1 week ago": [
            "(\\d+) ہفتہ پہلے",
            "(\\d+) ہفتے پہلے"
        ],
        "in \\1 day": [
            "(\\d+) دن میں",
            "(\\d+) دنوں میں"
        ],
        "\\1 day ago": [
            "(\\d+) دن پہلے",
            "(\\d+) دنوں پہلے"
        ],
        "in \\1 hour": [
            "(\\d+) گھنٹہ میں",
            "(\\d+) گھنٹے میں",
            "(\\d+) گھنٹوں میں"
        ],
        "\\1 hour ago": [
            "(\\d+) گھنٹہ پہلے",
            "(\\d+) گھنٹے پہلے"
        ],
        "in \\1 minute": [
            "(\\d+) منٹ میں"
        ],
        "\\1 minute ago": [
            "(\\d+) منٹ پہلے"
        ],
        "in \\1 second": [
            "(\\d+) سیکنڈ میں"
        ],
        "\\1 second ago": [
            "(\\d+) سیکنڈ پہلے"
        ]
    },
    "locale_specific": {
        "ur-IN": {
            "name": "ur-IN",
            "monday": [
                "پیر"
            ],
            "relative-type": {
                "1 month ago": [
                    "گزشتہ ماہ"
                ],
                "0 month ago": [
                    "اس ماہ"
                ],
                "in 1 month": [
                    "اگلے ماہ"
                ],
                "1 week ago": [
                    "گزشتہ ہفتہ"
                ]
            },
            "relative-type-regex": {
                "in \\1 year": [
                    "(\\d+) سالوں میں"
                ],
                "\\1 year ago": [
                    "(\\d+) سالوں پہلے"
                ],
                "in \\1 week": [
                    "(\\d+) ہفتوں میں"
                ],
                "\\1 week ago": [
                    "(\\d+) ہفتہ قبل",
                    "(\\d+) ہفتے قبل"
                ],
                "\\1 day ago": [
                    "(\\d+) دن قبل"
                ],
                "\\1 hour ago": [
                    "(\\d+) گھنٹہ قبل",
                    "(\\d+) گھنٹے قبل"
                ],
                "\\1 minute ago": [
                    "(\\d+) منٹ قبل"
                ],
                "\\1 second ago": [
                    "(\\d+) سیکنڈ قبل"
                ]
            }
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}