/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.fibs.geotag.Geotag;

public final class Settings {
    private static Map<SETTING, List<SettingsListener>> listeners = new HashMap<SETTING, List<SettingsListener>>();
    public static final String KML_DEFAULT_ICON_URL = "http://maps.google.com/mapfiles/kml/pal4/icon46.png";
    public static final String GEONAMES_DEFAULT_URL = "api.geonames.org";
    public static final int GEONAMES_DEFAULT_RADIUS = 5;
    public static final int GEONAMES_DEFAULT_MAX_ROWS = 5;
    public static final int GEONAMES_MAX_MAX_ROWS = 50;
    public static final int GEONAMES_DEFAULT_WIKIPEDIA_ENTRIES = 3;
    public static final int GEONAMES_MAX_WIKIPEDIA_ENTRIES = 50;
    public static final int DEFAULT_THUMBNAIL_SIZE = 150;
    public static final int DEFAULT_CLICKS_TO_EDIT = 1;
    public static final String MAPS_API_2 = "2";
    public static final String MAPS_API_3 = "3";
    public static final String[] MAPS_API_VERSIONS = new String[]{"2", "3"};
    private static Preferences preferences = Preferences.userNodeForPackage(Geotag.class);

    private Settings() {
    }

    public static void addListener(SETTING setting, SettingsListener listener) {
        List<SettingsListener> listenerList = listeners.get((Object)setting);
        if (listenerList == null) {
            listenerList = new ArrayList<SettingsListener>();
            listeners.put(setting, listenerList);
        }
        listenerList.add(listener);
    }

    public static void removeListener(SETTING setting, SettingsListener listener) {
        List<SettingsListener> listenerList = listeners.get((Object)setting);
        if (listenerList != null) {
            listenerList.remove(listener);
        }
    }

    private static void notifyListeners(SETTING setting) {
        List<SettingsListener> listenerList = listeners.get((Object)setting);
        if (listenerList != null) {
            for (SettingsListener listener : listenerList) {
                listener.settingChanged(setting);
            }
        }
    }

    public static void flush() {
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static int get(SETTING key, int defaultValue) {
        return preferences.getInt(key.toString(), defaultValue);
    }

    public static void put(SETTING key, int value) {
        preferences.putInt(key.toString(), value);
        Settings.notifyListeners(key);
    }

    public static String get(SETTING key, String defaultValue) {
        return preferences.get(key.toString(), defaultValue);
    }

    public static void put(SETTING key, String value) {
        preferences.put(key.toString(), value);
        Settings.notifyListeners(key);
    }

    public static boolean get(SETTING key, boolean defaultValue) {
        return preferences.getBoolean(key.toString(), defaultValue);
    }

    public static void put(SETTING key, boolean value) {
        preferences.putBoolean(key.toString(), value);
        Settings.notifyListeners(key);
    }

    public static enum SETTING {
        MAIN_WINDOW_X,
        MAIN_WINDOW_Y,
        MAIN_WINDOW_HEIGHT,
        MAIN_WINDOW_WIDHTH,
        PREVIEW_HEIGHT,
        THUMBNAIL_SIZE,
        TUMBNAILS_IN_TOOLTIPS,
        LAST_FILE_OPENED,
        LAST_DIRECTORY_OPENED,
        LAST_FILE_FILTER_SELECTED,
        LAST_GPX_FILE_OPENED,
        EXIFTOOL_PATH,
        EXIFTOOL_ARGUMENTS,
        GPSBABEL_PATH,
        GPSBABEL_PROTOCOL,
        GPSBABEL_DEVICE,
        DCRAW_PATH,
        XMP_FILES_ONLY,
        CREATE_BACKUPS,
        IMAGE_NAME_WIDTH,
        GPS_DATE_WIDTH,
        TIME_OFFSET_WIDTH,
        CAMERA_DATE_WIDTH,
        LATITUDE_WIDTH,
        LONGITUDE_WIDTH,
        ALTITUDE_WIDTH,
        DIRECTION_WIDTH,
        LOCATION_NAME_WIDTH,
        CITY_NAME_WIDTH,
        PROVINCE_NAME_WIDTH,
        COUNTRY_NAME_WIDTH,
        USER_COMMENT_WIDTH,
        IMAGE_NAME_POSITION,
        GPS_DATE_POSITION,
        TIME_OFFSET_POSITION,
        CAMERA_DATE_POSITION,
        LATITUDE_POSITION,
        LONGITUDE_POSITION,
        ALTITUDE_POSITION,
        DIRECTION_POSITION,
        LOCATION_NAME_POSITION,
        CITY_NAME_POSITION,
        PROVINCE_NAME_POSITION,
        COUNTRY_NAME_POSITION,
        USER_COMMENT_POSITION,
        FONT,
        LAST_GOOGLE_MAPS_ZOOM_LEVEL,
        LAST_GOOGLE_MAPS_MAP_TYPE,
        LAST_GOOGLE_MAPS_LATITUDE,
        LAST_GOOGLE_MAPS_LONGITUDE,
        GOOGLE_MAP_SHOW_TRACKS,
        GOOGLE_MAP_SHOW_WIKIPEDIA,
        GOOGLE_MAPS_MOUSE_WHEEL_ZOOM,
        GOOGLE_MAPS_MENU_OPEN,
        CHECK_FOR_NEW_VERSION,
        BROWSER,
        GOOGLEEARTH_LAST_FILE_SAVED,
        GOOGLE_EARTH_PATH,
        KMZ_STORE_THUMBNAILS,
        KML_IMAGE_PATH,
        KML_ICON_URL,
        KML_DESCRIPTION_HEADER,
        KML_DESCRIPTION_FOOTER,
        GEONAMES_URL,
        GEONAMES_USE_RADIUS,
        GEONAMES_RADIUS,
        GEONAMES_MAX_ROWS,
        GEONAMES_USE_WIKIPEDIA,
        GEONAMES_WIKIPEDIA_ENTRIES,
        GEONAMES_OVERRIDE_LANGUAGE,
        GEONAMES_LANGUAGE,
        DISTANCE_UNIT,
        ALTITUDE_UNIT,
        COORDINATES_FORMAT,
        PROXY_TYPE,
        PROXY_ADDRESS,
        CLIPBOARD_ENABLED,
        CLIPBOARD_LATITUDE_FIRST,
        CLIPBOARD_NORTH,
        CLIPBOARD_SOUTH,
        CLIPBOARD_EAST,
        CLIPBOARD_WEST,
        LAST_USED_TIMEZONE,
        CLICKS_TO_EDIT,
        FILE_TYPES_SUPPORTED_BY_XMP;


        public String toString() {
            return this.name().toLowerCase().replace('_', '.');
        }
    }

    public static interface SettingsListener {
        public void settingChanged(SETTING var1);
    }
}

