/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.IPrimitiveAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class ExportRelationToGpxAction
extends GpxExportAction
implements IPrimitiveAction {
    protected final Set<Mode> mode;
    protected Collection<Relation> relations = Collections.emptySet();

    public ExportRelationToGpxAction() {
        this(EnumSet.of(Mode.FROM_FIRST_MEMBER, Mode.TO_FILE));
    }

    public ExportRelationToGpxAction(Set<Mode> mode) {
        super(ExportRelationToGpxAction.name(mode), mode.contains((Object)Mode.TO_FILE) ? "exportgpx" : "dialogs/layerlist", ExportRelationToGpxAction.tooltip(mode), null, false, null, false);
        this.setHelpId(HelpUtil.ht("/Action/ExportRelationToGpx"));
        this.mode = mode;
    }

    private static String name(Set<Mode> mode) {
        if (mode.contains((Object)Mode.TO_FILE)) {
            if (mode.contains((Object)Mode.FROM_FIRST_MEMBER)) {
                return I18n.tr("Export GPX file starting from first member", new Object[0]);
            }
            return I18n.tr("Export GPX file starting from last member", new Object[0]);
        }
        if (mode.contains((Object)Mode.FROM_FIRST_MEMBER)) {
            return I18n.tr("Convert to GPX layer starting from first member", new Object[0]);
        }
        return I18n.tr("Convert to GPX layer starting from last member", new Object[0]);
    }

    private static String tooltip(Set<Mode> mode) {
        if (mode.contains((Object)Mode.FROM_FIRST_MEMBER)) {
            return I18n.tr("Flatten this relation to a single gpx track recursively, starting with the first member, successively continuing to the last.", new Object[0]);
        }
        return I18n.tr("Flatten this relation to a single gpx track recursively, starting with the last member, successively continuing to the first.", new Object[0]);
    }

    @Override
    protected Layer getLayer() {
        String layerName;
        ArrayList<RelationMember> flat = new ArrayList<RelationMember>();
        ArrayList init = new ArrayList();
        this.relations.forEach(t -> init.add(new RelationMember("", (OsmPrimitive)t)));
        Stack stack = new Stack();
        stack.push(this.modeAwareIterator(init));
        ArrayList<Relation> relsFound = new ArrayList<Relation>();
        block0: do {
            Iterator i;
            if (!(i = (Iterator)stack.peek()).hasNext()) {
                stack.pop();
            }
            while (i.hasNext()) {
                RelationMember m = (RelationMember)i.next();
                if (m.isRelation() && !m.getRelation().isIncomplete()) {
                    List<RelationMember> members = m.getRelation().getMembers();
                    stack.push(this.modeAwareIterator(members));
                    relsFound.add(m.getRelation());
                    continue block0;
                }
                if (!m.isWay()) continue;
                flat.add(m);
            }
        } while (!stack.isEmpty());
        GpxData gpxData = new GpxData();
        long time = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - 86400L;
        if (!flat.isEmpty()) {
            HashMap<String, Object> trkAttr = new HashMap<String, Object>();
            ArrayList<Collection<WayPoint>> trk = new ArrayList<Collection<WayPoint>>();
            ArrayList<WayPoint> trkseg = new ArrayList<WayPoint>();
            trk.add(trkseg);
            List<WayConnectionType> wct = new WayConnectionTypeCalculator().updateLinks(flat);
            HashMap<String, Integer> names = new HashMap<String, Integer>();
            for (int i = 0; i < flat.size(); ++i) {
                WayConnectionType wayConnectionType = wct.get(i);
                if (wayConnectionType.isOnewayLoopBackwardPart || wayConnectionType.direction.isRoundabout()) continue;
                if (!wayConnectionType.linkPrev && !trkseg.isEmpty()) {
                    gpxData.addTrack(new ImmutableGpxTrack((Collection<Collection<WayPoint>>)trk, (Map<String, Object>)trkAttr));
                    trkAttr.clear();
                    trk.clear();
                    trkseg.clear();
                    trk.add(trkseg);
                }
                if (trkAttr.isEmpty()) {
                    ((RelationMember)flat.get(i)).getWay().referrers(Relation.class).filter(relsFound::contains).findFirst().ifPresent(r -> {
                        trkAttr.put("name", r.getName() != null ? r.getName() : Long.valueOf(r.getId()));
                        trkAttr.put("desc", I18n.tr("based on osm route relation data, timestamps are synthetic", new Object[0]));
                    });
                    GpxData.ensureUniqueName(trkAttr, names);
                }
                List<Node> ln = ((RelationMember)flat.get(i)).getWay().getNodes();
                if (wayConnectionType.direction == WayConnectionType.Direction.BACKWARD) {
                    Collections.reverse(ln);
                }
                for (Node n : ln) {
                    trkseg.add(OsmDataLayer.nodeToWayPoint(n, TimeUnit.SECONDS.toMillis(time)));
                    ++time;
                }
            }
            gpxData.addTrack(new ImmutableGpxTrack((Collection<Collection<WayPoint>>)trk, (Map<String, Object>)trkAttr));
            String lprefix = this.relations.iterator().next().getName();
            if (lprefix == null || this.relations.size() > 1) {
                lprefix = I18n.tr("Selected Relations", new Object[0]);
            }
            layerName = I18n.tr("{0} (GPX export)", lprefix);
        } else {
            layerName = "";
        }
        return new GpxLayer(gpxData, layerName, true);
    }

    private <T> Iterator<T> modeAwareIterator(List<T> list) {
        return this.mode.contains((Object)Mode.FROM_FIRST_MEMBER) ? list.iterator() : new LinkedList<T>(list).descendingIterator();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mode.contains((Object)Mode.TO_LAYER)) {
            MainApplication.getLayerManager().addLayer(this.getLayer());
        }
        if (this.mode.contains((Object)Mode.TO_FILE)) {
            super.actionPerformed(e);
        }
    }

    @Override
    public void setPrimitives(Collection<? extends IPrimitive> primitives) {
        this.relations = Collections.emptySet();
        if (primitives != null && !primitives.isEmpty()) {
            this.relations = new SubclassFilteredCollection<IPrimitive, Relation>(primitives, r -> r instanceof Relation && r.hasTag("type", Arrays.asList("route", "superroute")));
        }
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!this.relations.isEmpty());
    }

    public static enum Mode {
        FROM_FIRST_MEMBER,
        FROM_LAST_MEMBER,
        TO_LAYER,
        TO_FILE;

    }
}

