/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.painter.AbstractPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXMapLayer
extends AbstractPainter<JXMapViewer> {
    private static final Logger LOG = Logger.getLogger(JXMapLayer.class.getName());
    private Image loadingImage;
    private HashMap<String, Tile> currentTiles = new HashMap();
    private HashMap<String, Point> tileWindowCoords = new HashMap();
    private int prevWidth = 0;
    private int prevHeight = 0;
    private Rectangle prevViewPort = new Rectangle();
    private volatile boolean needToCalcMapTiles = false;
    private volatile int currentTilesZoom = -10;
    private Rectangle currentTilesBounds = new Rectangle(0, 0, 0, 0);
    private LinkedList<Tile> requiredTiles;
    private final Integer requiredTilesMutex = new Integer(5);
    private TileImageChangeListener tileImageChangeListener = new TileImageChangeListener();
    private volatile boolean ignoreImageUpdates = false;

    public JXMapLayer() {
        this.setCacheable(false);
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("mapviewer/resources/loading.png");
            this.setLoadingImage(ImageIO.read(url));
        }
        catch (Throwable ex) {
            BufferedImage img = new BufferedImage(16, 16, 2);
            Graphics2D g2 = img.createGraphics();
            g2.setColor(Color.black);
            g2.fillRect(0, 0, 16, 16);
            g2.dispose();
            this.setLoadingImage(img);
        }
    }

    protected void doPaint(Graphics2D g, JXMapViewer component, int width, int height) {
        if (this.prevWidth != width || this.prevHeight != height || !this.prevViewPort.equals(component.getViewportBounds())) {
            this.prevWidth = width;
            this.prevHeight = height;
            this.prevViewPort = new Rectangle(component.getViewportBounds());
            this.needToCalcMapTiles = true;
        }
        this.drawMapTiles(g, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void drawMapTiles(Graphics g, JXMapViewer mapViewer) {
        try {
            boolean hasTiles;
            Rectangle viewportBounds = mapViewer.getViewportBounds();
            int zoom = mapViewer.getZoom();
            if (!mapViewer.isDrawMapTiles()) {
                return;
            }
            if (this.needToCalcMapTiles) {
                this.calcRequiredTiles(mapViewer.getTileFactory(), viewportBounds, zoom, mapViewer.getUniqueViewName());
            }
            Integer n = this.requiredTilesMutex;
            synchronized (n) {
                hasTiles = this.requiredTiles != null;
            }
            if (hasTiles) {
                this.requestMapTiles(mapViewer.getTileFactory(), mapViewer.getUniqueViewName());
            }
            int tileSize = mapViewer.getTileFactory().getTileSize(zoom);
            for (Tile tile : this.currentTiles.values()) {
                Point point;
                Integer n2 = this.requiredTilesMutex;
                synchronized (n2) {
                    point = this.tileWindowCoords.get(tile.getKey());
                }
                if (point == null) continue;
                BufferedImage tileImage = tile.getImage();
                if (tileImage == null) {
                    if (mapViewer.isOpaque()) {
                        g.setColor(mapViewer.getBackground());
                        g.fillRect(point.x, point.y, tileSize, tileSize);
                    }
                } else {
                    g.drawImage(tileImage, point.x, point.y, null);
                }
                if (!mapViewer.isDrawTileBorders()) continue;
                g.setColor(Color.black);
                g.drawRect(point.x, point.y, tileSize, tileSize);
                g.drawRect(point.x + tileSize / 2 - 5, point.y + tileSize / 2 - 5, 10, 10);
                g.setColor(Color.white);
                g.drawRect(point.x + 1, point.y + 1, tileSize, tileSize);
                String text = tile.getX() + ", " + tile.getY() + ", " + zoom;
                g.setColor(Color.black);
                g.drawString(text, point.x + 10, point.y + 30);
                g.drawString(text, point.x + 10 + 2, point.y + 30 + 2);
                g.setColor(Color.white);
                g.drawString(text, point.x + 10 + 1, point.y + 30 + 1);
            }
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
            this.setDirty(true);
        }
    }

    public Image getLoadingImage() {
        return this.loadingImage;
    }

    public void setLoadingImage(Image loadingImage) {
        this.loadingImage = loadingImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void calcRequiredTiles(TileFactory tileFactory, Rectangle viewportBounds, int zoom, String viewName) {
        block16: {
            try {
                int tileSize = tileFactory.getTileSize(zoom);
                boolean sameTiles = false;
                this.needToCalcMapTiles = false;
                Integer n = this.requiredTilesMutex;
                synchronized (n) {
                    if (zoom == this.currentTilesZoom && this.currentTilesBounds.contains(viewportBounds)) {
                        sameTiles = true;
                    }
                    this.tileWindowCoords.clear();
                }
                this.ignoreImageUpdates = true;
                int topLeftTile_MapTileIndex_X = viewportBounds.x / tileSize;
                int topLeftTile_MapTileIndex_Y = viewportBounds.y / tileSize;
                int numWide = (viewportBounds.x + viewportBounds.width - topLeftTile_MapTileIndex_X * tileSize) / tileSize + 1;
                int numHigh = (viewportBounds.y + viewportBounds.height - topLeftTile_MapTileIndex_Y * tileSize) / tileSize + 1;
                this.currentTilesBounds = new Rectangle(topLeftTile_MapTileIndex_X * tileSize, topLeftTile_MapTileIndex_Y * tileSize, numWide * tileSize, numHigh * tileSize);
                LinkedList<Tile> newRequiredTiles = new LinkedList<Tile>();
                for (int currentTile_WindowTileIndex_X = 0; currentTile_WindowTileIndex_X < numWide; ++currentTile_WindowTileIndex_X) {
                    for (int currentTile_WindowTileIndex_Y = 0; currentTile_WindowTileIndex_Y < numHigh; ++currentTile_WindowTileIndex_Y) {
                        Tile tile;
                        int currentTile_MapTileIndex_X = currentTile_WindowTileIndex_X + topLeftTile_MapTileIndex_X;
                        int currentTile_MapTileIndex_Y = currentTile_WindowTileIndex_Y + topLeftTile_MapTileIndex_Y;
                        int currentTile_WindowCoordsX = currentTile_MapTileIndex_X * tileSize - viewportBounds.x;
                        int currentTile_WindowCoordsY = currentTile_MapTileIndex_Y * tileSize - viewportBounds.y;
                        Integer n2 = this.requiredTilesMutex;
                        synchronized (n2) {
                            tile = this.currentTiles.get(tileFactory.getTileKey(currentTile_MapTileIndex_X, currentTile_MapTileIndex_Y, zoom));
                        }
                        if (tile == null) {
                            tile = tileFactory.getTileInstance(currentTile_MapTileIndex_X, currentTile_MapTileIndex_Y, zoom);
                            tile.addPropertyChangeListener("image", this.tileImageChangeListener);
                        }
                        newRequiredTiles.add(tile);
                        Point pt = new Point(currentTile_WindowCoordsX, currentTile_WindowCoordsY);
                        this.tileWindowCoords.put(tile.getKey(), pt);
                    }
                }
                if (sameTiles) break block16;
                Integer n3 = this.requiredTilesMutex;
                synchronized (n3) {
                    this.currentTiles.clear();
                    for (Tile tile : newRequiredTiles) {
                        this.currentTiles.put(tile.getKey(), tile);
                    }
                    this.requiredTiles = newRequiredTiles;
                    this.currentTilesZoom = zoom;
                }
                this.requestMapTiles(tileFactory, viewName);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "During update of needed tiles", e);
            }
        }
        this.ignoreImageUpdates = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMapTiles(TileFactory factory, String viewName) {
        Integer n = this.requiredTilesMutex;
        synchronized (n) {
            if (this.requiredTiles != null) {
                factory.setRequiredTiles(this.requiredTiles, viewName);
                this.requiredTiles = null;
            }
        }
    }

    static {
        LOG.setLevel(Level.SEVERE);
    }

    private final class TileImageChangeListener
    implements PropertyChangeListener {
        private TileImageChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!JXMapLayer.this.ignoreImageUpdates) {
                Tile tile = (Tile)((Object)evt.getSource());
                if (!JXMapLayer.this.currentTiles.containsKey(tile.getKey())) {
                    return;
                }
                JXMapLayer.this.setDirty(true);
            }
        }
    }
}

