/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.ControlFlowProcessor;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.PropertyImportedFromObject;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class PseudocodeUtil {
    @NotNull
    public static Pseudocode generatePseudocode(@NotNull KtDeclaration declaration, final @NotNull BindingContext bindingContext) {
        BindingTrace mockTrace = new BindingTrace(){

            @Override
            @NotNull
            public BindingContext getBindingContext() {
                return bindingContext;
            }

            @Override
            public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
            }

            @Override
            public <K> void record(WritableSlice<K, Boolean> slice, K key) {
            }

            @Override
            public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
                return bindingContext.get(slice, key);
            }

            @Override
            @NotNull
            public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
                return bindingContext.getKeys(slice);
            }

            @Override
            @Nullable
            public KotlinType getType(@NotNull KtExpression expression2) {
                return bindingContext.getType(expression2);
            }

            @Override
            public void recordType(@NotNull KtExpression expression2, @Nullable KotlinType type2) {
            }

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
            }

            @Override
            public boolean wantsDiagnostics() {
                return false;
            }
        };
        return new ControlFlowProcessor(mockTrace, null).generatePseudocode(declaration);
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorFromReference(@NotNull Instruction instruction, @NotNull BindingContext bindingContext) {
        if (instruction instanceof AccessValueInstruction) {
            KtElement element = ((AccessValueInstruction)instruction).getElement();
            if (element instanceof KtDeclaration) {
                return null;
            }
            VariableDescriptor descriptor2 = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, bindingContext);
            if (descriptor2 instanceof PropertyImportedFromObject) {
                return (VariableDescriptor)((PropertyImportedFromObject)descriptor2).getCallableFromObject();
            }
            return descriptor2;
        }
        return null;
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorIfAny(@NotNull Instruction instruction, @NotNull BindingContext bindingContext) {
        if (instruction instanceof VariableDeclarationInstruction) {
            KtDeclaration declaration = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
            return BindingContextUtils.variableDescriptorForDeclaration(bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration));
        }
        if (instruction instanceof AccessValueInstruction) {
            AccessTarget target = ((AccessValueInstruction)instruction).getTarget();
            if (target instanceof AccessTarget.Declaration) {
                return ((AccessTarget.Declaration)target).getDescriptor();
            }
            if (target instanceof AccessTarget.Call) {
                return BindingContextUtils.variableDescriptorForDeclaration(((AccessTarget.Call)target).getResolvedCall().getResultingDescriptor());
            }
        }
        return null;
    }

    public static boolean isThisOrNoDispatchReceiver(@NotNull AccessValueInstruction instruction, @NotNull BindingContext bindingContext) {
        if (instruction.getReceiverValues().isEmpty()) {
            return true;
        }
        AccessTarget accessTarget = instruction.getTarget();
        if (accessTarget instanceof AccessTarget.BlackBox) {
            return false;
        }
        assert (accessTarget instanceof AccessTarget.Call) : "AccessTarget.Declaration has no receivers and it's not BlackBox, so it should be Call";
        ResolvedCall<?> accessResolvedCall = ((AccessTarget.Call)accessTarget).getResolvedCall();
        return ResolvedCallUtilKt.hasThisOrNoDispatchReceiver(accessResolvedCall, bindingContext);
    }
}

