/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.internal;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.configuration.internal.UserCodeApplicationId;

public class DefaultUserCodeApplicationContext
implements UserCodeApplicationContext {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final ThreadLocal<Deque<UserCodeApplicationId>> stackThreadLocal = new ThreadLocal<Deque<UserCodeApplicationId>>(){

        @Override
        protected Deque<UserCodeApplicationId> initialValue() {
            return new ArrayDeque<UserCodeApplicationId>();
        }
    };

    @Override
    @Nullable
    public UserCodeApplicationId current() {
        return this.stackThreadLocal.get().peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Action<? super UserCodeApplicationId> action) {
        Deque<UserCodeApplicationId> stack = this.stackThreadLocal.get();
        UserCodeApplicationId id = this.push(stack);
        try {
            action.execute((Object)id);
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reapply(UserCodeApplicationId id, Runnable runnable) {
        Deque<UserCodeApplicationId> stack = this.stackThreadLocal.get();
        stack.push(id);
        try {
            runnable.run();
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public <T> Action<T> decorateWithCurrent(final Action<T> action) {
        final UserCodeApplicationId id = this.current();
        if (id == null) {
            return action;
        }
        return new Action<T>(){

            public void execute(T t) {
                Deque stack = (Deque)DefaultUserCodeApplicationContext.this.stackThreadLocal.get();
                stack.push(id);
                try {
                    action.execute(t);
                }
                finally {
                    stack.pop();
                }
            }
        };
    }

    @VisibleForTesting
    UserCodeApplicationId push() {
        return this.push(this.stackThreadLocal.get());
    }

    @VisibleForTesting
    void pop() {
        this.stackThreadLocal.get().pop();
    }

    private UserCodeApplicationId push(Deque<UserCodeApplicationId> stack) {
        UserCodeApplicationId id = DefaultUserCodeApplicationContext.id();
        stack.push(id);
        return id;
    }

    private static UserCodeApplicationId id() {
        return new UserCodeApplicationId(COUNTER.incrementAndGet());
    }
}

