/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.PBEKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashSet;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;

abstract class PBEKeyFactory
extends SecretKeyFactorySpi {
    private String type;
    private static HashSet<String> validTypes = new HashSet(17);

    private PBEKeyFactory(String keytype) {
        this.type = keytype;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        return new PBEKey((PBEKeySpec)keySpec, this.type);
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpecCl) throws InvalidKeySpecException {
        if (key instanceof SecretKey && validTypes.contains(key.getAlgorithm().toUpperCase()) && key.getFormat().equalsIgnoreCase("RAW")) {
            if (keySpecCl != null && PBEKeySpec.class.isAssignableFrom(keySpecCl)) {
                byte[] passwdBytes = key.getEncoded();
                char[] passwdChars = new char[passwdBytes.length];
                for (int i = 0; i < passwdChars.length; ++i) {
                    passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
                }
                PBEKeySpec ret = new PBEKeySpec(passwdChars);
                Arrays.fill(passwdChars, ' ');
                Arrays.fill(passwdBytes, (byte)0);
                return ret;
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (key != null && validTypes.contains(key.getAlgorithm().toUpperCase()) && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof PBEKey) {
                    return key;
                }
                PBEKeySpec pbeKeySpec = (PBEKeySpec)this.engineGetKeySpec(key, (Class)PBEKeySpec.class);
                return this.engineGenerateSecret(pbeKeySpec);
            }
            throw new InvalidKeyException("Invalid key format/algorithm");
        }
        catch (InvalidKeySpecException ikse) {
            throw new InvalidKeyException("Cannot translate key: " + ikse.getMessage());
        }
    }

    static {
        validTypes.add("PBEWithMD5AndDES".toUpperCase());
        validTypes.add("PBEWithSHA1AndDESede".toUpperCase());
        validTypes.add("PBEWithSHA1AndRC2_40".toUpperCase());
        validTypes.add("PBEWithSHA1AndRC2_128".toUpperCase());
        validTypes.add("PBEWithSHA1AndRC4_40".toUpperCase());
        validTypes.add("PBEWithSHA1AndRC4_128".toUpperCase());
        validTypes.add("PBEWithMD5AndTripleDES".toUpperCase());
        validTypes.add("PBEWithHmacSHA1AndAES_128".toUpperCase());
        validTypes.add("PBEWithHmacSHA224AndAES_128".toUpperCase());
        validTypes.add("PBEWithHmacSHA256AndAES_128".toUpperCase());
        validTypes.add("PBEWithHmacSHA384AndAES_128".toUpperCase());
        validTypes.add("PBEWithHmacSHA512AndAES_128".toUpperCase());
        validTypes.add("PBEWithHmacSHA1AndAES_256".toUpperCase());
        validTypes.add("PBEWithHmacSHA224AndAES_256".toUpperCase());
        validTypes.add("PBEWithHmacSHA256AndAES_256".toUpperCase());
        validTypes.add("PBEWithHmacSHA384AndAES_256".toUpperCase());
        validTypes.add("PBEWithHmacSHA512AndAES_256".toUpperCase());
    }

    public static final class PBEWithHmacSHA512AndAES_256
    extends PBEKeyFactory {
        public PBEWithHmacSHA512AndAES_256() {
            super("PBEWithHmacSHA512AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA384AndAES_256
    extends PBEKeyFactory {
        public PBEWithHmacSHA384AndAES_256() {
            super("PBEWithHmacSHA384AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA256AndAES_256
    extends PBEKeyFactory {
        public PBEWithHmacSHA256AndAES_256() {
            super("PBEWithHmacSHA256AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA224AndAES_256
    extends PBEKeyFactory {
        public PBEWithHmacSHA224AndAES_256() {
            super("PBEWithHmacSHA224AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA1AndAES_256
    extends PBEKeyFactory {
        public PBEWithHmacSHA1AndAES_256() {
            super("PBEWithHmacSHA1AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA512AndAES_128
    extends PBEKeyFactory {
        public PBEWithHmacSHA512AndAES_128() {
            super("PBEWithHmacSHA512AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA384AndAES_128
    extends PBEKeyFactory {
        public PBEWithHmacSHA384AndAES_128() {
            super("PBEWithHmacSHA384AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA256AndAES_128
    extends PBEKeyFactory {
        public PBEWithHmacSHA256AndAES_128() {
            super("PBEWithHmacSHA256AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA224AndAES_128
    extends PBEKeyFactory {
        public PBEWithHmacSHA224AndAES_128() {
            super("PBEWithHmacSHA224AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA1AndAES_128
    extends PBEKeyFactory {
        public PBEWithHmacSHA1AndAES_128() {
            super("PBEWithHmacSHA1AndAES_128");
        }
    }

    public static final class PBEWithMD5AndTripleDES
    extends PBEKeyFactory {
        public PBEWithMD5AndTripleDES() {
            super("PBEWithMD5AndTripleDES");
        }
    }

    public static final class PBEWithSHA1AndRC4_128
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC4_128() {
            super("PBEWithSHA1AndRC4_128");
        }
    }

    public static final class PBEWithSHA1AndRC4_40
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC4_40() {
            super("PBEWithSHA1AndRC4_40");
        }
    }

    public static final class PBEWithSHA1AndRC2_128
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC2_128() {
            super("PBEWithSHA1AndRC2_128");
        }
    }

    public static final class PBEWithSHA1AndRC2_40
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC2_40() {
            super("PBEWithSHA1AndRC2_40");
        }
    }

    public static final class PBEWithSHA1AndDESede
    extends PBEKeyFactory {
        public PBEWithSHA1AndDESede() {
            super("PBEWithSHA1AndDESede");
        }
    }

    public static final class PBEWithMD5AndDES
    extends PBEKeyFactory {
        public PBEWithMD5AndDES() {
            super("PBEWithMD5AndDES");
        }
    }
}

