Object.assign(window.search, {"doc_urls":["what-is-rustc.html#what-is-rustc","what-is-rustc.html#basic-usage","command-line-arguments.html#command-line-arguments","command-line-arguments.html#-h--help-get-help","command-line-arguments.html#--cfg-configure-the-compilation-environment","command-line-arguments.html#-l-add-a-directory-to-the-library-search-path","command-line-arguments.html#-l-link-the-generated-crate-to-a-native-library","command-line-arguments.html#--crate-type-a-list-of-types-of-crates-for-the-compiler-to-emit","command-line-arguments.html#--crate-name-specify-the-name-of-the-crate-being-built","command-line-arguments.html#--edition-specify-the-edition-to-use","command-line-arguments.html#--emit-specifies-the-types-of-output-files-to-generate","command-line-arguments.html#--print-print-compiler-information","command-line-arguments.html#-g-include-debug-information","command-line-arguments.html#-o-optimize-your-code","command-line-arguments.html#-o-filename-of-the-output","command-line-arguments.html#--out-dir-directory-to-write-the-output-in","command-line-arguments.html#--explain-provide-a-detailed-explanation-of-an-error-message","command-line-arguments.html#--test-build-a-test-harness","command-line-arguments.html#--target-select-a-target-triple-to-build","command-line-arguments.html#-w-set-lint-warnings","command-line-arguments.html#-a-set-lint-allowed","command-line-arguments.html#-d-set-lint-denied","command-line-arguments.html#-f-set-lint-forbidden","command-line-arguments.html#-z-set-unstable-options","command-line-arguments.html#--cap-lints-set-the-most-restrictive-lint-level","command-line-arguments.html#-c--codegen-code-generation-options","command-line-arguments.html#-v--version-print-a-version","command-line-arguments.html#-v--verbose-use-verbose-output","command-line-arguments.html#--extern-specify-where-an-external-library-is-located","command-line-arguments.html#--sysroot-override-the-system-root","command-line-arguments.html#--error-format-control-how-errors-are-produced","command-line-arguments.html#--color-configure-coloring-of-output","command-line-arguments.html#--remap-path-prefix-remap-source-names-in-output","command-line-arguments.html#--json-configure-json-messages-printed-by-the-compiler","lints/index.html#lints","lints/levels.html#lint-levels","lints/levels.html#allow","lints/levels.html#warn","lints/levels.html#deny","lints/levels.html#forbid","lints/levels.html#configuring-warning-levels","lints/levels.html#via-compiler-flag","lints/levels.html#via-an-attribute","lints/levels.html#capping-lints","lints/groups.html#lint-groups","lints/listing/index.html#lint-listing","lints/listing/allowed-by-default.html#allowed-by-default-lints","lints/listing/allowed-by-default.html#anonymous-parameters","lints/listing/allowed-by-default.html#bare-trait-object","lints/listing/allowed-by-default.html#box-pointers","lints/listing/allowed-by-default.html#elided-lifetime-in-path","lints/listing/allowed-by-default.html#missing-copy-implementations","lints/listing/allowed-by-default.html#missing-debug-implementations","lints/listing/allowed-by-default.html#missing-docs","lints/listing/allowed-by-default.html#single-use-lifetime","lints/listing/allowed-by-default.html#trivial-casts","lints/listing/allowed-by-default.html#trivial-numeric-casts","lints/listing/allowed-by-default.html#unreachable-pub","lints/listing/allowed-by-default.html#unsafe-code","lints/listing/allowed-by-default.html#unstable-features","lints/listing/allowed-by-default.html#unused-extern-crates","lints/listing/allowed-by-default.html#unused-import-braces","lints/listing/allowed-by-default.html#unused-qualifications","lints/listing/allowed-by-default.html#unused-results","lints/listing/allowed-by-default.html#variant-size-differences","lints/listing/warn-by-default.html#warn-by-default-lints","lints/listing/warn-by-default.html#const-err","lints/listing/warn-by-default.html#dead-code","lints/listing/warn-by-default.html#deprecated","lints/listing/warn-by-default.html#illegal-floating-point-literal-pattern","lints/listing/warn-by-default.html#improper-ctypes","lints/listing/warn-by-default.html#late-bound-lifetime-arguments","lints/listing/warn-by-default.html#non-camel-case-types","lints/listing/warn-by-default.html#non-shorthand-field-patterns","lints/listing/warn-by-default.html#non-snake-case","lints/listing/warn-by-default.html#non-upper-case-globals","lints/listing/warn-by-default.html#no-mangle-generic-items","lints/listing/warn-by-default.html#path-statements","lints/listing/warn-by-default.html#patterns-in-fns-without-body","lints/listing/warn-by-default.html#plugin-as-library","lints/listing/warn-by-default.html#private-in-public","lints/listing/warn-by-default.html#private-no-mangle-fns","lints/listing/warn-by-default.html#private-no-mangle-statics","lints/listing/warn-by-default.html#renamed-and-removed-lints","lints/listing/warn-by-default.html#safe-packed-borrows","lints/listing/warn-by-default.html#stable-features","lints/listing/warn-by-default.html#type-alias-bounds","lints/listing/warn-by-default.html#tyvar-behind-raw-pointer","lints/listing/warn-by-default.html#unconditional-recursion","lints/listing/warn-by-default.html#unions-with-drop-fields","lints/listing/warn-by-default.html#unknown-lints","lints/listing/warn-by-default.html#unreachable-code","lints/listing/warn-by-default.html#unreachable-patterns","lints/listing/warn-by-default.html#unstable-name-collision","lints/listing/warn-by-default.html#unused-allocation","lints/listing/warn-by-default.html#unused-assignments","lints/listing/warn-by-default.html#unused-attributes","lints/listing/warn-by-default.html#unused-comparisons","lints/listing/warn-by-default.html#unused-doc-comment","lints/listing/warn-by-default.html#unused-features","lints/listing/warn-by-default.html#unused-imports","lints/listing/warn-by-default.html#unused-macros","lints/listing/warn-by-default.html#unused-must-use","lints/listing/warn-by-default.html#unused-mut","lints/listing/warn-by-default.html#unused-parens","lints/listing/warn-by-default.html#unused-unsafe","lints/listing/warn-by-default.html#unused-variables","lints/listing/warn-by-default.html#warnings","lints/listing/warn-by-default.html#while-true","lints/listing/deny-by-default.html#deny-by-default-lints","lints/listing/deny-by-default.html#exceeding-bitshifts","lints/listing/deny-by-default.html#invalid-type-param-default","lints/listing/deny-by-default.html#legacy-constructor-visibility","lints/listing/deny-by-default.html#legacy-directory-ownership","lints/listing/deny-by-default.html#missing-fragment-specifier","lints/listing/deny-by-default.html#mutable-transmutes","lints/listing/deny-by-default.html#no-mangle-const-items","lints/listing/deny-by-default.html#overflowing-literals","lints/listing/deny-by-default.html#parenthesized-params-in-types-and-modules","lints/listing/deny-by-default.html#pub-use-of-private-extern-crate","lints/listing/deny-by-default.html#safe-extern-statics","lints/listing/deny-by-default.html#unknown-crate-types","codegen-options/index.html#codegen-options","codegen-options/index.html#ar","codegen-options/index.html#linker","codegen-options/index.html#link-argval","codegen-options/index.html#link-args","codegen-options/index.html#linker-flavor","codegen-options/index.html#link-dead-code","codegen-options/index.html#lto","codegen-options/index.html#target-cpu","codegen-options/index.html#target-feature","codegen-options/index.html#passes","codegen-options/index.html#llvm-args","codegen-options/index.html#save-temps","codegen-options/index.html#rpath","codegen-options/index.html#overflow-checks","codegen-options/index.html#no-prepopulate-passes","codegen-options/index.html#no-vectorize-loops","codegen-options/index.html#no-vectorize-slp","codegen-options/index.html#soft-float","codegen-options/index.html#prefer-dynamic","codegen-options/index.html#no-integrated-as","codegen-options/index.html#no-redzone","codegen-options/index.html#relocation-model","codegen-options/index.html#code-modelval","codegen-options/index.html#metadata","codegen-options/index.html#extra-filename","codegen-options/index.html#codegen-units","codegen-options/index.html#remark","codegen-options/index.html#no-stack-check","codegen-options/index.html#debuginfo","codegen-options/index.html#opt-level","codegen-options/index.html#debug-assertions","codegen-options/index.html#inline-threshold","codegen-options/index.html#panic","codegen-options/index.html#incremental","codegen-options/index.html#profile-generate","codegen-options/index.html#profile-use","targets/index.html#targets","targets/built-in.html#built-in-targets","targets/custom.html#custom-targets","profile-guided-optimization.html#profile-guided-optimization","profile-guided-optimization.html#what-is-profiled-guided-optimization","profile-guided-optimization.html#usage","profile-guided-optimization.html#a-complete-cargo-workflow","profile-guided-optimization.html#further-reading","linker-plugin-lto.html#linker-plugin-lto","linker-plugin-lto.html#usage","linker-plugin-lto.html#rust-staticlib-as-dependency-in-cc-program","linker-plugin-lto.html#cc-code-as-a-dependency-in-rust","linker-plugin-lto.html#explicitly-specifying-the-linker-plugin-to-be-used-by-rustc","linker-plugin-lto.html#toolchain-compatibility","contributing.html#contributing-to-rustc"],"index":{"documentStore":{"docInfo":{"0":{"body":66,"breadcrumbs":1,"title":1},"1":{"body":78,"breadcrumbs":2,"title":2},"10":{"body":149,"breadcrumbs":6,"title":6},"100":{"body":20,"breadcrumbs":5,"title":2},"101":{"body":24,"breadcrumbs":5,"title":2},"102":{"body":26,"breadcrumbs":5,"title":2},"103":{"body":27,"breadcrumbs":5,"title":2},"104":{"body":23,"breadcrumbs":5,"title":2},"105":{"body":22,"breadcrumbs":5,"title":2},"106":{"body":25,"breadcrumbs":5,"title":2},"107":{"body":19,"breadcrumbs":4,"title":1},"108":{"body":20,"breadcrumbs":4,"title":1},"109":{"body":5,"breadcrumbs":6,"title":3},"11":{"body":165,"breadcrumbs":4,"title":4},"110":{"body":24,"breadcrumbs":5,"title":2},"111":{"body":55,"breadcrumbs":7,"title":4},"112":{"body":68,"breadcrumbs":6,"title":3},"113":{"body":39,"breadcrumbs":6,"title":3},"114":{"body":26,"breadcrumbs":6,"title":3},"115":{"body":37,"breadcrumbs":5,"title":2},"116":{"body":43,"breadcrumbs":6,"title":3},"117":{"body":24,"breadcrumbs":5,"title":2},"118":{"body":48,"breadcrumbs":7,"title":4},"119":{"body":9,"breadcrumbs":8,"title":5},"12":{"body":6,"breadcrumbs":4,"title":4},"120":{"body":17,"breadcrumbs":6,"title":3},"121":{"body":21,"breadcrumbs":6,"title":3},"122":{"body":17,"breadcrumbs":2,"title":2},"123":{"body":3,"breadcrumbs":1,"title":1},"124":{"body":8,"breadcrumbs":1,"title":1},"125":{"body":17,"breadcrumbs":2,"title":2},"126":{"body":11,"breadcrumbs":2,"title":2},"127":{"body":32,"breadcrumbs":2,"title":2},"128":{"body":16,"breadcrumbs":3,"title":3},"129":{"body":23,"breadcrumbs":1,"title":1},"13":{"body":7,"breadcrumbs":3,"title":3},"130":{"body":24,"breadcrumbs":2,"title":2},"131":{"body":21,"breadcrumbs":2,"title":2},"132":{"body":10,"breadcrumbs":1,"title":1},"133":{"body":10,"breadcrumbs":2,"title":2},"134":{"body":16,"breadcrumbs":2,"title":2},"135":{"body":5,"breadcrumbs":1,"title":1},"136":{"body":19,"breadcrumbs":2,"title":2},"137":{"body":11,"breadcrumbs":2,"title":2},"138":{"body":8,"breadcrumbs":2,"title":2},"139":{"body":12,"breadcrumbs":2,"title":2},"14":{"body":4,"breadcrumbs":3,"title":3},"140":{"body":26,"breadcrumbs":2,"title":2},"141":{"body":12,"breadcrumbs":2,"title":2},"142":{"body":9,"breadcrumbs":1,"title":1},"143":{"body":16,"breadcrumbs":1,"title":1},"144":{"body":15,"breadcrumbs":2,"title":2},"145":{"body":15,"breadcrumbs":2,"title":2},"146":{"body":7,"breadcrumbs":1,"title":1},"147":{"body":8,"breadcrumbs":2,"title":2},"148":{"body":18,"breadcrumbs":2,"title":2},"149":{"body":12,"breadcrumbs":1,"title":1},"15":{"body":9,"breadcrumbs":5,"title":5},"150":{"body":3,"breadcrumbs":2,"title":2},"151":{"body":15,"breadcrumbs":1,"title":1},"152":{"body":27,"breadcrumbs":2,"title":2},"153":{"body":4,"breadcrumbs":2,"title":2},"154":{"body":8,"breadcrumbs":2,"title":2},"155":{"body":16,"breadcrumbs":1,"title":1},"156":{"body":5,"breadcrumbs":1,"title":1},"157":{"body":31,"breadcrumbs":2,"title":2},"158":{"body":25,"breadcrumbs":2,"title":2},"159":{"body":32,"breadcrumbs":1,"title":1},"16":{"body":12,"breadcrumbs":6,"title":6},"160":{"body":34,"breadcrumbs":3,"title":2},"161":{"body":52,"breadcrumbs":3,"title":2},"162":{"body":12,"breadcrumbs":3,"title":3},"163":{"body":53,"breadcrumbs":3,"title":3},"164":{"body":217,"breadcrumbs":1,"title":1},"165":{"body":200,"breadcrumbs":3,"title":3},"166":{"body":30,"breadcrumbs":2,"title":2},"167":{"body":39,"breadcrumbs":3,"title":3},"168":{"body":39,"breadcrumbs":1,"title":1},"169":{"body":104,"breadcrumbs":5,"title":5},"17":{"body":10,"breadcrumbs":4,"title":4},"170":{"body":90,"breadcrumbs":4,"title":4},"171":{"body":30,"breadcrumbs":6,"title":6},"172":{"body":77,"breadcrumbs":2,"title":2},"173":{"body":27,"breadcrumbs":2,"title":2},"18":{"body":3,"breadcrumbs":5,"title":5},"19":{"body":6,"breadcrumbs":4,"title":4},"2":{"body":6,"breadcrumbs":3,"title":3},"20":{"body":6,"breadcrumbs":3,"title":3},"21":{"body":6,"breadcrumbs":4,"title":4},"22":{"body":6,"breadcrumbs":4,"title":4},"23":{"body":33,"breadcrumbs":4,"title":4},"24":{"body":7,"breadcrumbs":6,"title":6},"25":{"body":5,"breadcrumbs":5,"title":5},"26":{"body":5,"breadcrumbs":4,"title":4},"27":{"body":7,"breadcrumbs":5,"title":5},"28":{"body":17,"breadcrumbs":5,"title":5},"29":{"body":10,"breadcrumbs":4,"title":4},"3":{"body":6,"breadcrumbs":3,"title":3},"30":{"body":24,"breadcrumbs":5,"title":5},"31":{"body":23,"breadcrumbs":4,"title":4},"32":{"body":59,"breadcrumbs":7,"title":7},"33":{"body":149,"breadcrumbs":6,"title":6},"34":{"body":70,"breadcrumbs":1,"title":1},"35":{"body":30,"breadcrumbs":3,"title":2},"36":{"body":33,"breadcrumbs":2,"title":1},"37":{"body":42,"breadcrumbs":2,"title":1},"38":{"body":62,"breadcrumbs":2,"title":1},"39":{"body":40,"breadcrumbs":2,"title":1},"4":{"body":21,"breadcrumbs":4,"title":4},"40":{"body":38,"breadcrumbs":4,"title":3},"41":{"body":115,"breadcrumbs":4,"title":3},"42":{"body":72,"breadcrumbs":3,"title":2},"43":{"body":86,"breadcrumbs":3,"title":2},"44":{"body":238,"breadcrumbs":3,"title":2},"45":{"body":14,"breadcrumbs":3,"title":2},"46":{"body":16,"breadcrumbs":6,"title":3},"47":{"body":57,"breadcrumbs":5,"title":2},"48":{"body":49,"breadcrumbs":6,"title":3},"49":{"body":48,"breadcrumbs":5,"title":2},"5":{"body":46,"breadcrumbs":6,"title":6},"50":{"body":38,"breadcrumbs":6,"title":3},"51":{"body":65,"breadcrumbs":6,"title":3},"52":{"body":33,"breadcrumbs":6,"title":3},"53":{"body":47,"breadcrumbs":5,"title":2},"54":{"body":27,"breadcrumbs":6,"title":3},"55":{"body":47,"breadcrumbs":5,"title":2},"56":{"body":36,"breadcrumbs":6,"title":3},"57":{"body":33,"breadcrumbs":5,"title":2},"58":{"body":25,"breadcrumbs":5,"title":2},"59":{"body":4,"breadcrumbs":5,"title":2},"6":{"body":77,"breadcrumbs":6,"title":6},"60":{"body":27,"breadcrumbs":6,"title":3},"61":{"body":34,"breadcrumbs":6,"title":3},"62":{"body":33,"breadcrumbs":5,"title":2},"63":{"body":26,"breadcrumbs":5,"title":2},"64":{"body":40,"breadcrumbs":6,"title":3},"65":{"body":5,"breadcrumbs":6,"title":3},"66":{"body":24,"breadcrumbs":5,"title":2},"67":{"body":21,"breadcrumbs":5,"title":2},"68":{"body":24,"breadcrumbs":4,"title":1},"69":{"body":50,"breadcrumbs":8,"title":5},"7":{"body":75,"breadcrumbs":7,"title":7},"70":{"body":39,"breadcrumbs":5,"title":2},"71":{"body":84,"breadcrumbs":7,"title":4},"72":{"body":30,"breadcrumbs":7,"title":4},"73":{"body":62,"breadcrumbs":7,"title":4},"74":{"body":31,"breadcrumbs":6,"title":3},"75":{"body":31,"breadcrumbs":7,"title":4},"76":{"body":33,"breadcrumbs":6,"title":3},"77":{"body":20,"breadcrumbs":5,"title":2},"78":{"body":77,"breadcrumbs":7,"title":4},"79":{"body":19,"breadcrumbs":5,"title":2},"8":{"body":4,"breadcrumbs":7,"title":7},"80":{"body":46,"breadcrumbs":5,"title":2},"81":{"body":45,"breadcrumbs":6,"title":3},"82":{"body":49,"breadcrumbs":6,"title":3},"83":{"body":29,"breadcrumbs":6,"title":3},"84":{"body":73,"breadcrumbs":6,"title":3},"85":{"body":31,"breadcrumbs":5,"title":2},"86":{"body":40,"breadcrumbs":6,"title":3},"87":{"body":48,"breadcrumbs":7,"title":4},"88":{"body":32,"breadcrumbs":5,"title":2},"89":{"body":41,"breadcrumbs":6,"title":3},"9":{"body":13,"breadcrumbs":4,"title":4},"90":{"body":18,"breadcrumbs":5,"title":2},"91":{"body":24,"breadcrumbs":5,"title":2},"92":{"body":41,"breadcrumbs":5,"title":2},"93":{"body":24,"breadcrumbs":6,"title":3},"94":{"body":5,"breadcrumbs":5,"title":2},"95":{"body":25,"breadcrumbs":5,"title":2},"96":{"body":17,"breadcrumbs":5,"title":2},"97":{"body":28,"breadcrumbs":5,"title":2},"98":{"body":25,"breadcrumbs":6,"title":3},"99":{"body":15,"breadcrumbs":5,"title":2}},"docs":{"0":{"body":"Welcome to \"The rustc book\"! rustc is the compiler for the Rust programming language, provided by the project itself. Compilers take your source code and produce binary code, either as a library or executable. Most Rust programmers don't invoke rustc directly, but instead do it through Cargo . It's all in service of rustc though! If you want to see how Cargo calls rustc, you can $ cargo build --verbose And it will print out each rustc invocation. This book can help you understand what each of these options does. Additionally, while most Rustaceans use Cargo, not all do: sometimes they integrate rustc into other build systems. This book should provide a guide to all of the options you'd need to do so.","breadcrumbs":"What is rustc?","id":"0","title":"What is rustc?"},"1":{"body":"Let's say you've got a little hello world program in a file hello.rs: fn main() { println!(\"Hello, world!\");\n} To turn this source code into an executable, you can use rustc: $ rustc hello.rs\n$ ./hello # on a *NIX\n$ .\\hello.exe # on Windows Note that we only ever pass rustc the crate root , not every file we wish to compile. For example, if we had a main.rs that looked like this: mod foo; fn main() { foo::hello();\n} And a foo.rs that had this: pub fn hello() { println!(\"Hello, world!\");\n} To compile this, we'd run this command: $ rustc main.rs No need to tell rustc about foo.rs; the mod statements give it everything that it needs. This is different than how you would use a C compiler, where you invoke the compiler on each file, and then link everything together. In other words, the crate is a translation unit, not a particular module.","breadcrumbs":"Basic usage","id":"1","title":"Basic usage"},"10":{"body":"This flag controls the types of output files generated by the compiler. It accepts a comma-separated list of values, and may be specified multiple times. The valid emit kinds are: asm — Generates a file with the crate's assembly code. The default output filename is CRATE_NAME.s. dep-info — Generates a file with Makefile syntax that indicates all the source files that were loaded to generate the crate. The default output filename is CRATE_NAME.d. link — Generates the crates specified by --crate-type. The default output filenames depend on the crate type and platform. This is the default if --emit is not specified. llvm-bc — Generates a binary file containing the LLVM bitcode . The default output filename is CRATE_NAME.bc. llvm-ir — Generates a file containing LLVM IR . The default output filename is CRATE_NAME.ll. metadata — Generates a file containing metadata about the crate. The default output filename is CRATE_NAME.rmeta. mir — Generates a file containing rustc's mid-level intermediate representation. The default output filename is CRATE_NAME.mir. obj — Generates a native object file. The default output filename is CRATE_NAME.o. The output filename can be set with the -o flag. A suffix may be added to the filename with the -C extra-filename flag. The files are written to the current directory unless the --out-dir flag is used. Each emission type may also specify the output filename with the form KIND=PATH, which takes precedence over the -o flag.","breadcrumbs":"--emit: specifies the types of output files to generate","id":"10","title":"--emit: specifies the types of output files to generate"},"100":{"body":"This lint detects imports that are never used. Some example code that triggers this lint: use std::collections::HashMap; This will produce: warning: unused import: `std::collections::HashMap` --> src/main.rs:1:5 |\n1 | use std::collections::HashMap; | ^^^^^^^^^^^^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » unused-imports","id":"100","title":"unused-imports"},"101":{"body":"This lint detects macros that were not used. Some example code that triggers this lint: macro_rules! unused { () => {};\n} fn main() {\n} This will produce: warning: unused macro definition --> src/main.rs:1:1 |\n1 | / macro_rules! unused {\n2 | | () => {};\n3 | | } | |_^ |","breadcrumbs":"Lints » Lint listing » unused-macros","id":"101","title":"unused-macros"},"102":{"body":"This lint detects unused result of a type flagged as #[must_use]. Some example code that triggers this lint: fn returns_result() -> Result<(), ()> { Ok(())\n} fn main() { returns_result();\n} This will produce: warning: unused `std::result::Result` that must be used --> src/main.rs:6:5 |\n6 | returns_result(); | ^^^^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » unused-must-use","id":"102","title":"unused-must-use"},"103":{"body":"This lint detects mut variables which don't need to be mutable. Some example code that triggers this lint: let mut x = 5; This will produce: warning: variable does not need to be mutable --> src/main.rs:2:9 |\n2 | let mut x = 5; | ----^ | | | help: remove this `mut` |","breadcrumbs":"Lints » Lint listing » unused-mut","id":"103","title":"unused-mut"},"104":{"body":"This lint detects if, match, while and return with parentheses; they do not need them. Some example code that triggers this lint: if(true) {} This will produce: warning: unnecessary parentheses around `if` condition --> src/main.rs:2:7 |\n2 | if(true) {} | ^^^^^^ help: remove these parentheses |","breadcrumbs":"Lints » Lint listing » unused-parens","id":"104","title":"unused-parens"},"105":{"body":"This lint detects unnecessary use of an unsafe block. Some example code that triggers this lint: unsafe {} This will produce: warning: unnecessary `unsafe` block --> src/main.rs:2:5 |\n2 | unsafe {} | ^^^^^^ unnecessary `unsafe` block |","breadcrumbs":"Lints » Lint listing » unused-unsafe","id":"105","title":"unused-unsafe"},"106":{"body":"This lint detects variables which are not used in any way. Some example code that triggers this lint: let x = 5; This will produce: warning: unused variable: `x` --> src/main.rs:2:9 |\n2 | let x = 5; | ^ help: consider using `_x` instead |","breadcrumbs":"Lints » Lint listing » unused-variables","id":"106","title":"unused-variables"},"107":{"body":"This lint is a bit special; by changing its level, you change every other warning that would produce a warning to whatever value you'd like: #![deny(warnings)] As such, you won't ever trigger this lint in your code directly.","breadcrumbs":"Lints » Lint listing » warnings","id":"107","title":"warnings"},"108":{"body":"This lint detects while true { }. Some example code that triggers this lint: while true { } This will produce: warning: denote infinite loops with `loop { ... }` --> src/main.rs:2:5 |\n2 | while true { | ^^^^^^^^^^ help: use `loop` |","breadcrumbs":"Lints » Lint listing » while-true","id":"108","title":"while-true"},"109":{"body":"These lints are all set to the 'deny' level by default.","breadcrumbs":"Lints » Lint listing » Deny-by-default lints","id":"109","title":"Deny-by-default lints"},"11":{"body":"This flag prints out various information about the compiler. This flag may be specified multiple times, and the information is printed in the order the flags are specified. Specifying a --print flag will usually disable the --emit step and will only print the requested information. The valid types of print values are: crate-name — The name of the crate. file-names — The names of the files created by the link emit kind. sysroot — Path to the sysroot. cfg — List of cfg values. See conditional compilation for more information about cfg values. target-list — List of known targets. The target may be selected with the --target flag. target-cpus — List of available CPU values for the current target. The target CPU may be selected with the -C target-cpu=val flag. target-features — List of available target features for the current target. Target features may be enabled with the -C target-feature=val flag. relocation-models — List of relocation models. Relocation models may be selected with the -C relocation-model=val flag. code-models — List of code models. Code models may be selected with the -C code-model=val flag. tls-models — List of Thread Local Storage models supported. The model may be selected with the -Z tls-model=val flag. native-static-libs — This may be used when creating a staticlib crate type. If this is the only flag, it will perform a full compilation and include a diagnostic note that indicates the linker flags to use when linking the resulting static library. The note starts with the text native-static-libs: to make it easier to fetch the output.","breadcrumbs":"--print: print compiler information","id":"11","title":"--print: print compiler information"},"110":{"body":"This lint detects that a shift exceeds the type's number of bits. Some example code that triggers this lint: 1_i32 << 32; This will produce: error: bitshift exceeds the type's number of bits --> src/main.rs:2:5 |\n2 | 1_i32 << 32; | ^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » exceeding-bitshifts","id":"110","title":"exceeding-bitshifts"},"111":{"body":"This lint detects type parameter default erroneously allowed in invalid location. Some example code that triggers this lint: fn foo<T=i32>(t: T) {} This will produce: error: defaults for type parameters are only allowed in `struct`, `enum`, `type`, or `trait` definitions. --> src/main.rs:4:8 |\n4 | fn foo<T=i32>(t: T) {} | ^ | = note: `#[deny(invalid_type_param_default)]` on by default = warning: this was previously accepted by the compiler but is being phased out; it will become a hard error in a future release! = note: for more information, see issue #36887 <https://github.com/rust-lang/rust/issues/36887>","breadcrumbs":"Lints » Lint listing » invalid-type-param-default","id":"111","title":"invalid-type-param-default"},"112":{"body":"RFC 1506 modified some visibility rules, and changed the visibility of struct constructors. Some example code that triggers this lint: mod m { pub struct S(u8); fn f() { // this is trying to use S from the 'use' line, but because the `u8` is // not pub, it is private ::S; }\n} use m::S; This will produce: error: private struct constructors are not usable through re-exports in outer modules --> src/main.rs:5:9 |\n5 | ::S; | ^^^ | = note: `#[deny(legacy_constructor_visibility)]` on by default = warning: this was previously accepted by the compiler but is being phased out; it will become a hard error in a future release! = note: for more information, see issue #39207 <https://github.com/rust-lang/rust/issues/39207>","breadcrumbs":"Lints » Lint listing » legacy-constructor-visibility","id":"112","title":"legacy-constructor-visibility"},"113":{"body":"The legacy_directory_ownership warning is issued when There is a non-inline module with a #[path] attribute (e.g. #[path = \"foo.rs\"] mod bar;), The module's file (\"foo.rs\" in the above example) is not named \"mod.rs\", and The module's file contains a non-inline child module without a #[path] attribute. The warning can be fixed by renaming the parent module to \"mod.rs\" and moving it into its own directory if appropriate.","breadcrumbs":"Lints » Lint listing » legacy-directory-ownership","id":"113","title":"legacy-directory-ownership"},"114":{"body":"The missing_fragment_specifier warning is issued when an unused pattern in a macro_rules! macro definition has a meta-variable (e.g. $e) that is not followed by a fragment specifier (e.g. :expr). This warning can always be fixed by removing the unused pattern in the macro_rules! macro definition.","breadcrumbs":"Lints » Lint listing » missing-fragment-specifier","id":"114","title":"missing-fragment-specifier"},"115":{"body":"This lint catches transmuting from &T to &mut T because it is undefined behavior. Some example code that triggers this lint: unsafe { let y = std::mem::transmute::<&i32, &mut i32>(&5);\n} This will produce: error: mutating transmuted &mut T from &T may cause undefined behavior, consider instead using an UnsafeCell --> src/main.rs:3:17 |\n3 | let y = std::mem::transmute::<&i32, &mut i32>(&5); | ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » mutable-transmutes","id":"115","title":"mutable-transmutes"},"116":{"body":"This lint detects any const items with the #[no_mangle] attribute. Constants do not have their symbols exported, and therefore, this probably means you meant to use a static, not a const. Some example code that triggers this lint: #[no_mangle]\nconst FOO: i32 = 5; This will produce: error: const items should never be `#[no_mangle]` --> src/main.rs:3:1 |\n3 | const FOO: i32 = 5; | -----^^^^^^^^^^^^^^ | | | help: try a static value: `pub static` |","breadcrumbs":"Lints » Lint listing » no-mangle-const-items","id":"116","title":"no-mangle-const-items"},"117":{"body":"This lint detects literal out of range for its type. Some example code that triggers this lint: let x: u8 = 1000; This will produce: error: literal out of range for u8 --> src/main.rs:2:17 |\n2 | let x: u8 = 1000; | ^^^^ |","breadcrumbs":"Lints » Lint listing » overflowing-literals","id":"117","title":"overflowing-literals"},"118":{"body":"This lint detects incorrect parentheses. Some example code that triggers this lint: let x = 5 as usize(); This will produce: error: parenthesized parameters may only be used with a trait --> src/main.rs:2:21 |\n2 | let x = 5 as usize(); | ^^ | = note: `#[deny(parenthesized_params_in_types_and_modules)]` on by default = warning: this was previously accepted by the compiler but is being phased out; it will become a hard error in a future release! = note: for more information, see issue #42238 <https://github.com/rust-lang/rust/issues/42238> To fix it, remove the ()s.","breadcrumbs":"Lints » Lint listing » parenthesized-params-in-types-and-modules","id":"118","title":"parenthesized-params-in-types-and-modules"},"119":{"body":"This lint detects a specific situation of re-exporting a private extern crate;","breadcrumbs":"Lints » Lint listing » pub-use-of-private-extern-crate","id":"119","title":"pub-use-of-private-extern-crate"},"12":{"body":"A synonym for -C debuginfo=2, for more see here .","breadcrumbs":"-g: include debug information","id":"12","title":"-g: include debug information"},"120":{"body":"In older versions of Rust, there was a soundness issue where extern statics were allowed to be accessed in safe code. This lint now catches and denies this kind of code.","breadcrumbs":"Lints » Lint listing » safe-extern-statics","id":"120","title":"safe-extern-statics"},"121":{"body":"This lint detects an unknown crate type found in a #[crate_type] directive. Some example code that triggers this lint: #![crate_type=\"lol\"] This will produce: error: invalid `crate_type` value --> src/lib.rs:1:1 |\n1 | #![crate_type=\"lol\"] | ^^^^^^^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » unknown-crate-types","id":"121","title":"unknown-crate-types"},"122":{"body":"All of these options are passed to rustc via the -C flag, short for \"codegen.\" You can see a version of this list for your exact compiler by running rustc -C help.","breadcrumbs":"Codegen options","id":"122","title":"Codegen options"},"123":{"body":"This option is deprecated and does nothing.","breadcrumbs":"ar","id":"123","title":"ar"},"124":{"body":"This flag lets you control which linker rustc invokes to link your code.","breadcrumbs":"linker","id":"124","title":"linker"},"125":{"body":"This flag lets you append a single extra argument to the linker invocation. \"Append\" is significant; you can pass this flag multiple times to add multiple arguments.","breadcrumbs":"link-arg=val","id":"125","title":"link-arg=val"},"126":{"body":"This flag lets you append multiple extra arguments to the linker invocation. The options should be separated by spaces.","breadcrumbs":"link-args","id":"126","title":"link-args"},"127":{"body":"This flag lets you control the linker flavor used by rustc. If a linker is given with the -C linker flag described above then the linker flavor is inferred from the value provided. If no linker is given then the linker flavor is used to determine the linker to use. Every rustc target defaults to some linker flavor.","breadcrumbs":"linker-flavor","id":"127","title":"linker-flavor"},"128":{"body":"Normally, the linker will remove dead code. This flag disables this behavior. An example of when this flag might be useful is when trying to construct code coverage metrics.","breadcrumbs":"link-dead-code","id":"128","title":"link-dead-code"},"129":{"body":"This flag instructs LLVM to use link time optimizations . It takes one of two values, thin and fat. 'thin' LTO is a new feature of LLVM , 'fat' referring to the classic version of LTO.","breadcrumbs":"lto","id":"129","title":"lto"},"13":{"body":"A synonym for -C opt-level=2, for more see here .","breadcrumbs":"-O: optimize your code","id":"13","title":"-O: optimize your code"},"130":{"body":"This instructs rustc to generate code specifically for a particular processor. You can run rustc --print target-cpus to see the valid options to pass here. Additionally, native can be passed to use the processor of the host machine.","breadcrumbs":"target-cpu","id":"130","title":"target-cpu"},"131":{"body":"Individual targets will support different features; this flag lets you control enabling or disabling a feature. To see the valid options and an example of use, run rustc --print target-features.","breadcrumbs":"target-feature","id":"131","title":"target-feature"},"132":{"body":"This flag can be used to add extra LLVM passes to the compilation. The list must be separated by spaces.","breadcrumbs":"passes","id":"132","title":"passes"},"133":{"body":"This flag can be used to pass a list of arguments directly to LLVM. The list must be separated by spaces.","breadcrumbs":"llvm-args","id":"133","title":"llvm-args"},"134":{"body":"rustc will generate temporary files during compilation; normally it will delete them after it's done with its work. This option will cause them to be preserved instead of removed.","breadcrumbs":"save-temps","id":"134","title":"save-temps"},"135":{"body":"This option allows you to set the value of rpath .","breadcrumbs":"rpath","id":"135","title":"rpath"},"136":{"body":"This flag allows you to control the behavior of integer overflow. This flag can be passed many options: To turn overflow checks on: y, yes, or on. To turn overflow checks off: n, no, or off.","breadcrumbs":"overflow-checks","id":"136","title":"overflow-checks"},"137":{"body":"The pass manager comes pre-populated with a list of passes; this flag ensures that list is empty.","breadcrumbs":"no-prepopulate-passes","id":"137","title":"no-prepopulate-passes"},"138":{"body":"By default, rustc will attempt to vectorize loops . This flag will turn that behavior off.","breadcrumbs":"no-vectorize-loops","id":"138","title":"no-vectorize-loops"},"139":{"body":"By default, rustc will attempt to vectorize loops using superword-level parallelism . This flag will turn that behavior off.","breadcrumbs":"no-vectorize-slp","id":"139","title":"no-vectorize-slp"},"14":{"body":"This flag controls the output filename.","breadcrumbs":"-o: filename of the output","id":"14","title":"-o: filename of the output"},"140":{"body":"This option will make rustc generate code using \"soft floats.\" By default, a lot of hardware supports floating point instructions, and so the code generated will take advantage of this. \"soft floats\" emulate floating point instructions in software.","breadcrumbs":"soft-float","id":"140","title":"soft-float"},"141":{"body":"By default, rustc prefers to statically link dependencies. This option will make it use dynamic linking instead.","breadcrumbs":"prefer-dynamic","id":"141","title":"prefer-dynamic"},"142":{"body":"LLVM comes with an internal assembler; this option will let you use an external assembler instead.","breadcrumbs":"no-integrated-as","id":"142","title":"no-integrated-as"},"143":{"body":"This flag allows you to disable the red zone . This flag can be passed many options: To enable the red zone: y, yes, or on. To disable it: n, no, or off.","breadcrumbs":"no-redzone","id":"143","title":"no-redzone"},"144":{"body":"This option lets you choose which relocation model to use. To find the valid options for this flag, run rustc --print relocation-models.","breadcrumbs":"relocation-model","id":"144","title":"relocation-model"},"145":{"body":"This option lets you choose which code model to use. To find the valid options for this flag, run rustc --print code-models.","breadcrumbs":"code-model=val","id":"145","title":"code-model=val"},"146":{"body":"This option allows you to control the metadata used for symbol mangling.","breadcrumbs":"metadata","id":"146","title":"metadata"},"147":{"body":"This option allows you to put extra data in each output filename.","breadcrumbs":"extra-filename","id":"147","title":"extra-filename"},"148":{"body":"This flag lets you control how many threads are used when doing code generation. Increasing parallelism may speed up compile times, but may also produce slower code.","breadcrumbs":"codegen-units","id":"148","title":"codegen-units"},"149":{"body":"This flag lets you print remarks for these optimization passes. The list of passes should be separated by spaces. all will remark on every pass.","breadcrumbs":"remark","id":"149","title":"remark"},"15":{"body":"The outputted crate will be written to this directory. This flag is ignored if the -o flag is used.","breadcrumbs":"--out-dir: directory to write the output in","id":"15","title":"--out-dir: directory to write the output in"},"150":{"body":"This option is deprecated and does nothing.","breadcrumbs":"no-stack-check","id":"150","title":"no-stack-check"},"151":{"body":"This flag lets you control debug information: 0: no debug info at all 1: line tables only 2: full debug info","breadcrumbs":"debuginfo","id":"151","title":"debuginfo"},"152":{"body":"This flag lets you control the optimization level. 0: no optimizations, also turn on cfg(debug_assertions). 1: basic optimizations 2: some optimizations 3: all optimizations s: optimize for binary size z: optimize for binary size, but also turn off loop vectorization.","breadcrumbs":"opt-level","id":"152","title":"opt-level"},"153":{"body":"This flag lets you turn cfg(debug_assertions) on or off.","breadcrumbs":"debug-assertions","id":"153","title":"debug-assertions"},"154":{"body":"This option lets you set the threshold for inlining a function. The default is 225.","breadcrumbs":"inline-threshold","id":"154","title":"inline-threshold"},"155":{"body":"This option lets you control what happens when the code panics. abort: terminate the process upon panic unwind: unwind the stack upon panic","breadcrumbs":"panic","id":"155","title":"panic"},"156":{"body":"This flag allows you to enable incremental compilation.","breadcrumbs":"incremental","id":"156","title":"incremental"},"157":{"body":"This flag allows for creating instrumented binaries that will collect profiling data for use with profile-guided optimization (PGO). The flag takes an optional argument which is the path to a directory into which the instrumented binary will emit the collected data. See the chapter on profile-guided optimization for more information.","breadcrumbs":"profile-generate","id":"157","title":"profile-generate"},"158":{"body":"This flag specifies the profiling data file to be used for profile-guided optimization (PGO). The flag takes a mandatory argument which is the path to a valid .profdata file. See the chapter on profile-guided optimization for more information.","breadcrumbs":"profile-use","id":"158","title":"profile-use"},"159":{"body":"rustc is a cross-compiler by default. This means that you can use any compiler to build for any architecture. The list of targets are the possible architectures that you can build for. To see all the options that you can set with a target, see the docs here . To compile to a particular target, use the --target flag: $ rustc src/main.rs --target=wasm32-unknown-unknown","breadcrumbs":"Targets","id":"159","title":"Targets"},"16":{"body":"Each error of rustc's comes with an error code; this will print out a longer explanation of a given error.","breadcrumbs":"--explain: provide a detailed explanation of an error message","id":"16","title":"--explain: provide a detailed explanation of an error message"},"160":{"body":"rustc ships with the ability to compile to many targets automatically, we call these \"built-in\" targets, and they generally correspond to targets that the team is supporting directly. To see the list of built-in targets, you can run rustc --print target-list, or look at the API docs . Each module there defines a builder for a particular target.","breadcrumbs":"Targets » Built-in Targets","id":"160","title":"Built-in Targets"},"161":{"body":"If you'd like to build for a target that is not yet supported by rustc, you can use a \"custom target specification\" to define a target. These target specification files are JSON. To see the JSON for the host target, you can run: $ rustc +nightly -Z unstable-options --print target-spec-json To see it for a different target, add the --target flag: $ rustc +nightly -Z unstable-options --target=wasm32-unknown-unknown --print target-spec-json To use a custom target, see xargo .","breadcrumbs":"Targets » Custom Targets","id":"161","title":"Custom Targets"},"162":{"body":"rustc supports doing profile-guided optimization (PGO). This chapter describes what PGO is, what it is good for, and how it can be used.","breadcrumbs":"Profile Guided Optimization","id":"162","title":"Profile Guided Optimization"},"163":{"body":"The basic concept of PGO is to collect data about the typical execution of a program (e.g. which branches it is likely to take) and then use this data to inform optimizations such as inlining, machine-code layout, register allocation, etc. There are different ways of collecting data about a program's execution. One is to run the program inside a profiler (such as perf) and another is to create an instrumented binary, that is, a binary that has data collection built into it, and run that. The latter usually provides more accurate data and it is also what is supported by rustc.","breadcrumbs":"What Is Profiled-Guided Optimization?","id":"163","title":"What Is Profiled-Guided Optimization?"},"164":{"body":"Generating a PGO-optimized program involves following a workflow with four steps: Compile the program with instrumentation enabled (e.g. rustc -Cprofile-generate=/tmp/pgo-data main.rs) Run the instrumented program (e.g. ./main) which generates a default_<id>.profraw file Convert the .profraw file into a .profdata file using LLVM's llvm-profdata tool Compile the program again, this time making use of the profiling data (for example rustc -Cprofile-use=merged.profdata main.rs) An instrumented program will create one or more .profraw files, one for each instrumented binary. E.g. an instrumented executable that loads two instrumented dynamic libraries at runtime will generate three .profraw files. Running an instrumented binary multiple times, on the other hand, will re-use the respective .profraw files, updating them in place. These .profraw files have to be post-processed before they can be fed back into the compiler. This is done by the llvm-profdata tool. This tool is most easily installed via rustup component add llvm-tools-preview Note that installing the llvm-tools-preview component won't add llvm-profdata to the PATH. Rather, the tool can be found in: ~/.rustup/toolchains/<toolchain>/lib/rustlib/<target-triple>/bin/ Alternatively, an llvm-profdata coming with a recent LLVM or Clang version usually works too. The llvm-profdata tool merges multiple .profraw files into a single .profdata file that can then be fed back into the compiler via -Cprofile-use: # STEP 1: Compile the binary with instrumentation\nrustc -Cprofile-generate=/tmp/pgo-data -O ./main.rs # STEP 2: Run the binary a few times, maybe with common sets of args.\n# Each run will create or update `.profraw` files in /tmp/pgo-data\n./main mydata1.csv\n./main mydata2.csv\n./main mydata3.csv # STEP 3: Merge and post-process all the `.profraw` files in /tmp/pgo-data\nllvm-profdata merge -o ./merged.profdata /tmp/pgo-data # STEP 4: Use the merged `.profdata` file during optimization. All `rustc`\n# flags have to be the same.\nrustc -Cprofile-use=./merged.profdata -O ./main.rs","breadcrumbs":"Usage","id":"164","title":"Usage"},"165":{"body":"Using this feature with Cargo works very similar to using it with rustc directly. Again, we generate an instrumented binary, run it to produce data, merge the data, and feed it back into the compiler. Some things of note: We use the RUSTFLAGS environment variable in order to pass the PGO compiler flags to the compilation of all crates in the program. We pass the --target flag to Cargo, which prevents the RUSTFLAGS arguments to be passed to Cargo build scripts. We don't want the build scripts to generate a bunch of .profraw files. We pass --release to Cargo because that's where PGO makes the most sense. In theory, PGO can also be done on debug builds but there is little reason to do so. It is recommended to use absolute paths for the argument of -Cprofile-generate and -Cprofile-use. Cargo can invoke rustc with varying working directories, meaning that rustc will not be able to find the supplied .profdata file. With absolute paths this is not an issue. It is good practice to make sure that there is no left-over profiling data from previous compilation sessions. Just deleting the directory is a simple way of doing so (see STEP 0 below). This is what the entire workflow looks like: # STEP 0: Make sure there is no left-over profiling data from previous runs\nrm -rf /tmp/pgo-data # STEP 1: Build the instrumented binaries\nRUSTFLAGS=\"-Cprofile-generate=/tmp/pgo-data\" \\ cargo build --release --target=x86_64-unknown-linux-gnu # STEP 2: Run the instrumented binaries with some typical data\n./target/x86_64-unknown-linux-gnu/release/myprogram mydata1.csv\n./target/x86_64-unknown-linux-gnu/release/myprogram mydata2.csv\n./target/x86_64-unknown-linux-gnu/release/myprogram mydata3.csv # STEP 3: Merge the `.profraw` files into a `.profdata` file\nllvm-profdata merge -o /tmp/pgo-data/merged.profdata /tmp/pgo-data # STEP 4: Use the `.profdata` file for guiding optimizations\nRUSTFLAGS=\"-Cprofile-use=/tmp/pgo-data/merged.profdata\" \\ cargo build --release --target=x86_64-unknown-linux-gnu","breadcrumbs":"A Complete Cargo Workflow","id":"165","title":"A Complete Cargo Workflow"},"166":{"body":"rustc's PGO support relies entirely on LLVM's implementation of the feature and is equivalent to what Clang offers via the -fprofile-generate / -fprofile-use flags. The Profile Guided Optimization section in Clang's documentation is therefore an interesting read for anyone who wants to use PGO with Rust.","breadcrumbs":"Further Reading","id":"166","title":"Further Reading"},"167":{"body":"The -C linker-plugin-lto flag allows for deferring the LTO optimization to the actual linking step, which in turn allows for performing interprocedural optimizations across programming language boundaries if all the object files being linked were created by LLVM based toolchains. The prime example here would be linking Rust code together with Clang-compiled C/C++ code.","breadcrumbs":"Linker-plugin-LTO","id":"167","title":"Linker-plugin-LTO"},"168":{"body":"There are two main cases how linker plugin based LTO can be used: compiling a Rust staticlib that is used as a C ABI dependency compiling a Rust binary where rustc invokes the linker In both cases the Rust code has to be compiled with -C linker-plugin-lto and the C/C++ code with -flto or -flto=thin so that object files are emitted as LLVM bitcode.","breadcrumbs":"Usage","id":"168","title":"Usage"},"169":{"body":"In this case the Rust compiler just has to make sure that the object files in the staticlib are in the right format. For linking, a linker with the LLVM plugin must be used (e.g. LLD). Using rustc directly: # Compile the Rust staticlib\nrustc --crate-type=staticlib -Clinker-plugin-lto -Copt-level=2 ./lib.rs\n# Compile the C code with `-flto=thin`\nclang -c -O2 -flto=thin -o main.o ./main.c\n# Link everything, making sure that we use an appropriate linker\nclang -flto=thin -fuse-ld=lld -L . -l\"name-of-your-rust-lib\" -o main -O2 ./cmain.o Using cargo: # Compile the Rust staticlib\nRUSTFLAGS=\"-Clinker-plugin-lto\" cargo build --release\n# Compile the C code with `-flto=thin`\nclang -c -O2 -flto=thin -o main.o ./main.c\n# Link everything, making sure that we use an appropriate linker\nclang -flto=thin -fuse-ld=lld -L . -l\"name-of-your-rust-lib\" -o main -O2 ./cmain.o","breadcrumbs":"Rust staticlib as dependency in C/C++ program","id":"169","title":"Rust staticlib as dependency in C/C++ program"},"17":{"body":"When compiling this crate, rustc will ignore your main function and instead produce a test harness.","breadcrumbs":"--test: build a test harness","id":"17","title":"--test: build a test harness"},"170":{"body":"In this case the linker will be invoked by rustc. We again have to make sure that an appropriate linker is used. Using rustc directly: # Compile C code with `-flto`\nclang ./clib.c -flto=thin -c -o ./clib.o -O2\n# Create a static library from the C code\nar crus ./libxyz.a ./clib.o # Invoke `rustc` with the additional arguments\nrustc -Clinker-plugin-lto -L. -Copt-level=2 -Clinker=clang -Clink-arg=-fuse-ld=lld ./main.rs Using cargo directly: # Compile C code with `-flto`\nclang ./clib.c -flto=thin -c -o ./clib.o -O2\n# Create a static library from the C code\nar crus ./libxyz.a ./clib.o # Set the linking arguments via RUSTFLAGS\nRUSTFLAGS=\"-Clinker-plugin-lto -Clinker=clang -Clink-arg=-fuse-ld=lld\" cargo build --release","breadcrumbs":"C/C++ code as a dependency in Rust","id":"170","title":"C/C++ code as a dependency in Rust"},"171":{"body":"If one wants to use a linker other than LLD, the LLVM linker plugin has to be specified explicitly. Otherwise the linker cannot read the object files. The path to the plugin is passed as an argument to the -Clinker-plugin-lto option: rustc -Clinker-plugin-lto=\"/path/to/LLVMgold.so\" -L. -Copt-level=2 ./main.rs","breadcrumbs":"Explicitly specifying the linker plugin to be used by rustc","id":"171","title":"Explicitly specifying the linker plugin to be used by rustc"},"172":{"body":"In order for this kind of LTO to work, the LLVM linker plugin must be able to handle the LLVM bitcode produced by both rustc and clang. Best results are achieved by using a rustc and clang that are based on the exact same version of LLVM. One can use rustc -vV in order to view the LLVM used by a given rustc version. Note that the version number given here is only an approximation as Rust sometimes uses unstable revisions of LLVM. However, the approximation is usually reliable. The following table shows known good combinations of toolchain versions. Clang 7 Clang 8 Rust 1.34 ✗ ✓ Rust 1.35 ✗ ✓ Rust 1.36 ✗ ✓ Rust 1.37 ✗ ✓ Note that the compatibility policy for this feature might change in the future.","breadcrumbs":"Toolchain Compatibility","id":"172","title":"Toolchain Compatibility"},"173":{"body":"We'd love to have your help improving rustc! To that end, we've written a whole book on its internals, how it works, and how to get started working on it. To learn more, you'll want to check that out. If you would like to contribute to this book, you can find its source in the rustc source at src/doc/rustc .","breadcrumbs":"Contributing to rustc","id":"173","title":"Contributing to rustc"},"18":{"body":"This controls which target to produce.","breadcrumbs":"--target: select a target triple to build","id":"18","title":"--target: select a target triple to build"},"19":{"body":"This flag will set which lints should be set to the warn level .","breadcrumbs":"-W: set lint warnings","id":"19","title":"-W: set lint warnings"},"2":{"body":"Here's a list of command-line arguments to rustc and what they do.","breadcrumbs":"Command-line arguments","id":"2","title":"Command-line arguments"},"20":{"body":"This flag will set which lints should be set to the allow level .","breadcrumbs":"-A: set lint allowed","id":"20","title":"-A: set lint allowed"},"21":{"body":"This flag will set which lints should be set to the deny level .","breadcrumbs":"-D: set lint denied","id":"21","title":"-D: set lint denied"},"22":{"body":"This flag will set which lints should be set to the forbid level .","breadcrumbs":"-F: set lint forbidden","id":"22","title":"-F: set lint forbidden"},"23":{"body":"This flag will allow you to set unstable options of rustc. In order to set multiple options, the -Z flag can be used multiple times. For example: rustc -Z verbose -Z time. Specifying options with -Z is only available on nightly. To view all available options run: rustc -Z help.","breadcrumbs":"-Z: set unstable options","id":"23","title":"-Z: set unstable options"},"24":{"body":"This flag lets you 'cap' lints, for more, see here .","breadcrumbs":"--cap-lints: set the most restrictive lint level","id":"24","title":"--cap-lints: set the most restrictive lint level"},"25":{"body":"This flag will allow you to set codegen options .","breadcrumbs":"-C/--codegen: code generation options","id":"25","title":"-C/--codegen: code generation options"},"26":{"body":"This flag will print out rustc's version.","breadcrumbs":"-V/--version: print a version","id":"26","title":"-V/--version: print a version"},"27":{"body":"This flag, when combined with other flags, makes them produce extra output.","breadcrumbs":"-v/--verbose: use verbose output","id":"27","title":"-v/--verbose: use verbose output"},"28":{"body":"This flag allows you to pass the name and location of an external crate that will be linked into the crate you are building. This flag may be specified multiple times. The format of the value should be CRATENAME=PATH.","breadcrumbs":"--extern: specify where an external library is located","id":"28","title":"--extern: specify where an external library is located"},"29":{"body":"The \"sysroot\" is where rustc looks for the crates that come with the Rust distribution; this flag allows that to be overridden.","breadcrumbs":"--sysroot: Override the system root","id":"29","title":"--sysroot: Override the system root"},"3":{"body":"This flag will print out help information for rustc.","breadcrumbs":"-h/--help: get help","id":"3","title":"-h/--help: get help"},"30":{"body":"This flag lets you control the format of messages. Messages are printed to stderr. The valid options are: human — Human-readable output. This is the default. json — Structured JSON output. short — Short, one-line messages.","breadcrumbs":"--error-format: control how errors are produced","id":"30","title":"--error-format: control how errors are produced"},"31":{"body":"This flag lets you control color settings of the output. The valid options are: auto — Use colors if output goes to a tty. This is the default. always — Always use colors. never — Never colorize output.","breadcrumbs":"--color: configure coloring of output","id":"31","title":"--color: configure coloring of output"},"32":{"body":"Remap source path prefixes in all output, including compiler diagnostics, debug information, macro expansions, etc. It takes a value of the form FROM=TO where a path prefix equal to FROM is rewritten to the value TO. The FROM may itself contain an = symbol, but the TO value may not. This flag may be specified multiple times. This is useful for normalizing build products, for example by removing the current directory out of pathnames emitted into the object files. The replacement is purely textual, with no consideration of the current system's pathname syntax. For example --remap-path-prefix foo=bar will match foo/lib.rs but not ./foo/lib.rs.","breadcrumbs":"--remap-path-prefix: remap source names in output","id":"32","title":"--remap-path-prefix: remap source names in output"},"33":{"body":"When the --error-format=json option is passed to rustc then all of the compiler's diagnostic output will be emitted in the form of JSON blobs. The --json argument can be used in conjunction with --error-format=json to configure what the JSON blobs contain as well as which ones are emitted. With --error-format=json the compiler will always emit any compiler errors as a JSON blob, but the following options are also available to the --json flag to customize the output: diagnostic-short - json blobs for diagnostic messages should use the \"short\" rendering instead of the normal \"human\" default. This means that the output of --error-format=short will be embedded into the JSON diagnostics instead of the default --error-format=human. diagnostic-rendered-ansi - by default JSON blobs in their rendered field will contain a plain text rendering of the diagnostic. This option instead indicates that the diagnostic should have embedded ANSI color codes intended to be used to colorize the message in the manner rustc typically already does for terminal outputs. Note that this is usefully combined with crates like fwdansi to translate these ANSI codes on Windows to console commands or strip-ansi-escapes if you'd like to optionally remove the ansi colors afterwards. artifacts - this instructs rustc to emit a JSON blob for each artifact that is emitted. An artifact corresponds to a request from the --emit CLI argument, and as soon as the artifact is available on the filesystem a notification will be emitted. Note that it is invalid to combine the --json argument with the --color argument, and it is required to combine --json with --error-format=json.","breadcrumbs":"--json: configure json messages printed by the compiler","id":"33","title":"--json: configure json messages printed by the compiler"},"34":{"body":"In software, a \"lint\" is a tool used to help improve your source code. The Rust compiler contains a number of lints, and when it compiles your code, it will also run the lints. These lints may produce a warning, an error, or nothing at all, depending on how you've configured things. Here's a small example: $ cat main.rs\nfn main() { let x = 5;\n}\n$ rustc main.rs\nwarning: unused variable: `x` --> main.rs:2:9 |\n2 | let x = 5; | ^ | = note: `#[warn(unused_variables)]` on by default = note: to avoid this warning, consider using `_x` instead This is the unused_variables lint, and it tells you that you've introduced a variable that you don't use in your code. That's not wrong , so it's not an error, but it might be a bug, so you get a warning.","breadcrumbs":"Lints","id":"34","title":"Lints"},"35":{"body":"In rustc, lints are divided into four levels : allow warn deny forbid Each lint has a default level (explained in the lint listing later in this chapter), and the compiler has a default warning level. First, let's explain what these levels mean, and then we'll talk about configuration.","breadcrumbs":"Lints » Lint levels","id":"35","title":"Lint levels"},"36":{"body":"These lints exist, but by default, do nothing. For example, consider this source: pub fn foo() {} Compiling this file produces no warnings: $ rustc lib.rs --crate-type=lib\n$ But this code violates the missing_docs lint. These lints exist mostly to be manually turned on via configuration, as we'll talk about later in this section.","breadcrumbs":"Lints » allow","id":"36","title":"allow"},"37":{"body":"The 'warn' lint level will produce a warning if you violate the lint. For example, this code runs afoul of the unused_variable lint: pub fn foo() { let x = 5;\n} This will produce this warning: $ rustc lib.rs --crate-type=lib\nwarning: unused variable: `x` --> lib.rs:2:9 |\n2 | let x = 5; | ^ | = note: `#[warn(unused_variables)]` on by default = note: to avoid this warning, consider using `_x` instead","breadcrumbs":"Lints » warn","id":"37","title":"warn"},"38":{"body":"A 'deny' lint produces an error if you violate it. For example, this code runs into the exceeding_bitshifts lint. fn main() { 100u8 << 10;\n} $ rustc main.rs\nerror: bitshift exceeds the type's number of bits --> main.rs:2:13 |\n2 | 100u8 << 10; | ^^^^^^^^^^^ | = note: `#[deny(exceeding_bitshifts)]` on by default What's the difference between an error from a lint and a regular old error? Lints are configurable via levels, so in a similar way to 'allow' lints, warnings that are 'deny' by default let you allow them. Similarly, you may wish to set up a lint that is warn by default to produce an error instead. This lint level gives you that.","breadcrumbs":"Lints » deny","id":"38","title":"deny"},"39":{"body":"'forbid' is a special lint level that's stronger than 'deny'. It's the same as 'deny' in that a lint at this level will produce an error, but unlike the 'deny' level, the 'forbid' level can not be overridden to be anything lower than an error. However, lint levels may still be capped with --cap-lints (see below) so rustc --cap-lints warn will make lints set to 'forbid' just warn.","breadcrumbs":"Lints » forbid","id":"39","title":"forbid"},"4":{"body":"This flag can turn on or off various #[cfg] settings. The value can either be a single identifier or two identifiers separated by =. For examples, --cfg 'verbose' or --cfg 'feature=\"serde\"'. These correspond to #[cfg(verbose)] and #[cfg(feature = \"serde\")] respectively.","breadcrumbs":"--cfg: configure the compilation environment","id":"4","title":"--cfg: configure the compilation environment"},"40":{"body":"Remember our missing_docs example from the 'allow' lint level? $ cat lib.rs\npub fn foo() {}\n$ rustc lib.rs --crate-type=lib\n$ We can configure this lint to operate at a higher level, both with compiler flags, as well as with an attribute in the source code. You can also \"cap\" lints so that the compiler can choose to ignore certain lint levels. We'll talk about that last.","breadcrumbs":"Lints » Configuring warning levels","id":"40","title":"Configuring warning levels"},"41":{"body":"The -A, -W, -D, and -F flags let you turn one or more lints into allowed, warning, deny, or forbid levels, like this: $ rustc lib.rs --crate-type=lib -W missing-docs\nwarning: missing documentation for crate --> lib.rs:1:1 |\n1 | pub fn foo() {} | ^^^^^^^^^^^^ | = note: requested on the command line with `-W missing-docs` warning: missing documentation for a function --> lib.rs:1:1 |\n1 | pub fn foo() {} | ^^^^^^^^^^^^ $ rustc lib.rs --crate-type=lib -D missing-docs\nerror: missing documentation for crate --> lib.rs:1:1 |\n1 | pub fn foo() {} | ^^^^^^^^^^^^ | = note: requested on the command line with `-D missing-docs` error: missing documentation for a function --> lib.rs:1:1 |\n1 | pub fn foo() {} | ^^^^^^^^^^^^ error: aborting due to 2 previous errors You can also pass each flag more than once for changing multiple lints: $ rustc lib.rs --crate-type=lib -D missing-docs -D unused-variables And of course, you can mix these four flags together: $ rustc lib.rs --crate-type=lib -D missing-docs -A unused-variables","breadcrumbs":"Lints » Via compiler flag","id":"41","title":"Via compiler flag"},"42":{"body":"You can also modify the lint level with a crate-wide attribute: $ cat lib.rs\n#![warn(missing_docs)] pub fn foo() {}\n$ rustc lib.rs --crate-type=lib\nwarning: missing documentation for crate --> lib.rs:1:1 |\n1 | / #![warn(missing_docs)]\n2 | |\n3 | | pub fn foo() {} | |_______________^ |\nnote: lint level defined here --> lib.rs:1:9 |\n1 | #![warn(missing_docs)] | ^^^^^^^^^^^^ warning: missing documentation for a function --> lib.rs:3:1 |\n3 | pub fn foo() {} | ^^^^^^^^^^^^ All four, warn, allow, deny, and forbid all work this way. You can also pass in multiple lints per attribute: #![warn(missing_docs, unused_variables)] pub fn foo() {} And use multiple attributes together: #![warn(missing_docs)]\n#![deny(unused_variables)] pub fn foo() {}","breadcrumbs":"Lints » Via an attribute","id":"42","title":"Via an attribute"},"43":{"body":"rustc supports a flag, --cap-lints LEVEL that sets the \"lint cap level.\" This is the maximum level for all lints. So for example, if we take our code sample from the \"deny\" lint level above: fn main() { 100u8 << 10;\n} And we compile it, capping lints to warn: $ rustc lib.rs --cap-lints warn\nwarning: bitshift exceeds the type's number of bits --> lib.rs:2:5 |\n2 | 100u8 << 10; | ^^^^^^^^^^^ | = note: `#[warn(exceeding_bitshifts)]` on by default warning: this expression will panic at run-time --> lib.rs:2:5 |\n2 | 100u8 << 10; | ^^^^^^^^^^^ attempt to shift left with overflow It now only warns, rather than errors. We can go further and allow all lints: $ rustc lib.rs --cap-lints allow\n$ This feature is used heavily by Cargo; it will pass --cap-lints allow when compiling your dependencies, so that if they have any warnings, they do not pollute the output of your build.","breadcrumbs":"Lints » Capping lints","id":"43","title":"Capping lints"},"44":{"body":"rustc has the concept of a \"lint group\", where you can toggle several warnings through one name. For example, the nonstandard-style lint sets non-camel-case-types, non-snake-case, and non-upper-case-globals all at once. So these are equivalent: $ rustc -D nonstandard-style\n$ rustc -D non-camel-case-types -D non-snake-case -D non-upper-case-globals Here's a list of each lint group, and the lints that they are made up of: group description lints nonstandard-style Violation of standard naming conventions non-camel-case-types, non-snake-case, non-upper-case-globals warnings all lints that would be issuing warnings all lints that would be issuing warnings edition-2018 Lints that will be turned into errors in Rust 2018 tyvar-behind-raw-pointer rust-2018-idioms Lints to nudge you toward idiomatic features of Rust 2018 bare-trait-object, unreachable-pub unused These lints detect things being declared but not used unused-imports, unused-variables, unused-assignments, dead-code, unused-mut, unreachable-code, unreachable-patterns, unused-must-use, unused-unsafe, path-statements, unused-attributes, unused-macros, unused-allocation, unused-doc-comment, unused-extern-crates, unused-features, unused-parens future-incompatible Lints that detect code that has future-compatibility problems private-in-public, pub-use-of-private-extern-crate, patterns-in-fns-without-body, safe-extern-statics, invalid-type-param-default, legacy-directory-ownership, legacy-imports, legacy-constructor-visibility, missing-fragment-specifier, illegal-floating-point-literal-pattern, anonymous-parameters, parenthesized-params-in-types-and-modules, late-bound-lifetime-arguments, safe-packed-borrows, tyvar-behind-raw-pointer, unstable-name-collision Additionally, there's a bad-style lint group that's a deprecated alias for nonstandard-style. Finally, you can also see the table above by invoking rustc -W help. This will give you the exact values for the specific compiler you have installed.","breadcrumbs":"Lints » Lint Groups","id":"44","title":"Lint Groups"},"45":{"body":"This section lists out all of the lints, grouped by their default lint levels. You can also see this list by running rustc -W help.","breadcrumbs":"Lints » Lint listing","id":"45","title":"Lint listing"},"46":{"body":"These lints are all set to the 'allow' level by default. As such, they won't show up unless you set them to a higher lint level with a flag or attribute.","breadcrumbs":"Lints » Lint listing » Allowed-by-default lints","id":"46","title":"Allowed-by-default lints"},"47":{"body":"This lint detects anonymous parameters. Some example code that triggers this lint: trait Foo { fn foo(usize);\n} When set to 'deny', this will produce: error: use of deprecated anonymous parameter --> src/lib.rs:5:11 |\n5 | fn foo(usize); | ^ | = warning: this was previously accepted by the compiler but is being phased out; it will become a hard error in a future release! = note: for more information, see issue #41686 <https://github.com/rust-lang/rust/issues/41686> This syntax is mostly a historical accident, and can be worked around quite easily: trait Foo { fn foo(_: usize);\n}","breadcrumbs":"Lints » Lint listing » anonymous-parameters","id":"47","title":"anonymous-parameters"},"48":{"body":"This lint suggests using dyn Trait for trait objects. Some example code that triggers this lint: #![feature(dyn_trait)] trait Trait { } fn takes_trait_object(_: Box<Trait>) {\n} When set to 'deny', this will produce: error: trait objects without an explicit `dyn` are deprecated --> src/lib.rs:7:30 |\n7 | fn takes_trait_object(_: Box<Trait>) { | ^^^^^ help: use `dyn`: `dyn Trait` | To fix it, do as the help message suggests: #![feature(dyn_trait)]\n#![deny(bare_trait_objects)] trait Trait { } fn takes_trait_object(_: Box<dyn Trait>) {\n}","breadcrumbs":"Lints » Lint listing » bare-trait-object","id":"48","title":"bare-trait-object"},"49":{"body":"This lints use of the Box type. Some example code that triggers this lint: struct Foo { x: Box<isize>,\n} When set to 'deny', this will produce: error: type uses owned (Box type) pointers: std::boxed::Box<isize> --> src/lib.rs:6:5 |\n6 | x: Box<isize> //~ ERROR type uses owned | ^^^^^^^^^^^^^ | This lint is mostly historical, and not particularly useful. Box<T> used to be built into the language, and the only way to do heap allocation. Today's Rust can call into other allocators, etc.","breadcrumbs":"Lints » Lint listing » box-pointers","id":"49","title":"box-pointers"},"5":{"body":"When looking for external crates or libraries, a directory passed to this flag will be searched. The kind of search path can optionally be specified with the form -L KIND=PATH where KIND may be one of: dependency — Only search for transitive dependencies in this directory. crate — Only search for this crate's direct dependencies in this directory. native — Only search for native libraries in this directory. framework — Only search for macOS frameworks in this directory. all — Search for all library kinds in this directory. This is the default if KIND is not specified.","breadcrumbs":"-L: add a directory to the library search path","id":"5","title":"-L: add a directory to the library search path"},"50":{"body":"This lint detects the use of hidden lifetime parameters. Some example code that triggers this lint: struct Foo<'a> { x: &'a u32\n} fn foo(x: &Foo) {\n} When set to 'deny', this will produce: error: hidden lifetime parameters are deprecated, try `Foo<'_>` --> src/lib.rs:5:12 |\n5 | fn foo(x: &Foo) { | ^^^ | Lifetime elision elides this lifetime, but that is being deprecated.","breadcrumbs":"Lints » Lint listing » elided-lifetime-in-path","id":"50","title":"elided-lifetime-in-path"},"51":{"body":"This lint detects potentially-forgotten implementations of Copy. Some example code that triggers this lint: pub struct Foo { pub field: i32\n} When set to 'deny', this will produce: error: type could implement `Copy`; consider adding `impl Copy` --> src/main.rs:3:1 |\n3 | / pub struct Foo { //~ ERROR type could implement `Copy`; consider adding `impl Copy`\n4 | | pub field: i32\n5 | | } | |_^ | You can fix the lint by deriving Copy. This lint is set to 'allow' because this code isn't bad; it's common to write newtypes like this specifically so that a Copy type is no longer Copy.","breadcrumbs":"Lints » Lint listing » missing-copy-implementations","id":"51","title":"missing-copy-implementations"},"52":{"body":"This lint detects missing implementations of fmt::Debug. Some example code that triggers this lint: pub struct Foo; When set to 'deny', this will produce: error: type does not implement `fmt::Debug`; consider adding `#[derive(Debug)]` or a manual implementation --> src/main.rs:3:1 |\n3 | pub struct Foo; | ^^^^^^^^^^^^^^^ | You can fix the lint by deriving Debug.","breadcrumbs":"Lints » Lint listing » missing-debug-implementations","id":"52","title":"missing-debug-implementations"},"53":{"body":"This lint detects missing documentation for public items. Some example code that triggers this lint: pub fn foo() {} When set to 'deny', this will produce: error: missing documentation for crate --> src/main.rs:1:1 |\n1 | / #![deny(missing_docs)]\n2 | |\n3 | | pub fn foo() {}\n4 | |\n5 | | fn main() {} | |____________^ | error: missing documentation for a function --> src/main.rs:3:1 |\n3 | pub fn foo() {} | ^^^^^^^^^^^^ To fix the lint, add documentation to all items.","breadcrumbs":"Lints » Lint listing » missing-docs","id":"53","title":"missing-docs"},"54":{"body":"This lint detects lifetimes that are only used once. Some example code that triggers this lint: struct Foo<'x> { x: &'x u32\n} When set to 'deny', this will produce: error: lifetime name `'x` only used once --> src/main.rs:3:12 |\n3 | struct Foo<'x> { | ^^ |","breadcrumbs":"Lints » Lint listing » single-use-lifetime","id":"54","title":"single-use-lifetime"},"55":{"body":"This lint detects trivial casts which could be removed. Some example code that triggers this lint: let x: &u32 = &42;\nlet _ = x as *const u32; When set to 'deny', this will produce: error: trivial cast: `&u32` as `*const u32`. Cast can be replaced by coercion, this might require type ascription or a temporary variable --> src/main.rs:5:13 |\n5 | let _ = x as *const u32; | ^^^^^^^^^^^^^^^ |\nnote: lint level defined here --> src/main.rs:1:9 |\n1 | #![deny(trivial_casts)] | ^^^^^^^^^^^^^","breadcrumbs":"Lints » Lint listing » trivial-casts","id":"55","title":"trivial-casts"},"56":{"body":"This lint detects trivial casts of numeric types which could be removed. Some example code that triggers this lint: let x = 42i32 as i32; When set to 'deny', this will produce: error: trivial numeric cast: `i32` as `i32`. Cast can be replaced by coercion, this might require type ascription or a temporary variable --> src/main.rs:4:13 |\n4 | let x = 42i32 as i32; | ^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » trivial-numeric-casts","id":"56","title":"trivial-numeric-casts"},"57":{"body":"This lint triggers for pub items not reachable from the crate root. Some example code that triggers this lint: mod foo { pub mod bar { }\n} When set to 'deny', this will produce: error: unreachable `pub` item --> src/main.rs:4:5 |\n4 | pub mod bar { | ---^^^^^^^^ | | | help: consider restricting its visibility: `pub(crate)` |","breadcrumbs":"Lints » Lint listing » unreachable-pub","id":"57","title":"unreachable-pub"},"58":{"body":"This lint catches usage of unsafe code. Some example code that triggers this lint: fn main() { unsafe { }\n} When set to 'deny', this will produce: error: usage of an `unsafe` block --> src/main.rs:4:5 |\n4 | / unsafe {\n5 | | 6 | | } | |_____^ |","breadcrumbs":"Lints » Lint listing » unsafe-code","id":"58","title":"unsafe-code"},"59":{"body":"This lint is deprecated and no longer used.","breadcrumbs":"Lints » Lint listing » unstable-features","id":"59","title":"unstable-features"},"6":{"body":"This flag allows you to specify linking to a specific native library when building a crate. The kind of library can optionally be specified with the form -l KIND=lib where KIND may be one of: dylib — A native dynamic library. static — A native static library (such as a .a archive). framework — A macOS framework. The kind of library can be specified in a #[link] attribute . If the kind is not specified in the link attribute or on the command-line, it will link a dynamic library if available, otherwise it will use a static library. If the kind is specified on the command-line, it will override the kind specified in a link attribute. The name used in a link attribute may be overridden using the form -l ATTR_NAME:LINK_NAME where ATTR_NAME is the name in the link attribute, and LINK_NAME is the name of the actual library that will be linked.","breadcrumbs":"-l: link the generated crate to a native library","id":"6","title":"-l: link the generated crate to a native library"},"60":{"body":"This lint guards against extern crate items that are never used. Some example code that triggers this lint: extern crate semver; When set to 'deny', this will produce: error: unused extern crate --> src/main.rs:3:1 |\n3 | extern crate semver; | ^^^^^^^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » unused-extern-crates","id":"60","title":"unused-extern-crates"},"61":{"body":"This lint catches unnecessary braces around an imported item. Some example code that triggers this lint: use test::{A}; pub mod test { pub struct A;\n}\n# fn main() {} When set to 'deny', this will produce: error: braces around A is unnecessary --> src/main.rs:3:1 |\n3 | use test::{A}; | ^^^^^^^^^^^^^^ | To fix it, use test::A;","breadcrumbs":"Lints » Lint listing » unused-import-braces","id":"61","title":"unused-import-braces"},"62":{"body":"This lint detects unnecessarily qualified names. Some example code that triggers this lint: mod foo { pub fn bar() {}\n} fn main() { use foo::bar; foo::bar();\n} When set to 'deny', this will produce: error: unnecessary qualification --> src/main.rs:9:5 |\n9 | foo::bar(); | ^^^^^^^^ | You can call bar() directly, without the foo::.","breadcrumbs":"Lints » Lint listing » unused-qualifications","id":"62","title":"unused-qualifications"},"63":{"body":"This lint checks for the unused result of an expression in a statement. Some example code that triggers this lint: fn foo<T>() -> T { panic!() } fn main() { foo::<usize>();\n} When set to 'deny', this will produce: error: unused result --> src/main.rs:6:5 |\n6 | foo::<usize>(); | ^^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » unused-results","id":"63","title":"unused-results"},"64":{"body":"This lint detects enums with widely varying variant sizes. Some example code that triggers this lint: enum En { V0(u8), VBig([u8; 1024]),\n} When set to 'deny', this will produce: error: enum variant is more than three times larger (1024 bytes) than the next largest --> src/main.rs:5:5 |\n5 | VBig([u8; 1024]), //~ ERROR variant is more than three times larger | ^^^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » variant-size-differences","id":"64","title":"variant-size-differences"},"65":{"body":"These lints are all set to the 'warn' level by default.","breadcrumbs":"Lints » Lint listing » Warn-by-default lints","id":"65","title":"Warn-by-default lints"},"66":{"body":"This lint detects an erroneous expression while doing constant evaluation. Some example code that triggers this lint: let b = 200u8 + 200u8; This will produce: warning: attempt to add with overflow --> src/main.rs:2:9 |\n2 | let b = 200u8 + 200u8; | ^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » const-err","id":"66","title":"const-err"},"67":{"body":"This lint detects unused, unexported items. Some example code that triggers this lint: fn foo() {} This will produce: warning: function is never used: `foo` --> src/lib.rs:2:1 |\n2 | fn foo() {} | ^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » dead-code","id":"67","title":"dead-code"},"68":{"body":"This lint detects use of deprecated items. Some example code that triggers this lint: #[deprecated]\nfn foo() {} fn bar() { foo();\n} This will produce: warning: use of deprecated item 'foo' --> src/lib.rs:7:5 |\n7 | foo(); | ^^^ |","breadcrumbs":"Lints » Lint listing » deprecated","id":"68","title":"deprecated"},"69":{"body":"This lint detects floating-point literals used in patterns. Some example code that triggers this lint: let x = 42.0; match x { 5.0 => {}, _ => {},\n} This will produce: warning: floating-point literals cannot be used in patterns --> src/main.rs:4:9 |\n4 | 5.0 => {}, | ^^^ | = note: `#[warn(illegal_floating_point_literal_pattern)]` on by default = warning: this was previously accepted by the compiler but is being phased out; it will become a hard error in a future release! = note: for more information, see issue #41620 <https://github.com/rust-lang/rust/issues/41620>","breadcrumbs":"Lints » Lint listing » illegal-floating-point-literal-pattern","id":"69","title":"illegal-floating-point-literal-pattern"},"7":{"body":"This instructs rustc on which crate type to build. This flag accepts a comma-separated list of values, and may be specified multiple times. The valid crate types are: lib — Generates a library kind preferred by the compiler, currently defaults to rlib. rlib — A Rust static library. staticlib — A native static library. dylib — A Rust dynamic library. cdylib — A native dynamic library. bin — A runnable executable program. proc-macro — Generates a format suitable for a procedural macro library that may be loaded by the compiler. The crate type may be specified with the crate_type attribute . The --crate-type command-line value will override the crate_type attribute. More details may be found in the linkage chapter of the reference.","breadcrumbs":"--crate-type: a list of types of crates for the compiler to emit","id":"7","title":"--crate-type: a list of types of crates for the compiler to emit"},"70":{"body":"This lint detects proper use of libc types in foreign modules. Some example code that triggers this lint: extern \"C\" { static STATIC: String;\n} This will produce: warning: found struct without foreign-function-safe representation annotation in foreign module, consider adding a `#[repr(C)]` attribute to the type --> src/main.rs:2:20 |\n2 | static STATIC: String; | ^^^^^^ |","breadcrumbs":"Lints » Lint listing » improper-ctypes","id":"70","title":"improper-ctypes"},"71":{"body":"This lint detects generic lifetime arguments in path segments with late bound lifetime parameters. Some example code that triggers this lint: struct S; impl S { fn late<'a, 'b>(self, _: &'a u8, _: &'b u8) {}\n} fn main() { S.late::<'static>(&0, &0);\n} This will produce: warning: cannot specify lifetime arguments explicitly if late bound lifetime parameters are present --> src/main.rs:8:14 |\n4 | fn late<'a, 'b>(self, _: &'a u8, _: &'b u8) {} | -- the late bound lifetime parameter is introduced here\n...\n8 | S.late::<'static>(&0, &0); | ^^^^^^^ | = note: `#[warn(late_bound_lifetime_arguments)]` on by default = warning: this was previously accepted by the compiler but is being phased out; it will become a hard error in a future release! = note: for more information, see issue #42868 <https://github.com/rust-lang/rust/issues/42868>","breadcrumbs":"Lints » Lint listing » late-bound-lifetime-arguments","id":"71","title":"late-bound-lifetime-arguments"},"72":{"body":"This lint detects types, variants, traits and type parameters that don't have camel case names. Some example code that triggers this lint: struct s; This will produce: warning: type `s` should have a camel case name such as `S` --> src/main.rs:1:1 |\n1 | struct s; | ^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » non-camel-case-types","id":"72","title":"non-camel-case-types"},"73":{"body":"This lint detects using Struct { x: x } instead of Struct { x } in a pattern. Some example code that triggers this lint: struct Point { x: i32, y: i32,\n} fn main() { let p = Point { x: 5, y: 5, }; match p { Point { x: x, y: y } => (), }\n} This will produce: warning: the `x:` in this pattern is redundant --> src/main.rs:14:17 |\n14 | Point { x: x, y: y } => (), | --^^ | | | help: remove this | warning: the `y:` in this pattern is redundant --> src/main.rs:14:23 |\n14 | Point { x: x, y: y } => (), | --^^ | | | help: remove this","breadcrumbs":"Lints » Lint listing » non-shorthand-field-patterns","id":"73","title":"non-shorthand-field-patterns"},"74":{"body":"This lint detects variables, methods, functions, lifetime parameters and modules that don't have snake case names. Some example code that triggers this lint: let X = 5; This will produce: warning: variable `X` should have a snake case name such as `x` --> src/main.rs:2:9 |\n2 | let X = 5; | ^ |","breadcrumbs":"Lints » Lint listing » non-snake-case","id":"74","title":"non-snake-case"},"75":{"body":"This lint detects static constants that don't have uppercase identifiers. Some example code that triggers this lint: static x: i32 = 5; This will produce: warning: static variable `x` should have an upper case name such as `X` --> src/main.rs:1:1 |\n1 | static x: i32 = 5; | ^^^^^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » non-upper-case-globals","id":"75","title":"non-upper-case-globals"},"76":{"body":"This lint detects generic items must be mangled. Some example code that triggers this lint: #[no_mangle]\nfn foo<T>(t: T) { } This will produce: warning: functions generic over types must be mangled --> src/main.rs:2:1 |\n1 | #[no_mangle] | ------------ help: remove this attribute\n2 | / fn foo<T>(t: T) {\n3 | |\n4 | | } | |_^ |","breadcrumbs":"Lints » Lint listing » no-mangle-generic-items","id":"76","title":"no-mangle-generic-items"},"77":{"body":"This lint detects path statements with no effect. Some example code that triggers this lint: let x = 42; x; This will produce: warning: path statement with no effect --> src/main.rs:3:5 |\n3 | x; | ^^ |","breadcrumbs":"Lints » Lint listing » path-statements","id":"77","title":"path-statements"},"78":{"body":"This lint detects patterns in functions without body were that were previously erroneously allowed. Some example code that triggers this lint: trait Trait { fn foo(mut arg: u8);\n} This will produce: warning: patterns aren't allowed in methods without bodies --> src/main.rs:2:12 |\n2 | fn foo(mut arg: u8); | ^^^^^^^ | = note: `#[warn(patterns_in_fns_without_body)]` on by default = warning: this was previously accepted by the compiler but is being phased out; it will become a hard error in a future release! = note: for more information, see issue #35203 <https://github.com/rust-lang/rust/issues/35203> To fix this, remove the pattern; it can be used in the implementation without being used in the definition. That is: trait Trait { fn foo(arg: u8);\n} impl Trait for i32 { fn foo(mut arg: u8) { }\n}","breadcrumbs":"Lints » Lint listing » patterns-in-fns-without-body","id":"78","title":"patterns-in-fns-without-body"},"79":{"body":"This lint detects when compiler plugins are used as ordinary library in non-plugin crate. Some example code that triggers this lint: #![feature(plugin)]\n#![plugin(macro_crate_test)] extern crate macro_crate_test;","breadcrumbs":"Lints » Lint listing » plugin-as-library","id":"79","title":"plugin-as-library"},"8":{"body":"This informs rustc of the name of your crate.","breadcrumbs":"--crate-name: specify the name of the crate being built","id":"8","title":"--crate-name: specify the name of the crate being built"},"80":{"body":"This lint detects private items in public interfaces not caught by the old implementation. Some example code that triggers this lint: pub trait Trait { type A;\n} pub struct S; mod foo { struct Z; impl ::Trait for ::S { type A = Z; }\n}\n# fn main() {} This will produce: error[E0446]: private type `foo::Z` in public interface --> src/main.rs:11:9 |\n11 | type A = Z; | ^^^^^^^^^^^ can't leak private type","breadcrumbs":"Lints » Lint listing » private-in-public","id":"80","title":"private-in-public"},"81":{"body":"This lint detects functions marked #[no_mangle] that are also private. Given that private functions aren't exposed publicly, and #[no_mangle] controls the public symbol, this combination is erroneous. Some example code that triggers this lint: #[no_mangle]\nfn foo() {} This will produce: warning: function is marked `#[no_mangle]`, but not exported --> src/main.rs:2:1 |\n2 | fn foo() {} | -^^^^^^^^^^ | | | help: try making it public: `pub` | To fix this, either make it public or remove the #[no_mangle].","breadcrumbs":"Lints » Lint listing » private-no-mangle-fns","id":"81","title":"private-no-mangle-fns"},"82":{"body":"This lint detects any statics marked #[no_mangle] that are private. Given that private statics aren't exposed publicly, and #[no_mangle] controls the public symbol, this combination is erroneous. Some example code that triggers this lint: #[no_mangle]\nstatic X: i32 = 4; This will produce: warning: static is marked `#[no_mangle]`, but not exported --> src/main.rs:2:1 |\n2 | static X: i32 = 4; | -^^^^^^^^^^^^^^^^^ | | | help: try making it public: `pub` | To fix this, either make it public or remove the #[no_mangle].","breadcrumbs":"Lints » Lint listing » private-no-mangle-statics","id":"82","title":"private-no-mangle-statics"},"83":{"body":"This lint detects lints that have been renamed or removed. Some example code that triggers this lint: #![deny(raw_pointer_derive)] This will produce: warning: lint raw_pointer_derive has been removed: using derive with raw pointers is ok --> src/main.rs:1:9 |\n1 | #![deny(raw_pointer_derive)] | ^^^^^^^^^^^^^^^^^^ | To fix this, either remove the lint or use the new name.","breadcrumbs":"Lints » Lint listing » renamed-and-removed-lints","id":"83","title":"renamed-and-removed-lints"},"84":{"body":"This lint detects borrowing a field in the interior of a packed structure with alignment other than 1. Some example code that triggers this lint: #[repr(packed)]\npub struct Unaligned<T>(pub T); pub struct Foo { start: u8, data: Unaligned<u32>,\n} fn main() { let x = Foo { start: 0, data: Unaligned(1) }; let y = &x.data.0;\n} This will produce: warning: borrow of packed field requires unsafe function or block (error E0133) --> src/main.rs:11:13 |\n11 | let y = &x.data.0; | ^^^^^^^^^ | = note: `#[warn(safe_packed_borrows)]` on by default = warning: this was previously accepted by the compiler but is being phased out; it will become a hard error in a future release! = note: for more information, see issue #46043 <https://github.com/rust-lang/rust/issues/46043>","breadcrumbs":"Lints » Lint listing » safe-packed-borrows","id":"84","title":"safe-packed-borrows"},"85":{"body":"This lint detects a #[feature] attribute that's since been made stable. Some example code that triggers this lint: #![feature(test_accepted_feature)] This will produce: warning: this feature has been stable since 1.0.0. Attribute no longer needed --> src/main.rs:1:12 |\n1 | #![feature(test_accepted_feature)] | ^^^^^^^^^^^^^^^^^^^^^ | To fix, simply remove the #![feature] attribute, as it's no longer needed.","breadcrumbs":"Lints » Lint listing » stable-features","id":"85","title":"stable-features"},"86":{"body":"This lint detects bounds in type aliases. These are not currently enforced. Some example code that triggers this lint: #[allow(dead_code)]\ntype SendVec<T: Send> = Vec<T>; This will produce: warning: bounds on generic parameters are not enforced in type aliases --> src/lib.rs:2:17 |\n2 | type SendVec<T: Send> = Vec<T>; | ^^^^ | = note: `#[warn(type_alias_bounds)]` on by default = help: the bound will not be checked when the type alias is used, and should be removed","breadcrumbs":"Lints » Lint listing » type-alias-bounds","id":"86","title":"type-alias-bounds"},"87":{"body":"This lint detects raw pointer to an inference variable. Some example code that triggers this lint: let data = std::ptr::null();\nlet _ = &data as *const *const (); if data.is_null() {} This will produce: warning: type annotations needed --> src/main.rs:4:13 |\n4 | if data.is_null() {} | ^^^^^^^ | = note: `#[warn(tyvar_behind_raw_pointer)]` on by default = warning: this was previously accepted by the compiler but is being phased out; it will become a hard error in the 2018 edition! = note: for more information, see issue #46906 <https://github.com/rust-lang/rust/issues/46906>","breadcrumbs":"Lints » Lint listing » tyvar-behind-raw-pointer","id":"87","title":"tyvar-behind-raw-pointer"},"88":{"body":"This lint detects functions that cannot return without calling themselves. Some example code that triggers this lint: fn foo() { foo();\n} This will produce: warning: function cannot return without recursing --> src/main.rs:1:1 |\n1 | fn foo() { | ^^^^^^^^ cannot return without recursing\n2 | foo(); | ----- recursive call site |","breadcrumbs":"Lints » Lint listing » unconditional-recursion","id":"88","title":"unconditional-recursion"},"89":{"body":"This lint detects use of unions that contain fields with possibly non-trivial drop code. Some example code that triggers this lint: #![feature(untagged_unions)] union U { s: String,\n} This will produce: warning: union contains a field with possibly non-trivial drop code, drop code of union fields is ignored when dropping the union --> src/main.rs:4:5 |\n4 | s: String, | ^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » unions-with-drop-fields","id":"89","title":"unions-with-drop-fields"},"9":{"body":"This flag takes a value of 2015 or 2018. The default is 2015. More information about editions may be found in the edition guide .","breadcrumbs":"--edition: specify the edition to use","id":"9","title":"--edition: specify the edition to use"},"90":{"body":"This lint detects unrecognized lint attribute. Some example code that triggers this lint: #[allow(not_a_real_lint)] This will produce: warning: unknown lint: `not_a_real_lint` --> src/main.rs:1:10 |\n1 | #![allow(not_a_real_lint)] | ^^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » unknown-lints","id":"90","title":"unknown-lints"},"91":{"body":"This lint detects unreachable code paths. Some example code that triggers this lint: panic!(\"we never go past here!\"); let x = 5; This will produce: warning: unreachable statement --> src/main.rs:4:5 |\n4 | let x = 5; | ^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » unreachable-code","id":"91","title":"unreachable-code"},"92":{"body":"This lint detects unreachable patterns. Some example code that triggers this lint: let x = 5;\nmatch x { y => (), 5 => (),\n} This will produce: warning: unreachable pattern --> src/main.rs:5:5 |\n5 | 5 => (), | ^ | The y pattern will always match, so the five is impossible to reach. Remember, match arms match in order, you probably wanted to put the 5 case above the y case.","breadcrumbs":"Lints » Lint listing » unreachable-patterns","id":"92","title":"unreachable-patterns"},"93":{"body":"This lint detects that you've used a name that the standard library plans to add in the future, which means that your code may fail to compile without additional type annotations in the future. Either rename, or add those annotations now.","breadcrumbs":"Lints » Lint listing » unstable-name-collision","id":"93","title":"unstable-name-collision"},"94":{"body":"This lint detects unnecessary allocations that can be eliminated.","breadcrumbs":"Lints » Lint listing » unused-allocation","id":"94","title":"unused-allocation"},"95":{"body":"This lint detects assignments that will never be read. Some example code that triggers this lint: let mut x = 5;\nx = 6; This will produce: warning: value assigned to `x` is never read --> src/main.rs:4:5 |\n4 | x = 6; | ^ |","breadcrumbs":"Lints » Lint listing » unused-assignments","id":"95","title":"unused-assignments"},"96":{"body":"This lint detects attributes that were not used by the compiler. Some example code that triggers this lint: #![macro_export] This will produce: warning: unused attribute --> src/main.rs:1:1 |\n1 | #![macro_export] | ^^^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » unused-attributes","id":"96","title":"unused-attributes"},"97":{"body":"This lint detects comparisons made useless by limits of the types involved. Some example code that triggers this lint: fn foo(x: u8) { x >= 0;\n} This will produce: warning: comparison is useless due to type limits --> src/main.rs:6:5 |\n6 | x >= 0; | ^^^^^^ |","breadcrumbs":"Lints » Lint listing » unused-comparisons","id":"97","title":"unused-comparisons"},"98":{"body":"This lint detects doc comments that aren't used by rustdoc. Some example code that triggers this lint: /// docs for x\nlet x = 12; This will produce: warning: doc comment not used by rustdoc --> src/main.rs:2:5 |\n2 | /// docs for x | ^^^^^^^^^^^^^^ |","breadcrumbs":"Lints » Lint listing » unused-doc-comment","id":"98","title":"unused-doc-comment"},"99":{"body":"This lint detects unused or unknown features found in crate-level #[feature] directives. To fix this, simply remove the feature flag.","breadcrumbs":"Lints » Lint listing » unused-features","id":"99","title":"unused-features"}},"length":174,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{"df":6,"docs":{"151":{"tf":1.0},"152":{"tf":1.0},"165":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"84":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"1":{".":{"0":{".":{"0":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"4":{"df":1,"docs":{"172":{"tf":1.0}}},"5":{"df":1,"docs":{"172":{"tf":1.0}}},"6":{"df":1,"docs":{"172":{"tf":1.0}}},"7":{"df":1,"docs":{"172":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}},"df":0,"docs":{},"u":{"8":{"df":2,"docs":{"38":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"2":{"4":{"df":1,"docs":{"64":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":2,"docs":{"38":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772}}},"1":{"df":2,"docs":{"80":{"tf":1.0},"84":{"tf":1.0}}},"2":{"df":1,"docs":{"98":{"tf":1.0}}},"4":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"5":{"0":{"6":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":20,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"121":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.4142135623730951},"53":{"tf":1.0},"55":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}},"2":{"0":{"0":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"66":{"tf":2.0}}},"df":0,"docs":{}}},"1":{"5":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"8":{"df":3,"docs":{"44":{"tf":2.0},"87":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"5":{"df":1,"docs":{"154":{"tf":1.0}}},"df":0,"docs":{}},"df":31,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"53":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"98":{"tf":1.0}}},"3":{"2":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}},"5":{"2":{"0":{"3":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"8":{"8":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{"0":{"7":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"101":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"152":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"42":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}},"4":{"1":{"6":{"2":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"2":{"3":{"8":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"6":{"8":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":1.0},"77":{"tf":1.0}},"i":{"3":{"2":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"6":{"0":{"4":{"3":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"6":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":16,"docs":{"111":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}},"5":{".":{"0":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":20,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":2.23606797749979},"95":{"tf":1.0}}},"6":{"df":6,"docs":{"102":{"tf":1.0},"49":{"tf":1.0},"58":{"tf":1.0},"63":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"7":{"df":3,"docs":{"172":{"tf":1.0},"48":{"tf":1.0},"68":{"tf":1.0}}},"8":{"df":2,"docs":{"172":{"tf":1.0},"71":{"tf":1.0}}},"9":{"df":1,"docs":{"62":{"tf":1.0}}},"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"101":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":2.0},"76":{"tf":1.0},"87":{"tf":1.0}},"x":{"df":3,"docs":{"106":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0}}}},"a":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"168":{"tf":1.0}},"l":{"df":1,"docs":{"160":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"155":{"tf":1.0},"41":{"tf":1.0}}}},"v":{"df":5,"docs":{"113":{"tf":1.0},"127":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"92":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":11,"docs":{"10":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"120":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"172":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"167":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":8,"docs":{"125":{"tf":1.0},"132":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.4142135623730951},"5":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"93":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"170":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"130":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"df":4,"docs":{"10":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"70":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"140":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"164":{"tf":1.0},"165":{"tf":1.0},"170":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":2,"docs":{"44":{"tf":1.0},"86":{"tf":1.4142135623730951}},"s":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":4,"docs":{"163":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951}}},"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"a":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":26,"docs":{"111":{"tf":1.4142135623730951},"120":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.0},"143":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.0},"167":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"114":{"tf":1.0},"31":{"tf":1.4142135623730951},"33":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"70":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":2,"docs":{"44":{"tf":1.0},"47":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"163":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":2.23606797749979}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"160":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"125":{"tf":1.4142135623730951},"126":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"113":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"172":{"tf":1.4142135623730951}}}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":2,"docs":{"123":{"tf":1.0},"170":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"=":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"125":{"tf":1.0}}}},"df":0,"docs":{}}},"df":5,"docs":{"126":{"tf":1.0},"133":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"133":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"165":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"171":{"tf":1.0},"2":{"tf":1.4142135623730951},"33":{"tf":2.0},"44":{"tf":1.0},"71":{"tf":1.7320508075688772}}}}}}}},"m":{"df":1,"docs":{"92":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"104":{"tf":1.0},"47":{"tf":1.0},"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"142":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"153":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"44":{"tf":1.0},"95":{"tf":1.7320508075688772}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"138":{"tf":1.0},"139":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.0}}}}}},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}},"e":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":13,"docs":{"113":{"tf":1.4142135623730951},"116":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":2.0},"44":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.7320508075688772},"90":{"tf":1.0},"96":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"160":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"34":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{">":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"164":{"tf":1.4142135623730951},"165":{"tf":1.0}}}},"d":{"df":2,"docs":{"44":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":4,"docs":{"113":{"tf":1.0},"57":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"68":{"tf":1.0}},"e":{"df":2,"docs":{"44":{"tf":1.0},"48":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"167":{"tf":1.0},"168":{"tf":1.0},"172":{"tf":1.0}}},"i":{"c":{"df":3,"docs":{"1":{"tf":1.0},"152":{"tf":1.0},"163":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":2,"docs":{"66":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":9,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}}}},"df":13,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"167":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"164":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"115":{"tf":1.4142135623730951},"128":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"44":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"165":{"tf":1.0},"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"172":{"tf":1.0}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"152":{"tf":1.4142135623730951},"157":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"164":{"tf":2.0},"165":{"tf":1.7320508075688772},"168":{"tf":1.0}}}}},"df":1,"docs":{"7":{"tf":1.0}}},"t":{"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"10":{"tf":1.0},"168":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{}}},"df":4,"docs":{"107":{"tf":1.0},"110":{"tf":1.4142135623730951},"38":{"tf":1.0},"43":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"110":{"tf":1.4142135623730951},"38":{"tf":1.0},"43":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"33":{"tf":2.449489742783178}}},"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"105":{"tf":1.7320508075688772},"58":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"78":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"0":{"tf":1.7320508075688772},"173":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"44":{"tf":1.0},"84":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"168":{"tf":1.0},"172":{"tf":1.0},"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"167":{"tf":1.0}}}}},"df":3,"docs":{"44":{"tf":1.0},"71":{"tf":2.0},"86":{"tf":2.0}}},"df":0,"docs":{}}},"x":{"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"49":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"49":{"tf":1.7320508075688772}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"163":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"161":{"tf":1.0},"165":{"tf":2.449489742783178},"169":{"tf":1.0},"17":{"tf":1.0},"170":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"160":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"160":{"tf":1.7320508075688772},"163":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"165":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"c":{"/":{"c":{"df":4,"docs":{"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"160":{"tf":1.0},"49":{"tf":1.0},"62":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"44":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":4,"docs":{"24":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"43":{"tf":2.6457513110645907}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":5,"docs":{"0":{"tf":2.0},"165":{"tf":2.8284271247461903},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"43":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"168":{"tf":1.4142135623730951},"169":{"tf":1.0},"170":{"tf":1.0},"44":{"tf":3.0},"72":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951}}},"t":{"df":2,"docs":{"55":{"tf":2.0},"56":{"tf":2.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"115":{"tf":1.0},"120":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0}}}},"df":3,"docs":{"34":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}},"s":{"df":2,"docs":{"115":{"tf":1.0},"134":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":13,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.0},"122":{"tf":1.4142135623730951},"127":{"tf":1.0},"13":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.4142135623730951},"169":{"tf":2.0},"170":{"tf":2.449489742783178},"25":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"152":{"tf":1.0},"153":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"11":{"tf":1.7320508075688772},"4":{"tf":2.0}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"107":{"tf":1.4142135623730951},"112":{"tf":1.0},"172":{"tf":1.0},"41":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"157":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"35":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"136":{"tf":1.7320508075688772},"150":{"tf":1.0},"173":{"tf":1.0},"63":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"40":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"166":{"tf":1.0}}},"df":6,"docs":{"164":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":2.0},"170":{"tf":1.4142135623730951},"172":{"tf":2.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"b":{".":{"c":{"df":1,"docs":{"170":{"tf":1.4142135623730951}}},"df":0,"docs":{},"o":{"df":1,"docs":{"170":{"tf":2.0}}}},"df":0,"docs":{}},"df":1,"docs":{"33":{"tf":1.0}},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"170":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"=":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"170":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951}}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"o":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":94,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":2.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"124":{"tf":1.0},"128":{"tf":1.7320508075688772},"13":{"tf":1.0},"130":{"tf":1.0},"140":{"tf":1.4142135623730951},"145":{"tf":1.7320508075688772},"148":{"tf":1.4142135623730951},"155":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951},"170":{"tf":2.23606797749979},"25":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.0},"90":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"122":{"tf":1.4142135623730951},"148":{"tf":1.0},"25":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"157":{"tf":1.4142135623730951},"163":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"44":{"tf":1.0},"93":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":2.449489742783178},"33":{"tf":2.0}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"172":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.7320508075688772},"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"137":{"tf":1.0},"142":{"tf":1.0},"16":{"tf":1.0},"164":{"tf":1.0},"29":{"tf":1.0}}},"m":{"a":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}},"n":{"d":{"df":6,"docs":{"1":{"tf":1.0},"2":{"tf":1.4142135623730951},"33":{"tf":1.0},"41":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"164":{"tf":1.0},"51":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"97":{"tf":1.7320508075688772}}}}}}},"t":{"df":2,"docs":{"172":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":41,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":2.0},"10":{"tf":1.0},"11":{"tf":2.0},"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"148":{"tf":1.0},"156":{"tf":1.0},"159":{"tf":1.7320508075688772},"160":{"tf":1.0},"164":{"tf":2.23606797749979},"165":{"tf":2.0},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"169":{"tf":2.23606797749979},"17":{"tf":1.0},"170":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.7320508075688772},"71":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"163":{"tf":1.0},"44":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"11":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.4142135623730951}}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":9,"docs":{"106":{"tf":1.0},"115":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"116":{"tf":1.0},"66":{"tf":1.0},"75":{"tf":1.0}}}}},"df":4,"docs":{"116":{"tf":2.449489742783178},"55":{"tf":1.7320508075688772},"66":{"tf":1.0},"87":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"128":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"112":{"tf":1.7320508075688772},"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"10":{"tf":2.0},"113":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"89":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"173":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":16,"docs":{"10":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"136":{"tf":1.0},"14":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"155":{"tf":1.0},"18":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":3.0}}},"t":{"df":3,"docs":{"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"160":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"128":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"164":{"tf":2.23606797749979},"165":{"tf":2.0}}}}}}},"u":{"=":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"11":{"tf":1.7320508075688772},"130":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"b":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":1,"docs":{"10":{"tf":1.0}},"l":{"df":1,"docs":{"10":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":1,"docs":{"10":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"121":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}},"e":{"=":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":27,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":2.23606797749979},"11":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"15":{"tf":1.0},"165":{"tf":1.0},"169":{"tf":1.0},"17":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.449489742783178},"42":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"53":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"7":{"tf":2.449489742783178},"79":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"99":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.4142135623730951},"157":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.4142135623730951},"167":{"tf":1.0},"170":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"159":{"tf":1.0}}}}},"u":{"df":1,"docs":{"170":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"7":{"tf":1.0},"86":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"161":{"tf":1.7320508075688772},"33":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":8,"docs":{"147":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"163":{"tf":2.23606797749979},"164":{"tf":2.449489742783178},"165":{"tf":2.8284271247461903},"84":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":3,"docs":{"21":{"tf":1.0},"41":{"tf":2.449489742783178},"44":{"tf":2.0}},"e":{"a":{"d":{"df":3,"docs":{"128":{"tf":1.4142135623730951},"44":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":6,"docs":{"12":{"tf":1.0},"151":{"tf":1.7320508075688772},"153":{"tf":1.0},"165":{"tf":1.0},"32":{"tf":1.0},"52":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"=":{"2":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"151":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"_":{"<":{"df":0,"docs":{},"i":{"d":{">":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":34,"docs":{"10":{"tf":3.0},"109":{"tf":1.4142135623730951},"111":{"tf":2.0},"112":{"tf":1.0},"118":{"tf":1.0},"127":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"65":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"167":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"160":{"tf":1.0},"161":{"tf":1.0},"42":{"tf":1.0},"55":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"134":{"tf":1.0},"165":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"i":{"df":26,"docs":{"109":{"tf":1.4142135623730951},"120":{"tf":1.0},"21":{"tf":1.4142135623730951},"35":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}},"y":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"c":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"107":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"10":{"tf":1.0},"141":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":8,"docs":{"123":{"tf":1.0},"150":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"59":{"tf":1.0},"68":{"tf":2.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"51":{"tf":1.0},"52":{"tf":1.0},"83":{"tf":1.0}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"127":{"tf":1.0},"162":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":60,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"127":{"tf":1.0}}}}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":2.6457513110645907}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"1":{"tf":1.0},"131":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"38":{"tf":1.0},"64":{"tf":1.0}}}}}},"r":{"df":2,"docs":{"10":{"tf":1.0},"15":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"121":{"tf":1.0},"5":{"tf":1.0},"99":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"133":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.4142135623730951},"62":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"10":{"tf":1.0},"113":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"157":{"tf":1.0},"165":{"tf":1.4142135623730951},"32":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":2.6457513110645907}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"11":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"143":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"c":{"df":6,"docs":{"159":{"tf":1.0},"160":{"tf":1.0},"41":{"tf":2.449489742783178},"44":{"tf":1.0},"53":{"tf":1.0},"98":{"tf":2.23606797749979}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"166":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.4142135623730951},"53":{"tf":2.0}}}}}}}},"df":4,"docs":{"148":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":1.0},"66":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"165":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"134":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"89":{"tf":2.23606797749979}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"41":{"tf":1.0},"97":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"134":{"tf":1.0},"164":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"141":{"tf":1.4142135623730951},"164":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"df":1,"docs":{"48":{"tf":2.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":5,"docs":{"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.7320508075688772},"169":{"tf":1.0}}}},"0":{"1":{"3":{"3":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"h":{"df":11,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.0},"147":{"tf":1.0},"16":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.4142135623730951},"33":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"164":{"tf":1.0},"47":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"44":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":2.0}}}}},"df":1,"docs":{"114":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"94":{"tf":1.0}}}}},"s":{"df":1,"docs":{"50":{"tf":1.0}}}}},"m":{"b":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}},"t":{"df":7,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"157":{"tf":1.0},"168":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":2.6457513110645907},"7":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"137":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"140":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"11":{"tf":1.0},"131":{"tf":1.0},"143":{"tf":1.0},"156":{"tf":1.0},"164":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"173":{"tf":1.0}}},"df":1,"docs":{"64":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"137":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"165":{"tf":1.0},"166":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"111":{"tf":1.0},"64":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"165":{"tf":1.0},"4":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"166":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"111":{"tf":1.0},"66":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}},"r":{"[":{"df":0,"docs":{},"e":{"0":{"4":{"4":{"6":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":39,"docs":{"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"121":{"tf":1.0},"16":{"tf":2.0},"30":{"tf":1.4142135623730951},"33":{"tf":2.6457513110645907},"34":{"tf":1.4142135623730951},"38":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"41":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"c":{"df":3,"docs":{"163":{"tf":1.0},"32":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"122":{"tf":1.0},"172":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":80,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"110":{"tf":1.4142135623730951},"38":{"tf":1.0},"43":{"tf":1.0}},"e":{"d":{"df":1,"docs":{"110":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"35":{"tf":1.4142135623730951}}}},"n":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"171":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"s":{"df":2,"docs":{"81":{"tf":1.0},"82":{"tf":1.0}}}},"r":{"df":1,"docs":{"114":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"43":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"142":{"tf":1.0},"28":{"tf":1.7320508075688772},"44":{"tf":1.7320508075688772},"5":{"tf":1.0},"60":{"tf":2.23606797749979},"70":{"tf":1.0},"79":{"tf":1.0}}}}},"r":{"a":{"df":6,"docs":{"10":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"132":{"tf":1.0},"147":{"tf":1.4142135623730951},"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"t":{"df":1,"docs":{"129":{"tf":1.4142135623730951}}}},"df":3,"docs":{"112":{"tf":1.0},"22":{"tf":1.0},"41":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"11":{"tf":1.7320508075688772},"129":{"tf":1.0},"131":{"tf":2.0},"165":{"tf":1.0},"166":{"tf":1.0},"172":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"59":{"tf":1.0},"85":{"tf":2.0},"99":{"tf":2.0}},"e":{"(":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":1,"docs":{"164":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"33":{"tf":1.0},"51":{"tf":1.4142135623730951},"73":{"tf":1.0},"84":{"tf":1.4142135623730951},"89":{"tf":2.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":15,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":3.3166247903554},"11":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"134":{"tf":1.0},"158":{"tf":1.4142135623730951},"161":{"tf":1.0},"164":{"tf":3.4641016151377544},"165":{"tf":2.23606797749979},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":3.4641016151377544},"14":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}},"d":{"df":4,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"165":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"92":{"tf":1.0}}}},"x":{"df":14,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"99":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":62,"docs":{"10":{"tf":2.23606797749979},"102":{"tf":1.0},"11":{"tf":3.4641016151377544},"122":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"129":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"136":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"15":{"tf":1.4142135623730951},"151":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"43":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":2.23606797749979}}}}}},"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"140":{"tf":2.23606797749979},"44":{"tf":1.0},"69":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"168":{"tf":1.0},"169":{"tf":2.449489742783178},"170":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"168":{"tf":1.0},"170":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":33,"docs":{"1":{"tf":1.7320508075688772},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":2.23606797749979},"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"53":{"tf":2.0},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"78":{"tf":2.23606797749979},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"84":{"tf":1.0},"88":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"114":{"tf":1.0},"164":{"tf":1.0},"172":{"tf":1.0},"33":{"tf":1.0}}}}}},"o":{"(":{"_":{"df":1,"docs":{"47":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}},"x":{"df":2,"docs":{"50":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},".":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951}}}},"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"<":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"z":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":1,"docs":{"50":{"tf":1.0}}},"a":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"x":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"i":{"3":{"2":{">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}}},"=":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":21,"docs":{"1":{"tf":1.0},"116":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":2.23606797749979},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"57":{"tf":1.0},"62":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"88":{"tf":2.0}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":5,"docs":{"22":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":2.0},"41":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":2.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"df":4,"docs":{"169":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"df":5,"docs":{"10":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"121":{"tf":1.0},"164":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":4,"docs":{"164":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"166":{"tf":1.4142135623730951}}}}}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"151":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":13,"docs":{"154":{"tf":1.0},"17":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.7320508075688772},"84":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"166":{"tf":1.0},"43":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"172":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"w":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"g":{"df":1,"docs":{"12":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"=":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"164":{"tf":1.4142135623730951},"165":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":16,"docs":{"10":{"tf":3.3166247903554},"130":{"tf":1.0},"134":{"tf":1.0},"140":{"tf":1.4142135623730951},"148":{"tf":1.0},"157":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":1.7320508075688772},"166":{"tf":1.0},"25":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"76":{"tf":1.7320508075688772},"86":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0}},"n":{"df":5,"docs":{"127":{"tf":1.4142135623730951},"16":{"tf":1.0},"172":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"44":{"tf":1.7320508075688772},"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"165":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"165":{"tf":1.4142135623730951}}}},"o":{"df":2,"docs":{"43":{"tf":1.0},"91":{"tf":1.0}},"e":{"df":1,"docs":{"31":{"tf":1.0}}},"o":{"d":{"df":3,"docs":{"162":{"tf":1.0},"165":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"44":{"tf":2.23606797749979},"45":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"0":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"164":{"tf":1.0}},"l":{"df":1,"docs":{"172":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"155":{"tf":1.0}}}}}},"r":{"d":{"df":9,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"140":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"df":1,"docs":{"3":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"1":{"tf":1.0}}}},"r":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"p":{"df":20,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.0},"173":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.7320508075688772},"34":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"57":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"2":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0}}},"df":11,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0},"172":{"tf":1.0},"24":{"tf":1.0},"42":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.0},"91":{"tf":1.0}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"40":{"tf":1.0},"46":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"47":{"tf":1.0},"49":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"130":{"tf":1.0},"161":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"3":{"2":{">":{"(":{"&":{"5":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"116":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"56":{"tf":2.0},"73":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"40":{"tf":1.0},"89":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":2,"docs":{"44":{"tf":1.0},"69":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"51":{"tf":1.4142135623730951},"71":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"166":{"tf":1.0},"51":{"tf":2.0},"52":{"tf":2.0},"78":{"tf":1.0},"80":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"70":{"tf":1.0}}},"v":{"df":2,"docs":{"173":{"tf":1.0},"34":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"156":{"tf":1.4142135623730951}}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"127":{"tf":1.0},"87":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"10":{"tf":1.0},"151":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"m":{"df":19,"docs":{"11":{"tf":2.23606797749979},"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"151":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"113":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"163":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"163":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"164":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":12,"docs":{"0":{"tf":1.0},"106":{"tf":1.0},"115":{"tf":1.0},"134":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"17":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"129":{"tf":1.0},"130":{"tf":1.0},"140":{"tf":1.4142135623730951},"33":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"157":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":2.8284271247461903},"165":{"tf":1.7320508075688772}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"136":{"tf":1.0}},"r":{"df":2,"docs":{"0":{"tf":1.0},"142":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"166":{"tf":1.0}}}}},"f":{"a":{"c":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":2,"docs":{"142":{"tf":1.0},"173":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"167":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"34":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"111":{"tf":1.4142135623730951},"121":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":3,"docs":{"0":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"124":{"tf":1.0},"165":{"tf":1.0},"168":{"tf":1.0},"170":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"164":{"tf":1.0},"97":{"tf":1.0}}}}}}},"r":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":14,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"165":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}}}},"t":{"'":{"df":6,"docs":{"0":{"tf":1.0},"134":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"51":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":9,"docs":{"116":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"32":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"161":{"tf":2.0},"30":{"tf":1.4142135623730951},"33":{"tf":3.605551275463989}}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"120":{"tf":1.0},"172":{"tf":1.0},"5":{"tf":2.0},"6":{"tf":2.449489742783178},"7":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"172":{"tf":1.0}}}}}}},"l":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"3":{"5":{"2":{"0":{"3":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"8":{"8":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{"0":{"7":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"1":{"6":{"2":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"2":{"3":{"8":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"6":{"8":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"0":{"4":{"3":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"6":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"0":{"tf":1.0},"167":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"<":{"'":{"a":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"44":{"tf":1.0},"71":{"tf":2.0}},"r":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"163":{"tf":1.0}}}}}}},"d":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":5,"docs":{"169":{"tf":1.4142135623730951},"170":{"tf":1.0},"171":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"80":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"173":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"165":{"tf":1.4142135623730951},"43":{"tf":1.0}}}},"g":{"a":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"112":{"tf":1.0},"113":{"tf":1.0},"44":{"tf":1.7320508075688772}}},"y":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"'":{"df":2,"docs":{"1":{"tf":1.0},"35":{"tf":1.0}}},"df":17,"docs":{"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"=":{"2":{"df":4,"docs":{"13":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0}}},"df":0,"docs":{}},"df":23,"docs":{"10":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.0},"139":{"tf":1.0},"152":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"35":{"tf":2.23606797749979},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979},"40":{"tf":2.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"55":{"tf":1.0},"65":{"tf":1.0},"99":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":7,"docs":{"169":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951}},"s":{":":{"1":{":":{"1":{"df":2,"docs":{"41":{"tf":2.0},"42":{"tf":1.0}}},"9":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"5":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"9":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{":":{"1":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":3,"docs":{"11":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951},"7":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":10,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.4142135623730951},"28":{"tf":1.0},"5":{"tf":2.0},"6":{"tf":3.0},"7":{"tf":2.449489742783178},"79":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{".":{"a":{"df":1,"docs":{"170":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"44":{"tf":1.0},"50":{"tf":2.23606797749979},"54":{"tf":1.7320508075688772},"71":{"tf":2.449489742783178},"74":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":7,"docs":{"112":{"tf":1.0},"151":{"tf":1.0},"2":{"tf":1.4142135623730951},"30":{"tf":1.0},"41":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"k":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":14,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"141":{"tf":1.4142135623730951},"167":{"tf":1.7320508075688772},"169":{"tf":1.7320508075688772},"170":{"tf":1.0},"28":{"tf":1.0},"6":{"tf":3.0}},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"11":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":3.0},"128":{"tf":1.0},"167":{"tf":1.4142135623730951},"168":{"tf":1.7320508075688772},"169":{"tf":1.7320508075688772},"170":{"tf":1.4142135623730951},"171":{"tf":2.0},"172":{"tf":1.0}}}}},"t":{"df":91,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"34":{"tf":2.449489742783178},"35":{"tf":2.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.7320508075688772},"38":{"tf":2.6457513110645907},"39":{"tf":2.449489742783178},"40":{"tf":2.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"43":{"tf":3.1622776601683795},"44":{"tf":3.605551275463989},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"51":{"tf":2.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":2.449489742783178},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":2.23606797749979},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"165":{"tf":2.23606797749979}}}}},"s":{"df":0,"docs":{},"t":{"df":14,"docs":{"10":{"tf":1.0},"11":{"tf":2.8284271247461903},"122":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.4142135623730951},"137":{"tf":1.4142135623730951},"149":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.4142135623730951},"2":{"tf":1.0},"35":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":1.7320508075688772},"44":{"tf":1.0},"69":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"165":{"tf":1.0}}}}}},"l":{"d":{"df":2,"docs":{"169":{"tf":1.0},"171":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"'":{"df":2,"docs":{"164":{"tf":1.0},"166":{"tf":1.0}}},"df":12,"docs":{"10":{"tf":2.0},"129":{"tf":1.4142135623730951},"132":{"tf":1.0},"133":{"tf":1.4142135623730951},"142":{"tf":1.0},"164":{"tf":3.0},"165":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":2.23606797749979}}}}},"o":{"a":{"d":{"df":3,"docs":{"10":{"tf":1.0},"164":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}},"t":{"df":2,"docs":{"111":{"tf":1.0},"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0},"85":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"1":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.0},"29":{"tf":1.0},"5":{"tf":1.0}}},"p":{"df":4,"docs":{"108":{"tf":1.7320508075688772},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"152":{"tf":1.0}}}},"t":{"df":1,"docs":{"140":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"173":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"=":{"\"":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"171":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"129":{"tf":1.7320508075688772},"167":{"tf":1.7320508075688772},"168":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0}}}}},"m":{":":{":":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"130":{"tf":1.0},"163":{"tf":1.0}}}}},"o":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951}}}}}},"df":5,"docs":{"101":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"32":{"tf":1.0},"44":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"44":{"tf":1.0},"85":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"c":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}},"df":0,"docs":{},"o":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}},"r":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"164":{"tf":2.0},"170":{"tf":1.0},"171":{"tf":1.0},"34":{"tf":1.4142135623730951},"38":{"tf":1.0}},"s":{":":{"2":{":":{"1":{"3":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"9":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":19,"docs":{"1":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"164":{"tf":2.0},"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"17":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":11,"docs":{"11":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.7320508075688772},"169":{"tf":1.7320508075688772},"170":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"158":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"116":{"tf":1.0},"146":{"tf":1.0},"76":{"tf":1.7320508075688772},"81":{"tf":1.0},"82":{"tf":1.0}}}},"i":{"df":4,"docs":{"136":{"tf":1.0},"143":{"tf":1.0},"148":{"tf":1.0},"160":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"104":{"tf":1.0},"32":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"92":{"tf":2.0}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"y":{"b":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"112":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":6,"docs":{"116":{"tf":1.0},"159":{"tf":1.0},"165":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"93":{"tf":1.0}},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"164":{"tf":2.0},"165":{"tf":1.7320508075688772}},"e":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"16":{"tf":1.0},"30":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"74":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"114":{"tf":1.0},"41":{"tf":3.1622776601683795},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":2.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"36":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"x":{"df":1,"docs":{"41":{"tf":1.0}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}}},"df":7,"docs":{"1":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.0},"57":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"v":{"df":2,"docs":{"11":{"tf":1.7320508075688772},"145":{"tf":1.0}}}},"df":3,"docs":{"11":{"tf":3.0},"144":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"112":{"tf":1.0},"42":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":8,"docs":{"1":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.7320508075688772},"118":{"tf":1.0},"160":{"tf":1.0},"44":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":22,"docs":{"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"173":{"tf":1.0},"24":{"tf":1.0},"41":{"tf":1.4142135623730951},"47":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"36":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"113":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"164":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"102":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"115":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":4,"docs":{"103":{"tf":2.23606797749979},"115":{"tf":2.0},"44":{"tf":1.0},"95":{"tf":1.0}}}},"y":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"1":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":2,"docs":{"164":{"tf":1.0},"165":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":2,"docs":{"164":{"tf":1.0},"165":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":2,"docs":{"164":{"tf":1.0},"165":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"11":{"tf":2.0},"113":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":1.7320508075688772},"54":{"tf":1.0},"6":{"tf":1.7320508075688772},"62":{"tf":1.0},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"8":{"tf":1.7320508075688772},"83":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"130":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":2.0},"7":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"136":{"tf":1.0},"143":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"d":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.0},"116":{"tf":1.0},"31":{"tf":1.4142135623730951},"60":{"tf":1.0},"67":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}},"w":{"df":2,"docs":{"129":{"tf":1.0},"83":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"161":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}}}},"x":{"df":1,"docs":{"1":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"116":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"81":{"tf":2.23606797749979},"82":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":8,"docs":{"113":{"tf":1.4142135623730951},"44":{"tf":3.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"44":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"128":{"tf":1.0},"134":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"_":{"a":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":23,"docs":{"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.0},"172":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"h":{"df":4,"docs":{"123":{"tf":1.0},"150":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"33":{"tf":1.0}}}}},"w":{"df":3,"docs":{"120":{"tf":1.0},"43":{"tf":1.0},"93":{"tf":1.0}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"110":{"tf":1.4142135623730951},"172":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}}}}}},"o":{"2":{"df":2,"docs":{"169":{"tf":2.0},"170":{"tf":1.4142135623730951}}},"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":1.0},"169":{"tf":2.0},"170":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"166":{"tf":1.0}}}}}},"k":{"df":2,"docs":{"102":{"tf":1.0},"83":{"tf":1.0}}},"l":{"d":{"df":2,"docs":{"38":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":3,"docs":{"41":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.4142135623730951}}},"df":11,"docs":{"129":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"t":{"df":2,"docs":{"13":{"tf":1.0},"152":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":12,"docs":{"129":{"tf":1.0},"13":{"tf":1.0},"149":{"tf":1.0},"152":{"tf":2.6457513110645907},"157":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"n":{"df":31,"docs":{"0":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"123":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.4142135623730951},"171":{"tf":1.0},"23":{"tf":2.23606797749979},"25":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"11":{"tf":1.0},"165":{"tf":1.0},"172":{"tf":1.4142135623730951},"23":{"tf":1.0},"92":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"171":{"tf":1.0},"6":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"173":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"10":{"tf":3.4641016151377544},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"147":{"tf":1.0},"15":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":2.0},"32":{"tf":1.4142135623730951},"33":{"tf":2.0},"43":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"165":{"tf":1.4142135623730951},"76":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"117":{"tf":1.0},"136":{"tf":2.0},"43":{"tf":1.0},"66":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"29":{"tf":1.0},"39":{"tf":1.0},"6":{"tf":1.0}}}}},"df":3,"docs":{"29":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"113":{"tf":1.0},"44":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"44":{"tf":1.0},"84":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"w":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"155":{"tf":2.0},"43":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"139":{"tf":1.0},"148":{"tf":1.0}}}}}},"m":{"df":3,"docs":{"111":{"tf":1.0},"118":{"tf":1.0},"44":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":9,"docs":{"111":{"tf":1.4142135623730951},"118":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"104":{"tf":1.0},"44":{"tf":1.0}},"t":{"df":1,"docs":{"113":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"104":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"44":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"130":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":18,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0},"130":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"133":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.7320508075688772},"143":{"tf":1.0},"149":{"tf":1.7320508075688772},"165":{"tf":2.0},"171":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":14,"docs":{"11":{"tf":1.0},"113":{"tf":1.7320508075688772},"157":{"tf":1.0},"158":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"171":{"tf":1.0},"32":{"tf":2.0},"44":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.7320508075688772},"91":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"114":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"73":{"tf":2.0},"78":{"tf":2.0},"92":{"tf":2.0}}}}}}}},"df":1,"docs":{"73":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}},"f":{"df":1,"docs":{"163":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"167":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"o":{"df":7,"docs":{"157":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.7320508075688772},"166":{"tf":1.4142135623730951}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":9,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"n":{"df":1,"docs":{"93":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":7,"docs":{"167":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"169":{"tf":1.7320508075688772},"170":{"tf":1.4142135623730951},"171":{"tf":2.23606797749979},"172":{"tf":1.0},"79":{"tf":1.7320508075688772}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"140":{"tf":1.4142135623730951},"44":{"tf":1.0},"69":{"tf":1.7320508075688772},"73":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"44":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"83":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"172":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"159":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"137":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"141":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"32":{"tf":2.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"134":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"165":{"tf":1.4142135623730951},"41":{"tf":1.0}},"s":{"df":9,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"84":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"167":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":14,"docs":{"0":{"tf":1.0},"11":{"tf":2.6457513110645907},"130":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"149":{"tf":1.0},"16":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"112":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"80":{"tf":2.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"116":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"c":{"df":1,"docs":{"7":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"155":{"tf":1.0},"164":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":77,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"148":{"tf":1.0},"165":{"tf":1.0},"17":{"tf":1.0},"172":{"tf":1.0},"18":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":3,"docs":{"158":{"tf":1.0},"164":{"tf":3.0},"165":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"157":{"tf":2.0},"158":{"tf":2.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"166":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":2,"docs":{"164":{"tf":2.8284271247461903},"165":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"163":{"tf":1.0}}},"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":2.23606797749979},"165":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"7":{"tf":1.0}},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"127":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":20,"docs":{"1":{"tf":1.0},"112":{"tf":1.4142135623730951},"116":{"tf":1.0},"119":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":2.23606797749979},"44":{"tf":1.4142135623730951},"51":{"tf":2.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"57":{"tf":2.23606797749979},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"44":{"tf":1.0},"53":{"tf":1.0},"80":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"t":{"df":2,"docs":{"147":{"tf":1.0},"92":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"62":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":3,"docs":{"44":{"tf":1.4142135623730951},"83":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"92":{"tf":1.0}}}},"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"166":{"tf":1.4142135623730951},"171":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"165":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"88":{"tf":2.0}}}}}},"d":{"df":1,"docs":{"143":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"143":{"tf":1.0}}}}}},"df":3,"docs":{"112":{"tf":1.0},"119":{"tf":1.0},"164":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"129":{"tf":1.0},"7":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"163":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":11,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"165":{"tf":1.7320508075688772},"169":{"tf":1.0},"170":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"172":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"166":{"tf":1.0}}},"o":{"c":{"df":2,"docs":{"11":{"tf":2.0},"144":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"32":{"tf":2.0}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"149":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"40":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":19,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"128":{"tf":1.0},"134":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0},"99":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"113":{"tf":1.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":2.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":3,"docs":{"32":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"(":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"70":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"33":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"84":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"164":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"11":{"tf":1.0},"172":{"tf":1.0},"63":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"104":{"tf":1.0},"88":{"tf":1.7320508075688772}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"172":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}}}},"f":{"c":{"df":1,"docs":{"112":{"tf":1.0}}},"df":1,"docs":{"165":{"tf":1.0}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"169":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":1,"docs":{"165":{"tf":1.0}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"29":{"tf":1.0},"57":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"135":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"112":{"tf":1.0}}}},"n":{"df":17,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":2.0},"165":{"tf":1.7320508075688772},"23":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"'":{"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"166":{"tf":1.0},"26":{"tf":1.0}}},"df":47,"docs":{"0":{"tf":2.8284271247461903},"1":{"tf":2.23606797749979},"122":{"tf":1.4142135623730951},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"159":{"tf":1.4142135623730951},"160":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":2.23606797749979},"165":{"tf":1.7320508075688772},"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"17":{"tf":1.0},"170":{"tf":2.0},"171":{"tf":1.4142135623730951},"172":{"tf":2.0},"173":{"tf":1.7320508075688772},"2":{"tf":1.0},"23":{"tf":1.7320508075688772},"29":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":2.0},"45":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":13,"docs":{"0":{"tf":1.4142135623730951},"120":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"169":{"tf":2.449489742783178},"170":{"tf":1.0},"172":{"tf":2.23606797749979},"29":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.7320508075688772},"49":{"tf":1.0},"7":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"165":{"tf":2.0},"169":{"tf":1.0},"170":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{">":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"<":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"164":{"tf":1.0}}}}}}}},"s":{"(":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}},".":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"<":{"'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{">":{"(":{"&":{"0":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":4,"docs":{"120":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"70":{"tf":1.0},"84":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"164":{"tf":1.0},"172":{"tf":1.0},"39":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"134":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}}}}}},"df":7,"docs":{"112":{"tf":1.7320508075688772},"118":{"tf":1.0},"152":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":2.0},"80":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":2.8284271247461903}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"166":{"tf":1.0},"36":{"tf":1.0},"45":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":26,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"122":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"160":{"tf":1.0},"161":{"tf":1.7320508075688772},"165":{"tf":1.0},"24":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":2.23606797749979},"18":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"n":{"d":{"df":1,"docs":{"86":{"tf":1.4142135623730951}},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"165":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"10":{"tf":1.0},"126":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"149":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"165":{"tf":1.0}}}}}}},"t":{"df":39,"docs":{"10":{"tf":1.0},"109":{"tf":1.0},"135":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"43":{"tf":1.0}}}},"p":{"df":1,"docs":{"160":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"122":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"w":{"df":2,"docs":{"172":{"tf":1.0},"46":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"125":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"165":{"tf":1.0},"38":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"165":{"tf":1.0}},"i":{"df":2,"docs":{"85":{"tf":1.0},"99":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"125":{"tf":1.0},"164":{"tf":1.0},"4":{"tf":1.0},"54":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"88":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"152":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"148":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"139":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"44":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"140":{"tf":1.7320508075688772}},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"140":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"0":{"tf":1.0},"172":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"r":{"c":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"173":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"126":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"149":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"161":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"107":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":6,"docs":{"119":{"tf":1.0},"130":{"tf":1.0},"161":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0}},"i":{"df":15,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"158":{"tf":1.0},"171":{"tf":1.4142135623730951},"23":{"tf":1.0},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":2.449489742783178},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"c":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"173":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"1":{"7":{"df":1,"docs":{"86":{"tf":1.0}}},"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{":":{"1":{"1":{"df":1,"docs":{"47":{"tf":1.0}}},"2":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{":":{"5":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{":":{"3":{"0":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.0}},"s":{":":{"1":{"1":{":":{"1":{"3":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"9":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"1":{"7":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"2":{"3":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"1":{"0":{"df":1,"docs":{"90":{"tf":1.0}}},"2":{"df":1,"docs":{"85":{"tf":1.0}}},"df":6,"docs":{"101":{"tf":1.0},"53":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}},"5":{"df":1,"docs":{"100":{"tf":1.0}}},"9":{"df":2,"docs":{"55":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"1":{"2":{"df":1,"docs":{"78":{"tf":1.0}}},"7":{"df":1,"docs":{"117":{"tf":1.0}}},"df":3,"docs":{"76":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}},"2":{"0":{"df":1,"docs":{"70":{"tf":1.0}}},"1":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":4,"docs":{"105":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"98":{"tf":1.0}}},"7":{"df":1,"docs":{"104":{"tf":1.0}}},"9":{"df":4,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"66":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{":":{"1":{"2":{"df":1,"docs":{"54":{"tf":1.0}}},"7":{"df":1,"docs":{"115":{"tf":1.0}}},"df":6,"docs":{"116":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}}},"5":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"1":{"3":{"df":2,"docs":{"56":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":5,"docs":{"57":{"tf":1.0},"58":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}},"8":{"df":1,"docs":{"111":{"tf":1.0}}},"9":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{":":{"1":{"3":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":2,"docs":{"64":{"tf":1.0},"92":{"tf":1.0}}},"9":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{":":{"5":{"df":3,"docs":{"102":{"tf":1.0},"63":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{":":{"1":{"4":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{":":{"5":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.7320508075688772}}}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"150":{"tf":1.0},"155":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"44":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"173":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.0},"77":{"tf":1.7320508075688772},"91":{"tf":1.0}}}}}}},"i":{"c":{"df":11,"docs":{"11":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"141":{"tf":1.0},"170":{"tf":1.4142135623730951},"44":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"70":{"tf":2.0},"75":{"tf":2.0},"82":{"tf":2.449489742783178}},"l":{"df":0,"docs":{},"i":{"b":{"df":4,"docs":{"11":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":2.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"100":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"<":{"&":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"11":{"tf":1.0},"164":{"tf":2.23606797749979},"165":{"tf":2.449489742783178},"167":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}},"p":{"df":1,"docs":{"33":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":14,"docs":{"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":2.23606797749979}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"107":{"tf":1.0},"163":{"tf":1.4142135623730951},"46":{"tf":1.0},"6":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"139":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.0},"131":{"tf":1.0},"140":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"166":{"tf":1.0},"43":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"165":{"tf":1.4142135623730951},"169":{"tf":1.7320508075688772},"170":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"116":{"tf":1.0},"146":{"tf":1.0},"32":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"x":{"df":3,"docs":{"10":{"tf":1.0},"32":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"32":{"tf":1.0}}},"df":2,"docs":{"0":{"tf":1.0},"29":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"151":{"tf":1.0},"172":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":10,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"129":{"tf":1.0},"140":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"9":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"_":{"df":1,"docs":{"48":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"k":{"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"165":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":2,"docs":{"159":{"tf":1.0},"161":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":9,"docs":{"11":{"tf":3.605551275463989},"127":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"159":{"tf":2.23606797749979},"160":{"tf":2.6457513110645907},"161":{"tf":3.3166247903554},"165":{"tf":1.0},"18":{"tf":1.7320508075688772}}}}}}},"df":5,"docs":{"111":{"tf":1.4142135623730951},"115":{"tf":2.0},"63":{"tf":1.0},"76":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"160":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"34":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"134":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"134":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"155":{"tf":1.0},"33":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{":":{":":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"{":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"17":{"tf":1.7320508075688772},"61":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"33":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":5,"docs":{"165":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.0},"166":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"129":{"tf":1.4142135623730951}},"g":{"df":3,"docs":{"165":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"93":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"11":{"tf":1.0},"148":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":2,"docs":{"164":{"tf":1.0},"64":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"154":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"125":{"tf":1.0},"129":{"tf":1.0},"148":{"tf":1.0},"164":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"64":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"l":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"164":{"tf":1.7320508075688772},"165":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"1":{"tf":1.0},"167":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"167":{"tf":1.0},"172":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":2,"docs":{"164":{"tf":2.6457513110645907},"34":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":8,"docs":{"111":{"tf":1.0},"118":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":3.1622776601683795},"72":{"tf":1.0},"78":{"tf":2.23606797749979},"80":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{},"i":{"df":6,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"128":{"tf":1.0},"50":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":65,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}},"e":{">":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"164":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"55":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"108":{"tf":2.0}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":11,"docs":{"1":{"tf":1.0},"136":{"tf":1.4142135623730951},"138":{"tf":1.0},"139":{"tf":1.0},"152":{"tf":1.4142135623730951},"153":{"tf":1.0},"167":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":4,"docs":{"129":{"tf":1.0},"164":{"tf":1.0},"168":{"tf":1.0},"4":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"110":{"tf":1.4142135623730951},"38":{"tf":1.0},"43":{"tf":1.0}}},"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"169":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":22,"docs":{"10":{"tf":2.23606797749979},"102":{"tf":1.0},"11":{"tf":1.4142135623730951},"111":{"tf":2.0},"117":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"44":{"tf":2.23606797749979},"49":{"tf":2.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"7":{"tf":2.449489742783178},"70":{"tf":1.4142135623730951},"72":{"tf":2.0},"76":{"tf":1.0},"80":{"tf":2.23606797749979},"86":{"tf":2.449489742783178},"87":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"i":{"c":{"df":3,"docs":{"163":{"tf":1.0},"165":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"3":{"2":{"df":3,"docs":{"50":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.23606797749979}}},"df":0,"docs":{}},"8":{"df":6,"docs":{"112":{"tf":1.0},"117":{"tf":1.7320508075688772},"71":{"tf":2.0},"78":{"tf":2.0},"84":{"tf":1.0},"97":{"tf":1.0}}},"df":1,"docs":{"89":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{"1":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"3":{"2":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":2.449489742783178}}}},"t":{"df":2,"docs":{"1":{"tf":1.0},"148":{"tf":1.0}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":6,"docs":{"121":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"161":{"tf":1.4142135623730951},"165":{"tf":2.23606797749979},"90":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.0},"46":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"94":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"44":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"92":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":5,"docs":{"105":{"tf":2.449489742783178},"115":{"tf":1.0},"44":{"tf":1.0},"58":{"tf":2.23606797749979},"84":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"115":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"161":{"tf":1.4142135623730951},"172":{"tf":1.0},"23":{"tf":1.4142135623730951},"44":{"tf":1.0},"59":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":23,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":2.0},"102":{"tf":1.7320508075688772},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":3.7416573867739413},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.7320508075688772},"67":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"34":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":4,"docs":{"148":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"44":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951}}}}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":4,"docs":{"1":{"tf":1.0},"164":{"tf":1.0},"168":{"tf":1.0},"58":{"tf":1.4142135623730951}}}},"df":79,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"100":{"tf":1.7320508075688772},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"108":{"tf":1.0},"11":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"115":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"127":{"tf":1.7320508075688772},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"15":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"161":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":2.23606797749979},"165":{"tf":2.449489742783178},"166":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"169":{"tf":2.23606797749979},"170":{"tf":1.7320508075688772},"171":{"tf":1.4142135623730951},"172":{"tf":2.0},"23":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"37":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":2.23606797749979},"50":{"tf":1.0},"54":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.4142135623730951},"86":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"=":{".":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"165":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"118":{"tf":1.4142135623730951},"47":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"11":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"172":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"0":{"(":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":10,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":15,"docs":{"10":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":2.0},"116":{"tf":1.0},"121":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"135":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.7320508075688772},"4":{"tf":1.0},"44":{"tf":1.0},"7":{"tf":1.4142135623730951},"9":{"tf":1.0},"95":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":13,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"114":{"tf":1.0},"165":{"tf":1.0},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":2.0},"72":{"tf":1.0}}}}},"df":2,"docs":{"165":{"tf":1.0},"64":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"11":{"tf":1.0},"4":{"tf":1.0}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"(":{"[":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}},"e":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"138":{"tf":1.4142135623730951},"139":{"tf":1.4142135623730951},"152":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":4,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"120":{"tf":1.0},"122":{"tf":1.0},"129":{"tf":1.0},"164":{"tf":1.0},"172":{"tf":2.0},"26":{"tf":1.7320508075688772}}}}}}}},"i":{"a":{"df":8,"docs":{"122":{"tf":1.0},"164":{"tf":1.4142135623730951},"166":{"tf":1.0},"170":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"172":{"tf":1.0},"23":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"112":{"tf":1.7320508075688772},"44":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":1,"docs":{"172":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"165":{"tf":1.0},"173":{"tf":1.0},"92":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"42":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"87":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"34":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":57,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"19":{"tf":1.4142135623730951},"34":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":2.449489742783178},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"43":{"tf":2.449489742783178},"44":{"tf":2.0},"47":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}},"y":{"df":6,"docs":{"106":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0}}}},"df":4,"docs":{"19":{"tf":1.0},"41":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.0}},"e":{"'":{"d":{"df":2,"docs":{"1":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0}}}},"v":{"df":1,"docs":{"173":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.0},"40":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"107":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"173":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"42":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"1":{"tf":1.0},"33":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"38":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"113":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":2.0},"88":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"107":{"tf":1.0},"164":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":7,"docs":{"134":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":1.4142135623730951},"42":{"tf":1.0},"47":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"164":{"tf":1.0},"165":{"tf":1.4142135623730951}}}}}}},"l":{"d":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"51":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"173":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"x":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"0":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"161":{"tf":1.0}}}}}},"df":23,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"37":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"73":{"tf":3.4641016151377544},"74":{"tf":2.0},"75":{"tf":2.0},"77":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"95":{"tf":2.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.7320508075688772}}},"y":{"df":6,"docs":{"115":{"tf":1.4142135623730951},"136":{"tf":1.0},"143":{"tf":1.0},"73":{"tf":3.0},"84":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772}},"e":{"df":2,"docs":{"136":{"tf":1.0},"143":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":4,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"161":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"173":{"tf":1.0}}}},"v":{"df":3,"docs":{"1":{"tf":1.0},"34":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"z":{"df":5,"docs":{"11":{"tf":1.0},"152":{"tf":1.0},"161":{"tf":1.4142135623730951},"23":{"tf":2.449489742783178},"80":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"143":{"tf":1.4142135623730951}}}}}}}},"breadcrumbs":{"root":{"0":{"df":6,"docs":{"151":{"tf":1.0},"152":{"tf":1.0},"165":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"84":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"1":{".":{"0":{".":{"0":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"4":{"df":1,"docs":{"172":{"tf":1.0}}},"5":{"df":1,"docs":{"172":{"tf":1.0}}},"6":{"df":1,"docs":{"172":{"tf":1.0}}},"7":{"df":1,"docs":{"172":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}},"df":0,"docs":{},"u":{"8":{"df":2,"docs":{"38":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"2":{"4":{"df":1,"docs":{"64":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":2,"docs":{"38":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772}}},"1":{"df":2,"docs":{"80":{"tf":1.0},"84":{"tf":1.0}}},"2":{"df":1,"docs":{"98":{"tf":1.0}}},"4":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"5":{"0":{"6":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":20,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"121":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.4142135623730951},"53":{"tf":1.0},"55":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}},"2":{"0":{"0":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"66":{"tf":2.0}}},"df":0,"docs":{}}},"1":{"5":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"8":{"df":3,"docs":{"44":{"tf":2.0},"87":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"5":{"df":1,"docs":{"154":{"tf":1.0}}},"df":0,"docs":{}},"df":31,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"53":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"98":{"tf":1.0}}},"3":{"2":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}},"5":{"2":{"0":{"3":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"8":{"8":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{"0":{"7":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"101":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"152":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"42":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}},"4":{"1":{"6":{"2":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"2":{"3":{"8":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"6":{"8":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":1.0},"77":{"tf":1.0}},"i":{"3":{"2":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"6":{"0":{"4":{"3":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"6":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":16,"docs":{"111":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}},"5":{".":{"0":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":20,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":2.23606797749979},"95":{"tf":1.0}}},"6":{"df":6,"docs":{"102":{"tf":1.0},"49":{"tf":1.0},"58":{"tf":1.0},"63":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"7":{"df":3,"docs":{"172":{"tf":1.0},"48":{"tf":1.0},"68":{"tf":1.0}}},"8":{"df":2,"docs":{"172":{"tf":1.0},"71":{"tf":1.0}}},"9":{"df":1,"docs":{"62":{"tf":1.0}}},"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"101":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":2.0},"76":{"tf":1.0},"87":{"tf":1.0}},"x":{"df":3,"docs":{"106":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0}}}},"a":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"168":{"tf":1.0}},"l":{"df":1,"docs":{"160":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"155":{"tf":1.0},"41":{"tf":1.0}}}},"v":{"df":5,"docs":{"113":{"tf":1.0},"127":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"92":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":11,"docs":{"10":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"120":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"172":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"167":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":8,"docs":{"125":{"tf":1.0},"132":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"53":{"tf":1.0},"66":{"tf":1.0},"93":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"170":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"130":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"df":4,"docs":{"10":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"70":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"140":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"164":{"tf":1.0},"165":{"tf":1.0},"170":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":2,"docs":{"44":{"tf":1.0},"86":{"tf":1.7320508075688772}},"s":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":4,"docs":{"163":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772}}},"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"a":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":26,"docs":{"111":{"tf":1.4142135623730951},"120":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.0},"143":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.0},"167":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"23":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"51":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"114":{"tf":1.0},"31":{"tf":1.4142135623730951},"33":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"70":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":2,"docs":{"44":{"tf":1.0},"47":{"tf":2.0}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"163":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":2.23606797749979}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"160":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"125":{"tf":1.4142135623730951},"126":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"113":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"172":{"tf":1.4142135623730951}}}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":2,"docs":{"123":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"=":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"125":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":5,"docs":{"126":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"164":{"tf":1.0},"170":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"133":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"165":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"171":{"tf":1.0},"2":{"tf":1.7320508075688772},"33":{"tf":2.0},"44":{"tf":1.0},"71":{"tf":2.0}}}}}}}},"m":{"df":1,"docs":{"92":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"104":{"tf":1.0},"47":{"tf":1.0},"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"142":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"153":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"44":{"tf":1.0},"95":{"tf":2.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"138":{"tf":1.0},"139":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.0}}}}}},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}},"e":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":13,"docs":{"113":{"tf":1.4142135623730951},"116":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":2.23606797749979},"44":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.7320508075688772},"90":{"tf":1.0},"96":{"tf":2.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"160":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"34":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{">":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"164":{"tf":1.4142135623730951},"165":{"tf":1.0}}}},"d":{"df":2,"docs":{"44":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":4,"docs":{"113":{"tf":1.0},"57":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"68":{"tf":1.0}},"e":{"df":2,"docs":{"44":{"tf":1.0},"48":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"167":{"tf":1.0},"168":{"tf":1.0},"172":{"tf":1.0}}},"i":{"c":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"152":{"tf":1.0},"163":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":2,"docs":{"66":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":9,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}}}},"df":13,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"167":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"84":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"164":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"115":{"tf":1.4142135623730951},"128":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"44":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"165":{"tf":1.0},"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"172":{"tf":1.0}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"152":{"tf":1.4142135623730951},"157":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"164":{"tf":2.0},"165":{"tf":1.7320508075688772},"168":{"tf":1.0}}}}},"df":1,"docs":{"7":{"tf":1.0}}},"t":{"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"10":{"tf":1.0},"168":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{}}},"df":4,"docs":{"107":{"tf":1.0},"110":{"tf":1.4142135623730951},"38":{"tf":1.0},"43":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"110":{"tf":1.7320508075688772},"38":{"tf":1.0},"43":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"33":{"tf":2.449489742783178}}},"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"105":{"tf":1.7320508075688772},"58":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"78":{"tf":2.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"0":{"tf":1.7320508075688772},"173":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"44":{"tf":1.0},"84":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"168":{"tf":1.0},"172":{"tf":1.0},"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"167":{"tf":1.0}}}}},"df":3,"docs":{"44":{"tf":1.0},"71":{"tf":2.23606797749979},"86":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"x":{"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"49":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"49":{"tf":2.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":2.0}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"163":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"161":{"tf":1.0},"165":{"tf":2.449489742783178},"169":{"tf":1.0},"17":{"tf":1.4142135623730951},"170":{"tf":1.0},"18":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"160":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"160":{"tf":2.0},"163":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"165":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"c":{"/":{"c":{"df":4,"docs":{"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"160":{"tf":1.0},"49":{"tf":1.0},"62":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"44":{"tf":1.7320508075688772},"72":{"tf":2.0}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":4,"docs":{"24":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"43":{"tf":2.8284271247461903}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":5,"docs":{"0":{"tf":2.0},"165":{"tf":3.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"43":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"168":{"tf":1.4142135623730951},"169":{"tf":1.0},"170":{"tf":1.0},"44":{"tf":3.0},"72":{"tf":2.0},"74":{"tf":2.0},"75":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951}}},"t":{"df":2,"docs":{"55":{"tf":2.23606797749979},"56":{"tf":2.23606797749979}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"115":{"tf":1.0},"120":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0}}}},"df":3,"docs":{"34":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}},"s":{"df":2,"docs":{"115":{"tf":1.0},"134":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":13,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.0},"122":{"tf":1.4142135623730951},"127":{"tf":1.0},"13":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.4142135623730951},"169":{"tf":2.0},"170":{"tf":2.449489742783178},"25":{"tf":1.4142135623730951},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"152":{"tf":1.0},"153":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"11":{"tf":1.7320508075688772},"4":{"tf":2.23606797749979}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"107":{"tf":1.4142135623730951},"112":{"tf":1.0},"172":{"tf":1.0},"41":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"157":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"35":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"136":{"tf":2.0},"150":{"tf":1.4142135623730951},"173":{"tf":1.0},"63":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"40":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"166":{"tf":1.0}}},"df":6,"docs":{"164":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":2.0},"170":{"tf":1.4142135623730951},"172":{"tf":2.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"b":{".":{"c":{"df":1,"docs":{"170":{"tf":1.4142135623730951}}},"df":0,"docs":{},"o":{"df":1,"docs":{"170":{"tf":2.0}}}},"df":0,"docs":{}},"df":1,"docs":{"33":{"tf":1.0}},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"170":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"=":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"170":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951}}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"o":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":94,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":2.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"124":{"tf":1.0},"128":{"tf":2.0},"13":{"tf":1.4142135623730951},"130":{"tf":1.0},"140":{"tf":1.4142135623730951},"145":{"tf":2.0},"148":{"tf":1.4142135623730951},"155":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951},"170":{"tf":2.449489742783178},"25":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.0},"90":{"tf":1.0},"91":{"tf":2.0},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"122":{"tf":1.7320508075688772},"148":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"157":{"tf":1.4142135623730951},"163":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"44":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":2.8284271247461903},"33":{"tf":2.0}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"172":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.7320508075688772},"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"137":{"tf":1.0},"142":{"tf":1.0},"16":{"tf":1.0},"164":{"tf":1.0},"29":{"tf":1.0}}},"m":{"a":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}},"n":{"d":{"df":6,"docs":{"1":{"tf":1.0},"2":{"tf":1.7320508075688772},"33":{"tf":1.0},"41":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"98":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"164":{"tf":1.0},"51":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"97":{"tf":2.0}}}}}}},"t":{"df":2,"docs":{"172":{"tf":1.7320508075688772},"44":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":41,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":2.0},"10":{"tf":1.0},"11":{"tf":2.23606797749979},"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"148":{"tf":1.0},"156":{"tf":1.0},"159":{"tf":1.7320508075688772},"160":{"tf":1.0},"164":{"tf":2.23606797749979},"165":{"tf":2.0},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"169":{"tf":2.23606797749979},"17":{"tf":1.0},"170":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":2.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.0},"71":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"163":{"tf":1.0},"44":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"11":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"31":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772}}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":9,"docs":{"106":{"tf":1.0},"115":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"116":{"tf":1.0},"66":{"tf":1.0},"75":{"tf":1.0}}}}},"df":4,"docs":{"116":{"tf":2.6457513110645907},"55":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"128":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"112":{"tf":2.0},"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"10":{"tf":2.0},"113":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"89":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"173":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":16,"docs":{"10":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"136":{"tf":1.0},"14":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"155":{"tf":1.0},"18":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":3.1622776601683795}}},"t":{"df":3,"docs":{"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"160":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"128":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"164":{"tf":2.23606797749979},"165":{"tf":2.0}}}}}}},"u":{"=":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"11":{"tf":1.7320508075688772},"130":{"tf":1.7320508075688772}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"b":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":1,"docs":{"10":{"tf":1.0}},"l":{"df":1,"docs":{"10":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":1,"docs":{"10":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"121":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}},"e":{"=":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":27,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":2.23606797749979},"11":{"tf":1.7320508075688772},"119":{"tf":1.7320508075688772},"121":{"tf":1.7320508075688772},"15":{"tf":1.0},"165":{"tf":1.0},"169":{"tf":1.0},"17":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.449489742783178},"42":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"53":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.7320508075688772},"60":{"tf":2.449489742783178},"7":{"tf":2.8284271247461903},"79":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979},"99":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.4142135623730951},"157":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.4142135623730951},"167":{"tf":1.0},"170":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"159":{"tf":1.0}}}}},"u":{"df":1,"docs":{"170":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"7":{"tf":1.0},"86":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"161":{"tf":2.0},"33":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":8,"docs":{"147":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"163":{"tf":2.23606797749979},"164":{"tf":2.449489742783178},"165":{"tf":2.8284271247461903},"84":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":3,"docs":{"21":{"tf":1.4142135623730951},"41":{"tf":2.449489742783178},"44":{"tf":2.0}},"e":{"a":{"d":{"df":3,"docs":{"128":{"tf":1.7320508075688772},"44":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":6,"docs":{"12":{"tf":1.4142135623730951},"151":{"tf":1.7320508075688772},"153":{"tf":1.4142135623730951},"165":{"tf":1.0},"32":{"tf":1.0},"52":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"=":{"2":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"151":{"tf":1.4142135623730951}}}}}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"_":{"<":{"df":0,"docs":{},"i":{"d":{">":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":34,"docs":{"10":{"tf":3.0},"109":{"tf":1.7320508075688772},"111":{"tf":2.23606797749979},"112":{"tf":1.0},"118":{"tf":1.0},"127":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.0},"65":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"167":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"160":{"tf":1.0},"161":{"tf":1.0},"42":{"tf":1.0},"55":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"134":{"tf":1.0},"165":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"i":{"df":26,"docs":{"109":{"tf":1.7320508075688772},"120":{"tf":1.0},"21":{"tf":1.7320508075688772},"35":{"tf":1.0},"38":{"tf":2.0},"39":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}},"y":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"c":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"107":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"10":{"tf":1.0},"141":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"34":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":8,"docs":{"123":{"tf":1.0},"150":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"59":{"tf":1.0},"68":{"tf":2.23606797749979}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"51":{"tf":1.0},"52":{"tf":1.0},"83":{"tf":1.0}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"127":{"tf":1.0},"162":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":60,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"127":{"tf":1.0}}}}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":2.6457513110645907}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"1":{"tf":1.0},"131":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"38":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}}},"r":{"df":2,"docs":{"10":{"tf":1.0},"15":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"121":{"tf":1.0},"5":{"tf":1.0},"99":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"133":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.4142135623730951},"62":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"10":{"tf":1.0},"113":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"157":{"tf":1.0},"165":{"tf":1.4142135623730951},"32":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":2.8284271247461903}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"11":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"143":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"c":{"df":6,"docs":{"159":{"tf":1.0},"160":{"tf":1.0},"41":{"tf":2.449489742783178},"44":{"tf":1.0},"53":{"tf":1.4142135623730951},"98":{"tf":2.449489742783178}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"166":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.4142135623730951},"53":{"tf":2.0}}}}}}}},"df":4,"docs":{"148":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":1.0},"66":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"165":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"134":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"89":{"tf":2.449489742783178}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"41":{"tf":1.0},"97":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"134":{"tf":1.0},"164":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"141":{"tf":1.7320508075688772},"164":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"df":1,"docs":{"48":{"tf":2.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":5,"docs":{"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.7320508075688772},"169":{"tf":1.0}}}},"0":{"1":{"3":{"3":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"h":{"df":11,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.0},"147":{"tf":1.0},"16":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.4142135623730951},"33":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"164":{"tf":1.0},"47":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"44":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":2.449489742783178}}}}},"df":1,"docs":{"114":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"94":{"tf":1.0}}}}},"s":{"df":1,"docs":{"50":{"tf":1.0}}}}},"m":{"b":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}},"t":{"df":7,"docs":{"10":{"tf":2.0},"11":{"tf":1.4142135623730951},"157":{"tf":1.0},"168":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":2.6457513110645907},"7":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"137":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"140":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"11":{"tf":1.0},"131":{"tf":1.0},"143":{"tf":1.0},"156":{"tf":1.0},"164":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"173":{"tf":1.0}}},"df":1,"docs":{"64":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"137":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"165":{"tf":1.0},"166":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"111":{"tf":1.0},"64":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"165":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"166":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"111":{"tf":1.0},"66":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}},"r":{"[":{"df":0,"docs":{},"e":{"0":{"4":{"4":{"6":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":39,"docs":{"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"121":{"tf":1.0},"16":{"tf":2.23606797749979},"30":{"tf":2.0},"33":{"tf":2.6457513110645907},"34":{"tf":1.4142135623730951},"38":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"41":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"c":{"df":3,"docs":{"163":{"tf":1.0},"32":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"122":{"tf":1.0},"172":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":80,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"110":{"tf":1.4142135623730951},"38":{"tf":1.0},"43":{"tf":1.0}},"e":{"d":{"df":1,"docs":{"110":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951}}}},"n":{"df":1,"docs":{"16":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"171":{"tf":1.7320508075688772},"71":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"s":{"df":2,"docs":{"81":{"tf":1.0},"82":{"tf":1.0}}}},"r":{"df":1,"docs":{"114":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"43":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"119":{"tf":1.7320508075688772},"120":{"tf":1.7320508075688772},"142":{"tf":1.0},"28":{"tf":2.23606797749979},"44":{"tf":1.7320508075688772},"5":{"tf":1.0},"60":{"tf":2.449489742783178},"70":{"tf":1.0},"79":{"tf":1.0}}}}},"r":{"a":{"df":6,"docs":{"10":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"132":{"tf":1.0},"147":{"tf":1.7320508075688772},"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"t":{"df":1,"docs":{"129":{"tf":1.4142135623730951}}}},"df":3,"docs":{"112":{"tf":1.0},"22":{"tf":1.4142135623730951},"41":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"11":{"tf":1.7320508075688772},"129":{"tf":1.0},"131":{"tf":2.23606797749979},"165":{"tf":1.0},"166":{"tf":1.0},"172":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"85":{"tf":2.23606797749979},"99":{"tf":2.23606797749979}},"e":{"(":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":1,"docs":{"164":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"33":{"tf":1.0},"51":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"89":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":15,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":3.4641016151377544},"11":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"134":{"tf":1.0},"158":{"tf":1.4142135623730951},"161":{"tf":1.0},"164":{"tf":3.4641016151377544},"165":{"tf":2.23606797749979},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":3.4641016151377544},"14":{"tf":1.7320508075688772},"147":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}},"d":{"df":4,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"165":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"92":{"tf":1.0}}}},"x":{"df":14,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"99":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":62,"docs":{"10":{"tf":2.23606797749979},"102":{"tf":1.0},"11":{"tf":3.4641016151377544},"122":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"129":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"136":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"15":{"tf":1.4142135623730951},"151":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.23606797749979},"43":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":2.449489742783178}}}}}},"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"140":{"tf":2.449489742783178},"44":{"tf":1.0},"69":{"tf":2.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"168":{"tf":1.0},"169":{"tf":2.449489742783178},"170":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"168":{"tf":1.0},"170":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":33,"docs":{"1":{"tf":1.7320508075688772},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":2.23606797749979},"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"53":{"tf":2.0},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"78":{"tf":2.449489742783178},"80":{"tf":1.0},"81":{"tf":2.0},"84":{"tf":1.0},"88":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"114":{"tf":1.0},"164":{"tf":1.0},"172":{"tf":1.0},"33":{"tf":1.0}}}}}},"o":{"(":{"_":{"df":1,"docs":{"47":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}},"x":{"df":2,"docs":{"50":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},".":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951}}}},"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"<":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"z":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":1,"docs":{"50":{"tf":1.0}}},"a":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"x":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"i":{"3":{"2":{">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}}},"=":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":21,"docs":{"1":{"tf":1.0},"116":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":2.23606797749979},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"57":{"tf":1.0},"62":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"88":{"tf":2.0}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"df":5,"docs":{"22":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":2.23606797749979},"41":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":2.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"df":4,"docs":{"169":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"df":5,"docs":{"10":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"121":{"tf":1.0},"164":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":4,"docs":{"164":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"166":{"tf":1.4142135623730951}}}}}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.7320508075688772},"44":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"151":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":13,"docs":{"154":{"tf":1.0},"17":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.7320508075688772},"84":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"166":{"tf":1.4142135623730951},"43":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"172":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"w":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"g":{"df":1,"docs":{"12":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"=":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"164":{"tf":1.4142135623730951},"165":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":16,"docs":{"10":{"tf":3.4641016151377544},"130":{"tf":1.0},"134":{"tf":1.0},"140":{"tf":1.4142135623730951},"148":{"tf":1.0},"157":{"tf":1.4142135623730951},"160":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":1.7320508075688772},"166":{"tf":1.0},"25":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"76":{"tf":2.0},"86":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0}},"n":{"df":5,"docs":{"127":{"tf":1.4142135623730951},"16":{"tf":1.0},"172":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"44":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"165":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"165":{"tf":1.4142135623730951}}}},"o":{"df":2,"docs":{"43":{"tf":1.0},"91":{"tf":1.0}},"e":{"df":1,"docs":{"31":{"tf":1.0}}},"o":{"d":{"df":3,"docs":{"162":{"tf":1.0},"165":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"44":{"tf":2.449489742783178},"45":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"0":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"162":{"tf":1.7320508075688772},"163":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"164":{"tf":1.0}},"l":{"df":1,"docs":{"172":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"155":{"tf":1.0}}}}}},"r":{"d":{"df":9,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"140":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"df":1,"docs":{"3":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"1":{"tf":1.0}}}},"r":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"p":{"df":20,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.0},"173":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":2.23606797749979},"34":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"57":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"2":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0}}},"df":11,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0},"172":{"tf":1.0},"24":{"tf":1.0},"42":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.0},"91":{"tf":1.0}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"40":{"tf":1.0},"46":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"47":{"tf":1.0},"49":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"130":{"tf":1.0},"161":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"3":{"2":{">":{"(":{"&":{"5":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"116":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"56":{"tf":2.0},"73":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"40":{"tf":1.0},"89":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":2,"docs":{"44":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"51":{"tf":1.4142135623730951},"71":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"166":{"tf":1.0},"51":{"tf":2.23606797749979},"52":{"tf":2.23606797749979},"78":{"tf":1.0},"80":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":2.0},"44":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"v":{"df":2,"docs":{"173":{"tf":1.0},"34":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"32":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"156":{"tf":1.7320508075688772}}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"127":{"tf":1.0},"87":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"10":{"tf":1.0},"151":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"m":{"df":19,"docs":{"11":{"tf":2.449489742783178},"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.4142135623730951},"151":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"113":{"tf":1.4142135623730951},"154":{"tf":1.7320508075688772},"163":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"163":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"164":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":12,"docs":{"0":{"tf":1.0},"106":{"tf":1.0},"115":{"tf":1.0},"134":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"17":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"129":{"tf":1.0},"130":{"tf":1.0},"140":{"tf":1.4142135623730951},"33":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"157":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":2.8284271247461903},"165":{"tf":1.7320508075688772}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"136":{"tf":1.0}},"r":{"df":2,"docs":{"0":{"tf":1.0},"142":{"tf":1.4142135623730951}}}},"n":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"166":{"tf":1.0}}}}},"f":{"a":{"c":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":2,"docs":{"142":{"tf":1.0},"173":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"167":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"34":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"111":{"tf":1.7320508075688772},"121":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":3,"docs":{"0":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"124":{"tf":1.0},"165":{"tf":1.0},"168":{"tf":1.0},"170":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"164":{"tf":1.0},"97":{"tf":1.0}}}}}}},"r":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":14,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"165":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}}}},"t":{"'":{"df":6,"docs":{"0":{"tf":1.0},"134":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"51":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":9,"docs":{"116":{"tf":2.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"80":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"32":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"161":{"tf":2.0},"30":{"tf":1.4142135623730951},"33":{"tf":3.872983346207417}}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"120":{"tf":1.0},"172":{"tf":1.0},"5":{"tf":2.0},"6":{"tf":2.449489742783178},"7":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"172":{"tf":1.0}}}}}}},"l":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"3":{"5":{"2":{"0":{"3":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"8":{"8":{"7":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{"0":{"7":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"1":{"6":{"2":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"2":{"3":{"8":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"6":{"8":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"0":{"4":{"3":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"6":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"0":{"tf":1.0},"167":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"<":{"'":{"a":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"44":{"tf":1.0},"71":{"tf":2.23606797749979}},"r":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"163":{"tf":1.0}}}}}}},"d":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":5,"docs":{"169":{"tf":1.4142135623730951},"170":{"tf":1.0},"171":{"tf":1.0},"5":{"tf":1.7320508075688772},"6":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"80":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"173":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"165":{"tf":1.4142135623730951},"43":{"tf":1.0}}}},"g":{"a":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"112":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772}}},"y":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"'":{"df":2,"docs":{"1":{"tf":1.0},"35":{"tf":1.0}}},"df":17,"docs":{"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"=":{"2":{"df":4,"docs":{"13":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0}}},"df":0,"docs":{}},"df":23,"docs":{"10":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.0},"139":{"tf":1.0},"152":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"35":{"tf":2.449489742783178},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979},"40":{"tf":2.23606797749979},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"55":{"tf":1.0},"65":{"tf":1.0},"99":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":7,"docs":{"169":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951}},"s":{":":{"1":{":":{"1":{"df":2,"docs":{"41":{"tf":2.0},"42":{"tf":1.0}}},"9":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"5":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"9":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{":":{"1":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":3,"docs":{"11":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951},"7":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":10,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"5":{"tf":2.23606797749979},"6":{"tf":3.1622776601683795},"7":{"tf":2.449489742783178},"79":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{".":{"a":{"df":1,"docs":{"170":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"44":{"tf":1.0},"50":{"tf":2.449489742783178},"54":{"tf":2.0},"71":{"tf":2.6457513110645907},"74":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":7,"docs":{"112":{"tf":1.0},"151":{"tf":1.0},"2":{"tf":1.7320508075688772},"30":{"tf":1.0},"41":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"k":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":14,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"129":{"tf":1.0},"141":{"tf":1.4142135623730951},"167":{"tf":1.7320508075688772},"169":{"tf":1.7320508075688772},"170":{"tf":1.0},"28":{"tf":1.0},"6":{"tf":3.1622776601683795}},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"11":{"tf":1.0},"124":{"tf":1.7320508075688772},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":3.1622776601683795},"128":{"tf":1.0},"167":{"tf":1.7320508075688772},"168":{"tf":1.7320508075688772},"169":{"tf":1.7320508075688772},"170":{"tf":1.4142135623730951},"171":{"tf":2.23606797749979},"172":{"tf":1.0}}}}},"t":{"df":93,"docs":{"100":{"tf":2.0},"101":{"tf":2.0},"102":{"tf":2.0},"103":{"tf":2.0},"104":{"tf":2.0},"105":{"tf":2.0},"106":{"tf":2.0},"107":{"tf":2.0},"108":{"tf":2.0},"109":{"tf":2.23606797749979},"110":{"tf":2.0},"111":{"tf":2.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"115":{"tf":2.0},"116":{"tf":2.0},"117":{"tf":2.0},"118":{"tf":2.0},"119":{"tf":1.7320508075688772},"120":{"tf":1.7320508075688772},"121":{"tf":2.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"24":{"tf":2.23606797749979},"34":{"tf":2.6457513110645907},"35":{"tf":2.449489742783178},"36":{"tf":2.0},"37":{"tf":2.0},"38":{"tf":2.8284271247461903},"39":{"tf":2.6457513110645907},"40":{"tf":2.23606797749979},"41":{"tf":1.7320508075688772},"42":{"tf":2.0},"43":{"tf":3.4641016151377544},"44":{"tf":3.872983346207417},"45":{"tf":2.23606797749979},"46":{"tf":2.449489742783178},"47":{"tf":2.0},"48":{"tf":2.0},"49":{"tf":2.23606797749979},"50":{"tf":2.0},"51":{"tf":2.449489742783178},"52":{"tf":2.23606797749979},"53":{"tf":2.23606797749979},"54":{"tf":2.0},"55":{"tf":2.23606797749979},"56":{"tf":2.0},"57":{"tf":2.0},"58":{"tf":2.0},"59":{"tf":1.7320508075688772},"60":{"tf":2.0},"61":{"tf":2.0},"62":{"tf":2.0},"63":{"tf":2.0},"64":{"tf":2.0},"65":{"tf":2.23606797749979},"66":{"tf":2.0},"67":{"tf":2.0},"68":{"tf":2.0},"69":{"tf":2.0},"70":{"tf":2.0},"71":{"tf":2.0},"72":{"tf":2.0},"73":{"tf":2.0},"74":{"tf":2.0},"75":{"tf":2.0},"76":{"tf":2.0},"77":{"tf":2.0},"78":{"tf":2.0},"79":{"tf":2.0},"80":{"tf":2.0},"81":{"tf":2.0},"82":{"tf":2.0},"83":{"tf":3.0},"84":{"tf":2.0},"85":{"tf":2.0},"86":{"tf":2.0},"87":{"tf":2.0},"88":{"tf":2.0},"89":{"tf":2.0},"90":{"tf":2.8284271247461903},"91":{"tf":2.0},"92":{"tf":2.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.7320508075688772},"95":{"tf":2.0},"96":{"tf":2.0},"97":{"tf":2.0},"98":{"tf":2.0},"99":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"165":{"tf":2.23606797749979}}}}},"s":{"df":0,"docs":{},"t":{"df":90,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":2.8284271247461903},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.4142135623730951},"137":{"tf":1.4142135623730951},"149":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.4142135623730951},"2":{"tf":1.0},"35":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":2.0},"44":{"tf":1.0},"69":{"tf":2.0}}}},"t":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"165":{"tf":1.0}}}}}},"l":{"d":{"df":2,"docs":{"169":{"tf":1.0},"171":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"'":{"df":2,"docs":{"164":{"tf":1.0},"166":{"tf":1.0}}},"df":12,"docs":{"10":{"tf":2.0},"129":{"tf":1.4142135623730951},"132":{"tf":1.0},"133":{"tf":1.7320508075688772},"142":{"tf":1.0},"164":{"tf":3.0},"165":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":2.23606797749979}}}}},"o":{"a":{"d":{"df":3,"docs":{"10":{"tf":1.0},"164":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}},"t":{"df":2,"docs":{"111":{"tf":1.0},"28":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0},"85":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"1":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.0},"29":{"tf":1.0},"5":{"tf":1.0}}},"p":{"df":4,"docs":{"108":{"tf":1.7320508075688772},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"152":{"tf":1.0}}}},"t":{"df":1,"docs":{"140":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"173":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"=":{"\"":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"171":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"129":{"tf":2.0},"167":{"tf":2.0},"168":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0}}}}},"m":{":":{":":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"130":{"tf":1.0},"163":{"tf":1.0}}}}},"o":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951}}}}}},"df":5,"docs":{"101":{"tf":2.0},"114":{"tf":1.4142135623730951},"32":{"tf":1.0},"44":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"44":{"tf":1.0},"85":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"c":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}},"df":0,"docs":{},"o":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}},"r":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"164":{"tf":2.0},"170":{"tf":1.0},"171":{"tf":1.0},"34":{"tf":1.4142135623730951},"38":{"tf":1.0}},"s":{":":{"2":{":":{"1":{"3":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"9":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":19,"docs":{"1":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"164":{"tf":2.0},"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"17":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":11,"docs":{"11":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.7320508075688772},"169":{"tf":1.7320508075688772},"170":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"158":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"116":{"tf":1.4142135623730951},"146":{"tf":1.0},"76":{"tf":2.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}},"i":{"df":4,"docs":{"136":{"tf":1.0},"143":{"tf":1.0},"148":{"tf":1.0},"160":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"104":{"tf":1.0},"32":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"92":{"tf":2.0}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"y":{"b":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"112":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":6,"docs":{"116":{"tf":1.0},"159":{"tf":1.0},"165":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"93":{"tf":1.0}},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"164":{"tf":2.0},"165":{"tf":1.7320508075688772}},"e":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"33":{"tf":2.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"146":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"74":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"114":{"tf":1.4142135623730951},"41":{"tf":3.1622776601683795},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"53":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"36":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"x":{"df":1,"docs":{"41":{"tf":1.0}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}}},"df":7,"docs":{"1":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.0},"57":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"v":{"df":2,"docs":{"11":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951}}}},"df":3,"docs":{"11":{"tf":3.0},"144":{"tf":2.0},"145":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"112":{"tf":1.0},"42":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":8,"docs":{"1":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"160":{"tf":1.0},"44":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":22,"docs":{"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"173":{"tf":1.0},"24":{"tf":1.0},"41":{"tf":1.4142135623730951},"47":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"36":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"113":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"164":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"102":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":4,"docs":{"103":{"tf":2.449489742783178},"115":{"tf":2.0},"44":{"tf":1.0},"95":{"tf":1.0}}}},"y":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"1":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":2,"docs":{"164":{"tf":1.0},"165":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":2,"docs":{"164":{"tf":1.0},"165":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":2,"docs":{"164":{"tf":1.0},"165":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"11":{"tf":2.0},"113":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"54":{"tf":1.0},"6":{"tf":1.7320508075688772},"62":{"tf":1.0},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"8":{"tf":2.23606797749979},"83":{"tf":1.0},"93":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"130":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"136":{"tf":1.0},"143":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"d":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.0},"116":{"tf":1.0},"31":{"tf":1.4142135623730951},"60":{"tf":1.0},"67":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}},"w":{"df":2,"docs":{"129":{"tf":1.0},"83":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"161":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}}}},"x":{"df":1,"docs":{"1":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"116":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"81":{"tf":2.23606797749979},"82":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":8,"docs":{"113":{"tf":1.4142135623730951},"44":{"tf":3.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"89":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"44":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"128":{"tf":1.0},"134":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"_":{"a":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":23,"docs":{"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.0},"172":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"h":{"df":4,"docs":{"123":{"tf":1.0},"150":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"33":{"tf":1.0}}}}},"w":{"df":3,"docs":{"120":{"tf":1.0},"43":{"tf":1.0},"93":{"tf":1.0}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"110":{"tf":1.4142135623730951},"172":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":2.0}}}}}}},"o":{"2":{"df":2,"docs":{"169":{"tf":2.0},"170":{"tf":1.4142135623730951}}},"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":2.0}}}},"df":0,"docs":{}}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":1.0},"169":{"tf":2.0},"170":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"166":{"tf":1.0}}}}}},"k":{"df":2,"docs":{"102":{"tf":1.0},"83":{"tf":1.0}}},"l":{"d":{"df":2,"docs":{"38":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":3,"docs":{"41":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.4142135623730951}}},"df":11,"docs":{"129":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"t":{"df":2,"docs":{"13":{"tf":1.0},"152":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"m":{"df":12,"docs":{"129":{"tf":1.0},"13":{"tf":1.4142135623730951},"149":{"tf":1.0},"152":{"tf":2.6457513110645907},"157":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"162":{"tf":1.7320508075688772},"163":{"tf":1.7320508075688772},"164":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"n":{"df":31,"docs":{"0":{"tf":1.4142135623730951},"122":{"tf":1.7320508075688772},"123":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.4142135623730951},"171":{"tf":1.0},"23":{"tf":2.449489742783178},"25":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"11":{"tf":1.0},"165":{"tf":1.0},"172":{"tf":1.4142135623730951},"23":{"tf":1.0},"92":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"171":{"tf":1.0},"6":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"173":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"10":{"tf":3.605551275463989},"11":{"tf":1.0},"14":{"tf":1.7320508075688772},"147":{"tf":1.0},"15":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":2.23606797749979},"32":{"tf":1.7320508075688772},"33":{"tf":2.0},"43":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"165":{"tf":1.4142135623730951},"76":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"117":{"tf":1.4142135623730951},"136":{"tf":2.23606797749979},"43":{"tf":1.0},"66":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"29":{"tf":1.0},"39":{"tf":1.0},"6":{"tf":1.0}}}}},"df":3,"docs":{"29":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"44":{"tf":1.0},"84":{"tf":2.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"w":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"155":{"tf":2.23606797749979},"43":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"139":{"tf":1.0},"148":{"tf":1.0}}}}}},"m":{"df":3,"docs":{"111":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":9,"docs":{"111":{"tf":1.4142135623730951},"118":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":2.0},"50":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"44":{"tf":1.0}},"t":{"df":1,"docs":{"113":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"104":{"tf":1.7320508075688772},"118":{"tf":2.0},"44":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"130":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":18,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0},"130":{"tf":1.4142135623730951},"132":{"tf":1.7320508075688772},"133":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":2.0},"143":{"tf":1.0},"149":{"tf":1.7320508075688772},"165":{"tf":2.0},"171":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":14,"docs":{"11":{"tf":1.0},"113":{"tf":1.7320508075688772},"157":{"tf":1.0},"158":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"171":{"tf":1.0},"32":{"tf":2.23606797749979},"44":{"tf":1.0},"5":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":2.0},"91":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"114":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"69":{"tf":2.0},"73":{"tf":2.23606797749979},"78":{"tf":2.23606797749979},"92":{"tf":2.23606797749979}}}}}}}},"df":1,"docs":{"73":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}},"f":{"df":1,"docs":{"163":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"167":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"o":{"df":7,"docs":{"157":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.7320508075688772},"166":{"tf":1.4142135623730951}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":9,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"n":{"df":1,"docs":{"93":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":7,"docs":{"167":{"tf":1.7320508075688772},"168":{"tf":1.4142135623730951},"169":{"tf":1.7320508075688772},"170":{"tf":1.4142135623730951},"171":{"tf":2.449489742783178},"172":{"tf":1.0},"79":{"tf":2.0}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"140":{"tf":1.4142135623730951},"44":{"tf":1.0},"69":{"tf":2.0},"73":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"44":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"83":{"tf":1.0},"87":{"tf":1.7320508075688772}}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"172":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"159":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"137":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"141":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"32":{"tf":2.23606797749979}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"134":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"165":{"tf":1.4142135623730951},"41":{"tf":1.0}},"s":{"df":9,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"84":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"167":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":14,"docs":{"0":{"tf":1.0},"11":{"tf":3.0},"130":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"149":{"tf":1.0},"16":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"3":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"112":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"80":{"tf":2.23606797749979},"81":{"tf":2.0},"82":{"tf":2.0}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"116":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"c":{"df":1,"docs":{"7":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"155":{"tf":1.0},"164":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":77,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"148":{"tf":1.0},"165":{"tf":1.0},"17":{"tf":1.0},"172":{"tf":1.0},"18":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":3,"docs":{"158":{"tf":1.0},"164":{"tf":3.0},"165":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"157":{"tf":2.23606797749979},"158":{"tf":2.23606797749979},"162":{"tf":1.7320508075688772},"163":{"tf":1.7320508075688772},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"166":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":2,"docs":{"164":{"tf":2.8284271247461903},"165":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"163":{"tf":1.0}}},"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":2.23606797749979},"165":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.4142135623730951},"7":{"tf":1.0}},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"127":{"tf":1.0},"16":{"tf":1.4142135623730951},"163":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":20,"docs":{"1":{"tf":1.0},"112":{"tf":1.4142135623730951},"116":{"tf":1.0},"119":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":2.23606797749979},"44":{"tf":1.4142135623730951},"51":{"tf":2.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"57":{"tf":2.449489742783178},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"44":{"tf":1.0},"53":{"tf":1.0},"80":{"tf":2.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"t":{"df":2,"docs":{"147":{"tf":1.0},"92":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"62":{"tf":1.7320508075688772}},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":3,"docs":{"44":{"tf":1.4142135623730951},"83":{"tf":1.0},"87":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"92":{"tf":1.0}}}},"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"166":{"tf":1.7320508075688772},"171":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"165":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"88":{"tf":2.23606797749979}}}}}},"d":{"df":1,"docs":{"143":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"143":{"tf":1.4142135623730951}}}}}},"df":3,"docs":{"112":{"tf":1.0},"119":{"tf":1.0},"164":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"129":{"tf":1.0},"7":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"163":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":11,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"165":{"tf":1.7320508075688772},"169":{"tf":1.0},"170":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"172":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"166":{"tf":1.0}}},"o":{"c":{"df":2,"docs":{"11":{"tf":2.0},"144":{"tf":2.0}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"32":{"tf":2.449489742783178}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"149":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"40":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":19,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"128":{"tf":1.0},"134":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":2.23606797749979},"85":{"tf":1.0},"86":{"tf":1.0},"99":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"113":{"tf":1.0},"83":{"tf":1.7320508075688772},"93":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":2.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":3,"docs":{"32":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"(":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"70":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"33":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"84":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"164":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"11":{"tf":1.0},"172":{"tf":1.0},"63":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"104":{"tf":1.0},"88":{"tf":1.7320508075688772}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"172":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}}}},"f":{"c":{"df":1,"docs":{"112":{"tf":1.0}}},"df":1,"docs":{"165":{"tf":1.0}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"169":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":1,"docs":{"165":{"tf":1.0}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"29":{"tf":1.4142135623730951},"57":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"135":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"112":{"tf":1.0}}}},"n":{"df":17,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":2.0},"165":{"tf":1.7320508075688772},"23":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"'":{"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"166":{"tf":1.0},"26":{"tf":1.0}}},"df":47,"docs":{"0":{"tf":3.0},"1":{"tf":2.23606797749979},"122":{"tf":1.4142135623730951},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"159":{"tf":1.4142135623730951},"160":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":2.23606797749979},"165":{"tf":1.7320508075688772},"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"17":{"tf":1.0},"170":{"tf":2.0},"171":{"tf":1.7320508075688772},"172":{"tf":2.0},"173":{"tf":2.0},"2":{"tf":1.0},"23":{"tf":1.7320508075688772},"29":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":2.0},"45":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":13,"docs":{"0":{"tf":1.4142135623730951},"120":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"169":{"tf":2.6457513110645907},"170":{"tf":1.4142135623730951},"172":{"tf":2.23606797749979},"29":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.7320508075688772},"49":{"tf":1.0},"7":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"165":{"tf":2.0},"169":{"tf":1.0},"170":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{">":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"<":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"164":{"tf":1.0}}}}}}}},"s":{"(":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}},".":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"<":{"'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{">":{"(":{"&":{"0":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":4,"docs":{"120":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"70":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"164":{"tf":1.0},"172":{"tf":1.0},"39":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"134":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}}}}}},"df":7,"docs":{"112":{"tf":1.7320508075688772},"118":{"tf":1.0},"152":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":2.0},"80":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":3.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"166":{"tf":1.0},"36":{"tf":1.0},"45":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":26,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"122":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"160":{"tf":1.0},"161":{"tf":1.7320508075688772},"165":{"tf":1.0},"24":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":2.23606797749979},"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"n":{"d":{"df":1,"docs":{"86":{"tf":1.4142135623730951}},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"165":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"10":{"tf":1.0},"126":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"149":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"165":{"tf":1.0}}}}}}},"t":{"df":39,"docs":{"10":{"tf":1.0},"109":{"tf":1.0},"135":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.0},"19":{"tf":2.0},"20":{"tf":2.0},"21":{"tf":2.0},"22":{"tf":2.0},"23":{"tf":2.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"43":{"tf":1.0}}}},"p":{"df":1,"docs":{"160":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"122":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"w":{"df":2,"docs":{"172":{"tf":1.0},"46":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"125":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"165":{"tf":1.0},"38":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"165":{"tf":1.0}},"i":{"df":2,"docs":{"85":{"tf":1.0},"99":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"125":{"tf":1.0},"164":{"tf":1.0},"4":{"tf":1.0},"54":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"88":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"152":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"148":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"139":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"44":{"tf":1.7320508075688772},"74":{"tf":2.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"140":{"tf":2.0}},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"140":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"0":{"tf":1.0},"172":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"r":{"c":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"173":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"34":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"126":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"149":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"161":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"107":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":6,"docs":{"119":{"tf":1.0},"130":{"tf":1.0},"161":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0}},"i":{"df":15,"docs":{"10":{"tf":2.449489742783178},"11":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"158":{"tf":1.0},"171":{"tf":1.7320508075688772},"23":{"tf":1.0},"28":{"tf":1.7320508075688772},"32":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":2.449489742783178},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"c":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"173":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"1":{"7":{"df":1,"docs":{"86":{"tf":1.0}}},"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{":":{"1":{"1":{"df":1,"docs":{"47":{"tf":1.0}}},"2":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{":":{"5":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{":":{"3":{"0":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.0}},"s":{":":{"1":{"1":{":":{"1":{"3":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"9":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"1":{"7":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"2":{"3":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"1":{"0":{"df":1,"docs":{"90":{"tf":1.0}}},"2":{"df":1,"docs":{"85":{"tf":1.0}}},"df":6,"docs":{"101":{"tf":1.0},"53":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}},"5":{"df":1,"docs":{"100":{"tf":1.0}}},"9":{"df":2,"docs":{"55":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"1":{"2":{"df":1,"docs":{"78":{"tf":1.0}}},"7":{"df":1,"docs":{"117":{"tf":1.0}}},"df":3,"docs":{"76":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}},"2":{"0":{"df":1,"docs":{"70":{"tf":1.0}}},"1":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":4,"docs":{"105":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"98":{"tf":1.0}}},"7":{"df":1,"docs":{"104":{"tf":1.0}}},"9":{"df":4,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"66":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{":":{"1":{"2":{"df":1,"docs":{"54":{"tf":1.0}}},"7":{"df":1,"docs":{"115":{"tf":1.0}}},"df":6,"docs":{"116":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}}},"5":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"1":{"3":{"df":2,"docs":{"56":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":5,"docs":{"57":{"tf":1.0},"58":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}},"8":{"df":1,"docs":{"111":{"tf":1.0}}},"9":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{":":{"1":{"3":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":2,"docs":{"64":{"tf":1.0},"92":{"tf":1.0}}},"9":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{":":{"5":{"df":3,"docs":{"102":{"tf":1.0},"63":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{":":{"1":{"4":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{":":{"5":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":2.0}}}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"150":{"tf":1.4142135623730951},"155":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"44":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"173":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.0},"77":{"tf":2.0},"91":{"tf":1.0}}}}}}},"i":{"c":{"df":11,"docs":{"11":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"120":{"tf":1.7320508075688772},"141":{"tf":1.0},"170":{"tf":1.4142135623730951},"44":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"70":{"tf":2.0},"75":{"tf":2.0},"82":{"tf":2.6457513110645907}},"l":{"df":0,"docs":{},"i":{"b":{"df":4,"docs":{"11":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":2.23606797749979},"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"100":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"<":{"&":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"11":{"tf":1.0},"164":{"tf":2.23606797749979},"165":{"tf":2.449489742783178},"167":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}},"p":{"df":1,"docs":{"33":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":14,"docs":{"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":2.23606797749979}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"107":{"tf":1.0},"163":{"tf":1.4142135623730951},"46":{"tf":1.0},"6":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"139":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.0},"131":{"tf":1.0},"140":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"166":{"tf":1.0},"43":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"165":{"tf":1.4142135623730951},"169":{"tf":1.7320508075688772},"170":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"116":{"tf":1.0},"146":{"tf":1.0},"32":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"x":{"df":3,"docs":{"10":{"tf":1.0},"32":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"32":{"tf":1.0}}},"df":2,"docs":{"0":{"tf":1.0},"29":{"tf":1.4142135623730951}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"151":{"tf":1.0},"172":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":10,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"129":{"tf":1.0},"140":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"9":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"_":{"df":1,"docs":{"48":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"k":{"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"165":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":2,"docs":{"159":{"tf":1.0},"161":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":9,"docs":{"11":{"tf":3.605551275463989},"127":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":2.0},"159":{"tf":2.449489742783178},"160":{"tf":3.0},"161":{"tf":3.605551275463989},"165":{"tf":1.0},"18":{"tf":2.23606797749979}}}}}}},"df":5,"docs":{"111":{"tf":1.4142135623730951},"115":{"tf":2.0},"63":{"tf":1.0},"76":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"160":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"34":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"134":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"134":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"155":{"tf":1.0},"33":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{":":{":":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"{":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"17":{"tf":2.23606797749979},"61":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"33":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":5,"docs":{"165":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.0},"166":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"129":{"tf":1.4142135623730951}},"g":{"df":3,"docs":{"165":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"93":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"11":{"tf":1.0},"148":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":2,"docs":{"164":{"tf":1.0},"64":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"154":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"125":{"tf":1.0},"129":{"tf":1.0},"148":{"tf":1.0},"164":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"64":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"l":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"164":{"tf":1.7320508075688772},"165":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"1":{"tf":1.0},"167":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"167":{"tf":1.0},"172":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":2,"docs":{"164":{"tf":2.6457513110645907},"34":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":8,"docs":{"111":{"tf":1.0},"118":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":3.3166247903554},"72":{"tf":1.0},"78":{"tf":2.23606797749979},"80":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":2.0}}}}}}}},"df":0,"docs":{},"i":{"df":6,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"128":{"tf":1.0},"50":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":65,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.4142135623730951}},"e":{">":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"164":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"55":{"tf":2.0},"56":{"tf":2.0},"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"108":{"tf":2.23606797749979}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":11,"docs":{"1":{"tf":1.0},"136":{"tf":1.4142135623730951},"138":{"tf":1.0},"139":{"tf":1.0},"152":{"tf":1.4142135623730951},"153":{"tf":1.0},"167":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":4,"docs":{"129":{"tf":1.0},"164":{"tf":1.0},"168":{"tf":1.0},"4":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"110":{"tf":1.4142135623730951},"38":{"tf":1.0},"43":{"tf":1.0}}},"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"169":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":22,"docs":{"10":{"tf":2.449489742783178},"102":{"tf":1.0},"11":{"tf":1.4142135623730951},"111":{"tf":2.23606797749979},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"44":{"tf":2.23606797749979},"49":{"tf":2.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"7":{"tf":2.8284271247461903},"70":{"tf":1.4142135623730951},"72":{"tf":2.23606797749979},"76":{"tf":1.0},"80":{"tf":2.23606797749979},"86":{"tf":2.6457513110645907},"87":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"i":{"c":{"df":3,"docs":{"163":{"tf":1.0},"165":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"3":{"2":{"df":3,"docs":{"50":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.23606797749979}}},"df":0,"docs":{}},"8":{"df":6,"docs":{"112":{"tf":1.0},"117":{"tf":1.7320508075688772},"71":{"tf":2.0},"78":{"tf":2.0},"84":{"tf":1.0},"97":{"tf":1.0}}},"df":1,"docs":{"89":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"(":{"1":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"3":{"2":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":2.6457513110645907}}}},"t":{"df":2,"docs":{"1":{"tf":1.0},"148":{"tf":1.4142135623730951}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":6,"docs":{"121":{"tf":1.7320508075688772},"159":{"tf":1.4142135623730951},"161":{"tf":1.4142135623730951},"165":{"tf":2.23606797749979},"90":{"tf":1.7320508075688772},"99":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.0},"46":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"94":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"44":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"91":{"tf":2.0},"92":{"tf":2.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":5,"docs":{"105":{"tf":2.6457513110645907},"115":{"tf":1.0},"44":{"tf":1.0},"58":{"tf":2.449489742783178},"84":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"115":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"161":{"tf":1.4142135623730951},"172":{"tf":1.0},"23":{"tf":1.7320508075688772},"44":{"tf":1.0},"59":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":23,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":2.23606797749979},"102":{"tf":2.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":3.7416573867739413},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":2.0},"67":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.7320508075688772}},"e":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"34":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":4,"docs":{"148":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"44":{"tf":1.7320508075688772},"75":{"tf":1.7320508075688772}}}}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951}}}},"df":79,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"100":{"tf":1.7320508075688772},"101":{"tf":1.0},"102":{"tf":1.7320508075688772},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"108":{"tf":1.0},"11":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"115":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.4142135623730951},"127":{"tf":1.7320508075688772},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"15":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.7320508075688772},"159":{"tf":1.4142135623730951},"161":{"tf":1.4142135623730951},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":2.23606797749979},"165":{"tf":2.449489742783178},"166":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"169":{"tf":2.23606797749979},"170":{"tf":1.7320508075688772},"171":{"tf":1.7320508075688772},"172":{"tf":2.0},"23":{"tf":1.0},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"37":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":2.23606797749979},"50":{"tf":1.0},"54":{"tf":2.0},"59":{"tf":1.0},"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.4142135623730951},"86":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"=":{".":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"165":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"118":{"tf":1.4142135623730951},"47":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"11":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"172":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"0":{"(":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":10,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":15,"docs":{"10":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":2.0},"116":{"tf":1.0},"121":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"135":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.7320508075688772},"4":{"tf":1.0},"44":{"tf":1.0},"7":{"tf":1.4142135623730951},"9":{"tf":1.0},"95":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":13,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":2.0},"114":{"tf":1.0},"165":{"tf":1.0},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":2.23606797749979},"72":{"tf":1.0}}}}},"df":2,"docs":{"165":{"tf":1.0},"64":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"11":{"tf":1.0},"4":{"tf":1.0}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"(":{"[":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}},"e":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"138":{"tf":1.7320508075688772},"139":{"tf":1.7320508075688772},"152":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":4,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":2.0},"4":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"120":{"tf":1.0},"122":{"tf":1.0},"129":{"tf":1.0},"164":{"tf":1.0},"172":{"tf":2.0},"26":{"tf":2.23606797749979}}}}}}}},"i":{"a":{"df":8,"docs":{"122":{"tf":1.0},"164":{"tf":1.4142135623730951},"166":{"tf":1.0},"170":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"172":{"tf":1.0},"23":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"112":{"tf":2.0},"44":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":1,"docs":{"172":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"165":{"tf":1.0},"173":{"tf":1.0},"92":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"42":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"87":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"34":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":57,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":2.0},"108":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"19":{"tf":1.7320508075688772},"34":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":2.6457513110645907},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"43":{"tf":2.449489742783178},"44":{"tf":2.0},"47":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}},"y":{"df":6,"docs":{"106":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0}}}},"df":4,"docs":{"19":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.0}},"e":{"'":{"d":{"df":2,"docs":{"1":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0}}}},"v":{"df":1,"docs":{"173":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.0},"40":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"107":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"173":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"42":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"1":{"tf":1.0},"33":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"38":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"113":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":2.23606797749979},"88":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"107":{"tf":1.0},"164":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":7,"docs":{"134":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":1.4142135623730951},"42":{"tf":1.0},"47":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"164":{"tf":1.0},"165":{"tf":1.7320508075688772}}}}}}},"l":{"d":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"173":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"x":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"0":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"161":{"tf":1.0}}}}}},"df":23,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"37":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"73":{"tf":3.4641016151377544},"74":{"tf":2.0},"75":{"tf":2.0},"77":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"95":{"tf":2.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.7320508075688772}}},"y":{"df":6,"docs":{"115":{"tf":1.4142135623730951},"136":{"tf":1.0},"143":{"tf":1.0},"73":{"tf":3.0},"84":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772}},"e":{"df":2,"docs":{"136":{"tf":1.0},"143":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":4,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"161":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"173":{"tf":1.0}}}},"v":{"df":3,"docs":{"1":{"tf":1.0},"34":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"z":{"df":5,"docs":{"11":{"tf":1.0},"152":{"tf":1.0},"161":{"tf":1.4142135623730951},"23":{"tf":2.6457513110645907},"80":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"143":{"tf":1.4142135623730951}}}}}}}},"title":{"root":{"a":{"d":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":3,"docs":{"20":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"r":{"df":1,"docs":{"123":{"tf":1.0}},"g":{"=":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"125":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"126":{"tf":1.0},"133":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"71":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"153":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"42":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"48":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"71":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"49":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"160":{"tf":1.0},"8":{"tf":1.0}}}}}}},"c":{"/":{"c":{"df":2,"docs":{"169":{"tf":1.0},"170":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}}}},"p":{"df":2,"docs":{"24":{"tf":1.0},"43":{"tf":1.0}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"165":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}}},"t":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}}}},"df":1,"docs":{"25":{"tf":1.0}},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"4":{"tf":1.0}}}},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"136":{"tf":1.0},"150":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"e":{"df":8,"docs":{"128":{"tf":1.0},"13":{"tf":1.0},"145":{"tf":1.0},"170":{"tf":1.0},"25":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"91":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"122":{"tf":1.0},"148":{"tf":1.0},"25":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"93":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"172":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"11":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.0},"66":{"tf":1.0}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"173":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"130":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"119":{"tf":1.0},"121":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"161":{"tf":1.0}}}}}}}},"d":{"df":1,"docs":{"21":{"tf":1.0}},"e":{"a":{"d":{"df":2,"docs":{"128":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"12":{"tf":1.0},"153":{"tf":1.0},"52":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"151":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"46":{"tf":1.0},"65":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":3,"docs":{"109":{"tf":1.0},"21":{"tf":1.0},"38":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"169":{"tf":1.0},"170":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"113":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"o":{"c":{"df":2,"docs":{"53":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"89":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"141":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"30":{"tf":1.4142135623730951}}}}}},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}},"n":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"171":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"119":{"tf":1.0},"120":{"tf":1.0},"28":{"tf":1.4142135623730951},"60":{"tf":1.0}}}}},"r":{"a":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"df":1,"docs":{"22":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"131":{"tf":1.0},"59":{"tf":1.0},"85":{"tf":1.0},"99":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"73":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"14":{"tf":1.0},"147":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"41":{"tf":1.0}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"140":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":2,"docs":{"78":{"tf":1.0},"81":{"tf":1.0}}},"o":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"166":{"tf":1.0}}}}}}}}},"g":{"df":1,"docs":{"12":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"157":{"tf":1.0},"25":{"tf":1.0},"6":{"tf":1.0},"76":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"162":{"tf":1.0},"163":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":1,"docs":{"3":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"51":{"tf":1.0},"52":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"61":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"156":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"154":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"142":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"116":{"tf":1.0},"76":{"tf":1.0}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"a":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"112":{"tf":1.0},"113":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"152":{"tf":1.0},"24":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"28":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"79":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"50":{"tf":1.0},"54":{"tf":1.0},"71":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.0}}},"k":{"df":4,"docs":{"125":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"124":{"tf":1.0},"127":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.0}}}}},"t":{"df":15,"docs":{"109":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"65":{"tf":1.0},"83":{"tf":1.0},"90":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"117":{"tf":1.0},"69":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"133":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"138":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"129":{"tf":1.0},"167":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"101":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"116":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"16":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"146":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"114":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"v":{"df":1,"docs":{"145":{"tf":1.0}}}},"df":1,"docs":{"144":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"103":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"32":{"tf":1.0},"8":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":2,"docs":{"13":{"tf":1.0},"14":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"152":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"13":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"122":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"117":{"tf":1.0},"136":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"155":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"111":{"tf":1.0},"118":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"104":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"132":{"tf":1.0},"137":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"32":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"77":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"69":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"92":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"167":{"tf":1.0},"171":{"tf":1.0},"79":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"49":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"141":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"32":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"137":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"26":{"tf":1.0},"33":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"119":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"157":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"169":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":2,"docs":{"119":{"tf":1.0},"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"166":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"143":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"144":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"149":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"83":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"135":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":3,"docs":{"0":{"tf":1.0},"171":{"tf":1.0},"173":{"tf":1.0}}},"df":2,"docs":{"169":{"tf":1.0},"170":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":2,"docs":{"120":{"tf":1.0},"84":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"134":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":6,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"139":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"74":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"140":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":6,"docs":{"10":{"tf":1.0},"114":{"tf":1.0},"171":{"tf":1.0},"28":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"150":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"i":{"c":{"df":2,"docs":{"120":{"tf":1.0},"82":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"169":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"130":{"tf":1.0},"131":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"18":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"134":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"154":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"172":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"108":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":7,"docs":{"10":{"tf":1.0},"111":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0},"7":{"tf":1.4142135623730951},"72":{"tf":1.0},"86":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.0}}}},"t":{"df":1,"docs":{"148":{"tf":1.0}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"121":{"tf":1.0},"90":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"57":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":2,"docs":{"105":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"59":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":17,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"1":{"tf":1.0},"164":{"tf":1.0},"168":{"tf":1.0}}}},"df":7,"docs":{"102":{"tf":1.0},"119":{"tf":1.0},"158":{"tf":1.0},"171":{"tf":1.0},"27":{"tf":1.0},"54":{"tf":1.0},"9":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"138":{"tf":1.0},"139":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}}},"i":{"a":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"107":{"tf":1.0},"19":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"65":{"tf":1.0}}}}},"df":1,"docs":{"19":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"165":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"z":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});