"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var def = require("raml-definition-system");
var ramlTypes = def.rt;
var hl = require("../parser/highLevelAST");
var lowLevel = require("../parser/lowLevelAST");
var universes = require("../parser/tools/universe");
var _ = require("underscore");
function getExtraProviderSource(extraProvider) {
    var sourceExtra = extraProvider.getExtra(ramlTypes.SOURCE_EXTRA);
    if (sourceExtra == null)
        return null;
    if (def.isSourceProvider(sourceExtra)) {
        return sourceExtra;
    }
    if (lowLevel.isLowLevelNode(sourceExtra)) {
        return {
            getSource: function () {
                return sourceExtra.highLevelNode();
            }
        };
    }
    if (hl.isParseResult(sourceExtra)) {
        return {
            getSource: function () {
                return sourceExtra;
            }
        };
    }
    return null;
}
exports.getExtraProviderSource = getExtraProviderSource;
function getRTypeSource(rType) {
    return getExtraProviderSource(rType);
}
exports.getRTypeSource = getRTypeSource;
function findRTypeByNominal(nominalType) {
    var adapters = nominalType.getAdapters();
    if (!adapters)
        return null;
    return _.find(adapters, function (adapter) {
        return def.rt.isParsedType(adapter);
    });
}
exports.findRTypeByNominal = findRTypeByNominal;
function getNominalTypeSource(nominalType) {
    if (!nominalType)
        return null;
    var sourceExtra = nominalType.getExtra(ramlTypes.SOURCE_EXTRA);
    if (sourceExtra) {
        return getExtraProviderSource(nominalType);
    }
    var rType = findRTypeByNominal(nominalType);
    if (rType) {
        return getRTypeSource(rType);
    }
    return null;
}
exports.getNominalTypeSource = getNominalTypeSource;
function getNominalPropertySource(type, name) {
    var typeSource = getNominalTypeSource(type);
    if (!typeSource)
        return null;
    return {
        getSource: function () {
            var typeNode = typeSource.getSource();
            var typeNodeElement = typeNode.asElement();
            if (typeNodeElement == null)
                return null;
            var propertyElements = typeNodeElement.elementsOfKind(universes.Universe10.ObjectTypeDeclaration.properties.properties.name);
            if (propertyElements == null || propertyElements.length == 0)
                return null;
            return _.find(propertyElements, function (propertyElement) {
                return name == propertyElement.attrValue(universes.Universe10.TypeDeclaration.properties.name.name);
            });
        }
    };
}
exports.getNominalPropertySource = getNominalPropertySource;
function getNominalPropertySource2(property) {
    return getNominalPropertySource(property.domain(), property.nameId());
}
exports.getNominalPropertySource2 = getNominalPropertySource2;
//# sourceMappingURL=sourceFinder.js.map