/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ngrams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tools.StringTools;

class GoogleToken {
    final String token;
    final int startPos;
    final int endPos;
    final Set<AnalyzedToken> posTags;

    GoogleToken(String token, int startPos, int endPos) {
        this(token, startPos, endPos, Collections.emptySet());
    }

    GoogleToken(String token, int startPos, int endPos, Set<AnalyzedToken> posTags) {
        this.token = "\u2019".equals(token) ? "'" : token;
        this.startPos = startPos;
        this.endPos = endPos;
        this.posTags = posTags;
    }

    Set<AnalyzedToken> getPosTags() {
        return this.posTags;
    }

    boolean isWhitespace() {
        return StringTools.isWhitespace(this.token);
    }

    public String toString() {
        return this.token;
    }

    static List<GoogleToken> getGoogleTokens(String sentence, boolean addStartToken, Tokenizer wordTokenizer) {
        ArrayList<GoogleToken> result = new ArrayList<GoogleToken>();
        if (addStartToken) {
            result.add(new GoogleToken("_START_", 0, 0));
        }
        List<String> tokens = wordTokenizer.tokenize(sentence);
        int startPos = 0;
        for (String token : tokens) {
            if (!StringTools.isWhitespace(token)) {
                result.add(new GoogleToken(token, startPos, startPos + token.length()));
            }
            startPos += token.length();
        }
        return result;
    }

    static List<GoogleToken> getGoogleTokens(AnalyzedSentence sentence, boolean addStartToken, Tokenizer wordTokenizer) {
        ArrayList<GoogleToken> result = new ArrayList<GoogleToken>();
        if (addStartToken) {
            result.add(new GoogleToken("_START_", 0, 0));
        }
        List<String> tokens = wordTokenizer.tokenize(sentence.getText());
        int startPos = 0;
        for (String token : tokens) {
            if (!StringTools.isWhitespace(token)) {
                int endPos = startPos + token.length();
                Set<AnalyzedToken> pos = GoogleToken.findOriginalAnalyzedTokens(sentence, startPos, endPos);
                GoogleToken gToken = new GoogleToken(token, startPos, endPos, pos);
                result.add(gToken);
            }
            startPos += token.length();
        }
        return result;
    }

    private static Set<AnalyzedToken> findOriginalAnalyzedTokens(AnalyzedSentence sentence, int startPos, int endPos) {
        HashSet<AnalyzedToken> result = new HashSet<AnalyzedToken>();
        for (AnalyzedTokenReadings tokens : sentence.getTokensWithoutWhitespace()) {
            if (tokens.getStartPos() != startPos || tokens.getEndPos() != endPos) continue;
            for (AnalyzedToken analyzedToken : tokens.getReadings()) {
                result.add(analyzedToken);
            }
        }
        return result;
    }
}

