/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.librarymanagement.ivyint;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.UnknownHostException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.BasicURLHandler;
import org.apache.ivy.util.url.IvyAuthenticator;
import org.apache.ivy.util.url.URLHandler;
import sbt.internal.librarymanagement.ivyint.ErrorMessageAuthenticator$;
import sbt.internal.librarymanagement.ivyint.GigahorseUrlHandler$;
import sbt.io.IO$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\f\u0019\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\u0006y\u0001!\ta\u0017\u0005\u0006M\u0002!Ia\u001a\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006k\u0002!\tA\u001e\u0005\b\u0003\u001b\u0001A\u0011AA\b\u000f\u001d\tY\u0002\u0007E\u0001\u0003;1aa\u0006\r\t\u0002\u0005}\u0001BB\u001c\u000b\t\u0003\t9CB\u0004\u0002*)\u0001a$a\u000b\t\u0015\u00055BB!A!\u0002\u0013\ty\u0003\u0003\u0006\u000261\u0011\t\u0011)A\u0005\u0003oA!\"!\u0010\r\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011)\ty\u0004\u0004B\u0001B\u0003%\u0011\u0011\t\u0005\u0007o1!\t!!\u0015\t\r]bA\u0011AA0\u0011%\t9G\u0003b\u0001\n\u0013\tI\u0007\u0003\u0005\u0002x)\u0001\u000b\u0011BA6\u0011\u001d\tIH\u0003C\u0005\u0003wBq!a!\u000b\t\u0013\t)IA\nHS\u001e\f\u0007n\u001c:tKV\u0013H\u000eS1oI2,'O\u0003\u0002\u001a5\u00051\u0011N^=j]RT!a\u0007\u000f\u0002#1L'M]1ss6\fg.Y4f[\u0016tGO\u0003\u0002\u001e=\u0005A\u0011N\u001c;fe:\fGNC\u0001 \u0003\r\u0019(\r^\u0002\u0001'\t\u0001!\u0005\u0005\u0002$]5\tAE\u0003\u0002&M\u0005\u0019QO\u001d7\u000b\u0005\u001dB\u0013\u0001B;uS2T!!\u000b\u0016\u0002\u0007%4\u0018P\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<\u0017BA\u0018%\u0005I\t%m\u001d;sC\u000e$XK\u0015'IC:$G.\u001a:\u0002\t!$H\u000f\u001d\t\u0003eUj\u0011a\r\u0006\u0002i\u00059qn\u001b5uiB\u001c\u0014B\u0001\u001c4\u00051y5\u000e\u0013;ua\u000ec\u0017.\u001a8u\u0003\u0019a\u0014N\\5u}Q\u0011\u0011h\u000f\t\u0003u\u0001i\u0011\u0001\u0007\u0005\u0006a\t\u0001\r!M\u0001\u000bO\u0016$XK\u0015'J]\u001a|GC\u0001 S!\tytJ\u0004\u0002A\u001b:\u0011\u0011\t\u0014\b\u0003\u0005.s!a\u0011&\u000f\u0005\u0011KeBA#I\u001b\u00051%BA$!\u0003\u0019a$o\\8u}%\tQ&\u0003\u0002,Y%\u0011\u0011FK\u0005\u0003O!J!!\n\u0014\n\u00059#\u0013AC+S\u0019\"\u000bg\u000e\u001a7fe&\u0011\u0001+\u0015\u0002\b+Jc\u0015J\u001c4p\u0015\tqE\u0005C\u0003&\u0007\u0001\u00071\u000b\u0005\u0002U36\tQK\u0003\u0002W/\u0006\u0019a.\u001a;\u000b\u0003a\u000bAA[1wC&\u0011!,\u0016\u0002\u0004+JcEc\u0001 ]=\")Q\f\u0002a\u0001'\u0006!QO\u001d71\u0011\u0015yF\u00011\u0001a\u0003\u001d!\u0018.\\3pkR\u0004\"!\u00193\u000e\u0003\tT\u0011aY\u0001\u0006g\u000e\fG.Y\u0005\u0003K\n\u00141!\u00138u\u0003\u00199W\r^+sYR\u0011\u0001n\u001b\t\u0003e%L!A[\u001a\u0003\u0011I+7\u000f]8og\u0016DQ!X\u0003A\u0002M\u000b!b\u001c9f]N#(/Z1n)\tqG\u000f\u0005\u0002pe6\t\u0001O\u0003\u0002r/\u0006\u0011\u0011n\\\u0005\u0003gB\u00141\"\u00138qkR\u001cFO]3b[\")QE\u0002a\u0001'\u0006AAm\\<oY>\fG\rF\u0003xun\f\t\u0001\u0005\u0002bq&\u0011\u0011P\u0019\u0002\u0005+:LG\u000fC\u0003&\u000f\u0001\u00071\u000bC\u0003}\u000f\u0001\u0007Q0\u0001\u0003eKN$\bCA8\u007f\u0013\ty\bO\u0001\u0003GS2,\u0007bBA\u0002\u000f\u0001\u0007\u0011QA\u0001\u0002YB!\u0011qAA\u0005\u001b\u00051\u0013bAA\u0006M\t!2i\u001c9z!J|wM]3tg2K7\u000f^3oKJ\fa!\u001e9m_\u0006$GcB<\u0002\u0012\u0005U\u0011\u0011\u0004\u0005\u0007\u0003'A\u0001\u0019A?\u0002\rM|WO]2f\u0011\u0019\t9\u0002\u0003a\u0001'\u0006)A-Z:ua!9\u00111\u0001\u0005A\u0002\u0005\u0015\u0011aE$jO\u0006DwN]:f+Jd\u0007*\u00198eY\u0016\u0014\bC\u0001\u001e\u000b'\rQ\u0011\u0011\u0005\t\u0004C\u0006\r\u0012bAA\u0013E\n1\u0011I\\=SK\u001a$\"!!\b\u0003\u0015M\u0013G/\u0016:m\u0013:4wn\u0005\u0002\r}\u0005I\u0011M^1jY\u0006\u0014G.\u001a\t\u0004C\u0006E\u0012bAA\u001aE\n9!i\\8mK\u0006t\u0017!D2p]R,g\u000e\u001e'f]\u001e$\b\u000eE\u0002b\u0003sI1!a\u000fc\u0005\u0011auN\\4\u0002\u00191\f7\u000f^'pI&4\u0017.\u001a3\u0002\u0017\t|G-_\"iCJ\u001cX\r\u001e\t\u0005\u0003\u0007\nYE\u0004\u0003\u0002F\u0005\u001d\u0003CA#c\u0013\r\tIEY\u0001\u0007!J,G-\u001a4\n\t\u00055\u0013q\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%#\r\u0006\u0006\u0002T\u0005]\u0013\u0011LA.\u0003;\u00022!!\u0016\r\u001b\u0005Q\u0001bBA\u0017#\u0001\u0007\u0011q\u0006\u0005\b\u0003k\t\u0002\u0019AA\u001c\u0011\u001d\ti$\u0005a\u0001\u0003oAq!a\u0010\u0012\u0001\u0004\t\t\u0005\u0006\u0005\u0002T\u0005\u0005\u00141MA3\u0011\u001d\tiC\u0005a\u0001\u0003_Aq!!\u000e\u0013\u0001\u0004\t9\u0004C\u0004\u0002>I\u0001\r!a\u000e\u0002\u0017\u0015k\u0007\u000f^=Ck\u001a4WM]\u000b\u0003\u0003W\u0002R!YA7\u0003cJ1!a\u001cc\u0005\u0015\t%O]1z!\r\t\u00171O\u0005\u0004\u0003k\u0012'\u0001\u0002\"zi\u0016\fA\"R7qif\u0014UO\u001a4fe\u0002\nqb\u00195fG.\u001cF/\u0019;vg\u000e{G-\u001a\u000b\u0007\u0003_\ti(a \t\u000b\u0015*\u0002\u0019A*\t\r\u0005\u0005U\u00031\u0001i\u0003!\u0011Xm\u001d9p]N,\u0017!\u00067bgRlu\u000eZ5gS\u0016$G+[7fgR\fW\u000e\u001d\u000b\u0005\u0003o\t9\t\u0003\u0004\u0002\u0002Z\u0001\r\u0001\u001b")
public class GigahorseUrlHandler
extends AbstractURLHandler {
    private final OkHttpClient http;

    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, 0);
    }

    public URLHandler.URLInfo getURLInfo(URL url0, int timeout) {
        URLHandler.URLInfo uRLInfo;
        if ("http".equals(url0.getProtocol()) || "https".equals(url0.getProtocol())) {
            IvyAuthenticator.install();
            ErrorMessageAuthenticator$.MODULE$.install();
        }
        URL url = this.normalizeToURL(url0);
        Request.Builder request = new Request.Builder().url(url);
        Request.Builder builder = this.getRequestMethod() == 2 ? request.head() : request.get();
        try (Response response = this.http.newCall(request.build()).execute();){
            None$ none$;
            try {
                if (GigahorseUrlHandler$.MODULE$.sbt$internal$librarymanagement$ivyint$GigahorseUrlHandler$$checkStatusCode(url, response)) {
                    String bodyCharset = BasicURLHandler.getCharSetFromContentType((String)((String)Option$.MODULE$.apply((Object)response.body().contentType()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).orNull(Predef$.MODULE$.$conforms())));
                    none$ = new Some((Object)new SbtUrlInfo(true, response.body().contentLength(), GigahorseUrlHandler$.MODULE$.sbt$internal$librarymanagement$ivyint$GigahorseUrlHandler$$lastModifiedTimestamp(response), bodyCharset));
                } else {
                    none$ = None$.MODULE$;
                }
            }
            catch (UnknownHostException e) {
                Message.warn((String)new StringBuilder(21).append("Host ").append(e.getMessage()).append(" not found. url=").append(url).toString());
                Message.info((String)"You probably access the destination server through a proxy server that is not well configured.");
                none$ = None$.MODULE$;
            }
            catch (IOException e) {
                Message.error((String)new StringBuilder(26).append("Server access Error: ").append(e.getMessage()).append(" url=").append(url).toString());
                none$ = None$.MODULE$;
            }
            None$ infoOption = none$;
            uRLInfo = (URLHandler.URLInfo)infoOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> URLHandler.UNAVAILABLE);
        }
        return uRLInfo;
    }

    private Response getUrl(URL url0) {
        Response response;
        if ("http".equals(url0.getProtocol()) || "https".equals(url0.getProtocol())) {
            IvyAuthenticator.install();
            ErrorMessageAuthenticator$.MODULE$.install();
        }
        URL url = this.normalizeToURL(url0);
        Request request = new Request.Builder().url(url).get().build();
        Response response2 = this.http.newCall(request).execute();
        try {
            if (!GigahorseUrlHandler$.MODULE$.sbt$internal$librarymanagement$ivyint$GigahorseUrlHandler$$checkStatusCode(url, response2)) {
                throw new IOException(new StringBuilder(80).append("The HTTP response code for ").append(url).append(" did not indicate a success.").append(" See log for more detail.").toString());
            }
            response = response2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                response2.close();
                throw e;
            }
            throw throwable;
        }
        return response;
    }

    public InputStream openStream(URL url) {
        return this.getUrl(url).body().byteStream();
    }

    public void download(URL url, File dest, CopyProgressListener l) {
        try (Response response = this.getUrl(url);){
            if (l != null) {
                l.start(new CopyProgressEvent());
            }
            try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)dest));){
                sink.writeAll((Source)response.body().source());
                sink.flush();
            }
            long contentLength = response.body().contentLength();
            if (contentLength != -1L && dest.length() != contentLength) {
                IO$.MODULE$.delete(dest);
                throw new IOException(new StringBuilder(78).append("Downloaded file size doesn't match expected Content Length for ").append(url).append(". Please retry.").toString());
            }
            long lastModified = GigahorseUrlHandler$.MODULE$.sbt$internal$librarymanagement$ivyint$GigahorseUrlHandler$$lastModifiedTimestamp(response);
            Object object = lastModified > 0L ? BoxesRunTime.boxToBoolean((boolean)IO$.MODULE$.setModifiedTimeOrFalse(dest, lastModified)) : BoxedUnit.UNIT;
            if (l != null) {
                l.end(new CopyProgressEvent(GigahorseUrlHandler$.MODULE$.sbt$internal$librarymanagement$ivyint$GigahorseUrlHandler$$EmptyBuffer(), contentLength));
            }
        }
    }

    public void upload(File source, URL dest0, CopyProgressListener l) {
        if (!"http".equals(dest0.getProtocol()) && !"https".equals(dest0.getProtocol())) {
            throw new UnsupportedOperationException("URL repository only support HTTP PUT at the moment");
        }
        IvyAuthenticator.install();
        ErrorMessageAuthenticator$.MODULE$.install();
        URL dest = this.normalizeToURL(dest0);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)source);
        Request request = new Request.Builder().url(dest).put(body).build();
        if (l != null) {
            l.start(new CopyProgressEvent());
        }
        try (Response response = this.http.newCall(request).execute();){
            if (l != null) {
                l.end(new CopyProgressEvent(GigahorseUrlHandler$.MODULE$.sbt$internal$librarymanagement$ivyint$GigahorseUrlHandler$$EmptyBuffer(), source.length()));
            }
            this.validatePutStatusCode(dest, response.code(), response.message());
        }
    }

    public GigahorseUrlHandler(OkHttpClient http) {
        this.http = http;
    }

    public static class SbtUrlInfo
    extends URLHandler.URLInfo {
        public SbtUrlInfo(boolean available, long contentLength, long lastModified, String bodyCharset) {
            super(available, contentLength, lastModified, bodyCharset);
        }

        public SbtUrlInfo(boolean available, long contentLength, long lastModified) {
            this(available, contentLength, lastModified, null);
        }
    }
}

