/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPReportBlock;
import com.sun.media.rtp.RTCPReporter;
import com.sun.media.rtp.RTCPSDES;
import com.sun.media.rtp.RTPSinkStream;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RTPSourceStream;
import com.sun.media.rtp.RTPStats;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.util.SSRCTable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.media.Format;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SourceDescription;

public abstract class SSRCInfo
implements Report {
    private SSRCCache cache;
    boolean alive = false;
    boolean payloadchange = false;
    boolean byeReceived = false;
    long byeTime = 0L;
    String byereason = null;
    RTPSourceInfo sourceInfo = null;
    SourceDescription name = null;
    SourceDescription email = null;
    SourceDescription phone = null;
    SourceDescription loc = null;
    SourceDescription tool = null;
    SourceDescription note = null;
    SourceDescription priv = null;
    long lastSRntptimestamp = 0L;
    long lastSRrtptimestamp = 0L;
    long lastSRoctetcount = 0L;
    long lastSRpacketcount = 0L;
    long lastRTCPreceiptTime = 0L;
    long lastSRreceiptTime = 0L;
    long lastHeardFrom = 0L;
    boolean quiet = false;
    boolean inactivesent = false;
    boolean aging;
    boolean sender = false;
    boolean ours = false;
    int ssrc;
    boolean streamconnect = false;
    SSRCTable reports = new SSRCTable();
    boolean active = false;
    boolean newrecvstream = false;
    boolean recvstrmap = false;
    boolean newpartsent = false;
    boolean lastsr = false;
    boolean wrapped = false;
    static final int INITIALPROBATION = 2;
    int probation = 2;
    static final int PAYLOAD_UNASSIGNED = -1;
    boolean wassender = false;
    int prevmaxseq;
    int prevlost;
    long starttime;
    long rtptime;
    long systime;
    InetAddress address;
    int port;
    RTCPReporter reporter;
    Format currentformat = null;
    int payloadType = -1;
    com.sun.media.protocol.rtp.DataSource dsource = null;
    DataSource pds = null;
    RTPSourceStream dstream = null;
    RTPSinkStream sinkstream = null;
    long lastRTPReceiptTime;
    int maxseq = 0;
    int cycles = 0;
    int baseseq;
    int lastbadseq;
    int received;
    long lasttimestamp = 0L;
    int lastPayloadType = -1;
    double jitter = 0.0;
    int bytesreceived;
    RTPStats stats = null;
    int clockrate = 0;

    SSRCInfo(SSRCCache cache, int ssrc) {
        this.cache = cache;
        this.ssrc = ssrc;
        this.stats = new RTPStats();
    }

    SSRCInfo(SSRCInfo info) {
        this.cache = info.cache;
        this.alive = info.alive;
        this.sourceInfo = info.sourceInfo;
        if (this.sourceInfo != null) {
            this.sourceInfo.addSSRC(this);
        }
        this.cache.remove(info.ssrc);
        this.name = info.name;
        this.email = info.email;
        this.phone = info.phone;
        this.loc = info.loc;
        this.tool = info.tool;
        this.note = info.note;
        this.priv = info.priv;
        this.lastSRntptimestamp = info.lastSRntptimestamp;
        this.lastSRrtptimestamp = info.lastSRrtptimestamp;
        this.lastSRoctetcount = info.lastSRoctetcount;
        this.lastSRpacketcount = info.lastSRpacketcount;
        this.lastRTCPreceiptTime = info.lastRTCPreceiptTime;
        this.lastSRreceiptTime = info.lastSRreceiptTime;
        this.lastHeardFrom = info.lastHeardFrom;
        this.quiet = info.quiet;
        this.inactivesent = info.inactivesent;
        this.aging = info.aging;
        this.reports = info.reports;
        this.ours = info.ours;
        this.ssrc = info.ssrc;
        this.streamconnect = info.streamconnect;
        this.newrecvstream = info.newrecvstream;
        this.recvstrmap = info.recvstrmap;
        this.newpartsent = info.newpartsent;
        this.lastsr = info.lastsr;
        this.probation = info.probation;
        this.wassender = info.wassender;
        this.prevmaxseq = info.prevmaxseq;
        this.prevlost = info.prevlost;
        this.starttime = info.starttime;
        this.reporter = info.reporter;
        if (info.reporter != null) {
            this.reporter.transmit.setSSRCInfo(this);
        }
        this.payloadType = info.payloadType;
        this.dsource = info.dsource;
        this.pds = info.pds;
        this.dstream = info.dstream;
        this.lastRTPReceiptTime = info.lastRTPReceiptTime;
        this.maxseq = info.maxseq;
        this.cycles = info.cycles;
        this.baseseq = info.baseseq;
        this.lastbadseq = info.lastbadseq;
        this.received = info.received;
        this.lasttimestamp = info.lasttimestamp;
        this.lastPayloadType = info.lastPayloadType;
        this.jitter = info.jitter;
        this.bytesreceived = info.bytesreceived;
        this.address = info.address;
        this.port = info.port;
        this.stats = info.stats;
        this.clockrate = info.clockrate;
        this.byeTime = info.byeTime;
        this.byeReceived = info.byeReceived;
    }

    private void InitSDES() {
        this.name = new SourceDescription(2, null, 0, false);
        this.email = new SourceDescription(3, null, 0, false);
        this.phone = new SourceDescription(4, null, 0, false);
        this.loc = new SourceDescription(5, null, 0, false);
        this.tool = new SourceDescription(6, null, 0, false);
        this.note = new SourceDescription(7, null, 0, false);
        this.priv = new SourceDescription(8, null, 0, false);
    }

    RTPSourceInfo getRTPSourceInfo() {
        return this.sourceInfo;
    }

    boolean isActive() {
        return this.active;
    }

    int getPayloadType() {
        return this.payloadType;
    }

    void setSourceDescription(SourceDescription[] userdesclist) {
        if (userdesclist == null) {
            return;
        }
        String cname = null;
        int i = 0;
        while (i < userdesclist.length) {
            SourceDescription currdesc = userdesclist[i];
            if (currdesc != null && currdesc.getType() == 1) {
                cname = userdesclist[i].getDescription();
                break;
            }
            ++i;
        }
        String sourceinfocname = null;
        if (this.sourceInfo != null) {
            sourceinfocname = this.sourceInfo.getCNAME();
        }
        if (this.sourceInfo != null && cname != null && !cname.equals(sourceinfocname)) {
            this.sourceInfo.removeSSRC(this);
            this.sourceInfo = null;
        }
        if (this.sourceInfo == null) {
            this.sourceInfo = this.cache.sourceInfoCache.get(cname, true);
            this.sourceInfo.addSSRC(this);
        }
        int j = 0;
        while (j < userdesclist.length) {
            SourceDescription currdesc = userdesclist[j];
            if (currdesc != null) {
                switch (currdesc.getType()) {
                    case 2: {
                        if (this.name == null) {
                            this.name = new SourceDescription(2, currdesc.getDescription(), 0, false);
                            break;
                        }
                        this.name.setDescription(currdesc.getDescription());
                        break;
                    }
                    case 3: {
                        if (this.email == null) {
                            this.email = new SourceDescription(3, currdesc.getDescription(), 0, false);
                            break;
                        }
                        this.email.setDescription(currdesc.getDescription());
                        break;
                    }
                    case 4: {
                        if (this.phone == null) {
                            this.phone = new SourceDescription(4, currdesc.getDescription(), 0, false);
                            break;
                        }
                        this.phone.setDescription(currdesc.getDescription());
                        break;
                    }
                    case 5: {
                        if (this.loc == null) {
                            this.loc = new SourceDescription(5, currdesc.getDescription(), 0, false);
                            break;
                        }
                        this.loc.setDescription(currdesc.getDescription());
                        break;
                    }
                    case 6: {
                        if (this.tool == null) {
                            this.tool = new SourceDescription(6, currdesc.getDescription(), 0, false);
                            break;
                        }
                        this.tool.setDescription(currdesc.getDescription());
                        break;
                    }
                    case 7: {
                        if (this.note == null) {
                            this.note = new SourceDescription(7, currdesc.getDescription(), 0, false);
                            break;
                        }
                        this.note.setDescription(currdesc.getDescription());
                        break;
                    }
                    case 8: {
                        if (this.priv == null) {
                            this.priv = new SourceDescription(8, currdesc.getDescription(), 0, false);
                            break;
                        }
                        this.priv.setDescription(currdesc.getDescription());
                        break;
                    }
                }
            }
            ++j;
        }
    }

    void delete() {
        if (this.sourceInfo != null) {
            this.sourceInfo.removeSSRC(this);
        }
    }

    void addSDESInfo(RTCPSDES chunk) {
        int ci = 0;
        while (ci < chunk.items.length) {
            if (chunk.items[ci].type == 1) break;
            ++ci;
        }
        String s = new String(chunk.items[ci].data);
        String sourceinfocname = null;
        if (this.sourceInfo != null) {
            sourceinfocname = this.sourceInfo.getCNAME();
        }
        if (this.sourceInfo != null && !s.equals(sourceinfocname)) {
            this.sourceInfo.removeSSRC(this);
            this.sourceInfo = null;
        }
        if (this.sourceInfo == null) {
            this.sourceInfo = this.cache.sourceInfoCache.get(s, this.ours);
            this.sourceInfo.addSSRC(this);
        }
        if (chunk.items.length > 1) {
            int i = 0;
            while (i < chunk.items.length) {
                s = new String(chunk.items[i].data);
                switch (chunk.items[i].type) {
                    case 2: {
                        if (this.name == null) {
                            this.name = new SourceDescription(2, s, 0, false);
                            break;
                        }
                        this.name.setDescription(s);
                        break;
                    }
                    case 3: {
                        if (this.email == null) {
                            this.email = new SourceDescription(3, s, 0, false);
                            break;
                        }
                        this.email.setDescription(s);
                        break;
                    }
                    case 4: {
                        if (this.phone == null) {
                            this.phone = new SourceDescription(4, s, 0, false);
                            break;
                        }
                        this.phone.setDescription(s);
                        break;
                    }
                    case 5: {
                        if (this.loc == null) {
                            this.loc = new SourceDescription(5, s, 0, false);
                            break;
                        }
                        this.loc.setDescription(s);
                        break;
                    }
                    case 6: {
                        if (this.tool == null) {
                            this.tool = new SourceDescription(6, s, 0, false);
                            break;
                        }
                        this.tool.setDescription(s);
                        break;
                    }
                    case 7: {
                        if (this.note == null) {
                            this.note = new SourceDescription(7, s, 0, false);
                            break;
                        }
                        this.note.setDescription(s);
                        break;
                    }
                    case 8: {
                        if (this.priv == null) {
                            this.priv = new SourceDescription(8, s, 0, false);
                            break;
                        }
                        this.priv.setDescription(s);
                    }
                }
                ++i;
            }
        }
    }

    void initsource(int seqnum) {
        if (this.probation <= 0) {
            this.active = true;
            this.setSender(true);
        }
        this.baseseq = seqnum;
        this.maxseq = seqnum - 1;
        this.lastbadseq = -2;
        this.cycles = 0;
        this.received = 0;
        this.bytesreceived = 0;
        this.lastRTPReceiptTime = 0L;
        this.lasttimestamp = 0L;
        this.jitter = 0.0;
        this.prevmaxseq = this.maxseq;
        this.prevlost = 0;
    }

    void setAlive(boolean bealive) {
        this.setAging(false);
        if (this.alive == bealive) {
            return;
        }
        if (bealive) {
            this.reports.removeAll();
        } else {
            this.setSender(false);
        }
        this.alive = bealive;
    }

    void setSender(boolean besender) {
        if (this.sender == besender) {
            return;
        }
        if (besender) {
            ++this.cache.sendercount;
            this.setAlive(true);
        } else {
            --this.cache.sendercount;
        }
        this.sender = besender;
    }

    void setOurs(boolean beours) {
        if (this.ours == beours) {
            return;
        }
        if (beours) {
            this.setAlive(true);
        } else {
            this.setAlive(false);
        }
        this.ours = beours;
    }

    void setAging(boolean beaging) {
        if (this.aging == beaging) {
            return;
        }
        this.aging = beaging;
    }

    public String getCNAME() {
        return this.sourceInfo == null ? null : this.sourceInfo.getCNAME();
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public Vector getFeedbackReports() {
        RTCPReportBlock[] reportblklist = null;
        if (this.reports.size() == 0) {
            Vector reportlist = new Vector(0);
            return reportlist;
        }
        Vector<RTCPReportBlock> reportlist = new Vector<RTCPReportBlock>(this.reports.size());
        Enumeration reportblks = this.reports.elements();
        try {
            while (reportblks.hasMoreElements()) {
                reportblklist = (RTCPReportBlock[])reportblks.nextElement();
                RTCPReportBlock report = new RTCPReportBlock();
                report = reportblklist[0];
                reportlist.addElement(report);
            }
        }
        catch (NoSuchElementException e) {
            System.err.println("No more elements");
        }
        reportlist.trimToSize();
        return reportlist;
    }

    public Participant getParticipant() {
        if (this.sourceInfo instanceof LocalParticipant && this.cache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    public SSRCCache getSSRCCache() {
        return this.cache;
    }

    public Vector getSourceDescription() {
        Vector<SourceDescription> sdeslist = new Vector<SourceDescription>();
        sdeslist.addElement(this.sourceInfo.getCNAMESDES());
        if (this.name != null) {
            sdeslist.addElement(this.name);
        }
        if (this.email != null) {
            sdeslist.addElement(this.email);
        }
        if (this.phone != null) {
            sdeslist.addElement(this.phone);
        }
        if (this.loc != null) {
            sdeslist.addElement(this.loc);
        }
        if (this.tool != null) {
            sdeslist.addElement(this.tool);
        }
        if (this.note != null) {
            sdeslist.addElement(this.note);
        }
        if (this.priv != null) {
            sdeslist.addElement(this.priv);
        }
        sdeslist.trimToSize();
        return sdeslist;
    }
}

