/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseUnsupportedException;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.Version;
import org.zaproxy.zap.control.AddOn;

public abstract class ExtensionAdaptor
implements Extension {
    private String name = this.getClass().getName();
    private String description;
    private Model model = null;
    private ViewDelegate view = null;
    private int order = 0;
    private boolean enabled = true;
    private ResourceBundle messages = null;
    private String i18nPrefix = null;
    private AddOn addOn;

    public ExtensionAdaptor() {
    }

    public ExtensionAdaptor(String name) {
        ExtensionAdaptor.validateNotNull(name, "name");
        this.name = name;
    }

    private static void validateNotNull(Object parameter, String parameterName) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter \"" + parameterName + "\" must not be null.");
        }
    }

    @Deprecated
    protected ExtensionAdaptor(String name, Version version) {
        this(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        ExtensionAdaptor.validateNotNull(name, "name");
        this.name = name;
    }

    @Override
    public String getUIName() {
        return this.getName();
    }

    @Override
    public void init() {
    }

    @Override
    public void initModel(Model model) {
        this.model = model;
    }

    @Override
    public void initView(ViewDelegate view) {
        this.view = view;
    }

    @Override
    public void initXML(Session session, OptionsParam options) {
    }

    public ExtensionHookView getExtensionView() {
        return null;
    }

    public ExtensionHookMenu getExtensionMenu() {
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public ViewDelegate getView() {
        return this.view;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
    }

    @Override
    public boolean isDepreciated() {
        return false;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getDescription() {
        if (this.description == null || this.description.length() == 0) {
            return this.getUIName();
        }
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<Class<? extends Extension>> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public boolean isCore() {
        return false;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    public ResourceBundle getMessages() {
        return this.messages;
    }

    @Override
    public void setMessages(ResourceBundle messages) {
        this.messages = messages;
    }

    @Override
    public String getI18nPrefix() {
        if (this.i18nPrefix == null) {
            String packageName = this.getClass().getPackage().getName();
            this.i18nPrefix = packageName.substring(packageName.lastIndexOf(".") + 1);
        }
        return this.i18nPrefix;
    }

    @Override
    public void setI18nPrefix(String prefix) {
        this.i18nPrefix = prefix;
    }

    @Override
    public void optionsLoaded() {
    }

    @Override
    public boolean canUnload() {
        return false;
    }

    @Override
    public void unload() {
    }

    @Override
    public List<String> getUnsavedResources() {
        return null;
    }

    @Override
    public List<String> getActiveActions() {
        return null;
    }

    @Override
    public void postInstall() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public void databaseOpen(Database db) throws DatabaseException, DatabaseUnsupportedException {
    }

    @Override
    public AddOn getAddOn() {
        return this.addOn;
    }

    @Override
    public void setAddOn(AddOn addOn) {
        if (this.addOn != addOn) {
            this.addOn = addOn;
            if (this.addOn != null) {
                this.addOn.addLoadedExtension(this);
            }
        }
    }

    @Override
    public boolean supportsDb(String type) {
        return "hsqldb".equals(type);
    }

    @Override
    public boolean supportsLowMemory() {
        return false;
    }
}

