/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.ui.UIUtils;

class EditableHistoryCombo
extends JComboBox {
    private Runnable onTextChange;

    EditableHistoryCombo() {
        super(new ComboHistoryModel(10));
        this.setEditable(true);
        this.setPrototypeDisplayValue("org.netbeans.lib.profiler.ui.swing.XXXXX");
        Dimension dimension = this.getPreferredSize();
        dimension.height = !UIUtils.isNimbusLookAndFeel() ? this.getMinimumSize().height : new JTextField((String)"X").getPreferredSize().height;
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        JTextComponent jTextComponent = this.getTextComponent();
        if (jTextComponent != null) {
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.onChange();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.onChange();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.onChange();
                }

                private void onChange() {
                    if (EditableHistoryCombo.this.onTextChange != null) {
                        EditableHistoryCombo.this.onTextChange.run();
                    }
                }
            });
        }
    }

    JTextComponent getTextComponent() {
        Component component = this.getEditor().getEditorComponent();
        return component instanceof JTextComponent ? (JTextComponent)component : null;
    }

    String getText() {
        JTextComponent jTextComponent = this.getTextComponent();
        return jTextComponent != null ? jTextComponent.getText() : this.getSelectedItem().toString();
    }

    void setOnTextChangeHandler(Runnable runnable) {
        this.onTextChange = runnable;
    }

    private static class ComboHistoryModel
    extends DefaultComboBoxModel {
        private final int historySize;

        ComboHistoryModel(int n) {
            this.historySize = n;
        }

        @Override
        public void addElement(Object object) {
            this.insertElementAt(object, 0);
        }

        @Override
        public void insertElementAt(Object object, int n) {
            int n2 = this.getIndexOf(object);
            if (n2 == n) {
                return;
            }
            if (n2 != -1) {
                this.removeElementAt(n2);
            }
            super.insertElementAt(object, n);
            if (this.getSize() > this.historySize) {
                this.removeElementAt(this.historySize);
            }
            this.setSelectedItem(object);
        }
    }
}

