/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.lang.ref.SoftReference;
import java.util.Map;
import org.openide.util.BaseUtilities;
import org.openide.util.RequestProcessor;

final class TimedSoftReference<T>
extends SoftReference<T>
implements Runnable {
    private static final int TIMEOUT = 30000;
    private static final RequestProcessor RP = new RequestProcessor("TimedSoftReference");
    private RequestProcessor.Task task;
    private T o;
    private final Map m;
    private final Object k;
    private long touched;

    public TimedSoftReference(T t, Map map, Object object) {
        super(t, BaseUtilities.activeReferenceQueue());
        this.o = t;
        this.m = map;
        this.k = object;
        this.task = RP.create(this);
        this.task.schedule(30000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map map = this.m;
        synchronized (map) {
            if (this.o != null) {
                long l = System.currentTimeMillis() - this.touched;
                if (l > 15000L) {
                    this.o = null;
                    this.touched = 0L;
                } else {
                    this.task.schedule(30000 - (int)l);
                }
            } else {
                this.m.remove(this.k);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Map map = this.m;
        synchronized (map) {
            if (this.o == null) {
                this.o = super.get();
            }
            if (this.o != null) {
                if (this.touched == 0L) {
                    this.task.schedule(30000);
                }
                this.touched = System.currentTimeMillis();
                return this.o;
            }
            return null;
        }
    }
}

