/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.wireprotocol.EventBufferDumpedCommand;

public class EventBufferProcessor
implements CommonConstants {
    protected static ProfilingSessionStatus status;
    protected static ProfilerClient profilerClient;
    protected static MappedByteBuffer mapByteBuf;
    protected static File bufFile;
    protected static RandomAccessFile raFile;
    protected static FileChannel bufFileChannel;
    protected static boolean bufFileExists;
    protected static long startDataProcessingTime;
    protected static long dataProcessingTime;

    public static long getDataProcessingTime() {
        return dataProcessingTime;
    }

    public static boolean setEventBufferFile(String string) {
        if (status != null && EventBufferProcessor.status.remoteProfiling) {
            return true;
        }
        if (bufFile != null) {
            EventBufferProcessor.removeEventBufferFile();
        }
        try {
            bufFile = new File(string);
            raFile = new RandomAccessFile(bufFile, "rw");
            bufFileChannel = raFile.getChannel();
            mapByteBuf = bufFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 1200000L);
            mapByteBuf.rewind();
            mapByteBuf.mark();
            bufFileExists = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            ProfilerLogger.severe("internal error when opening memory-mapped temporary file");
            ProfilerLogger.log(iOException);
            ProfilerLogger.severe("*** Please report this problem to feedback@profiler.netbeans.org");
            return false;
        }
        return true;
    }

    public static boolean bufFileExists() {
        return bufFileExists;
    }

    public static void initialize(ProfilerClient profilerClient) {
        EventBufferProcessor.profilerClient = profilerClient;
        status = EventBufferProcessor.profilerClient.getStatus();
    }

    public static synchronized byte[] readDataAndPrepareForProcessing(EventBufferDumpedCommand eventBufferDumpedCommand) {
        byte[] byArray;
        if (!EventBufferProcessor.status.remoteProfiling) {
            int n = eventBufferDumpedCommand.getBufSize();
            byArray = new byte[n];
            mapByteBuf.reset();
            mapByteBuf.get(byArray, 0, n);
        } else {
            byArray = eventBufferDumpedCommand.getBuffer();
            assert (byArray != null);
            assert (byArray.length == eventBufferDumpedCommand.getBufSize());
        }
        startDataProcessingTime = System.currentTimeMillis();
        return byArray;
    }

    public static void removeEventBufferFile() {
        if (status != null && EventBufferProcessor.status.remoteProfiling) {
            return;
        }
        try {
            if (bufFile != null) {
                mapByteBuf = null;
                if (bufFileChannel != null) {
                    bufFileChannel.close();
                }
                if (raFile != null) {
                    raFile.close();
                }
                System.gc();
                for (int i = 0; i < 20; ++i) {
                    if (bufFile.delete()) {
                        bufFile = null;
                        bufFileExists = false;
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (IOException iOException) {
            ProfilerLogger.severe("internal error when closing memory-mapped temporary file");
            ProfilerLogger.severe("*** Please report this problem to feedback@profiler.netbeans.org");
        }
        finally {
            bufFileExists = false;
        }
    }

    public static void reset() {
        dataProcessingTime = 0L;
    }

    protected static synchronized void completeDataProcessing() {
        dataProcessingTime += System.currentTimeMillis() - startDataProcessingTime;
    }
}

