/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.coyote.Processor;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;

public abstract class AbstractProcessorLight
implements Processor {
    private Set<DispatchType> dispatches = new CopyOnWriteArraySet<DispatchType>();

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapperBase<?> socketWrapper, SocketEvent status) throws IOException {
        AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
        Iterator<DispatchType> dispatches = null;
        do {
            if (dispatches != null) {
                DispatchType nextDispatch = (DispatchType)((Object)dispatches.next());
                state = this.dispatch(nextDispatch.getSocketStatus());
            } else if (status != SocketEvent.DISCONNECT) {
                if (this.isAsync() || this.isUpgrade() || state == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                    state = this.dispatch(status);
                    if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                        state = this.service(socketWrapper);
                    }
                } else {
                    state = status == SocketEvent.OPEN_WRITE ? AbstractEndpoint.Handler.SocketState.LONG : (status == SocketEvent.OPEN_READ ? this.service(socketWrapper) : AbstractEndpoint.Handler.SocketState.CLOSED);
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("Socket: [" + socketWrapper + "], Status in: [" + (Object)((Object)status) + "], State out: [" + (Object)((Object)state) + "]"));
            }
            if (state != AbstractEndpoint.Handler.SocketState.CLOSED && this.isAsync()) {
                state = this.asyncPostProcess();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)("Socket: [" + socketWrapper + "], State after async post processing: [" + (Object)((Object)state) + "]"));
                }
            }
            if (dispatches != null && dispatches.hasNext()) continue;
            dispatches = this.getIteratorAndClearDispatches();
        } while (state == AbstractEndpoint.Handler.SocketState.ASYNC_END || dispatches != null && state != AbstractEndpoint.Handler.SocketState.CLOSED);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDispatch(DispatchType dispatchType) {
        Set<DispatchType> set = this.dispatches;
        synchronized (set) {
            this.dispatches.add(dispatchType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<DispatchType> getIteratorAndClearDispatches() {
        Iterator<DispatchType> result;
        Set<DispatchType> set = this.dispatches;
        synchronized (set) {
            result = this.dispatches.iterator();
            if (result.hasNext()) {
                this.dispatches.clear();
            } else {
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearDispatches() {
        Set<DispatchType> set = this.dispatches;
        synchronized (set) {
            this.dispatches.clear();
        }
    }

    protected abstract AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> var1) throws IOException;

    protected abstract AbstractEndpoint.Handler.SocketState dispatch(SocketEvent var1) throws IOException;

    protected abstract AbstractEndpoint.Handler.SocketState asyncPostProcess();

    protected abstract Log getLog();
}

