/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.tomcat.util.res.StringManager;

public final class NetMask {
    private static final StringManager sm = StringManager.getManager(NetMask.class);
    private final String expression;
    private final byte[] netaddr;
    private final int nrBytes;
    private final int lastByteShift;

    public NetMask(String input) {
        int cidr;
        this.expression = input;
        int idx = input.indexOf("/");
        if (idx == -1) {
            try {
                this.netaddr = InetAddress.getByName(input).getAddress();
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(sm.getString("netmask.invalidAddress", new Object[]{input}));
            }
            this.nrBytes = this.netaddr.length;
            this.lastByteShift = 0;
            return;
        }
        String addressPart = input.substring(0, idx);
        String cidrPart = input.substring(idx + 1);
        try {
            this.netaddr = InetAddress.getByName(addressPart).getAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(sm.getString("netmask.invalidAddress", new Object[]{addressPart}));
        }
        int addrlen = this.netaddr.length * 8;
        try {
            cidr = Integer.parseInt(cidrPart);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrNotNumeric", new Object[]{cidrPart}));
        }
        if (cidr < 0) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrNegative", new Object[]{cidrPart}));
        }
        if (cidr > addrlen) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrTooBig", new Object[]{cidrPart, addrlen}));
        }
        this.nrBytes = cidr / 8;
        int remainder = cidr % 8;
        this.lastByteShift = remainder == 0 ? 0 : 8 - remainder;
    }

    public boolean matches(InetAddress addr) {
        int i;
        byte[] candidate = addr.getAddress();
        if (candidate.length != this.netaddr.length) {
            return false;
        }
        for (i = 0; i < this.nrBytes; ++i) {
            if (this.netaddr[i] == candidate[i]) continue;
            return false;
        }
        if (this.lastByteShift == 0) {
            return true;
        }
        int lastByte = this.netaddr[i] ^ candidate[i];
        return lastByte >> this.lastByteShift == 0;
    }

    public String toString() {
        return this.expression;
    }
}

