/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.NetMask;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class RemoteCIDRValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(RemoteCIDRValve.class);
    private final List<NetMask> allow = new ArrayList<NetMask>();
    private final List<NetMask> deny = new ArrayList<NetMask>();

    public RemoteCIDRValve() {
        super(true);
    }

    public String getAllow() {
        return this.allow.toString().replace("[", "").replace("]", "");
    }

    public void setAllow(String input) {
        List<String> messages = this.fillFromInput(input, this.allow);
        if (messages.isEmpty()) {
            return;
        }
        for (String message : messages) {
            log.error((Object)message);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrValve.invalid", new Object[]{"allow"}));
    }

    public String getDeny() {
        return this.deny.toString().replace("[", "").replace("]", "");
    }

    public void setDeny(String input) {
        List<String> messages = this.fillFromInput(input, this.deny);
        if (messages.isEmpty()) {
            return;
        }
        for (String message : messages) {
            log.error((Object)message);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrValve.invalid", new Object[]{"deny"}));
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.isAllowed(request.getRequest().getRemoteAddr())) {
            this.getNext().invoke(request, response);
        } else {
            response.sendError(403);
        }
    }

    private boolean isAllowed(String property) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(property);
        }
        catch (UnknownHostException e) {
            log.error((Object)sm.getString("remoteCidrValve.noRemoteIp"), (Throwable)e);
            return false;
        }
        for (NetMask nm : this.deny) {
            if (!nm.matches(addr)) continue;
            return false;
        }
        for (NetMask nm : this.allow) {
            if (!nm.matches(addr)) continue;
            return true;
        }
        return !this.deny.isEmpty() && this.allow.isEmpty();
    }

    private List<String> fillFromInput(String input, List<NetMask> target) {
        target.clear();
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> messages = new LinkedList<String>();
        for (String s : input.split("\\s*,\\s*")) {
            try {
                NetMask nm = new NetMask(s);
                target.add(nm);
            }
            catch (IllegalArgumentException e) {
                messages.add(s + ": " + e.getMessage());
            }
        }
        return Collections.unmodifiableList(messages);
    }
}

