/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

public abstract class AsymmetricECKey
implements AsymmetricKey {
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private final Algorithm algorithm;
    private final ECDomainParameters domainParameters;

    AsymmetricECKey(Algorithm algorithm, ECDomainParameters eCDomainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = eCDomainParameters;
    }

    AsymmetricECKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID) {
        this(algorithm, ECDomainParametersIndex.lookupDomainParameters(eCDomainParametersID));
    }

    AsymmetricECKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this(algorithm, ECDomainParameters.decodeCurveParameters(algorithmIdentifier));
    }

    public final Algorithm getAlgorithm() {
        if (this instanceof AsymmetricECPrivateKey) {
            this.checkApprovedOnlyModeStatus();
        }
        return this.algorithm;
    }

    public final ECDomainParameters getDomainParameters() {
        if (this instanceof AsymmetricECPrivateKey) {
            this.checkApprovedOnlyModeStatus();
        }
        return this.domainParameters;
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }
}

